/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudatrow.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:20:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV

#pragma hdrstop

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#include "app.hrc"

// FG: chrtitem.hxx ist in \svx\inc zu finden, das define braucht es damit
//     SvxChartDataDescrItem
#include "schattr.hxx"
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>

#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "attrib.hrc"
#include "attrib.hxx"
#include "objid.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "undatrow.hxx"
#include "undatpnt.hxx"
#include "uninsaxi.hxx"
#include "chaxis.hxx"
#include "fudatrow.hxx"
#ifndef _SVX_SVXIDS_HRC //autogen
#include <svx/svxids.hrc>
#endif
TYPEINIT1(SchFuDataRowPoint, SchFuPoor);
#include "chmod3d.hxx"

#include "globfunc.hxx"
#include "svx/tabline.hxx"
#include "pairs.hxx"
/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/
SchFuDataRowPoint::SchFuDataRowPoint(SchViewShell* pViewSh, SchWindow* pWin,
									 SchView* pView, ChartModel* pDoc,
									 SfxRequest& rReq, Point &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	CHART_TRACE( "SchFuDataRowPoint::SchFuDataRowPoint" );

	aMDPos       = rMDPos;

	if (pView->GetMarkedObjectList().GetMarkCount() >= 1)
	{
		SdrObject*   pObj   = pView->GetMarkedObjectList().GetMark(0)->GetObj();
		SchObjectId* pObjId = GetObjectId(*pObj);

		if (pObjId)
		{
			SchDataRow*   pDataRow		= NULL;
			SchDataPoint* pDataPoint	= NULL;

			UINT16 nId = pObjId->GetObjId();

			switch (nId)
			{
				case CHOBJID_DIAGRAM_STACKEDGROUP:
					DBG_TRACE( "SchFuDataRowPoint: STACKEDGROUP shouldn't be addressed" );
					// TVMNEW:leider tragen die Stackedgroups wohl keine Reiheninfo
					// (GetDataRow=0) Mittlerweile ist die Selektion eh geaendert,
					// diese ID sollte daher nicht hier erscheinen koennen.
					break;

				case CHOBJID_DIAGRAM_ROWGROUP:
				case CHOBJID_DIAGRAM_SPECIAL_GROUP:
				case CHOBJID_DIAGRAM_ROWS:
				case CHOBJID_DIAGRAM_ROWSLINE:
				case CHOBJID_LEGEND_SYMBOL_ROW:
					pDataRow = GetDataRow(*pObj);
					break;

				case CHOBJID_LEGEND_SYMBOL_COL:
				case CHOBJID_DIAGRAM_DATA:
					pDataPoint   = GetDataPoint(*pObj);
					break;
			}

			if (pDataRow || pDataPoint)
			{
				const SfxItemSet* pArgs = rReq.GetArgs();

				if (!pArgs)
				{
					SchAttribTabDlg* pDlg;
					USHORT nResult;
					//	This flag is used to remember wether a regression curve
					//	and its data series have the same color before changing
					//	the data series color.  If that is the case then the
					//	regression curve's color is also set to the new color.
					BOOL bRegressionColorFlag = TRUE;

					if (pDataRow)
					{
						long nR = pDataRow->GetRow();

						//bei Balken wird Overlap und Gap in den Set gemerged
						SfxItemSet aRowAttr(pDoc->GetPool(),
							CHART_ROW_WHICHPAIRS,
							CHATTR_DIAGRAM_START, CHATTR_DIAGRAM_END,
							CHATTR_BARCONNECT, CHATTR_BARCONNECT,
							0);
						aRowAttr.Put(pDoc->GetDataRowAttr(nR));

						if( (pDoc->IsBar() || pDoc->IsCol(nR) || pDoc->HasStockRects()) && !pDoc->Is3DChart())
						{
							//Balkendiagramm 2D
							if(!pDoc->IsStacked() && !pDoc->HasStockLines()) //eigentlich IsStockChart()
								aRowAttr.Put(SfxInt32Item(CHATTR_DIAGRAM_OVERLAP,pDoc->GetOverlap(nR)));
							else
								if(pDoc->IsCol(nR))
									aRowAttr.Put(SfxBoolItem(CHATTR_BARCONNECT,pDoc->HasBarConnectors(nR)));

							aRowAttr.Put(SfxInt32Item(CHATTR_DIAGRAM_GAPWIDTH,pDoc->GetGap(nR)));
						}

						aRowAttr.Put (SfxInt32Item (SCHATTR_DUMMY0, (INT32) pDoc->ChartStyle ()));
						aRowAttr.Put (SfxInt32Item (SCHATTR_DUMMY1, (INT32) nId));


						long nShapeType=pDoc->Is3DChart()
							? pDoc->GetChartShapeType()
							: CHART_SHAPE3D_ANY; //#63904# 13 %

						if(nShapeType!=CHART_SHAPE3D_ANY)
						{
							aRowAttr.ClearItem(SCHATTR_STYLE_SHAPE);
							aRowAttr.ClearItem(SDRATTR_3DOBJ_HORZ_SEGS);
						}


						AttrType eType;

						if (nId == CHOBJID_DIAGRAM_ROWSLINE)
						{
							eType = ATTR_DATA_LINE;
						}
						else eType = ATTR_DATA_ROW;

						eType = GetDlgRowType(pDataRow->GetRow(),eType);

						SfxItemSet aSymbolAttr(aRowAttr);
						if(pDoc->HasSymbols(pDataRow->GetRow()))
						{
							pDoc->GenerateSymbolAttr(aSymbolAttr,pDataRow->GetRow());
							pDlg = new SchAttribTabDlg(NULL, eType, &aRowAttr,pDoc->GetObjectShell()
								,pDoc, 0, pDoc->ChartStyle(),&aSymbolAttr
								,GenSymbolGraphic(pDataRow->GetRow()));
						}
						else
						{
							pDlg = new SchAttribTabDlg(NULL, eType, &aRowAttr,pDoc->GetObjectShell()
								,pDoc, 0, pDoc->ChartStyle());
						}

#ifdef DBG_UTIL
						String aDbgTemp = pDlg->GetText();
						aDbgTemp.AppendAscii( " " );
						aDbgTemp.Append( String::CreateFromInt32( nR + 1 ));
						pDlg->SetText( aDbgTemp );
#endif
						nResult = pDlg->Execute();
						
						//	Store in bRegressionColorFlag wether the colors of
						//	the data row and its regression curve (if existing)
						//	are the same.
						if (pDoc->IsXYChart() && pDataRow)
							bRegressionColorFlag = aRowAttr.Get (XATTR_LINECOLOR) == 
								pDoc->GetRegressAttr (nR).Get (XATTR_LINECOLOR);
					}
					else
					{
						long nR = pDataPoint->GetRow();
						long nC = pDataPoint->GetCol();

						SfxItemSet aPointAttr(pDoc->GetFullDataPointAttr(pDataPoint->GetCol(), pDataPoint->GetRow()));

						aPointAttr.Put (SfxInt32Item (SCHATTR_DUMMY0, (INT32) pDoc->ChartStyle ()));
						aPointAttr.Put (SfxInt32Item (SCHATTR_DUMMY1, (INT32) nId));

						SfxItemSet aSymbolAttr(aPointAttr);
						if(pDoc->HasSymbols(pDataPoint->GetRow()))
						{
							pDoc->GenerateSymbolAttr(aSymbolAttr,pDataPoint->GetRow());
							pDlg = new SchAttribTabDlg(NULL, ATTR_DATA_POINT, &aPointAttr,
								pDoc->GetObjectShell(), pDoc, 0, pDoc->ChartStyle(),&aSymbolAttr
								,GenSymbolGraphic(pDataPoint->GetRow(),pDataPoint->GetCol()));
						}
						else
						{
							pDlg = new SchAttribTabDlg(NULL, ATTR_DATA_POINT, &aPointAttr,
								pDoc->GetObjectShell(), pDoc, 0, pDoc->ChartStyle());
						}

#ifdef DBG_UTIL
						String aDbgTemp = pDlg->GetText();
						aDbgTemp.AppendAscii( " (" );
						aDbgTemp.Append( String::CreateFromInt32( nC + 1 ));
						aDbgTemp.AppendAscii( ", " );
						aDbgTemp.Append( String::CreateFromInt32( nR + 1 ));
						aDbgTemp.AppendAscii( ")" );
						pDlg->SetText( aDbgTemp );
#endif

						nResult = pDlg->Execute();
					}

					if (nResult == RET_OK)
					{
						rReq.Done(*(pDlg->GetOutputItemSet()));
						SfxItemSet aNewAttr(pViewSh->GetPool(),
											XATTR_LINE_FIRST, XATTR_LINE_LAST,
											XATTR_FILL_FIRST, XATTR_FILL_LAST,
											EE_ITEMS_START, EE_ITEMS_END,
											SCHATTR_DATADESCR_START, SCHATTR_DATADESCR_END,
											SCHATTR_STAT_START, SCHATTR_STAT_END,
											SCHATTR_STYLE_START,SCHATTR_STYLE_END,
//-/											SID_ATTR_3D_HORZ_SEGS,SID_ATTR_3D_HORZ_SEGS,
											SDRATTR_3DOBJ_HORZ_SEGS, SDRATTR_3DOBJ_HORZ_SEGS,
											SCHATTR_SYMBOL_BRUSH,SCHATTR_SYMBOL_BRUSH,
											SCHATTR_SYMBOL_SIZE,SCHATTR_SYMBOL_SIZE,
											SCHATTR_AXIS,SCHATTR_AXIS,
											CHATTR_DIAGRAM_START,CHATTR_DIAGRAM_END,
											CHATTR_BARCONNECT,CHATTR_BARCONNECT,
											0);
						aNewAttr.Put(*rReq.GetArgs());
						if(pDoc->HasSymbols())
						{
							const SfxPoolItem* pPoolItem;
							if(aNewAttr.GetItemState(SCHATTR_STYLE_SYMBOL,TRUE,&pPoolItem) == SFX_ITEM_SET)
							{
								long nIndex=((const SfxInt32Item*)pPoolItem)->GetValue();
								switch(nIndex)
								{
									case SVX_SYMBOLTYPE_NONE:
										aNewAttr.ClearItem(SCHATTR_SYMBOL_BRUSH);
										aNewAttr.ClearItem(SCHATTR_SYMBOL_SIZE);
										CHART_TRACE( "SVX_SYMBOLTYPE_NONE" );
										break;
									case SVX_SYMBOLTYPE_BRUSHITEM:
										CHART_TRACE( "SVX_SYMBOLTYPE_BRUSHITEM" );
										break;
									case SVX_SYMBOLTYPE_AUTO:
										CHART_TRACE( "SVX_SYMBOLTYPE_AUTO" );
										break;
									case SVX_SYMBOLTYPE_UNKNOWN:
										CHART_TRACE( "SVX_SYMBOLTYPE_UNKNOWN" );
										// change nothing -> remove items
										// should never happen
										aNewAttr.ClearItem(SCHATTR_SYMBOL_BRUSH);
										aNewAttr.ClearItem(SCHATTR_SYMBOL_SIZE);
										aNewAttr.ClearItem(SCHATTR_STYLE_SYMBOL);
										break;
									default: //0...n
										CHART_TRACE1( "SVX_SYMBOLTYPE == %ld", nIndex);
										break;
								}
							}
						}
						
						//	Set a modified line color to the associated regression curve
						//	if it exists and colors of data series and regression curve were the same
						//	before.
						if (pDataRow && bRegressionColorFlag)
						{
							//	Create an item set with line color of the modified item set as the only 
							//	content and set it the regression curve.  This overwrites the previous
							//	color even if it where explicitly set.
							SfxItemSet aLineColorAttribute (pViewSh->GetPool(),
								XATTR_LINECOLOR, XATTR_LINECOLOR);
							aLineColorAttribute.Put (aNewAttr);
							pDoc->PutRegressAttr (pDataRow->GetRow(), 
								aLineColorAttribute, TRUE);
						}

						delete pDlg;

						if( pViewSh )
							pViewSh->GetViewFrame()->GetDispatcher()->Execute(
								SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

						switch (nId)
						{
							case CHOBJID_DIAGRAM_SPECIAL_GROUP:
							case CHOBJID_DIAGRAM_ROWGROUP:
							case CHOBJID_DIAGRAM_ROWS:
							case CHOBJID_DIAGRAM_ROWSLINE:
							case CHOBJID_LEGEND_SYMBOL_ROW:
								{
									pDataRow = GetDataRow(*pObj);
									if(pDataRow)
									{
										const SfxPoolItem *pPoolItem = NULL;
										//#44148# ueberpruefen, ob itemset ueberhaupt diese attr. enthaelt
										if (aNewAttr.GetItemState(SCHATTR_DATADESCR_DESCR, TRUE, &pPoolItem) == SFX_ITEM_SET)
										{
											SvxChartDataDescr eNewDescr = ((const SvxChartDataDescrItem &) aNewAttr.Get(SCHATTR_DATADESCR_DESCR)).GetValue();
											BOOL bNewSym = ((const SfxBoolItem&) aNewAttr.Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
											pDoc->ChangeDataDescr(eNewDescr, bNewSym, pDataRow->GetRow(), FALSE);
										}
										if(aNewAttr.GetItemState(CHATTR_DIAGRAM_GAPWIDTH, TRUE, &pPoolItem) == SFX_ITEM_SET)
											pDoc->SetGap((long)((const SfxInt32Item*)pPoolItem)->GetValue(),pDataRow->GetRow());
										if(aNewAttr.GetItemState(CHATTR_DIAGRAM_OVERLAP, TRUE, &pPoolItem) == SFX_ITEM_SET)
											pDoc->SetOverlap((long)((const SfxInt32Item*)pPoolItem)->GetValue(),pDataRow->GetRow());
										if(aNewAttr.GetItemState(CHATTR_BARCONNECT, TRUE, &pPoolItem) == SFX_ITEM_SET)
											pDoc->SetBarConnectors(((const SfxBoolItem*)pPoolItem)->GetValue(),pDataRow->GetRow());
										
										ChangeDataRowAttr(aNewAttr, pDataRow->GetRow()); //#54870# rObj entfernt
									}
									else
									{
										DBG_ERROR("Chart:SchFuDataRowPoint::SchFuDataRowPoint no DataRow!");
									}
								}
								break;

							case CHOBJID_LEGEND_SYMBOL_COL:
							case CHOBJID_DIAGRAM_DATA:
								pDataPoint = GetDataPoint(*pObj);
								ChangeDataPointAttr(aNewAttr, pDataPoint->GetCol(), pDataPoint->GetRow(), *pObj);
								break;

						}
					}
					else delete pDlg;
				}
				else
				{
					if( pViewSh )
						pViewSh->GetViewFrame()->GetDispatcher()->Execute(
							SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

					if (pDataRow)
						ChangeDataRowAttr(*pArgs, pDataRow->GetRow());//#54870# rObj entfernt
					else
						ChangeDataPointAttr(*pArgs, pDataPoint->GetCol(), pDataPoint->GetRow(), *pObj);
				}
			}
		}
	}
	RemarkObject ();
}

/*************************************************************************
|*
|* Datenreihen-Attribute aendern
|*
\************************************************************************/

void SchFuDataRowPoint::ChangeDataRowAttr(const SfxItemSet& rAttr,short nRow)//#54870# rObj entfernt
{
	//	Construct an item set with the content of the nRow-th data row but
	//	with the item ranges of the new item set.
	SfxItemSet aOldAttr (pChDoc->GetPool(), rAttr.GetRanges());
	aOldAttr.Put(pChDoc->GetDataRowAttr(nRow));

	if( (pChDoc->IsBar() || pChDoc->IsCol(nRow) ) && !pChDoc->Is3DChart())
	{
		//Balkendiagramm 2D
		if(!pChDoc->IsStacked())
			aOldAttr.Put(SfxInt32Item(CHATTR_DIAGRAM_OVERLAP,pChDoc->GetOverlap(nRow)));
		else
			if(pChDoc->IsCol(nRow))
				aOldAttr.Put(SfxBoolItem(CHATTR_BARCONNECT,pChDoc->HasBarConnectors(nRow)));
		aOldAttr.Put(SfxInt32Item(CHATTR_DIAGRAM_GAPWIDTH,pChDoc->GetGap(nRow)));
	}

	DBG_ITEMS((SfxItemSet&)rAttr,pChDoc);

	//	In order to be able to undo an implicit creation (making visible)
	//	of the second y-axis, we keep track of it's visibility in 
	//	bY2AxisVisible.  The other flags have to be stored because they are
	//	needed for constructing the undo actio later.
	BOOL bY2AxisVisible = pChDoc->GetAxisByUID (
		CHART_AXIS_SECONDARY_Y)->IsVisible();
	BOOL bOldXAxis = pChDoc->ShowXAxis();
	BOOL bOldYAxis = pChDoc->ShowYAxis();
	BOOL bOldZAxis = pChDoc->ShowZAxis();
	BOOL bOld2YAxis = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible();
	BOOL bOld2XAxis = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible();
	BOOL bOldXDescr = pChDoc->ShowXDescr();
	BOOL bOldYDescr = pChDoc->ShowYDescr();
	BOOL bOldZDescr = pChDoc->ShowZDescr();
	BOOL bOld2YDescr = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription();
	BOOL bOld2XDescr = pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription();

	if (pChDoc->ChangeDataRowAttr(rAttr, nRow)) //#54870# nRow statt pObj
	{
		String	sUndoComment (SchResId(STR_UNDO_DATA_ROW));
		SchUndoDataRow* pUndo =
			new SchUndoDataRow(*pChDoc, nRow, aOldAttr, rAttr);
		pUndo->SetComment (sUndoComment);

		//	If the second y-axis became visible through the call to 
		//	ChangeDataRowAttr then insert an undo action.
		SchUndoInsertAxis * pUndoAxis = NULL;
		if (bY2AxisVisible != pChDoc->GetAxisByUID (
			CHART_AXIS_SECONDARY_Y)->IsVisible())
		{
			pUndoAxis = new SchUndoInsertAxis (
				*pChDoc,
				bOldXAxis, bOldXDescr,
			 	bOldYAxis, bOldYDescr,
				bOldZAxis, bOldZDescr,
				bOld2YAxis, bOld2YDescr,
				bOld2XAxis, bOld2XDescr,
				pChDoc->ShowXAxis(), pChDoc->ShowXDescr(),
				pChDoc->ShowYAxis(), pChDoc->ShowYDescr(),
				pChDoc->ShowZAxis(), pChDoc->ShowZDescr(),
				pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible(),
				pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription(),
				pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible(),
				pChDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription()
				);
			pUndoAxis->SetComment (sUndoComment);
		}
		
		//	Add the undo actions to the undo manager so that they are
		//	executed together.
		SfxUndoManager * pUndoManager =	pViewShell->GetViewFrame()->GetObjectShell()->GetUndoManager();
		if (pUndoAxis != NULL)
			pUndoManager->EnterListAction (sUndoComment, sUndoComment);
		pUndoManager->AddUndoAction(pUndo);
		if (pUndoAxis != NULL)
		{
			pUndoManager->AddUndoAction (pUndoAxis);
			pUndoManager->LeaveListAction ();
		}
	}
}

/*************************************************************************
|*
|* Datenpunkt-Attribute aendern
|*
\************************************************************************/

void SchFuDataRowPoint::ChangeDataPointAttr(const SfxItemSet& rAttr,
											short nCol, short nRow,
											SdrObject& rObj)
{
	DBG_ITEMS((SfxItemSet&)rAttr,pChDoc);
	SfxItemSet aOldAttr(pChDoc->GetDataPointAttr(nCol, nRow));

	if (pChDoc->ChangeDataPointAttr(rAttr, rObj))
	{
		SchUndoDataPoint* pUndo =
			new SchUndoDataPoint(*pChDoc, nCol, nRow, aOldAttr, rAttr);
		pUndo->SetComment(String(SchResId(STR_UNDO_DATA_POINT)));

		pViewShell->GetViewFrame()->GetObjectShell()->
			GetUndoManager()->AddUndoAction(pUndo);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

AttrType SchFuDataRowPoint::GetDlgRowType(const long nRow,const AttrType eDlgType)
{
	if(pChDoc->IsLine(nRow))
		return ATTR_DATA_LINE; //#54870#

	return eDlgType;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/


void SchFuDataRowPoint::Activate()
{
}
/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDataRowPoint::Deactivate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDataRowPoint::RemarkObject ()
{
	if (nMarkedID)
	{
		SdrPage *pPage = pChDoc->GetPage(0);

		if (pPage)
		{
			SdrObject *pObj = GetObjWithId (nMarkedID, *pPage, 0, IM_DEEPWITHGROUPS);

			if (pObj)
			{
				SdrPageView* pPV = pView->GetPageViewPvNum (0);

				pView->UnmarkAll ();
				pView->LeaveAllGroup ();
				pView->SetMarkHdlHidden(TRUE);
				pView->PickObj (aMDPos, 50, pObj, pPV);
				pView->MarkObj (pObj, pPV);

				pView->EnterMarkedGroup();
				pView->PickObj (aMDPos, 50, pObj, pPV);
				pView->MarkObj (pObj, pPV);
				pView->MarkLogicalGroup();

				if (nMarkedID == CHOBJID_DIAGRAM_DATA)
				{
					pView->EnterMarkedGroup();
					pView->PickObj (aMDPos, 50, pObj, pPV);
					pView->MarkObj (pObj, pPV);
					pView->MarkLogicalGroup();
				}
				if( nMarkedID == CHOBJID_DIAGRAM_ROWGROUP &&
                    pChDoc->IsFlat3DChart() )
                {
                    Select3DGroupMembers( pObj, pPV );
                }

				pView->SetMarkHdlHidden(FALSE);
			}
		}
	}
}

Graphic SchFuDataRowPoint::GenSymbolGraphic(long nRow,long nCol)
{
	SdrObject *pObj=pChDoc->CreateDefaultSymbol(nRow);
	if(!pObj)
	{
		Graphic aDummy;
		return aDummy;
	}

	VirtualDevice aVDev;
	aVDev.SetMapMode(MapMode(MAP_100TH_MM));
	SdrModel* pModel = new SdrModel();
	pModel->GetItemPool().FreezeIdRanges();
	SdrPage* pPage = new SdrPage( *pModel, FALSE );
	pPage->SetSize(Size(1000,1000));
	pModel->InsertPage( pPage, 0 );
	SdrView* pView = new SdrView( pModel, &aVDev );
	pView->SetMarkHdlHidden( TRUE );
	SdrPageView* pPageView = pView->ShowPage(pPage, Point());

	pPage->InsertObject(pObj);
	pView->MarkObj(pObj,pPageView);
	Rectangle aB(pObj->GetCurrentBoundRect());
	Rectangle aL(pObj->GetLogicRect());
	Rectangle aRect(pObj->GetSnapRect());
	aRect.Justify();
	Size aSize(aRect.GetSize());
	if(nCol==-1)
	{
		SfxItemSet aSymbolAttr(pChDoc->GetDataRowAttr(nRow));
		pChDoc->GenerateSymbolAttr(aSymbolAttr,nRow);

		pObj->SetMergedItemSet(aSymbolAttr);

	}
	else
	{
		SfxItemSet aSymbolAttr(pChDoc->GetFullDataPointAttr(nCol,nRow));
		pChDoc->GenerateSymbolAttr(aSymbolAttr,nRow);

		pObj->SetMergedItemSet(aSymbolAttr);

	}

	GDIMetaFile aMeta(pView->GetAllMarkedMetaFile());
	Graphic aGraph(aMeta);
	CHART_TRACE2( "Setting AutoSymbolSize to (%ld, %ld)", aSize.Width(), aSize.Height() );
	aGraph.SetPrefSize(aSize);
	aGraph.SetPrefMapMode(MAP_100TH_MM);
	pView->UnmarkAll();
	pObj=pPage->RemoveObject(0);
	if(pObj)
		delete pObj;

	delete pView;
	delete pModel;
	return aGraph;
}
