/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: excui.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:38:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "excui.hxx"




// ---------------------------------------------------- class ExcUiEntry -

// -------------------------------------------- ExcUiEntry::ExcUiEntry() -
ExcUiEntry::ExcUiEntry()
	{
	pDefString = NULL;
	pPageTemplPre = pParaTemplPre = pPageTemplPst = pParaTemplPst = NULL;
	pNext = NULL;
	}

// -------------------------------------------- ExcUiEntry::ExcUiEntry() -
ExcUiEntry::ExcUiEntry( const ExcUiEntry &rEntry )
	{
	*this = rEntry;
	}

// ------------------------------------------- ExcUiEntry::~ExcUiEntry() -
ExcUiEntry::~ExcUiEntry()
	{
	if( pDefString ) delete pDefString;
	if( pPageTemplPre ) delete pPageTemplPre;
	if( pParaTemplPre ) delete pParaTemplPre;
	if( pPageTemplPst ) delete pPageTemplPst;
	if( pParaTemplPst ) delete pParaTemplPst;
	}

// -------------------------------------------- ExcUiEntry::operator =() -
const ExcUiEntry &ExcUiEntry::operator =( const ExcUiEntry &rEntry )
	{
	aName = rEntry.aName;
	eType = rEntry.eType;

	nTab = rEntry.nTab;
	nColStart = rEntry.nColStart;
	nColEnd = rEntry.nColEnd;
	nRowStart = rEntry.nRowStart;
	nRowEnd = rEntry.nRowEnd;
	//nStrPos = rEntry.nStrPos;

	String *pNewDefString = rEntry.pDefString;
	if( pNewDefString )
		pDefString = new String( *pNewDefString );
	else
		pDefString = pNewDefString;

	pPageTemplPre = rEntry.pPageTemplPre;
	pParaTemplPre = rEntry.pParaTemplPre;
	pPageTemplPst = rEntry.pPageTemplPst;
	pParaTemplPst = rEntry.pParaTemplPst;

	return *this;
	}

// -------------------------------------------- ExcUiEntry::operator <() -
BOOL ExcUiEntry::operator <( const ExcUiEntry &rEntry ) const
	{// Reihenfolge:
	//	1. Tabelle -> Ranges -> UserRanges
	//	2. Namen
	if( ( USHORT ) eType < ( USHORT ) rEntry.eType )
		return TRUE;
	return ( aName < rEntry.aName );
	}

// ------------------------------------------- ExcUiEntry::operator ==() -
BOOL ExcUiEntry::operator ==( const ExcUiEntry &rEntry ) const
	{
	return ( eType == rEntry.eType && aName == rEntry.aName );
	}

// ----------------------------------------------- ExcUiEntry::GetName() -
const String &ExcUiEntry::GetName( void ) const
	{
	return aName;
	}

// -------------------------------------- ExcUiEntry::GetName( String& ) -
void ExcUiEntry::GetName( String &rName ) const
	{
	rName = aName;
	}

// -------------------------------- ExcUiEntry::SetName( const String& ) -
void ExcUiEntry::SetName( const String &rName )
	{
	aName = rName;
	}

// -------------------------------------------- ExcUiEntry::GetTabName() -
const String &ExcUiEntry::GetTabName( void ) const
	{
	return aTabName;
	}

// ----------------------------------- ExcUiEntry::GetTabName( String& ) -
void ExcUiEntry::GetTabName( String &rName ) const
	{
	rName = aTabName;
	}

// ----------------------------------------------- ExcUiEntry::GetType() -
ExcEntryType ExcUiEntry::GetType( void )
	{
	return eType;
	}

// -------------------------------- ExcUiEntry::GetType( ExcEntryType& ) -
void ExcUiEntry::GetType( ExcEntryType &rType )
	{
	rType = eType;
	}

// --------------------------------- ExcUiEntry::SetType( ExcEntryType ) -
void ExcUiEntry::SetType( ExcEntryType eNewType )
	{
	eType = eNewType;
	}

// ---------------- ExcUiEntry::SetTemplate( const String*, BOOL, BOOL ) -
void ExcUiEntry::SetTemplate( const String *pName, BOOL bPage, BOOL bPre )
	{
	//	POST:	bPre = TRUE 	-> Vorlage wird vor Tabelle eingefuegt
	//								(Default)
	//					sonst	-> ~ hinter Tabelle eingefuegt
	//			bPage = TRUE	-> Vorlage ist Seitenvorlage
	//					sonst	-> ~ Absatzvorlage
	if( bPre )
		{// vor Tabelle
		if( bPage )
			{// Seitenvorlage vor Tabelle
			SetTempl( pPageTemplPre, pParaTemplPre, pName );
			}
		else
			{// Absatzvorlage vor Tabelle
			SetTempl( pParaTemplPre, pPageTemplPre, pName );
			}
		}
	else
		{// nach Tabelle
		if( bPage )
			{// Seitenvorlage nach Tabelle
			SetTempl( pPageTemplPst, pParaTemplPst, pName );
			}
		else
			{// Absatzvorlage nach Tabelle
			SetTempl( pParaTemplPst, pPageTemplPst, pName );
			}
		}
	}

// ---------------------------- ExcUiEntry::SetTempl( String*, String* ) -
void ExcUiEntry::SetTempl( String *&pPrimPos, String *&pSecPos,
	const String *pName )
	{
	//	POST:	pName == NULL ->	pPrimPos = NULL
	//			pName != NULL ->	<pPrimPos> = <pName>
	//								<pSecPos> = <>
	if( pName )
		{// pPrimPos setzen
		if( pSecPos )
			{
			delete pSecPos;
			pSecPos = NULL;
			}
		if( !pPrimPos )
			pPrimPos = new String;
		*pPrimPos = *pName;
		}
	else
		{// pPrimPos loeschen
		if( pPrimPos )
			{
			delete pPrimPos;
			pPrimPos = NULL;
			}
		}
	}

// ---------------------------------------------- ExcUiEntry::GetRange() -
const String& ExcUiEntry::GetRange( void )
	{
	if( !pDefString )
		GenerateDefString();
	return *pDefString;
	}

// ------------------------------------- ExcUiEntry::GetRange( String& ) -
void ExcUiEntry::GetRange( String &rRange )
	{
	if( !pDefString )
		GenerateDefString();
	rRange = *pDefString;
	}

// --------------------------------- ExcUiEntry::SetRange( USHORT, ... ) -
void ExcUiEntry::SetRange( USHORT nCS, USHORT nCE, USHORT nRS, USHORT nRE )
	{
	if( nColStart != nCS || nColEnd != nCE ||
		nRowStart != nRS || nRowEnd != nRE )
		{// Definitionsstring dirty
		delete pDefString;
		pDefString = NULL;

		nColStart = nCS;
		nColEnd = nCE;
		nRowStart = nRS;
		nRowEnd = nRE;
		}
	}

// ------------------------------- ExcUiEntry::SetRange( const String& ) -
void ExcUiEntry::SetRange( const String &rRange )
	{
	DBG_ERROR( "*ExcUiEntry::SetRange(): Sorry, not yet implemented!" );
	}

// ------------------------------- ExcUiEntry::SetRange( const String& ) -
void ExcUiEntry::GenerateDefString( void )
	{
	pDefString = new String( aTabName );
	*pDefString += ".A1:T???";
	}



// ----------------------------------------------------- class ExcUiList -

// ---------------------------------------------- ExcUiList::ExcUiList() -
ExcUiList::ExcUiList()
	{
	pListe = pAkt = NULL;
	nAnz = 0;
	}

// --------------------------------------------- ExcUiList::~ExcUiList() -
ExcUiList::~ExcUiList()
	{
	ExcUiEntry *pNext;
	while( pListe )
		{
		pNext = pListe->pNext;
		delete pListe;
		pListe = pNext;
		}
	}

// ------------------------------------ ExcUiList::operator []( USHORT ) -
const ExcUiEntry *ExcUiList::operator []( USHORT nIndex ) const
	{
	if( nIndex >= nAnz ) return NULL;

	ExcUiEntry *pRet = pListe;

	while( nIndex > 0 )
		{
		pRet = pRet->pNext;
		nIndex--;
		}

	return pRet;
	}

// ----------------------------------------------- ExcUiList::GetFirst() -
const ExcUiEntry *ExcUiList::GetFirst( void )
	{
	pAkt = pListe;
	return pListe;
	}

// ------------------------------------------------ ExcUiList::GetNext() -
const ExcUiEntry *ExcUiList::GetNext( void )
	{
	if( pAkt )
		{
		ExcUiEntry *pRet = pAkt;
		pAkt = pAkt->pNext;
		return pAkt;	// naechster oder NULL
		}

	return pAkt;		// pAkt hier NULL
	}

// ------------------------------ ExcUiList::Insert( const ExcUiEntry& ) -
void ExcUiList::Insert( const ExcUiEntry &rEntry )
	{
	// fuegt Entry SORTIERT ein
	ExcUiEntry *pInsert = new ExcUiEntry( rEntry );
	pInsert->pNext = NULL;

	if( pListe )
		{// Liste gefuellt
		ExcUiEntry *pTest, *pLast;
		pTest = pListe;
		while( pTest )
			{
			pLast = pTest;
			if( *pTest < rEntry )
				pTest = pTest->pNext;
			else
				pTest = NULL;
			}
		// hinter pLast einfuegen
		pInsert->pNext = pLast->pNext;
		pLast->pNext = pInsert;
		}
	else
		{// Liste leer
		pListe = pInsert;
		}

	nAnz++;
	}

// ------------------------------ ExcUiList::Insert( const ExcUiEntry& ) -
void ExcUiList::Insert( const ExcUiEntry &rEntry, USHORT nIndex )
	{// einfuegen VOR Position
	ExcUiEntry *pInsert = new ExcUiEntry( rEntry );
	pInsert->pNext = NULL;

	if( pListe )
		{// mindestens ein Element in Liste
		if( nIndex )
			{// weiter hinten einhaengen ( nIndex > 0 )
			ExcUiEntry *pSucc = pListe->pNext;	// Nachfolger
			ExcUiEntry *pPred = pListe;			// Vorgaenger

			while( nIndex > 0 && pSucc )
				{ // Abbruch, wenn Index oder Ende erreicht
				pPred = pSucc;
				pSucc = pSucc->pNext;
				nIndex--;
				}
			pPred->pNext = pInsert;
			pInsert->pNext = pSucc;
			}
		else
			{// vorne einhaengen ( nIndex == 0 )
			pInsert->pNext = pListe;
			pListe = pInsert;
			}
		}
	else
		{// noch kein Element in Liste
		pListe = pInsert;
		}

	nAnz++;
	}

// ------------------------------ ExcUiList::InList( const ExcUiEntry& ) -
BOOL ExcUiList::InList( const ExcUiEntry &rEntry )
	{
	ExcUiEntry *pTest = pListe;

	while( pTest )
		{
		if( *pTest == rEntry )
			return TRUE;
		pTest = pTest->pNext;
		}
	return FALSE;
	}



