/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cacheddynamicresultset.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:11:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <cacheddynamicresultset.hxx>

#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif

#ifndef _CACHED_CONTENT_RESULTSET_HXX
#include <cachedcontentresultset.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

using namespace com::sun::star::lang;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using namespace rtl;

CachedDynamicResultSet::CachedDynamicResultSet(
		Reference< XDynamicResultSet > xOrigin
		, const Reference< XContentIdentifierMapping > & xContentMapping
		, const Reference< XMultiServiceFactory > & xSMgr )
		: DynamicResultSetWrapper( xOrigin, xSMgr )
		, m_xContentIdentifierMapping( xContentMapping )
{
	impl_init();
}

CachedDynamicResultSet::~CachedDynamicResultSet()
{
	impl_deinit();
}

//virtual
void SAL_CALL CachedDynamicResultSet
	::impl_InitResultSetOne( const Reference< XResultSet >& xResultSet )
{
	DynamicResultSetWrapper::impl_InitResultSetOne( xResultSet );
	OSL_ENSURE( m_xSourceResultOne.is(), "need source resultset" );

	Reference< XResultSet > xCache(
        new CachedContentResultSet( m_xSMgr, m_xSourceResultOne, m_xContentIdentifierMapping ) );

	osl::Guard< osl::Mutex > aGuard( m_aMutex );
	m_xMyResultOne = xCache;
}

//virtual
void SAL_CALL CachedDynamicResultSet
	::impl_InitResultSetTwo( const Reference< XResultSet >& xResultSet )
{
	DynamicResultSetWrapper::impl_InitResultSetTwo( xResultSet );
	OSL_ENSURE( m_xSourceResultTwo.is(), "need source resultset" );

	Reference< XResultSet > xCache(
        new CachedContentResultSet( m_xSMgr, m_xSourceResultTwo, m_xContentIdentifierMapping ) );

	osl::Guard< osl::Mutex > aGuard( m_aMutex );
	m_xMyResultTwo = xCache;
}

//--------------------------------------------------------------------------
// XInterface methods.
//--------------------------------------------------------------------------
XINTERFACE_COMMON_IMPL( CachedDynamicResultSet )

Any SAL_CALL CachedDynamicResultSet
	::queryInterface( const Type&  rType )
	throw ( RuntimeException )
{
	//list all interfaces inclusive baseclasses of interfaces

	Any aRet = DynamicResultSetWrapper::queryInterface( rType );
	if( aRet.hasValue() )
		return aRet;

	aRet = cppu::queryInterface( rType,
				static_cast< XTypeProvider* >( this )
				, static_cast< XServiceInfo* >( this )
				);
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType );
}

//--------------------------------------------------------------------------
// XTypeProvider methods.
//--------------------------------------------------------------------------
//list all interfaces exclusive baseclasses
XTYPEPROVIDER_IMPL_4( CachedDynamicResultSet
					, XTypeProvider
					, XServiceInfo
					, XDynamicResultSet
					, XSourceInitialization
					);

//--------------------------------------------------------------------------
// XServiceInfo methods.
//--------------------------------------------------------------------------

XSERVICEINFO_NOFACTORY_IMPL_1( CachedDynamicResultSet,
				 		   OUString::createFromAscii(
							"com.sun.star.comp.ucb.CachedDynamicResultSet" ),
				 		   OUString::createFromAscii(
							CACHED_DRS_SERVICE_NAME ) );

//--------------------------------------------------------------------------
// own methds. ( inherited )
//--------------------------------------------------------------------------
//virtual
void SAL_CALL CachedDynamicResultSet
	::impl_disposing( const EventObject& Source )
	throw( RuntimeException )
{
	DynamicResultSetWrapper::impl_disposing( Source );
	m_xContentIdentifierMapping.clear();
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
// class CachedDynamicResultSetFactory
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

CachedDynamicResultSetFactory::CachedDynamicResultSetFactory(
		const Reference< XMultiServiceFactory > & rSMgr )
{
	m_xSMgr = rSMgr;
}

CachedDynamicResultSetFactory::~CachedDynamicResultSetFactory()
{
}

//--------------------------------------------------------------------------
// CachedDynamicResultSetFactory XInterface methods.
//--------------------------------------------------------------------------

XINTERFACE_IMPL_3( CachedDynamicResultSetFactory,
				   XTypeProvider,
				   XServiceInfo,
				   XCachedDynamicResultSetFactory );

//--------------------------------------------------------------------------
// CachedDynamicResultSetFactory XTypeProvider methods.
//--------------------------------------------------------------------------

XTYPEPROVIDER_IMPL_3( CachedDynamicResultSetFactory,
					  XTypeProvider,
				   	  XServiceInfo,
					  XCachedDynamicResultSetFactory );

//--------------------------------------------------------------------------
// CachedDynamicResultSetFactory XServiceInfo methods.
//--------------------------------------------------------------------------

XSERVICEINFO_IMPL_1( CachedDynamicResultSetFactory,
	 		   		 OUString::createFromAscii(
					 	"com.sun.star.comp.ucb.CachedDynamicResultSetFactory" ),
	 		   		 OUString::createFromAscii(
					 	CACHED_DRS_FACTORY_NAME ) );

//--------------------------------------------------------------------------
// Service factory implementation.
//--------------------------------------------------------------------------

ONE_INSTANCE_SERVICE_FACTORY_IMPL( CachedDynamicResultSetFactory );

//--------------------------------------------------------------------------
// CachedDynamicResultSetFactory XCachedDynamicResultSetFactory methods.
//--------------------------------------------------------------------------

//virtual
Reference< XDynamicResultSet > SAL_CALL CachedDynamicResultSetFactory
	::createCachedDynamicResultSet(
		  const Reference< XDynamicResultSet > & SourceStub
		, const Reference< XContentIdentifierMapping > & ContentIdentifierMapping )
		throw( RuntimeException )
{
	Reference< XDynamicResultSet > xRet;
	xRet = new CachedDynamicResultSet( SourceStub, ContentIdentifierMapping, m_xSMgr );
	return xRet;
}


