/************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.DataInputStream;
import java.io.OutputStream;
import java.io.InputStream;
import java.io.IOException;

import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.PocketExcelConstants;


/**
 * Represents a BIFF REcord that describes workbook window attributes 
 */
public class Window1 implements BIFFRecord {

    private byte[] grbit 	= new byte[2];
    private byte[] itabCur	= new byte[2];		// index of selected worksheet
    
	/**
 	 * Constructor
 	 */
    public Window1() {
		grbit	= EndianConverter.writeShort((short) 0);
		itabCur	= EndianConverter.writeShort((short) 0);
    }

   	/**
 	 * Constructs a Window1 Record from an <code>InputStream</code> 
 	 *
 	 * @param	is InputStream containing a Window1 Record 
 	 */
    public Window1(InputStream is) throws IOException{
		read(is);	
    }
	
    /**
	 * Set the number of the active sheet
	 *
	 * @param activeSheet number of the active sheet 
	 */
    public void setActiveSheet(int activeSheet) {
        itabCur = EndianConverter.writeShort((short) activeSheet);
    }
	
    /**
	 * Get the number of the active sheet 
	 *
	 * @return 	 number of the active sheet
	 */
    public int getActiveSheet() {
        return EndianConverter.readShort(itabCur);
    }	

    /**
	 * Get the hex code for this particular <code>BIFFRecord</code> 
	 *
	 * @return the hex code for <code>Window1</code>
	 */
    public short getBiffType() {
        return PocketExcelConstants.WINDOW_INFO;
    }
    
   	/**
 	 * Reads a Window1 Record from an <code>InputStream</code> 
 	 *
 	 * @param	is InputStream containing a Window1 Record 
 	 */
    public int read(InputStream input) throws IOException {
		
        int numOfBytesRead	= input.read(grbit);
        numOfBytesRead		+= input.read(itabCur);
                
        Debug.log(Debug.TRACE,"\tgrbit : "+ EndianConverter.readShort(grbit) + 
                            " itabCur : " + EndianConverter.readShort(itabCur));
                            
        return numOfBytesRead;        
    }
    
    public void write(OutputStream output) throws IOException {

		output.write(getBiffType());
		output.write(grbit);
		output.write(itabCur);

		Debug.log(Debug.TRACE,"Writing Window1 record");
    }
}
