/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpResultSet.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:38:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.util.*;
import com.sun.star.io.*;
import com.sun.star.lang.*;
import com.sun.star.ucb.*;
import com.sun.star.sdbc.*;
import com.sun.star.beans.*;
import com.sun.star.container.*;

import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.xml.qe.*;


public class HelpResultSet extends HelpResultSetBase
	// implements XComponent,XCloseable,XPropertySet,XContentAccess,XRow,XResultSet,XResultSetMetaDataSupplier
{

	// boolean m_bWasNull;
	// int m_nRow = -1;
 	private QueryHitData                 m_xHitData[] = null;
  	// private HelpProvider                 m_xProvider;
	// private HelpContentIdentifier        m_xIdentifiers[] = null;
   	// private Property                     m_xProperties[] = null;


    public String getDocumentURL()
    {
    	if( ret() )
     		return m_xHitData[m_nRow].getDocument() + 
				"?Language=" + m_xParameter.get_language() +
				"&System=" + m_xParameter.get_system();
       	else
        	return null;
    }

    public Object getVal( int i )
    {
    	if( m_xProperties[i].Name.equals( "Title" ) )
     	{
        	return (( HelpContentIdentifier) queryContentIdentifier()).getParameter().get_title();
      	}
       	else if( m_xProperties[i].Name.equals( "MediaType" ) )
        {
         	return new String( "text/html" );
        }
        else if( m_xProperties[i].Name.equals( "ContentType" ) )
        {
         	return new String( "application/vnd.sun.star.help" );
        }
		else if( m_xProperties[i].Name.equals( "IsDocument" ) )
  		{
  			return new Boolean( true );
     	}
     	else if( m_xProperties[i].Name.equals( "IsFolder" ) )
  		{
  			return new Boolean( false );
     	}
        else
        {
    		return null;
      	}
    }

    public int getLength()
    {
    	return m_xHitData.length;
    }


	public HelpResultSet( HelpProvider xProvider,QueryResults result,Property xProperties[],HelpURLParameter xParameter )
 	{
  		super( xProvider,xProperties,xParameter );
  		// m_xProvider = xProvider;
    	// m_xProperties = xProperties;

		String[] translations = { "#HLP#",
   								  "vnd.sun.star.help://" };

		PrefixTranslator translator =  PrefixTranslator.makePrefixTranslator(translations);

		// m_xHitData = new QueryHitData[ result.getNonZeroCount() ];

  		int pos = 0;
    	String validator = "vnd.sun.star.help://";
  		String[] docStr = new String[ result.getNonZeroCount() ];
  		int[]    intStr = new int[ result.getNonZeroCount() ];

  		int row = -1;
  		for( int i = 0; i < docStr.length; ++i )
    	{
    		row = result.getNextNonZero( row );
 			String str = result.getHit( row ).translate( translator ).getDocument();
    		String cmp = null;
    		if( str != null && str.length() >= validator.length() )
    			cmp = str.substring(0,validator.length() );
    		if( str != null && cmp != null && validator.equals( cmp ) )
      		{
        		boolean insert = true;
        		for( int k = 0; k < pos-1; ++k )
          		{
          			if( docStr[k].equals( str ) )
             		{
               			insert = false;
               		}
           		}
             	if( insert )
                {
                  	docStr[pos] = str;
    				intStr[pos++] = row;
        		}
        	}
      	}

       	m_xHitData = new QueryHitData[ pos ];
        for( int z = 0; z < pos; ++z )
        {
        	m_xHitData[z] = result.getHit( intStr[z] ).translate( translator );
        }

       	// m_xIdentifiers = new HelpContentIdentifier[ m_xHitData.length ];
  	}



}

