/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: helpcontentprovider.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:26:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _HELPCONTENTPROVIDER_HXX_
#define _HELPCONTENTPROVIDER_HXX_
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif

namespace helpaccess {
	
	class HelpContentProvider:
		public cppu::OWeakObject,
		public com::sun::star::lang::XServiceInfo,
		public com::sun::star::ucb::XContentProvider,
		public com::sun::star::ucb::XContentIdentifierFactory
	{
	public:
		
		HelpContentProvider( const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& xMSF );
		~HelpContentProvider();
	  
		// XInterface
		virtual com::sun::star::uno::Any SAL_CALL
		queryInterface( 
			const com::sun::star::uno::Type& aType ) 
			throw( com::sun::star::uno::RuntimeException);
					
		virtual void SAL_CALL 
		acquire( 
			void ) 
			throw();
	  
		virtual void SAL_CALL
		release(
			void ) 
			throw();
	  
		// XServiceInfo
		virtual rtl::OUString SAL_CALL
		getImplementationName(  
			void ) 
			throw( com::sun::star::uno::RuntimeException );
	  
		virtual sal_Bool SAL_CALL
		supportsService( 
			const rtl::OUString& ServiceName )
			throw(com::sun::star::uno::RuntimeException );
	  
		virtual com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
		getSupportedServiceNames( 
			void ) 
			throw( com::sun::star::uno::RuntimeException );
	  

		static com::sun::star::uno::Reference< com::sun::star::lang::XSingleServiceFactory > SAL_CALL
		createServiceFactory( 
			const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& rxServiceMgr );
	  
		static com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
		CreateInstance( 
			const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& xMultiServiceFactory );
		
		// XContentProvider
		virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
		queryContent(
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Identifier ) 
			throw( com::sun::star::ucb::IllegalIdentifierException, 
				   com::sun::star::uno::RuntimeException);
		
		// XContentIdentifierFactory
		
		virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > SAL_CALL
		createContentIdentifier( 
			const rtl::OUString& ContentId ) 
			throw( com::sun::star::uno::RuntimeException );


		virtual sal_Int32 SAL_CALL
		compareContentIds( 
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Id1, 
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& Id2 )
			throw( com::sun::star::uno::RuntimeException );
		
	private:
		// Members
		com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >       m_xMultiServiceFactory;
		
		com::sun::star::uno::Reference< com::sun::star::ucb::XContentProvider >            m_xRemoteProvider;
		com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifierFactory >   m_xContentIdentifierFactory;
		
		// funktions
		sal_Bool init;
		void SAL_CALL initialize();
	};
	
}       // end namespace helpaccess

