
#include <acpid/driver/evdev.h>

static int setup(struct acpi_channel *channel, struct acpi_channel_descriptor *cds, unsigned long num)
{
	struct acpi_channel_private *private = (struct acpi_channel_private *) channel->private;

	acpi_channel_watch(channel, cds, private->fd, POLLIN);

	return 1;
}

static int handle(struct acpi_channel *channel, lua_State *L, int fd, int events)
{
	struct acpi_channel_private *private = (struct acpi_channel_private *) channel->private;

	struct input_event e;
	while (read(private->fd, &e, sizeof(e)) == sizeof(e)) {
		if (e.type == 0)
			continue;
		if (e.type == 1 && e.value == 1)
			continue;

		static const char *map[] = { "SYN", "KEY", "REL", "ABS", "MSC", "SW", "LED", "SND", "REP", "FF", "PWR", "FF_STATUS" };
		acpi_channel_event(channel, L, map[e.type], e.code, e.value);
	}

	return 0;
}



/*
 *	driver operations
 */

static int create(struct acpi_channel *channel, lua_State *L)
{
	static const struct acpi_channel_ops ops = { setup, handle };
	acpi_channel_register(channel, &ops);

	lua_pushinteger(L, 1);
	lua_gettable(L, -2);
	int fd = open(lua_tostring(L, -1), O_RDONLY);
	lua_pop(L, 1);

	if (fd < 0)
		return -1;

	channel->private = malloc(sizeof(struct acpi_channel_private));
	if (channel->private == NULL)
		return -1;

	struct acpi_channel_private *private = channel->private;
	private->fd = fd;

	if (ioctl(fd, EVIOCGPHYS(sizeof(private->hid)), private->hid) < 0)
		strcpy(private->hid, "unknown");

	char *end = strpbrk(private->hid, "/");
	if (end)
		*end = 0;

	printf("evdev hid: %s\n", private->hid);

	int flags = fcntl(private->fd, F_GETFL, 0);
	fcntl(private->fd, F_SETFL, flags | O_NONBLOCK);

	return 0;
}

static void destroy(struct acpi_channel *channel)
{
	struct acpi_channel_private *private = channel->private;

	close(private->fd);
	free(channel->private);
}



/*
 *	driver constuctor
 */

static __attribute__((constructor)) void constructor()
{
	static const struct acpi_driver driver = { "evdev", { create, destroy } };
	acpi_driver_register(&driver);
}

