#include <qlabel.h>
#include <qtabdialog.h>
#include <qfile.h>

#include "FireGLControl.h"
#include "watermark.xpm"
#include "buttons.xpm"


#ifdef FGLRX_USE_XEXTENSIONS
#include "FGLRXExtensions.h"
#endif // FGLRX_USE_XEXTENSIONS


#ifdef DEBUG
#define DEB(s)  s
#else
#define DEB(s)
#endif // DEBUG


AdjustPage::AdjustPage ( QWidget *parent, int CurMonitor ) : QWidget ( parent, (const char *)0 )
{
  m_CurMonitor = CurMonitor ;
  m_Init = FALSE ;
  m_TimingsChanged = FALSE ;
}

void AdjustPage::Init ( )
{
  QPixmap      pixmap ( watermark ) ;
#ifdef FGL_LATER
  QPixmap     *pPix ;
  QGroupBox   *pMove, *pSize, *pSyncPol ;
  QLabel      *pWarning ;
#endif
  QGroupBox   *pGammaBox ;
  QFrame      *pColorRed, *pColorGreen, *pColorBlue ;
  QString     Str ;


  setBackgroundPixmap ( pixmap ) ;

#ifdef FGL_LATER
  pMonitorBox = new QGroupBox ( tr("Monitor Tuning ( not attached )"), this ) ;
  pMonitorBox->setGeometry ( 8, 8, 430, 180 ) ;
  pMonitorBox->setAlignment ( AlignHCenter ) ;
  pMonitorBox->setBackgroundPixmap ( pixmap ) ;
  pMonitorBox->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pMove = new QGroupBox ( tr("Move"), this ) ;
  pMove->setGeometry ( 20, 25, 102, 110 ) ;
  pMove->setAlignment ( AlignHCenter ) ;
  pMove->setBackgroundPixmap ( pixmap ) ;
  pMove->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pSize = new QGroupBox ( tr("Size"), this ) ;
  pSize->setGeometry ( 135, 25, 102, 110 ) ;
  pSize->setAlignment ( AlignHCenter ) ;
  pSize->setBackgroundPixmap ( pixmap ) ;
  pSize->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pSyncPol = new QGroupBox ( tr("Sync Polarity"), this ) ;
  pSyncPol->setGeometry ( 250, 25, 175, 90 ) ;
  pSyncPol->setAlignment ( AlignHCenter ) ;
  pSyncPol->setBackgroundPixmap ( pixmap ) ;
  pSyncPol->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pLeft = new QPushButton ( tr("left"), this ) ;
  pLeft->setGeometry ( 32, 72, 25, 25 ) ;
  pPix = new QPixmap ( pix_left ) ;
  pLeft->setPixmap ( *pPix ) ;
  pLeft->setFocusPolicy ( QWidget::StrongFocus ) ;

  pRight = new QPushButton ( tr("right"), this ) ;
  pRight->setGeometry ( 86, 72, 25, 25 ) ;
  pPix = new QPixmap ( pix_right ) ;
  pRight->setPixmap ( *pPix ) ;
  pRight->setFocusPolicy ( QWidget::StrongFocus ) ;

  pUp = new QPushButton ( tr("up"), this ) ;
  pUp->setGeometry ( 58, 44, 25, 25 ) ;
  pPix = new QPixmap ( pix_up ) ;
  pUp->setPixmap ( *pPix ) ;
  pUp->setFocusPolicy ( QWidget::StrongFocus ) ;

  pDown = new QPushButton ( tr("down"), this ) ;
  pDown->setGeometry ( 58, 100, 25, 25 ) ;
  pPix = new QPixmap ( pix_down ) ;
  pDown->setPixmap ( *pPix ) ;
  pDown->setFocusPolicy ( QWidget::StrongFocus ) ;

  pWider = new QPushButton ( tr("wider"), this ) ;
  pWider->setGeometry ( 147, 72, 25, 25 ) ;
  pPix = new QPixmap ( pix_wider ) ;
  pWider->setPixmap ( *pPix ) ;
  pWider->setFocusPolicy ( QWidget::StrongFocus ) ;

  pSmaler = new QPushButton ( tr("smaler"), this ) ;
  pSmaler->setGeometry ( 201, 72, 25, 25 ) ;
  pPix = new QPixmap ( pix_smaler ) ;
  pSmaler->setPixmap ( *pPix ) ;
  pSmaler->setFocusPolicy ( QWidget::StrongFocus ) ;

  pHigher = new QPushButton ( tr("higher"), this ) ;
  pHigher->setGeometry ( 175, 44, 25, 25 ) ;
  pPix = new QPixmap ( pix_higher ) ;
  pHigher->setPixmap ( *pPix ) ;
  pHigher->setFocusPolicy ( QWidget::StrongFocus ) ;

  pLower = new QPushButton ( tr("lower"), this ) ;
  pLower->setGeometry ( 173, 100, 25, 25 ) ;
  pPix = new QPixmap ( pix_lower ) ;
  pLower->setPixmap ( *pPix ) ;
  pLower->setFocusPolicy ( QWidget::StrongFocus ) ;

  pSyncHorz = new QCheckBox ( tr("Horizontal Positive"), this ) ;
  pSyncHorz->setGeometry ( 260, 50, 25, 25 ) ;
  pSyncHorz->setAutoResize ( TRUE ) ;
  pSyncHorz->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSyncHorz->setBackgroundPixmap ( pixmap ) ;
  pSyncHorz->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pSyncVert = new QCheckBox ( tr("Vertical Positive"), this ) ;
  pSyncVert->setGeometry ( 260, 80, 25, 25 ) ;
  pSyncVert->setAutoResize ( TRUE ) ;
  pSyncVert->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSyncVert->setBackgroundPixmap ( pixmap ) ;
  pSyncVert->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pUndo = new QPushButton ( tr("Undo"), this ) ;
  pUndo->setGeometry ( 250, 125, 175, 25 ) ;
  pUndo->setFocusPolicy ( QWidget::StrongFocus ) ;

  pDefault = new QPushButton ( tr("Default"), this ) ;
  pDefault->setGeometry ( 250, 155, 175, 25 ) ;
  pDefault->setFocusPolicy ( QWidget::StrongFocus ) ;

  pWarning = new QLabel ( tr("Press the ESC key to undo changes\nif your monitor lost syncronization"), this ) ;
  pWarning->setGeometry ( 20, 138, 210, 45 ) ;
  pWarning->setAlignment ( AlignVCenter ) ;
  pWarning->setBackgroundPixmap ( pixmap ) ;
  pWarning->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

#endif // FGL_LATER

  pGammaBox = new QGroupBox ( tr("Gamma Correction"), this ) ;
  pGammaBox->setGeometry ( 8, 193, 430, 146 ) ;
  pGammaBox->setAlignment ( AlignHCenter ) ;
  pGammaBox->setBackgroundPixmap ( pixmap ) ;
  pGammaBox->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pCouple = new QCheckBox ( tr("Link sliders"), this ) ;
  pCouple->setGeometry ( 20, 205, 25, 25 ) ;
  pCouple->setAutoResize ( TRUE ) ;
  pCouple->setFocusPolicy ( QWidget::StrongFocus ) ;
  pCouple->setBackgroundPixmap ( pixmap ) ;
  pCouple->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

#ifdef FGLRX_GAMMA_X
  pGammaX = new QCheckBox ( tr("use X"), this ) ;
  pGammaX->setGeometry ( 120, 205, 25, 25 ) ;
  pGammaX->setAutoResize ( TRUE ) ;
  pGammaX->setFocusPolicy ( QWidget::StrongFocus ) ;
  pGammaX->setBackgroundPixmap ( pixmap ) ;
  pGammaX->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
#endif // FGLRX_GAMMA_X

  pColorRed = new QFrame ( this ) ;
  pColorRed->setGeometry ( 20, 230, 90, 25 ) ;
  pColorRed->setFrameStyle ( QFrame::Panel | QFrame::Sunken ) ;
  pColorRed->setBackgroundColor ( Qt::red ) ;

  pColorGreen = new QFrame ( this ) ;
  pColorGreen->setGeometry ( 20, 265, 90, 25 ) ;
  pColorGreen->setFrameStyle ( QFrame::Panel | QFrame::Sunken ) ;
  pColorGreen->setBackgroundColor ( Qt::green ) ;

  pColorBlue = new QFrame ( this ) ;
  pColorBlue->setGeometry ( 20, 300, 90, 25 ) ;
  pColorBlue->setFrameStyle ( QFrame::Panel | QFrame::Sunken ) ;
  pColorBlue->setBackgroundColor ( Qt::blue ) ;

  pSliderRed = new QSlider ( (int)(GAMMA_MIN*100), (int)(GAMMA_MAX*100), 30, 100, QSlider::Horizontal, this) ;
  pSliderRed->setGeometry ( 120, 230, 150, 25 ) ;
  pSliderRed->setTickmarks ( (QSlider::TickSetting)2 ) ; //Below
  pSliderRed->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSliderRed->setBackgroundPixmap ( pixmap ) ;
  pSliderRed->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pSliderGreen = new QSlider ( (int)(GAMMA_MIN*100), (int)(GAMMA_MAX*100), 30, 100, QSlider::Horizontal, this) ;
  pSliderGreen->setGeometry ( 120, 265, 150, 25 ) ;
  pSliderGreen->setTickmarks ( (QSlider::TickSetting)2 ) ; //Below
  pSliderGreen->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSliderGreen->setBackgroundPixmap ( pixmap ) ;
  pSliderGreen->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pSliderBlue = new QSlider ( (int)(GAMMA_MIN*100), (int)(GAMMA_MAX*100), 30, 100, QSlider::Horizontal, this) ;
  pSliderBlue->setGeometry ( 120, 300, 150, 25 ) ;
  pSliderBlue->setTickmarks ( (QSlider::TickSetting)2 ) ; //Below
  pSliderBlue->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSliderBlue->setBackgroundPixmap ( pixmap ) ;
  pSliderBlue->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTextRed = new QLabel ( "1.0", this ) ;
  pTextRed->setGeometry ( 285, 235, 20, 20 ) ;
  pTextRed->setAutoResize ( TRUE ) ;
  pTextRed->setBackgroundPixmap ( pixmap ) ;
  pTextRed->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTextGreen = new QLabel ( "1.0", this ) ;
  pTextGreen->setGeometry ( 285, 270, 20, 20 ) ;
  pTextGreen->setAutoResize ( TRUE ) ;
  pTextGreen->setBackgroundPixmap ( pixmap ) ;
  pTextGreen->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTextBlue = new QLabel ( "1.0", this ) ;
  pTextBlue->setGeometry ( 285, 305, 20, 20 ) ;
  pTextBlue->setAutoResize ( TRUE ) ;
  pTextBlue->setBackgroundPixmap ( pixmap ) ;
  pTextBlue->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pDefaultRed = new QPushButton ( tr(">1<"), this ) ;
  pDefaultRed->setGeometry ( 325, 230, 100, 25 ) ;
  pDefaultRed->setFocusPolicy ( QWidget::StrongFocus ) ;

  pDefaultGreen = new QPushButton ( tr(">1<"), this ) ;
  pDefaultGreen->setGeometry ( 325, 265, 100, 25 ) ;
  pDefaultGreen->setFocusPolicy ( QWidget::StrongFocus ) ;

  pDefaultBlue = new QPushButton ( tr(">1<"), this ) ;
  pDefaultBlue->setGeometry ( 325, 300, 100, 25 ) ;
  pDefaultBlue->setFocusPolicy ( QWidget::StrongFocus ) ;

  //signals
#ifdef FGL_LATER
  connect ( pLeft, SIGNAL(clicked()), SLOT(OnLeft() ) ) ;
  connect ( pRight, SIGNAL(clicked()), SLOT(OnRight() ) ) ;
  connect ( pUp, SIGNAL(clicked()), SLOT(OnUp() ) ) ;
  connect ( pDown, SIGNAL(clicked()), SLOT(OnDown() ) ) ;
  connect ( pWider, SIGNAL(clicked()), SLOT(OnWider() ) ) ;
  connect ( pSmaler, SIGNAL(clicked()), SLOT(OnSmaler() ) ) ;
  connect ( pHigher, SIGNAL(clicked()), SLOT(OnHigher() ) ) ;
  connect ( pLower, SIGNAL(clicked()), SLOT(OnLower() ) ) ;
  connect ( pSyncHorz, SIGNAL(clicked()), SLOT(OnSyncHorizontal()) ) ;
  connect ( pSyncVert, SIGNAL(clicked()), SLOT(OnSyncVertical()) ) ;
  connect ( pUndo, SIGNAL(clicked()), SLOT(OnUndo() ) ) ;
#endif // FGL_LATER

  connect ( pSliderRed, SIGNAL(valueChanged(int)), SLOT(OnSliderRed(int) ) ) ;
  connect ( pSliderGreen, SIGNAL(valueChanged(int)), SLOT(OnSliderGreen(int) ) ) ;
  connect ( pSliderBlue, SIGNAL(valueChanged(int)), SLOT(OnSliderBlue(int) ) ) ;
  connect ( pDefaultRed, SIGNAL(clicked()), SLOT(OnDefaultRed() ) ) ;
  connect ( pDefaultGreen, SIGNAL(clicked()), SLOT(OnDefaultGreen() ) ) ;
  connect ( pDefaultBlue, SIGNAL(clicked()), SLOT(OnDefaultBlue() ) ) ;

  //make widgets visible
#ifdef FGL_LATER
  pMonitorBox->show() ;
  pMove->show() ;
  pSize->show() ;
  pSyncPol->show() ;
  pLeft->show() ;
  pRight->show() ;
  pUp->show() ;
  pDown->show() ;
  pWider->show() ;
  pSmaler->show() ;
  pHigher->show() ;
  pLower->show() ;
  pSyncHorz->show() ;
  pSyncVert->show() ;
  pUndo->show() ;
  pDefault->show() ;
  pWarning->show() ;
#endif // FGL_LATER

  pGammaBox->show() ;
  pCouple->show() ;
#ifdef FGLRX_GAMMA_X
  //if (m_CurMonitor == 0)
  if (!m_CurMonitor)
    pGammaX->show() ;
  else
    pGammaX->hide() ;
#endif // FGLRX_GAMMA_X
  pColorRed->show() ;
  pColorGreen->show() ;
  pColorBlue->show() ;
  pSliderRed->show() ;
  pSliderGreen->show() ;
  pSliderBlue->show() ;
  pTextRed->show() ;
  pTextGreen->show() ;
  pTextBlue->show() ;
  pDefaultRed->show() ;
  pDefaultGreen->show() ;
  pDefaultBlue->show() ;

  //init
#ifdef FGL_LATER
  ReadTimings ( ) ;
  m_CurDotClock = m_DotClock ;
  m_CurTimings = m_Timings ;
  UpdateTimingsBox ( ) ;
#endif // FGL_LATER
  ReadGamma ( ) ;
  m_CurGamma = m_Gamma ;
  pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.red ) ;
  pTextRed->setText ( Str ) ;
  pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.green ) ;
  pTextGreen->setText ( Str ) ;
  pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.blue ) ;
  pTextBlue->setText ( Str ) ;
}

bool AdjustPage::ReadTimings ( )
{
  bool                RetC ;
  Display            *dpy ;

  dpy =  XOpenDisplay ( NULL ) ;
  RetC = XF86VidModeGetModeLine ( dpy, m_CurMonitor, &m_DotClock, &m_Timings ) ;
  XCloseDisplay ( dpy ) ;

  return ( RetC ) ;
}

bool AdjustPage::ReadGamma ( )
{
  bool                RetC ;
  Display            *dpy ;
#ifdef FGLRX_USE_XEXTENSIONS
  FGLRXDriverDataRec DriverData;
#endif // FGLRX_USE_XEXTENSIONS

  m_Gamma.red = m_Gamma.green = m_Gamma.blue = GAMMA_DEFAULT ;


#ifdef FGLRX_USE_XEXTENSIONS
#ifdef FGLRX_GAMMA_X
  if ((!(m_CurMonitor)) && (pGammaX->isChecked()) ) // only first monitor for X
  {
    dpy =  XOpenDisplay ( NULL ) ;
    RetC = XF86VidModeGetGamma ( dpy, m_CurMonitor, &m_Gamma ) ;
    XCloseDisplay ( dpy ) ;
  }
  else
#endif // FGLRX_GAMMA_X
  {
      RetC = ExtGetDriverData(&DriverData);
      m_HasSecondary = DriverData.HasSecondary;
     // printf("Read gamma,DriverData Gamma1,2:  %x %x\n", DriverData.ulGamma1, DriverData.ulGamma2);
      if (RetC)
      {
          if (!(m_CurMonitor))
          {
            m_Gamma.red   = ((float)((DriverData.ulGamma1 >> 20) & 0x3FF)) / 100;
            m_Gamma.green = ((float)((DriverData.ulGamma1 >> 10) & 0x3FF)) / 100;
            m_Gamma.blue  = ((float)( DriverData.ulGamma1        & 0x3FF)) / 100;
          }
          else
          {
            m_Gamma.red   = ((float)((DriverData.ulGamma2 >> 20) & 0x3FF)) / 100;
            m_Gamma.green = ((float)((DriverData.ulGamma2 >> 10) & 0x3FF)) / 100;
            m_Gamma.blue  = ((float)( DriverData.ulGamma2        & 0x3FF)) / 100;
          }
#if 0
          DEB(printf ("=== DriverData.ulGamma1 0x%08lx .ulGamma2 0x%08lx ===\n",
                                                                DriverData.ulGamma1, 
                                                                DriverData.ulGamma2));
          DEB(printf ("=== x m_Gamma.red %f green %f blue %f ===\n",
                                            m_Gamma.red,
                                            m_Gamma.green,
                                            m_Gamma.blue));
#endif
      }
  }
  
  if (!RetC)
#endif // FGLRX_USE_XEXTENSIONS
  {
    dpy =  XOpenDisplay ( NULL ) ;
    RetC = XF86VidModeGetGamma ( dpy, m_CurMonitor, &m_Gamma ) ;
    XCloseDisplay ( dpy ) ;
  }

  if ( m_Gamma.red < GAMMA_MIN || m_Gamma.red > GAMMA_MAX ) m_Gamma.red = GAMMA_DEFAULT ;
  if ( m_Gamma.green < GAMMA_MIN || m_Gamma.green > GAMMA_MAX ) m_Gamma.green = GAMMA_DEFAULT ;
  if ( m_Gamma.blue < GAMMA_MIN || m_Gamma.blue > GAMMA_MAX ) m_Gamma.blue = GAMMA_DEFAULT ;

  return ( RetC ) ;
}

void AdjustPage::UpdateTimingsBox ( )
{
  QString Str ;

  //set header text
  Str.sprintf ( tr("Monitor Tuning ( %dx%d %dHz )"), 
                m_Timings.hdisplay,
                m_Timings.vdisplay,

                (int)(((1000.0*(double)m_DotClock)/m_Timings.htotal)/m_Timings.vtotal + 0.5)
             ) ;
  pMonitorBox->setTitle ( Str ) ;

  //disable / enable buttons
  pSyncHorz->setEnabled ( TRUE ) ;
  pSyncVert->setEnabled ( TRUE ) ;
  pUndo->setEnabled ( m_TimingsChanged ) ;
  pDefault->setEnabled ( TRUE ) ;

  //smaller
  if ( (m_Timings.htotal-1) > (m_Timings.hdisplay-1) + ( ( (m_Timings.hdisplay-1) + 1 ) / 10 ) * 5 )
    pSmaler->setEnabled ( FALSE ) ;
  else
    pSmaler->setEnabled ( TRUE ) ;

  //lower
  if ( (m_Timings.vtotal-1) > (m_Timings.vdisplay-1) + ( ( (m_Timings.vdisplay-1) + 1 ) / 10 ) * 2 )
    pLower->setEnabled ( FALSE ) ;
  else
    pLower->setEnabled ( TRUE ) ;

  //wider
  if ( (m_Timings.hsyncstart-1) <= (m_Timings.hdisplay-1) + 16 )
    pWider->setEnabled ( FALSE ) ;
  else
    pWider->setEnabled ( TRUE ) ;

  //higher
  if ( (m_Timings.vsyncstart-1) <= (m_Timings.vdisplay-1) + 2 )
    pHigher->setEnabled ( FALSE ) ;
  else
    pHigher->setEnabled ( TRUE ) ;

  //right
  if ( (m_Timings.hsyncstart-1) <= (m_Timings.hdisplay-1) + 8 )
    pRight->setEnabled ( FALSE ) ;
  else
    pRight->setEnabled ( TRUE ) ;

  //left
  if ( (m_Timings.hsyncend-1) >= (m_Timings.htotal-1) - 8 )
    pLeft->setEnabled ( FALSE ) ;
  else
    pLeft->setEnabled ( TRUE ) ;

  //down
  if ( (m_Timings.vsyncstart-1) <= (m_Timings.vdisplay-1) + 1 )
    pDown->setEnabled ( FALSE ) ;
  else
    pDown->setEnabled ( TRUE ) ;

  //up
  if ( (m_Timings.vsyncend-1) >= (m_Timings.vtotal-1) - 1 )
    pUp->setEnabled ( FALSE ) ;
  else
    pUp->setEnabled ( TRUE ) ;

  pSyncHorz->setChecked ( !(m_Timings.flags & H_NEGATIVE) ) ;
  pSyncVert->setChecked ( !(m_Timings.flags & V_NEGATIVE) ) ;
}

void AdjustPage::OnLeft ( ) 
{
  int Diff ;

  Diff = m_Timings.hsyncend - m_Timings.hsyncstart ;
  m_Timings.hsyncstart += 8 ;
  m_Timings.hsyncend += 8 ;
  if ( m_Timings.hsyncend > m_Timings.htotal - 8 )
  {
    m_Timings.hsyncend = m_Timings.htotal - 8 ;
    m_Timings.hsyncstart = m_Timings.hsyncend - Diff ;
  }
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnRight ( ) 
{
  int Diff ;

  Diff = m_Timings.hsyncend - m_Timings.hsyncstart ;
  m_Timings.hsyncstart -= 8 ;
  m_Timings.hsyncend -= 8 ;
  if ( m_Timings.hsyncstart < m_Timings.hdisplay + 8 )
  {
    m_Timings.hsyncstart = m_Timings.hdisplay + 8 ;
    m_Timings.hsyncend = m_Timings.hsyncstart + Diff ;
  }
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;

}

void AdjustPage::OnUp ( ) 
{
  int Diff ;

  Diff = m_Timings.vsyncend - m_Timings.vsyncstart ;
  m_Timings.vsyncstart += 1 ;
  m_Timings.vsyncend += 1 ;
  if ( m_Timings.vsyncend > m_Timings.vtotal - 1 )
  {
    m_Timings.vsyncend = m_Timings.vtotal - 1 ;
    m_Timings.vsyncstart = m_Timings.vsyncend - Diff ;
  }
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnDown ( ) 
{
  int Diff ;

  Diff = m_Timings.vsyncend - m_Timings.vsyncstart ;
  m_Timings.vsyncstart -= 1 ;
  m_Timings.vsyncend -= 1 ;
  if ( m_Timings.vsyncstart < m_Timings.vdisplay + 1 )
  {
    m_Timings.vsyncstart = m_Timings.vdisplay + 1 ;
    m_Timings.vsyncend = m_Timings.vsyncstart + Diff ;
  }
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnSmaler ( )
{
  m_Timings.hsyncend += 16 ;
  m_Timings.hsyncstart += 16 ;
  m_Timings.htotal += 32 ;
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnLower ( )
{
  m_Timings.vsyncend += 2 ;
  m_Timings.vsyncstart += 2 ;
  m_Timings.vtotal += 4 ;
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnWider ( )
{
  m_Timings.hsyncend -= 16 ;
  m_Timings.hsyncstart -= 16 ;
  m_Timings.htotal -= 32 ;
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnHigher ( )
{
  m_Timings.vsyncend -= 2 ;
  m_Timings.vsyncstart -= 2 ;
  m_Timings.vtotal -= 4 ;
  InvokeTimings ( ) ;
  UpdateTimingsBox ( ) ;
}

void AdjustPage::OnSyncHorizontal ( )
{
  if ( pSyncHorz->isChecked() ) m_Timings.flags &= ~H_NEGATIVE ;
  else                          m_Timings.flags |= H_NEGATIVE ;
  
  InvokeTimings ( ) ;
  pUndo->setEnabled ( TRUE ) ;
}

void AdjustPage::OnSyncVertical ( )
{
  if ( pSyncVert->isChecked() ) m_Timings.flags &= ~V_NEGATIVE ;
  else                          m_Timings.flags |= V_NEGATIVE ;
  
  InvokeTimings ( ) ;
  pUndo->setEnabled ( TRUE ) ;
}

void AdjustPage::OnUndo ( )
{
  m_Timings = m_CurTimings ;
  m_DotClock = m_CurDotClock ;
  InvokeTimings ( ) ;
  m_TimingsChanged = FALSE ;
  UpdateTimingsBox ( ) ;
}

extern QString InstallPath ;

bool AdjustPage::InvokeTimings ( )
{
  bool                RetC ;
  Display            *dpy ;
  char                Command[ 1000 ] ;

  dpy =  XOpenDisplay ( NULL ) ;
  RetC = XF86VidModeModModeLine ( dpy, m_CurMonitor, &m_Timings ) ;
  XCloseDisplay ( dpy ) ;

  m_TimingsChanged = TRUE ;

  sprintf ( Command, "%s/xrefresh", InstallPath.data() ) ;
  system ( Command ) ;

  return ( RetC ) ;
}

void AdjustPage::OnSliderRed ( int Value )
{
  float   CurGamma, DeltaGamma ;
  QString Str ;

  CurGamma = ((float)Value) / 100 ;
  if ( CurGamma == m_Gamma.red ) return ;
  if ( CurGamma < GAMMA_MIN ) CurGamma = GAMMA_MIN ;
  if ( CurGamma > GAMMA_MAX ) CurGamma = GAMMA_MAX ;
  
  DeltaGamma = (float)((int)((CurGamma - m_Gamma.red)*100)) / 100 ;
  m_Gamma.red = CurGamma ;
  if ( pCouple->isChecked() )
  {
    m_Gamma.green += DeltaGamma ;
    if ( m_Gamma.green < GAMMA_MIN ) m_Gamma.green = GAMMA_MIN ;
    if ( m_Gamma.green > GAMMA_MAX ) m_Gamma.green = GAMMA_MAX ;
    pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.green ) ;
    pTextGreen->setText ( Str ) ;

    m_Gamma.blue += DeltaGamma ;
    if ( m_Gamma.blue < GAMMA_MIN ) m_Gamma.blue = GAMMA_MIN ;
    if ( m_Gamma.blue > GAMMA_MAX ) m_Gamma.blue = GAMMA_MAX ;
    pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.blue ) ;
    pTextBlue->setText ( Str ) ;
  }
  
  InvokeGammaCorrection ( ) ;
  Str.sprintf ( "%.2f", m_Gamma.red ) ;
  pTextRed->setText ( Str ) ;
}

void AdjustPage::OnSliderGreen ( int Value )
{
  float   CurGamma, DeltaGamma ;
  QString Str ;

  CurGamma = ((float)Value) / 100 ;
  if ( CurGamma == m_Gamma.green ) return ;
  if ( CurGamma < GAMMA_MIN ) CurGamma = GAMMA_MIN ;
  if ( CurGamma > GAMMA_MAX ) CurGamma = GAMMA_MAX ;
  
  DeltaGamma = (float)((int)((CurGamma - m_Gamma.green)*100)) / 100 ;
  m_Gamma.green = CurGamma ;
  if ( pCouple->isChecked() )
  {
    m_Gamma.red += DeltaGamma ;
    if ( m_Gamma.red < GAMMA_MIN ) m_Gamma.red = GAMMA_MIN ;
    if ( m_Gamma.red > GAMMA_MAX ) m_Gamma.red = GAMMA_MAX ;
    pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.red ) ;
    pTextRed->setText ( Str ) ;

    m_Gamma.blue += DeltaGamma ;
    if ( m_Gamma.blue < GAMMA_MIN ) m_Gamma.blue = GAMMA_MIN ;
    if ( m_Gamma.blue > GAMMA_MAX ) m_Gamma.blue = GAMMA_MAX ;
    pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.blue ) ;
    pTextBlue->setText ( Str ) ;
  }
  
  InvokeGammaCorrection ( ) ;
  Str.sprintf ( "%.2f", m_Gamma.green ) ;
  pTextGreen->setText ( Str ) ;
}

void AdjustPage::OnSliderBlue ( int Value )
{
  float   CurGamma, DeltaGamma ;
  QString Str ;

  CurGamma = ((float)Value) / 100 ;
  if ( CurGamma == m_Gamma.blue ) return ;
  if ( CurGamma < GAMMA_MIN ) CurGamma = GAMMA_MIN ;
  if ( CurGamma > GAMMA_MAX ) CurGamma = GAMMA_MAX ;
  
  DeltaGamma = (float)((int)((CurGamma - m_Gamma.blue)*100)) / 100 ;
  m_Gamma.blue = CurGamma ;
  if ( pCouple->isChecked() )
  {
    m_Gamma.red += DeltaGamma ;
    if ( m_Gamma.red < GAMMA_MIN ) m_Gamma.red = GAMMA_MIN ;
    if ( m_Gamma.red > GAMMA_MAX ) m_Gamma.red = GAMMA_MAX ;
    pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.red ) ;
    pTextRed->setText ( Str ) ;

    m_Gamma.green += DeltaGamma ;
    if ( m_Gamma.green < GAMMA_MIN ) m_Gamma.green = GAMMA_MIN ;
    if ( m_Gamma.green > GAMMA_MAX ) m_Gamma.green = GAMMA_MAX ;
    pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.green ) ;
    pTextGreen->setText ( Str ) ;
  }
  
  InvokeGammaCorrection ( ) ;
  Str.sprintf ( "%.2f", m_Gamma.blue ) ;
  pTextBlue->setText ( Str ) ;
}

void AdjustPage::OnDefaultRed ( )
{
  QString Str ;

  m_Gamma.red = GAMMA_DEFAULT ;
  if ( pCouple->isChecked() )
  {
    m_Gamma.green = GAMMA_DEFAULT ;
    pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.green ) ;
    pTextGreen->setText ( Str ) ;

    m_Gamma.blue = GAMMA_DEFAULT ;
    pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.blue ) ;
    pTextBlue->setText ( Str ) ;
  }
  
  InvokeGammaCorrection ( ) ;
  pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.red ) ;
  pTextRed->setText ( Str ) ;
}


void AdjustPage::OnDefaultGreen ( )
{
  QString Str ;

  m_Gamma.green = GAMMA_DEFAULT ;
  if ( pCouple->isChecked() )
  {
    m_Gamma.red = GAMMA_DEFAULT ;
    pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.red ) ;
    pTextRed->setText ( Str ) ;

    m_Gamma.blue = GAMMA_DEFAULT ;
    pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.blue ) ;
    pTextBlue->setText ( Str ) ;
  }
  
  InvokeGammaCorrection ( ) ;
  pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;

  Str.sprintf ( "%.2f", m_Gamma.green ) ;
  pTextGreen->setText ( Str ) ;
}

void AdjustPage::OnDefaultBlue ( )
{
  QString Str ;

  m_Gamma.blue = GAMMA_DEFAULT ;
  if ( pCouple->isChecked() )
  {
    m_Gamma.red = GAMMA_DEFAULT ;
    pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.red ) ;
    pTextRed->setText ( Str ) ;

    m_Gamma.green = GAMMA_DEFAULT ;
    pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;
    Str.sprintf ( "%.2f", m_Gamma.green ) ;
    pTextGreen->setText ( Str ) ;
  }
  
  InvokeGammaCorrection ( ) ;
  pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.blue ) ;
  pTextBlue->setText ( Str ) ;
}

bool AdjustPage::InvokeGammaCorrection ( )
{
  bool                RetC=FALSE ;
  Display            *dpy ;
#ifdef FGLRX_USE_XEXTENSIONS
  FGLRXGammaSettingsRec GammaSettings;
#endif // FGLRX_USE_XEXTENSIONS

#ifdef FGLRX_USE_XEXTENSIONS
#ifdef FGLRX_GAMMA_X
  if ((!(m_CurMonitor)) && (pGammaX->isChecked()) ) // only first monitor for X
  {
    dpy =  XOpenDisplay ( NULL ) ;
    RetC = XF86VidModeSetGamma ( dpy, m_CurMonitor, &m_Gamma ) ;
    XCloseDisplay ( dpy ) ;
  }
  else
#endif // FGLRX_GAMMA_X
  {
    GammaSettings.Monitor = m_CurMonitor;
    GammaSettings.ulGamma = 
        (unsigned long) ((((unsigned long)(m_Gamma.red   * 100)) << 20 ) |
                         (((unsigned long)(m_Gamma.green * 100)) << 10 ) |
                         (((unsigned long)(m_Gamma.blue * 100))));
    RetC = ExtSetGamma(&GammaSettings);
  }

  if (!RetC)
#endif // FGLRX_USE_XEXTENSIONS
  {
    dpy =  XOpenDisplay ( NULL ) ;
    RetC = XF86VidModeSetGamma ( dpy, m_CurMonitor, &m_Gamma ) ;
    XCloseDisplay ( dpy ) ;
  }
  return ( RetC ) ;
}

void AdjustPage::OnActivate ( int nPage )
{
  if ( nPage != ADJUST_PAGE ) return ;
  if ( m_Init ) return ;
  Init ( ) ;
  m_Init = TRUE ;
}

void AdjustPage::OnApply ( int *Accept )
{
  if ( !m_Init ) return ;

  *Accept |= APPLY_OK ;

  // apply means: the newly probed gamma values
  // do become the values of the current gamma setup.
  m_CurGamma = m_Gamma ;

  // we dont neet do call InvokeGammaCorrection()
  // since the tuning was already done with life feedback.
}

void AdjustPage::OnCancel ( )
{
  QString Str ;

  if ( !m_Init ) return ;

  //reset Timings
#ifdef FGL_LATER
  m_Timings = m_CurTimings ;
  m_DotClock = m_CurDotClock ;
  if ( m_TimingsChanged )
  {
    InvokeTimings ( ) ;
    m_TimingsChanged = FALSE ;
    UpdateTimingsBox ( ) ;
  }
#endif // FGL_LATER
  //reset Gamma
  m_Gamma = m_CurGamma ;
  pSliderRed->setValue ( (int)(m_Gamma.red*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.red ) ;
  pTextRed->setText ( Str ) ;
  pSliderGreen->setValue ( (int)(m_Gamma.green*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.green ) ;
  pTextGreen->setText ( Str ) ;
  pSliderBlue->setValue ( (int)(m_Gamma.blue*100) ) ;
  Str.sprintf ( "%.2f", m_Gamma.blue ) ;
  pTextBlue->setText ( Str ) ;
  InvokeGammaCorrection ( ) ;
}

















