// FGLRXExtensions.c
//////////////////////////////////////////////////////////////////////////////

#ifdef FGLRX_USE_XEXTENSIONS

// includes

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xlibint.h>
#include <X11/extensions/XTest.h>
#include <X11/extensions/sync.h>
#include <X11/Xproto.h>
#include <X11/extensions/Xdbe.h>
#include <X11/extensions/record.h>
#include <X11/extensions/shape.h>

#include <X11/extensions/xf86misc.h>
#include <X11/extensions/xf86mscstr.h>
#include "extutil.h"

#include <X11/extensions/XInput.h>

#include <X11/Xos.h>
#include <stdio.h>
#include <stdlib.h>

#include "R200_extensions.h"
#include "FGLRXExtensions.h"


//////////////////////////////////////////////////////////////////////////////
// type defines

typedef unsigned long DWORD;
typedef unsigned long ULONG;
typedef unsigned int HANDLE;
#ifndef ULONG_PTR
typedef ULONG ULONG_PTR;
#endif // ULONG_PTR


//////////////////////////////////////////////////////////////////////////////
// macro defines

// debug

#ifdef DEBUG
#define DEB(s)  s
#else
#define DEB(s)
#endif // DEBUG


#ifdef DEBUG
#define TRACE_XEXT(fmt, arg...)     printf("[FGLRXExtensions] " fmt, ##arg)
#else
#define TRACE_XEXT(fmt, arg...)     do { /* empty */ } while(0)
#endif // DEBUG

// misc

#define FALSE   (1==0)
#define TRUE    (1==1)


//////////////////////////////////////////////////////////////////////////////
// extension related defines

static XExtensionInfo _fglx_info_data;
static XExtensionInfo *fglx_info = &_fglx_info_data;
static char *fglx_extension_name = ATIFGL_EXTENSION_NAME;

// extension protocoll defines in R200_extensions.h

//////////////////////////////////////////////////////////////////////////////
// private functions

// X shutdown hook function that will cleanup the opened extension
static XEXT_GENERATE_CLOSE_DISPLAY (close_display_fglx, fglx_info)

// table with X hooks
static /* const */ XExtensionHooks fglx_extension_hooks = {
    NULL,               /* create_gc */
    NULL,               /* copy_gc */
    NULL,               /* flush_gc */
    NULL,               /* free_gc */
    NULL,               /* create_font */
    NULL,               /* free_font */
    close_display_fglx, /* close_display */
    NULL,               /* wire_to_event */
    NULL,               /* event_to_wire */
    NULL,               /* error */
    NULL,               /* error_string */
};


/*
 * find_display_fglx - get the display info block for fgl_gamme extension
 */
static XEXT_GENERATE_FIND_DISPLAY (find_display_fglx, fglx_info,
                   fglx_extension_name, 
                   &fglx_extension_hooks, 
                   ATIFGL_NUMBER_EVENTS, NULL)


/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtGetDriverData                                               */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:     Display *dpy                                                   */
/*            FGLRXDriverDataPtr pDriverData                                 */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtGetDriverData(FGLRXDriverDataPtr pDriverData)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;
    Bool RetVal = TRUE;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_fglx(dpy);

    TRACE_XEXT("=== ExtGetDriverData started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xFGLGetDriverDataReq *req;
        xFGLGetDriverDataReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(FGLGetDriverData, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_FGLGetDriverData;
        req->screen = DefaultScreen (dpy);

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        pDriverData->majorVersion       = rep.majorVersion;
        pDriverData->minorVersion       = rep.minorVersion;
        pDriverData->patchlevel         = rep.patchlevel;
        pDriverData->usBIOSVersionMajor = rep.BIOSVersionMajor;
        pDriverData->usBIOSVersionMinor = rep.BIOSVersionMinor;
        pDriverData->BoardType          = rep.usBoardType;

        TRACE_XEXT("has sec?\n");

        pDriverData->HasSecondary       = rep.HasSecondary;

        TRACE_XEXT("pDriverData->HasSecondary = %d\n",pDriverData->HasSecondary);

        pDriverData->ChipType           = rep.usChipType;
        pDriverData->VideoRam           = rep.usVideoRam;
        strcpy(pDriverData->sATiRevID,rep.sATiRevID);
        pDriverData->usAGPTransferMode  = rep.AGPTransferMode;
        pDriverData->uiAGPCapPtr        = rep.AGPCapPtr;
        pDriverData->uiAGPStatus        = rep.AGPStatus;
        pDriverData->uiAGPCommand       = rep.AGPCommand;
        pDriverData->ulGamma1           = rep.ulGamma1;
        pDriverData->ulGamma2           = rep.ulGamma2;
        pDriverData->ulDesktopSetup     = rep.ulDesktopSetup;
        pDriverData->ulPrimary          = rep.ulPrimary;

        TRACE_XEXT("maj /min/boardt. %d %d %x pDriverData->ulGamma1,2:  %x %x\n", rep.majorVersion,
            rep.minorVersion, rep.usBoardType, pDriverData->ulGamma1,pDriverData->ulGamma2 );

        TRACE_XEXT("=== go back ===\n");
        SyncHandle();
    }
    else
    {
        TRACE_XEXT("FIREGL23GAMMA extension *not* found\n");
        RetVal = FALSE;
    }
    XCloseDisplay (dpy);
    TRACE_XEXT("BoardType %x === Out ===\n", pDriverData->BoardType);

    return RetVal;
} // === ExtGetDriverData ===

/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtGetDisplaySettings                                          */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*            FGLRXDisplaySettingsPtr pDisplaySettings                       */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtGetDisplaySettings(FGLRXDisplaySettingsPtr pDisplaySettings)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_fglx(dpy);

    TRACE_XEXT("=== ExtGetDisplaySettings started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xFGLGetDisplaySettingsReq *req;
        xFGLGetDisplaySettingsReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(FGLGetDisplaySettings, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_FGLGetDisplaySettings;
        req->screen = DefaultScreen (dpy);

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        pDisplaySettings->Primary       = rep.ulPrimary;
        pDisplaySettings->Desktop       = rep.ulDesktop;

        SyncHandle();
    }
    else
    {
        TRACE_XEXT("FIREGL23GAMMA extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtGetDisplaySettings ===


/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtSetDisplaySettings                                          */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*            FGLRXDisplaySettingsPtr pDisplaySettings                       */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtSetDisplaySettings(FGLRXDisplaySettingsPtr pDisplaySettings)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_fglx(dpy);

    TRACE_XEXT("=== ExtSetDisplaySettings started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xFGLSetDisplaySettingsReq *req;
        xFGLSetDisplaySettingsReply rep;
        int i;

        TRACE_XEXT("=== HasExtension ===\n");
        GetReq(FGLSetDisplaySettings, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_FGLSetDisplaySettings;
        req->screen = DefaultScreen (dpy);
        req->ulPrimary = pDisplaySettings->Primary;
        req->ulDesktop = pDisplaySettings->Desktop;
        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        // TRACE_XEXT(" extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtSetDisplaySettings ===


/*****************************************************************************/
/*                                                                           */
/* NAME:      ExtSetGamma                                                    */
/*                                                                           */
/* FUNCTION:                                                                 */
/*                                                                           */
/* INPUT:                                                                    */
/*            FGLRXDisplaySettingsPtr pDisplaySettings                       */
/*                                                                           */
/*                                                                           */
/* OUTPUTS:                                                                  */
/*                                                                           */
/* NOTE:                                                                     */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
Bool ExtSetGamma(FGLRXGammaSettingsPtr pGammaSettings)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        exit (1);
    }

    info = find_display_fglx(dpy);

    TRACE_XEXT("=== ExtSetDisplaySettings started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xFGLVidModePanelSetGammaDataReq *req;
        xFGLVidModePanelSetGammaDataReply rep;
        int i;

        TRACE_XEXT("pGammaSettings->Monitor %d ->ulGamma 0x%08x\n",
                             pGammaSettings->Monitor, pGammaSettings->ulGamma);

        GetReq(FGLVidModePanelSetGammaData, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_FGLVidModePanelSetGammaData;
        req->screen = DefaultScreen (dpy);
        req->ulMonitor = pGammaSettings->Monitor;
        req->ulGamma = pGammaSettings->ulGamma;

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        if (!_XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse))
        {
            SyncHandle();
            XCloseDisplay (dpy);
            return FALSE;
        }

        SyncHandle();
    }
    else
    {
        // TRACE_XEXT("extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return TRUE;
} // === ExtSetGamma ===


/** \brief Set and/or get the CRTC the hardware overlay is assigned to
 */
Bool ExtSetOverlayCRTC(FGLRXOverlayCRTCSettingsPtr pOverlayCRTCSettings)
{
    Display *dpy;
    char    *displayname = NULL;
    // [First step] Check whether the extension exists
    XExtDisplayInfo *info;
    Bool retval = FALSE;

    dpy = XOpenDisplay (displayname);
    if (!dpy) 
    {
        TRACE_XEXT("unable to open display\n");
        return FALSE;
    }

    info = find_display_fglx(dpy);

    TRACE_XEXT("=== ExtSetOverlayCRTC started ===\n");
    // get driver data
    if (XextHasExtension(info))
    {
        xFGLSetOverlayCRTCReq *req;
        xFGLSetOverlayCRTCReply rep;
        int i;

        TRACE_XEXT("pOverlayCRTCSettings->uCurCRTC %d\n", pOverlayCRTCSettings->uCurCRTC);

        GetReq(FGLSetOverlayCRTC, req);

        // Fill in the request structure
        req->reqType = info->codes->major_opcode;
        // calculate size of request structure in 4 byte units 
        req->length = (sizeof(*req)+3) / 4;
        req->fireglReqType = X_FGLSetOverlayCRTC;
        req->screen = DefaultScreen (dpy);
        req->uCurCRTC = pOverlayCRTCSettings->uCurCRTC;

        // Carry out the extension function and wait for reply
        // 3rd parameter, called "extra": number of extra 32 bit words
        // reply structures must be multiple of 4 with a minimum of 32 bytes
        retval = _XReply(dpy, (xReply *)&rep, (sizeof(rep) - 32) / 4, xFalse);
        SyncHandle();

        if (retval)
        {
            pOverlayCRTCSettings->uCurCRTC = rep.uCurCRTC;
            pOverlayCRTCSettings->uPrevCRTC = rep.uPrevCRTC;
        }
    }
    else
    {
        // TRACE_XEXT("extension *not* found\n");
    }
    XCloseDisplay (dpy);
    return retval;
} // === ExtSetOverlayCRTC ===

#endif // FGLRX_USE_XEXTENSIONS
