#include "FireGLControl.h"
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>

QString InstallPath ;

extern bool bHasSecondary;

int main( int argc, char **argv )
{
    QTranslator translator ( 0 ) ;
    QString     lang ;
    QString     lfile  ;
    QFileInfo   fi ;
    int         Pos ;

    InstallPath = *argv ;
    Pos = InstallPath.findRev ( '/', -1 ) ;
    if ( Pos > -1 ) InstallPath = InstallPath.left ( Pos + 1 ) ;

    if ( getenv ( "LANG" ) ) lang = getenv ( "LANG" ) ;
    else lang = "en" ;


    lfile = "fireglcontrol_" + lang + ".qm" ;
    fi.setFile ( InstallPath + lfile ) ;
//    printf ( "%s\n", lpath.data() ) ;
//    printf ( "%s\n", lfile.data() ) ;

    QApplication::setStyle ( new QWindowsStyle ) ;

    QApplication a( argc, argv );

    if ( fi.exists() )
    {
      translator.load ( lfile, InstallPath ) ;
      a.installTranslator ( &translator ) ;
    }

    bool is_firegl = TRUE;
    if ( !BoardInfo.Init ( ) )
    {
        QMessageBox::information(
            0, QWidget::tr("Fire GL Control"),
            QWidget::tr("Driver does not provide the FireGL X11 extensions!\nPanel components will operate only partially."),
            QMessageBox::Ok + QMessageBox::Default
                               ) ;
        is_firegl = FALSE;
    }

    bool has_dual = is_firegl;
    bool has_gamma = is_firegl;

    if (has_dual)
    {
        // new dual head mode (mjg,2002/06/18)
        // disable dual page
        if (bHasSecondary)
        {
            has_dual=FALSE;
        }
        else
        {
            has_dual=TRUE;
        }
    }

    Sheet PropertySheet( 0L, "FireGLPropertySheet", is_firegl, has_dual, has_gamma );
    a.setMainWidget( &PropertySheet );
    PropertySheet.show();
    
    return a.exec();
}

// ### EOF ###
