/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fnmatch.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

#include	"FileSelP.h"
#include	"Col.h"
#include	"EntryLineP.h"
#include	"Button.h"
#include	"ScrollList.h"
#include	"Row.h"
#include	"Label.h"
#include	"Init.h"
#include	"misc.h"

static XtResource fileSelConstraintsResources [] = {
        {
         XtNleft_space ,
         XtCLeft_space ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(FileSelConstraintsRec , row.left_space) ,
         XtRImmediate ,
         (XtPointer) 3
        },
        {
         XtNright_space ,
         XtCRight_space ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(FileSelConstraintsRec , row.right_space) ,
         XtRImmediate ,
         (XtPointer) 3
        },
};

#define offset(field) XtOffsetOf(FileSelRec, fileSel.field)

static XtResource resources[] = { 
	{
         XtNspacing ,
         XtCSpacing ,
	 XtRInt ,
         sizeof(int) ,
         offset(spacing) ,
         XtRImmediate ,
         (XtPointer) 1
        },
        {
         XtNfilter ,
         XtCFilter ,
         XtRString ,
         sizeof(char *) ,
         offset(filter) ,
         XtRString ,
         (XtPointer) "*"
        },
        {
         XtNfile ,
         XtCFile ,
         XtRString ,
         sizeof(char *) ,
         offset(file) ,
         XtRString ,
         (XtPointer) NULL
        },
        {
         XtNdir ,
         XtCDir ,
         XtRString ,
         sizeof(char *) ,
         offset(dir) ,
         XtRString ,
         (XtPointer) NULL
        },
        {
         XtNok_button_cb ,
         XtCOk_button_cb ,
         XtRCallback ,
         sizeof(XtCallbackList) ,
         offset(ok_cb) ,
	 XtRCallback ,
         (XtPointer) NULL
        },
        {
         XtNcancel_button_cb ,
         XtCCancel_button_cb ,
         XtRCallback ,
         sizeof(XtCallbackList) ,
         offset(cancel_cb) ,
         XtRCallback ,
         (XtPointer) NULL
        },
        {
         XtNapply_button_cb ,
         XtCApply_button_cb ,
         XtRCallback ,
         sizeof(XtCallbackList) ,
         offset(apply_cb) ,
         XtRCallback ,
         (XtPointer) NULL
        },
 	{
         XtNhelp_button_cb ,
         XtCHelp_button_cb ,
         XtRCallback ,
         sizeof(XtCallbackList) ,
         offset(help_cb) ,
         XtRCallback ,
         (XtPointer) NULL
        },
	{
         XtNdirsel ,
         XtCDirsel ,
         XtRBoolean ,
         sizeof(Boolean) ,
         offset(dirsel) ,
         XtRImmediate ,
         (XtPointer) NULL
        },
        {
         XtNfilter_label ,
         XtCFilter_label ,
         XtRString ,
         sizeof(char *) ,
         offset(filter_label) ,
         XtRImmediate ,
         (XtPointer) "Filter : "
        },
        {
         XtNfile_label ,
         XtCFile_label ,
         XtRString ,
         sizeof(char *) ,
         offset(file_label) ,
         XtRImmediate ,
         (XtPointer) "File : "
        },
        {
         XtNdir_label ,
         XtCDir_label ,
         XtRString ,
         sizeof(char *) ,
         offset(dir_label) ,
         XtRImmediate ,
         (XtPointer) "Directory : "
        },
        {
         XtNok_label ,
         XtCOk_label ,
         XtRString ,
         sizeof(char *) ,
         offset(ok_label) ,
         XtRImmediate ,
         (XtPointer) "OK"
        },
        {
         XtNapply_label ,
         XtCApply_label ,
         XtRString ,
         sizeof(char *) ,
         offset(apply_label) ,
         XtRImmediate ,
         (XtPointer) "Apply"
        },
        {
         XtNrescan_label ,
         XtCRescan_label ,
         XtRString ,
         sizeof(char *) ,
         offset(rescan_label) ,
         XtRImmediate ,
         (XtPointer) "Rescan"
        },
        {
         XtNhelp_label ,
         XtCHelp_label ,
         XtRString ,
         sizeof(char *) ,
         offset(help_label) ,
         XtRImmediate ,
         (XtPointer) "Help"
        },
        {
         XtNcancel_label ,
         XtCCancel_label ,
         XtRString ,
         sizeof(char *) ,
         offset(cancel_label) ,
         XtRImmediate ,
         (XtPointer) "Cancel"
        },
};

static void ClassInitialize();
static void Initialize ();
static Boolean SetValues();

static void initial_settings();
static int rescan_dir();

static void Chdir();
static void RescanDir();
static void Ok();
static void Cancel();
static void Help();
static void Chfile();

static void Popdown();

FileSelClassRec fileSelClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &rowClassRec,
    /* class_name            */ "FileSel",
    /* widget_size           */ sizeof(FileSelRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager	     */ XtInheritGeometryManager,
    /* change_managed	     */ XtInheritChangeManaged,
    /* insert_child	     */ XtInheritInsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL
   },
   {
/* constraint */
    /* subresourses       */   fileSelConstraintsResources,
    /* subresource_count  */   XtNumber(fileSelConstraintsResources),
    /* constraint_size    */   sizeof(FileSelConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL
   },
/* baseConst */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse                */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* row */
   {
    /* empty		       */ 0
   },
/* fileSel */
   {
    /* empty		       */ 0
   },
};

WidgetClass fileSelWidgetClass = (WidgetClass) &fileSelClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}


static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	FileSelWidget nw = (FileSelWidget) new_widget;
	Widget col , srow , erow , slist;

	if (nw->fileSel.dir) nw->fileSel.dir = XtNewString(nw->fileSel.dir);
	if (nw->fileSel.filter) nw->fileSel.filter = XtNewString(nw->fileSel.filter);

	col = XtVaCreateManagedWidget("___fs_col" , colWidgetClass , new_widget , 
		XtNresizable , True ,
		XtNbox_type , XtCno_box ,
		XtNbox_width , 0 ,
		NULL);

	nw->fileSel.bcol_w = XtVaCreateManagedWidget("___fs_bcol" , colWidgetClass , 
		new_widget , 
		XtNbox_type , XtCno_box ,
		XtNbox_width , 0 ,
		NULL);

	nw->fileSel.ok_button_w = XtVaCreateManagedWidget("___fs_ok" , 
		buttonWidgetClass , nw->fileSel.bcol_w , XtNlabel , nw->fileSel.ok_label ,
		XtNtop_space , 10 ,
		NULL);

	XtAddCallback(nw->fileSel.ok_button_w , XtNactivate , Ok , nw);

	nw->fileSel.apply_button_w = XtVaCreateManagedWidget("___fs_apply" ,
		buttonWidgetClass , nw->fileSel.bcol_w , XtNlabel , nw->fileSel.apply_label ,
		NULL);

	XtAddCallback(nw->fileSel.apply_button_w , XtNactivate , Ok , nw);

	nw->fileSel.rescan_button_w = XtVaCreateManagedWidget("___fs_rescan" , 
		buttonWidgetClass , nw->fileSel.bcol_w , XtNlabel , nw->fileSel.rescan_label ,
		NULL);

	XtAddCallback(nw->fileSel.rescan_button_w , XtNactivate , RescanDir , nw);

	nw->fileSel.help_button_w = XtVaCreateManagedWidget("___fs_help" ,
		buttonWidgetClass , nw->fileSel.bcol_w , XtNlabel , nw->fileSel.help_label ,
		NULL);

	XtAddCallback(nw->fileSel.help_button_w , XtNactivate , Help , nw);

	nw->fileSel.cancel_button_w = XtVaCreateManagedWidget("___fs_cancel" , 
		buttonWidgetClass , nw->fileSel.bcol_w , XtNlabel , nw->fileSel.cancel_label ,
		NULL);

	XtAddCallback(nw->fileSel.cancel_button_w , XtNactivate , Cancel , nw);

	if (!nw->fileSel.dirsel)
	{
		erow = XtVaCreateManagedWidget("___fs_row" , rowWidgetClass , col ,
			XtNbox_type , XtCno_box ,
			XtNbox_width , 0 ,
			NULL);

		XtVaCreateManagedWidget("___fs_filter_l" , labelWidgetClass , erow ,
			XtNbox_type , XtCno_box ,
			XtNbox_width , 0 ,
			XtNlabel , nw->fileSel.filter_label ,
			NULL);

		nw->fileSel.filter_w = XtVaCreateManagedWidget("___fs_filter" ,
			entryLineWidgetClass , erow ,
			XtNresizable , True ,
			XtNtext , nw->fileSel.filter ,
			NULL);

		XtAddCallback(nw->fileSel.filter_w , XtNactivate , RescanDir , nw);
	}

	erow = XtVaCreateManagedWidget("___fs_row" , rowWidgetClass , col ,
		XtNbox_type , XtCno_box ,
		XtNbox_width , 0 ,
		NULL);

	XtVaCreateManagedWidget("___fs_dir_l" , labelWidgetClass , erow ,
		XtNlabel , nw->fileSel.dir_label ,
		XtNbox_type , XtCno_box ,
		XtNbox_width , 0 ,
		NULL);

	nw->fileSel.dir_w = XtVaCreateManagedWidget("___fs_dir" ,
		entryLineWidgetClass , erow ,
		XtNresizable , True ,
		NULL);

	XtAddCallback(nw->fileSel.dir_w , XtNactivate , RescanDir , nw);

	srow = XtVaCreateManagedWidget("___fs_srow" , rowWidgetClass , col ,
		XtNresizable , True ,
		XtNbox_type , XtCno_box ,
		XtNbox_width , 0 ,
		NULL);

	slist = XtVaCreateManagedWidget("___fs_dir_list" ,
		scrollListWidgetClass , srow , 
		XtNresizable , True ,
		NULL);

	nw->fileSel.dir_list_w = GetListWidget(slist);

	XtAddCallback(nw->fileSel.dir_list_w , XtNselect_cb , Chdir , NULL);

	if (!nw->fileSel.dirsel)
	{
		slist = XtVaCreateManagedWidget("___fs_dir_list" ,
			scrollListWidgetClass , srow , 
			XtNresizable , True ,
			NULL);

		nw->fileSel.file_list_w = GetListWidget(slist);

		XtAddCallback(nw->fileSel.file_list_w , XtNselect_cb , Ok , nw);
		XtAddCallback(nw->fileSel.file_list_w , XtNselect_changed_cb , Chfile , nw);

		erow = XtVaCreateManagedWidget("___fs_row" , rowWidgetClass , col ,
			XtNbox_type , XtCno_box ,
			XtNbox_width , 0 ,
			NULL);

		XtVaCreateManagedWidget("___fs_file_l" , labelWidgetClass , erow ,
			XtNlabel , nw->fileSel.file_label ,
			XtNbox_type , XtCno_box ,
			XtNbox_width , 0 ,
			NULL);

		nw->fileSel.file_w = XtVaCreateManagedWidget("___fs_file" ,
			entryLineWidgetClass , erow ,
			XtNresizable , True ,
			NULL);
	}

	nw->fileSel.num_files = 0;
	nw->fileSel.num_dir = 0;
	nw->fileSel.dir_list = NULL;
	nw->fileSel.file_list = NULL;

	initial_settings(new_widget);

	if (nw->fileSel.file && !nw->fileSel.dirsel) 
	{
		nw->fileSel.file = XtNewString(nw->fileSel.file);
		XtVaSetValues(nw->fileSel.file_w , XtNtext , nw->fileSel.file , NULL);
	}
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> fileSel.component != \
                                             w2 -> fileSel.component)


static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	FileSelWidget cw = (FileSelWidget) current;
	FileSelWidget nw = (FileSelWidget) new_widget;
	Boolean redraw = False;

	if (nw->fileSel.dir != cw->fileSel.dir)
	{
		if (cw->fileSel.dir) 
		{
			XtFree(cw->fileSel.dir);
			cw->fileSel.dir = NULL;
		}
		if (nw->fileSel.dir) nw->fileSel.dir = XtNewString(nw->fileSel.dir);
		redraw = True;
	}

	if (!nw->fileSel.dirsel)
	{
		{
			if (nw->fileSel.file) nw->fileSel.file = XtNewString(nw->fileSel.file);
			if (cw->fileSel.file)
			{
				XtFree(cw->fileSel.file);
				cw->fileSel.file = NULL;
			}
			redraw = True;
		}

		{
			if (nw->fileSel.filter) nw->fileSel.filter = XtNewString(nw->fileSel.filter);
			if (cw->fileSel.filter) 
			{
				XtFree(cw->fileSel.filter);
				cw->fileSel.filter = NULL;
			}
			redraw = True;
		}
	}

	if (redraw) initial_settings(nw);

	return redraw;
}

static void initial_settings(w)
FileSelWidget w;
{


	if (!w->fileSel.dir)
	{
		char *dir;

		dir = (char *) getcwd(NULL, MAX_PATH_LEN);
		w->fileSel.dir = (char *) malloc(strlen(dir)+2);
		strcpy(w->fileSel.dir , dir);
		strcat(w->fileSel.dir , "/");
		free(dir);
	}
	else
	{
		w->fileSel.dir = get_abs_path(w->fileSel.dir);
	}

	EntryLineSetText(w->fileSel.dir_w , w->fileSel.dir);

	if (!w->fileSel.dirsel)
	{
		if (w->fileSel.filter) w->fileSel.filter = XtNewString(w->fileSel.filter);
		else w->fileSel.filter = XtNewString("*");
	}

	rescan_dir(w , w->fileSel.dir , w->fileSel.filter);

	ListChange(w->fileSel.dir_list_w , w->fileSel.dir_list , 
		w->fileSel.num_dir , True);

	if (!w->fileSel.dirsel)
	{
		ListChange(w->fileSel.file_list_w , w->fileSel.file_list ,
			w->fileSel.num_files , True);
	}

	FreeList(w->fileSel.dir_list , w->fileSel.num_dir);

	if (!w->fileSel.dirsel)
	{
		FreeList(w->fileSel.file_list , w->fileSel.num_files);
	}
}

static int match(file , filter)
char *file;
char *filter;
{
	return ! fnmatch(filter , file , FNM_NOESCAPE | FNM_PERIOD);
}

static int lelcmp(f1 , f2)
ListStruct *f1,*f2;
{
        return strcmp(f1->label , f2->label);
}

static int rescan_dir(w,path,filter)
FileSelWidget w;
char *path;
char *filter;
{
	DIR *dir;
	struct dirent *dent;
	struct stat estat;
	char pom[MAX_PATH_LEN];
	int num_dir = 0 , num_files = 0;
	ListStruct *file_list=NULL;
	ListStruct *dir_list=NULL;

	if (!(dir = opendir(path)))
	{
		perror(path);
		return -1;
	}

	while((dent = readdir(dir)))
	{

		if ((!strcmp(path,"/")) && ((!strcmp(dent->d_name,".")) || 
			(!strcmp(dent->d_name,".."))))
				continue;

		sprintf(pom , "%s/%s" , path , dent->d_name);

		if (stat(pom , &estat))
		{
			perror(pom);
			continue;
		}
		if (S_ISDIR(estat.st_mode))
		{
			num_dir++;
			dir_list = (ListStruct *) XtRealloc((void *)dir_list ,
				num_dir * sizeof(ListStruct));
			dir_list[num_dir - 1].index = 0;
			dir_list[num_dir - 1].left_icon = None;
			dir_list[num_dir - 1].right_icon = None;
			dir_list[num_dir - 1].sensitive = True;
			dir_list[num_dir - 1].label = XtNewString(dent->d_name);
		}
		else if (!w->fileSel.dirsel)
		{
			if (!match(dent->d_name,filter)) continue;
			
			num_files++;
			file_list = (ListStruct *) XtRealloc((void *)file_list , 
				num_files * sizeof(ListStruct));
			file_list[num_files - 1].index = 0;
			file_list[num_files - 1].left_icon = None;
			file_list[num_files - 1].right_icon = None;
			file_list[num_files - 1].sensitive = True;
			file_list[num_files - 1].label = XtNewString(dent->d_name);
		}
	}

	closedir(dir);

	qsort((void *)(dir_list) , num_dir , sizeof(ListStruct) , lelcmp);

	if (!w->fileSel.dirsel) 
		qsort((void *)(file_list) , num_files , sizeof(ListStruct) , lelcmp);

	w->fileSel.num_dir = num_dir;
	w->fileSel.num_files = num_files;
	w->fileSel.dir_list = dir_list;
	w->fileSel.file_list = file_list;	

	return (0);
}

static void change_dir(w , path)
FileSelWidget w;
char *path;
{
	char *dir;

	dir = get_abs_path(path);

	if(!rescan_dir(w , dir , w->fileSel.filter))
	{
		XtFree(w->fileSel.dir);

		w->fileSel.dir = dir;

		EntryLineSetText(w->fileSel.dir_w , w->fileSel.dir);

		ListChange(w->fileSel.dir_list_w , w->fileSel.dir_list , 
			w->fileSel.num_dir , True);

		if (!w->fileSel.dirsel)
			ListChange(w->fileSel.file_list_w , w->fileSel.file_list ,
				w->fileSel.num_files , True);

		FreeList(w->fileSel.dir_list , w->fileSel.num_dir);

		if (!w->fileSel.dirsel)
			FreeList(w->fileSel.file_list , w->fileSel.num_files);


	}
	else 
	{
		XtFree(dir);
		XBell(XtDisplay((Widget)w),50);
	}
}


static void Chdir(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct *info = (ListStruct*) call_data;
	FileSelWidget cw = (FileSelWidget) XtParent(XtParent(XtParent(XtParent(w))));
	char pom[MAX_PATH_LEN];

	sprintf(pom , "%s/%s" , cw->fileSel.dir , info->label);
	
	change_dir((Widget) cw , pom);

}

static void RescanDir(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	FileSelWidget cw = (FileSelWidget) client_data;
	char *filter;
	char *dir;

	dir = EntryLineGetText(cw->fileSel.dir_w);

	if (access(dir , X_OK | R_OK | F_OK))
	{
		XBell(XtDisplay(w),50);
		return;
	}
	
	if (strcmp(dir , cw->fileSel.dir))
	{
		XtFree(cw->fileSel.dir);
		cw->fileSel.dir =  get_abs_path(dir);
	}
	
	EntryLineSetText(cw->fileSel.dir_w , cw->fileSel.dir);

	if (!cw->fileSel.dirsel)
	{
		filter = EntryLineGetText(cw->fileSel.filter_w);
		if (strcmp(filter , cw->fileSel.filter))
		{
			XtFree(cw->fileSel.filter);
			cw->fileSel.filter =  XtNewString(filter);
		}
	}

	if (!rescan_dir(cw , cw->fileSel.dir , cw->fileSel.filter))
	{
		ListChange(cw->fileSel.dir_list_w , cw->fileSel.dir_list , 
			cw->fileSel.num_dir , True);

		if (!cw->fileSel.dirsel)
			ListChange(cw->fileSel.file_list_w , cw->fileSel.file_list ,
				cw->fileSel.num_files , True);

		FreeList(cw->fileSel.dir_list , cw->fileSel.num_dir);

		if (!cw->fileSel.dirsel)
			FreeList(cw->fileSel.file_list , cw->fileSel.num_files);
	}
}

static void Ok(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	FileSelWidget cw = (FileSelWidget)client_data;
	char pom[MAX_PATH_LEN];

	XtFree(cw->fileSel.file);

	if (!cw->fileSel.dirsel)
		cw->fileSel.file =
			XtNewString(EntryLineGetText(cw->fileSel.file_w));

	sprintf(pom , "%s%s" , cw->fileSel.dir , 
		cw->fileSel.file ? cw->fileSel.file : "");

	XtCallCallbackList((Widget)cw , cw->fileSel.ok_cb , (XtPointer) pom);
}

static void Chfile(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct *info = (ListStruct*) call_data;
	FileSelWidget cw = (FileSelWidget) client_data;

	EntryLineSetText(cw->fileSel.file_w , info->label);
}

static void Help(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	FileSelWidget cw = (FileSelWidget)client_data;

	XtCallCallbackList((Widget)cw , cw->fileSel.help_cb , (XtPointer) NULL);
}

static void Cancel(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	FileSelWidget cw = (FileSelWidget)client_data;

	XtCallCallbackList((Widget)cw , cw->fileSel.cancel_cb , (XtPointer) NULL);
}

Widget GetFileSelWidget(w , which)
Widget w;
int which;
{
	FileSelWidget cw = (FileSelWidget) w;

	switch (which)
	{
		case XtCok_button:
			return cw->fileSel.ok_button_w;
		case XtCcancel_button:
			return cw->fileSel.cancel_button_w;
		case XtCapply_button:
			return cw->fileSel.apply_button_w;
		case XtChelp_button:
			return cw->fileSel.help_button_w;
		case XtCrescan_button:
			return cw->fileSel.rescan_button_w;
		case XtCfile_list:
			return cw->fileSel.file_list_w;
		case XtCdir_list:
			return cw->fileSel.dir_list_w;
		case XtCfilter_entry:
			return cw->fileSel.filter_w;
		case XtCdir_entry:
			return cw->fileSel.dir_w;
		case XtCfile_entry:
			return cw->fileSel.file_w;
		case XtCbutton_column:
			return cw->fileSel.bcol_w;
		default: XtWarning("GetFileSelWidget - bad value");
	}
	return NULL;
}

void CreateFSShell(names , namef , parent , shell , fsbox)
String names;
String namef;
Widget parent;
Widget *shell;
Widget *fsbox;
{
	*shell = XtVaCreatePopupShell(names , topLevelShellWidgetClass ,
			parent , NULL);
	*fsbox = XtVaCreateManagedWidget(namef , fileSelWidgetClass , *shell , NULL);

	XtAddCallback(*fsbox , XtNok_button_cb , Popdown , (XtPointer) *shell);
	XtAddCallback(*fsbox , XtNcancel_button_cb , Popdown , (XtPointer) *shell);

}

void CreateDSShell(names , namef , parent , shell , fsbox)
String names;
String namef;
Widget parent;
Widget *shell;
Widget *fsbox;
{
	*shell = XtVaCreatePopupShell(names , topLevelShellWidgetClass ,
			parent , NULL);
	*fsbox = XtVaCreateManagedWidget(namef , fileSelWidgetClass , *shell , 
		XtNdirsel , True , NULL);

	XtAddCallback(*fsbox , XtNok_button_cb , Popdown , (XtPointer) *shell);
	XtAddCallback(*fsbox , XtNcancel_button_cb , Popdown , (XtPointer) *shell);

}


static void Popdown(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XtPopdown((Widget)client_data);
}
