/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/Intrinsic.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include "misc.h"

int cnt_lines(in_text)
char *in_text;
{
	char *p,*s1,*s;
	int i=0;
	
	if (in_text)
	{
		p=s=s1=XtMalloc(strlen(in_text)+1);
		strcpy(s,in_text);
		for(i=1; ;i++)
		{
			p=strchr(s,'\n');
			if (p==NULL) break;
			s=++p;
		}
		free(s1);
	}
	
	return i;
}

int max_line_width(in_text,font)
char *in_text;
XFontStruct *font;
{
	char *p,*s1,*s;
	int i=0,maxw=0,pom;
	
	if (in_text)
	{
		p=s=s1=XtMalloc(strlen(in_text)+1);
		strcpy(s,in_text);
		for(i=1; ;i++)
		{
			p=strchr(s,'\n');
			if (p!=NULL) *p=0;

			pom = XTextWidth(font,s,strlen(s));

			if (pom > maxw) maxw = pom;
			if (p==NULL) break;
			s=++p;
		}
		XtFree(s1);
	}
	return maxw;
}

char *get_abs_path(path)
char *path;
{
	char *p,pom[MAX_PATH_LEN],*tmp,result[MAX_PATH_LEN]="/";
	
	

	for(p = path; isspace(*p) && *p ; p++);

	if (! (*p == '/'))
	{
		tmp = (char *) getcwd(NULL,MAX_PATH_LEN);
		sprintf(pom , "%s/%s" , tmp ,p);
	}
	else
	{
		sprintf(pom , "%s" , p);
	}

	p = strtok(pom , "/");
	
	while(p)
	{
		if (strcmp(p , "."))
		{
			if (strcmp(p , ".."))
			{
				if (result[strlen(result) - 1] != '/') strcat(result , "/");
				strcat(result , p);
			}
			else
			{
				tmp = rindex(result , '/');
				*(tmp + 1 - (tmp != result) ) = '\0';
			}
		}
		p = strtok(NULL , "/");
	}
	if (result[strlen(result) - 1] != '/') strcat(result , "/");

	tmp = (char *) malloc(strlen(result) + 1);
	strcpy(tmp , result);

	return tmp;
}

int x_atoi(str) 
char *str;
{
        char *__eptr__;
        int rv;

        rv = strtol(str , (char **) &__eptr__ , 10);
        if (*__eptr__ != '\0') errno = ERANGE;
        else errno = 0;

        return rv;
}
double x_atof(str) 
char *str;
{
        char *__eptr__;
        double rv;

        rv = strtod(str , (char **) &__eptr__);
        if (*__eptr__ != '\0') errno = ERANGE;
        else errno = 0;

        return rv;
}
