/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "bufio.h"
#include "tools.h"

#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

#define BUFIO_BUF_SIZE	4096

bufio *bufio_fdopen(fd)
int fd;
{
	bufio *retv;

	if (fd < 0) return NULL;

	retv = _malloc(sizeof(bufio));
	retv->buf = _malloc(BUFIO_BUF_SIZE);
	retv->fd = fd;
	retv->buf_size = BUFIO_BUF_SIZE;
	retv->buf_start = 0;
	retv->buf_end = 0;
	retv->bufio_errno = 0;
	retv->eof = 0;

	return retv;
}

bufio *bufio_open(filename , flags)
char *filename;
int flags;
{
	int fd;

	fd = open(filename , flags);

	if (fd < 0) return NULL;

	return bufio_fdopen(fd);
}

bufio *bufio_copen(filename , flags , mask)
char *filename;
int flags;
int mask;
{
	int fd;

	fd = open(filename , flags , mask);

	if (fd < 0) return NULL;

	return bufio_fdopen(fd);
}

void bufio_free(desc)
bufio *desc;
{
	_free(desc->buf);
	_free(desc);
}

int bufio_close(desc)
bufio *desc;
{
	int rv;

	rv = close(desc->fd);

	desc->fd = -1;

	_free(desc->buf);
	_free(desc);

	return rv;
}

int _bufio_write(desc , buf , size , ssld)
bufio *desc;
char *buf;
int size;
void *ssld;
{
	return my_write(desc->fd , buf , size, ssld);
}

int _bufio_read(desc , buf , size , ssld)
bufio *desc;
char *buf;
int size;
void *ssld;
{
	int read_sz = 0;
	int read_act;
	int miss_size = size;
	int acnt;

	if (desc->eof)
	{
		return 0;
	}

	if (desc->bufio_errno)
	{
		errno = desc->bufio_errno;
		return -1;
	}

	while (1)
	{
		if (desc->buf_start < desc->buf_end)
		{
			read_act = miss_size < desc->buf_end - desc->buf_start ?
				miss_size : desc->buf_end - desc->buf_start;

			memcpy(buf + read_sz , desc->buf + desc->buf_start , 
				read_act);

			desc->buf_start += read_act;
			miss_size -= read_act;
			read_sz += read_act;

			if (read_sz == size)
				return read_sz;
		}
		else
		{
			desc->buf_start = 0;
			desc->buf_end = 0;
			acnt = my_read(desc->fd , desc->buf , desc->buf_size , ssld);

			if (acnt <= 0)
			{
				if (acnt == 0) desc->eof = 1;
				if (read_sz)
				{
					desc->bufio_errno = errno;
					return read_sz;
				}
				else
					return acnt;
			}

			desc->buf_end = acnt;
		}
	}
}

int _bufio_nbfread(desc , buf , size , ssld)
bufio *desc;
char *buf;
int size;
void *ssld;
{
	int read_sz;

	if (desc->eof)
	{
		return 0;
	}
	if (desc->bufio_errno)
	{
		errno = desc->bufio_errno;
		return -1;
	}

	if (desc->buf_start < desc->buf_end)
	{
		read_sz = size < desc->buf_end - desc->buf_start ?
			size : desc->buf_end - desc->buf_start;

		memcpy(buf , desc->buf + desc->buf_start , 
			read_sz);

		desc->buf_start += read_sz;

		return read_sz;
	}
	else
	{
		desc->buf_start = 0;
		desc->buf_end = 0;
		read_sz = my_read(desc->fd , buf , size , ssld);

		if (read_sz <= 0)
		{
			if (read_sz == 0) desc->eof = 1;
			if (read_sz < 0) desc->bufio_errno = errno;
		}
		return read_sz;
	}
}

int _bufio_readln(desc , buf , size, ssld)
bufio *desc;
char *buf;
int size;
void *ssld;
{
	int read_sz = 0;
	int read_act;
	int miss_size = size-1;
	int acnt;
	char *mc = NULL;

	if (desc->eof)
	{
		return 0;
	}

	if (desc->bufio_errno)
	{
		errno = desc->bufio_errno;
		return -1;
	}

	size --;

	while (1)
	{
		if (desc->buf_start < desc->buf_end)
		{
			mc = memchr(desc->buf + desc->buf_start , '\n' , 
				desc->buf_end - desc->buf_start);

			if (mc && (mc - (desc->buf + desc->buf_start) < miss_size))
			{
				read_act = mc + 1 - (desc->buf + desc->buf_start);
			}
			else
				read_act = miss_size < desc->buf_end - desc->buf_start ?
					miss_size : desc->buf_end - desc->buf_start;

			memcpy(buf + read_sz , desc->buf + desc->buf_start , 
				read_act);

			desc->buf_start += read_act;
			miss_size -= read_act;
			read_sz += read_act;

			if (read_sz == size || mc)
			{
				*(buf + read_sz) = '\0';
				return read_sz;
			}
		}
		else
		{
			desc->buf_start = 0;
			desc->buf_end = 0;
			acnt = my_read(desc->fd , desc->buf , desc->buf_size , ssld);

			if (acnt <= 0)
			{
				if (acnt == 0) desc->eof = 1;
				if (read_sz)
				{
					desc->bufio_errno = errno;
					*(buf + read_sz + 1) = '\0';
					return read_sz;
				}
				else
					return acnt;
			}

			desc->buf_end = acnt;
		}
	}
}

void bufio_unread(desc , buf , size)
bufio *desc;
char *buf;
int size;
{
	char *p = desc->buf;

	desc->buf_size = MAX(desc->buf_size , (size + desc->buf_end - desc->buf_start));

	desc->buf = _malloc(desc->buf_size);

	memmove(desc->buf , buf , size);
	memmove(desc->buf + size , p + desc->buf_start , desc->buf_end - desc->buf_start);

	desc->buf_end = size + desc->buf_end - desc->buf_start;
	desc->buf_start = 0;

	_free(p);
}

void bufio_reset(desc)
bufio *desc;
{
	desc->buf_start = 0;
	desc->buf_end = 0;
}

