/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2000 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _form_h_
#define _form_h_

#include "dllist.h"

typedef enum {
	FORM_T_TEXT,
	FORM_T_PASSWORD,
	FORM_T_CHECKBOX,
	FORM_T_RADIO,
	FORM_T_SUBMIT,
	FORM_T_RESET,
	FORM_T_FILE,
	FORM_T_HIDDEN,
	FORM_T_IMAGE,
	FORM_T_BUTTON,
	FORM_T_SELECT,
	FORM_T_OPTION,
	FORM_T_OPTGROUP,
	FORM_T_TEXTAREA,
	FORM_T_NONFORM,
	FORM_T_UNKNOWN
} form_field_types;

typedef enum {
	FORM_M_GET,
	FORM_M_POST,
	FORM_M_UNKNOWN
} form_method;

typedef enum {
	FORM_E_MULTIPART,
	FORM_E_URLENCODED,
	FORM_E_UNKNOWN
} form_encoding;

typedef struct {
	form_method	method;
	form_encoding	encoding;
	char		*action;
	dllist		*infos;
	char		*text;
	void		*parent_url;
} form_info;

typedef struct {
	form_field_types	type;
	char			*name;
	char			*value;
}form_field;

extern char *form_decode_urlencoded_str(char *,int);
extern char *form_encode_urlencoded_str(char *);
extern char *form_encode_urlencoded(dllist *);
extern char *form_encode_multipart_boundary();
extern char *form_encode_multipart(dllist *, char *, int *);
extern char *form_encode_query(form_info *, int *);

extern int form_field_compare(form_field *, form_field *);

#ifdef GTK_FACE
#include <gtk/gtk.h>

typedef struct {
	form_field_types	type;
	char			*name;
	char			*default_value;
	char			*text;
	int			width;
	int			height;
	int			maxlen;
	int			readonly;
	int			checked;
	int			disabled;
	int			multiple;
	int			selected;
	dllist			*infos;
	GtkWidget		*widget;
	GSList			*rg;
} form_field_info;

extern void form_edit_dlg();
extern void form_edit_dlg_clear();

#endif

#endif

