//
//  SelectFolder.cpp  -- functions for accessing folders and retrieving
//    message headers
//  -- created 4/20/00  updated 4/20/00
//////////////////////////////////////////////

#include "SelectFolder.h"

extern Althea gAlthea;

string readTilEOL(AConPtr the_connection, int &errnum)  {
  string buffer;
  
  /* try to check for errors in an appropriate order.
     check for more specific matches prior to the less
     specific.
  */
  
  buffer = readTilEOL(the_connection);
  
  if (strstr(buffer.c_str(), "* BYE ")!=NULL)  {
    // lost connection to server.
    // must re-login before anything else
    // can be done with the network again.
    errnum = LOST_CONNECTION_TO_SERVER;
    return "";
  }
  else if ((strstr(buffer.c_str()," NO ")!=NULL) &&
	   (strstr(buffer.c_str()," lock ")!=NULL))  {
    // lost lock on folder
    errnum = SUCCESS;   
    return(buffer);
  }
  else if ((strstr(buffer.c_str(), " RECENT")!=NULL) &&
	   (strstr(buffer.c_str(), "* ")!=NULL) &&
	   (strstr(buffer.c_str(), " 0 ")==NULL))  {
    // new mail in this folder
    errnum = NEW_MAIL;
    return(buffer);
  }
  else if (strstr(buffer.c_str()," NO CLIENT BUG DETECTED")!=NULL) {
    //This is a weird thing about the UW imapd.  
    //Apparently you "shouldn't" get the STATUS of a selected folder
    //I believe the relevant section is in imapd.c in a section that is
    //turned off my an ENTOURAGE_BRAIN_DAMAGE flag.  In order words,
    //we are now as brain-damaged as entourage.  Well, crud.
    errnum = SUCCESSFUL_SERVER_READ;
    return(buffer);
  }
  else if (strstr(buffer.c_str()," NO ")!=NULL)  {
    // command failed
    errnum = COMMAND_TO_SERVER_FAILED;
    return("");
  }
  else if (strstr(buffer.c_str()," BAD ")!=NULL)  {
    // command unknown or arguments invalid
    errnum = COMMAND_OR_ARGUMENTS_INVALID;
    return("");
  }
  else  {
    errnum = SUCCESSFUL_SERVER_READ;
    return(buffer);
  } 
}

void EraseBefore(string &haystack, const string &needle)  {
  haystack.erase(0,haystack.find(needle)+1);
}

void GetLineText(const string &haystack, const string &keyword, string &value)  {
  // defs
  unsigned int afterKeyword;
  value = "";
  
  // figure it out
  if (strstr(haystack.c_str(),keyword.c_str())!=NULL)  {
    afterKeyword = haystack.find(keyword) + keyword.length();
    for (; !(haystack[afterKeyword]=='\n' && haystack.substr(afterKeyword-3,3).find(",")>haystack.substr(afterKeyword-3,3).length()) && afterKeyword<=haystack.length(); 
	 afterKeyword++)
      if (haystack[afterKeyword]!='\n' && haystack[afterKeyword]!='\r')
	value += haystack[afterKeyword];
  }
  else
    value = "";
  
}

int SelectFolder(AConPtr the_connection, const string &foldername, int &numMessages, 
		 string &folderOpenStatus)  {
  // defs
  string command;
  string response;
  string tmpString;
  int startEXISTS;
  int begStatus;
  int endStatus;
  int lengthStatus;
  int errnum=SUCCESS;
  
  // make command
  command = "a003 SELECT \"" + foldername + "\"\r\n";
  
  // send command to server
  WriteToSocket(the_connection, command.c_str(), strlen(command.c_str()));
  
  if (gAlthea.get_Verbose()==2)
    cout << "C: " << command << endl;

  // read response
  do {
    response = readTilEOL(the_connection,errnum);

    // right now we only really care about 
    // how many messages are in the mailbox 
    if (strstr(response.c_str()," EXISTS"))  {
      // we know that the message is in the form
      // * <SPACE> int <SPACE> EXISTS
      // -- must find out where that int ends,
      // which is posIndex for the start of 
      // exists - 1
      startEXISTS = response.find_first_of(" EXISTS");

      // find the int substring and convert it
      // to type int
      tmpString = response.substr(2,startEXISTS-3);
      numMessages = atoi(tmpString.c_str());
    }
  }  while ((!strstr(response.c_str(),"a003 OK ")) && (errnum<END_SUCCESS)); 

  // the final response told us our read/write
  // status for this folder
  // or if the folder open was unsuccessful, some
  // info we don't want.  check it first
  if (errnum<END_SUCCESS)  {
    begStatus = response.find("[")+1;
    endStatus = response.find("]");
    lengthStatus = endStatus-begStatus;
    folderOpenStatus = response.substr(begStatus,lengthStatus);
  }
  else  {
    folderOpenStatus = "Open Failed";
  }

  return(errnum);
}



string GetFlags(AConPtr the_connection,int msgNumber, int &errnum, list<string> &parts)  {
  // defs
  string response;
  string flags;
  string command;
  string msgStringCounter;

  // read the response
  while (response.find("FLAGS")>=response.length()) {
    response = readTilEOL(the_connection,errnum);
    if (errnum>BEG_FAIL)
      return("");
  }

  // remove FLAGS parens
  EraseBefore(response,"FLAGS"); 
  EraseBefore(response,"("); 
  flags = response.substr(0,response.find(")"));
  EraseBefore(response,"("); 
  string bodystructure;
  if (response[0]!='(')
    bodystructure="("+response;
  else 
    bodystructure=response;

  parts.clear();

  string part="";
  int parencount=0;
  int numpts=0;


  for (unsigned int x=0; x<bodystructure.length()-1; x++) {
    if (bodystructure[x]=='(')
      parencount++;
    if (bodystructure[x]==')') 
      parencount--;
    part+=bodystructure[x];
     
    if (parencount==0) {       
      numpts++;
      parts.push_back(part);
      part="";
      // if there isn't another part after this -- the x<bla will shortcut if this would go over the end of the string
      if (x<bodystructure.length()-1 && bodystructure[x+1]!='(') 
	x=bodystructure.length(); // we are done
    }
  }
   
  return(flags);
}

int GetMessageHeader (AConPtr the_connection, int msgNumber, string &to, 
		      string &cc,
		      string &from, string &subject, int &uid,
		      string & date)  {
  // defs
  string msgStringCounter;
  string command;
  string header;
  string bodystructure;
  string response;
  string tmpHeader;
  string tmpLength;
  int length;      
  int end;
  int beg;
  int headerCounter;
  int i;
  int errnum=SUCCESS;
  char c;

  response="";
  while (response.find("{")>=response.length()) {
    response = readTilEOL(the_connection,errnum);      
    if (errnum>BEG_FAIL)
      return(errnum);
  }
  beg = response.find("UID")+4;
  end = response.find(" ",beg);
  uid=atoi(response.substr(beg,end-beg).c_str());
  // the first line coming back will
  // have the length of the rest of our info
  beg = response.find("{") + 1;
  end = response.find("}");
  tmpLength = response.substr(beg,end-beg);
  length = atoi(tmpLength.c_str());
  // start reading in the rest of the header
  header = "";
  i = 1;
  for (headerCounter=0; headerCounter<=length && i>0; headerCounter++)  {
    i = ReadFromSocket(the_connection,&c,1);
    header += c;
    if (gAlthea.get_Verbose()==2)
      cout << c;
	
  }


  // get the date
  GetLineText(header,"Date:",date);

  // get sender (from)
  GetLineText(header,"From:",from);

  // get subject
  GetLineText(header,"Subject:",subject);
      
  // get who it is to
  GetLineText(header,"To:",to);

  // get who it is to
  GetLineText(header,"Cc:",cc);

  //Adding for case insensitivity
  if (cc=="")
    GetLineText(header,"CC:",cc);
  if (cc=="")
    GetLineText(header,"cc:",cc);


  return(errnum);
}

int GetMessageHeaders(AConPtr the_connection,Folder &folder)  {
  // defs
  int numMessages=0;
  int errnum=SUCCESS;
  int msgCounter;
  string foldername = folder.get_Full_Folder_Name();
  string folderOpenStatus;
  string command;
  string header;
  string flags;
  string to;
  string cc;
  string from;
  string subject;
  string date;
  int uid;
  Message message;

  // select a folder
  errnum = SelectFolder(the_connection,foldername,numMessages,folderOpenStatus);
  if (errnum>BEG_FAIL)
    return(errnum);
  cerr << folder.get_Num_Messages() << endl;
  if (folder.get_Num_Messages()!=0) 
    return (GetNewMail(the_connection, folder));

  progressbarinfo *pbarinfo = create_theprogresswindow();
  gtk_widget_show(pbarinfo->the_window);
  gtk_progress_set_percentage( GTK_PROGRESS(pbarinfo->the_progress_bar),
			       0 );
  guint sbcontext=gtk_statusbar_get_context_id( GTK_STATUSBAR(pbarinfo->the_status_bar),
						"progressbar" );
   
  char statusbarmessage[100];

  g_snprintf(statusbarmessage, 98, "Downloading Messages");

  gtk_statusbar_push( GTK_STATUSBAR(pbarinfo->the_status_bar),
		      sbcontext,
		      statusbarmessage );



  // loop through and start picking up message
  // headers, adding a new message instance to
  // our folder with each iteration

  if (gAlthea.get_Verbose() >= 1)
    cout << endl;


   
  // compose our command
  command = "aHEADER uid FETCH 1:4294967296 (BODY.PEEK[header] FLAGS BODYSTRUCTURE)\r\n";
   
  /********************************************
   * get all of our header information from   *
   * the Fetch BODY[header] command           *
   * ******************************************/
   
  // send it out and
  // find the size of our header
  WriteToSocket(the_connection,command.c_str(),strlen(command.c_str()));
   
  if (gAlthea.get_Verbose()==2)
    cout << "C: " << command << endl;

  list<string> msgparts;

  for (msgCounter=1; msgCounter<=numMessages; msgCounter++)  {


    // get the headers
    if (gAlthea.get_Verbose())
      cout << "getting headers for " << msgCounter << endl;
    errnum = GetMessageHeader(the_connection,msgCounter,to,cc,from,subject,uid,date);
    if (gAlthea.get_Verbose())
      cout << "getting flags and bodystructure for " << msgCounter << endl;
    flags=(GetFlags(the_connection,msgCounter,errnum,msgparts));
    if (gAlthea.get_Verbose())
      cout << " done." << endl;
    if (errnum>BEG_FAIL)
      return(errnum);
     
    if (errnum>BEG_FAIL)
      return(errnum);
     
    gtk_progress_set_percentage( GTK_PROGRESS(pbarinfo->the_progress_bar),
				 (float)msgCounter/(float)numMessages );
     
    g_snprintf(statusbarmessage, 98, "Downloading header %d of %d.",msgCounter,numMessages);
     
    gtk_statusbar_pop(  GTK_STATUSBAR(pbarinfo->the_status_bar),
			sbcontext );
    gtk_statusbar_push( GTK_STATUSBAR(pbarinfo->the_status_bar),
			sbcontext,
			statusbarmessage );
     
     
    while (gtk_events_pending())
      gtk_main_iteration();
     
     
    if (gAlthea.get_Verbose()>=1)
      cout << "Got headers for message " << msgCounter << " of " << numMessages << ".\r";
    // insert the stuff into out message
    message.set_From_Address(from);
    // do we care about this one?
    message.set_Subject(subject);
    message.set_To_Address(to);
    message.set_CC_Address(cc);
    message.parse_Date( date );
    message.set_Have_Body( 0 );
    message.set_Flags(flags);
    // this is not the uid here.
    // it is the relative msg number/sequence id
    message.set_Message_ID(msgCounter);
    message.set_Message_Parts(msgparts);
    message.set_UID(uid);
    message.set_Sequence_Number(msgCounter);
    message.set_Server_Ptr( folder.get_Server_Ptr() );
     
     
    folder.add_Message(message);
     
     
  }



  for (int x = 1; x <= folder.get_Sequence_Stop(); x++) {
    //lets see if we need to filter the suckah
    Message * M = folder.get_Message(x);
    string flags=M->get_Flags();

    if (flags.find("een") > flags.length() && flags.find("eleted")> flags.length() && folder.get_Folder_Name()=="INBOX") {
      if (gAlthea.get_Verbose())
	cout << "I could filter it..." << endl;
      list<Filter>::iterator it;
      it = gAlthea.filter_list.begin();
      while( it != gAlthea.filter_list.end() ) {
	if (((tolower((*it).field) == "from") && (from.find((*it).filter_string)<=from.length())) ||
	    ((tolower((*it).field) == "to") && (to.find((*it).filter_string)<=to.length())) ||
	    ((tolower((*it).field) == "subject") && (subject.find((*it).filter_string)<=subject.length()))) {
	  if ((*it).folder != "") {
	    IMAPCopyMessage(the_connection, uid, (*it).folder, folder.get_Server_Ptr()->get_Folder_Root());
	  }
	  if (gAlthea.get_Verbose())
	    cout << "filtered" << endl;
	  message.Delete();
	}
	it++;
      }
    }
  }
     
  // get rid of the progress window

  gtk_widget_destroy(pbarinfo->the_window);




  // anything we didn't pick up?

  // no errors
  // return success
  if (gAlthea.get_Verbose()==1)
    cout << "\n";
  return(SUCCESS);
}

int GetNewMail(AConPtr the_connection, Folder &folder)  {
  // defs
  Message message;
  string command;
  string response;
  string tmpString;
  string to,from,subject,date,cc;
  int uid;
  string flags;
  int startEXISTS;
  int highNumMessages;
  int numMessages;
  int errnum=SUCCESS;
  int msgCounter;

  // figure out how many messages are in the folder now
  command = "a023 STATUS " + folder.get_Folder_Name() + " (MESSAGES)\r\n";
  WriteToSocket(the_connection,command.c_str(),strlen(command.c_str()));
  if (gAlthea.get_Verbose()==2)
    cout << "C: " << command << endl;

  // read response
  do {
    response = readTilEOL(the_connection,errnum);
    if (errnum>BEG_FAIL)
      return(errnum);

    // right now we only really care about 
    // how many messages are in the mailbox 
    if (strstr(response.c_str(),"(MESSAGES"))  {
      // we know that the message is in the form
      // (MESSAGES N)
      // -- must find out where that int ends,
      // which is posIndex for the start of 
      // exists - 1
      startEXISTS = response.find("(MESSAGES");
      // find the int substring and convert it
      // to type int
      tmpString = response.substr(startEXISTS+10,response.find_last_of(")")-(startEXISTS+10));
      highNumMessages = atoi(tmpString.c_str());
    }
  }  while ((!strstr(response.c_str(),"a023 OK ")) && (errnum<END_SUCCESS)); 



  // loop through and start picking up message
  // headers, adding a new message instance to
  // our folder with each iteration
  // compose our command

  if (gAlthea.get_Current_Folder()==&folder || gAlthea.get_Current_Server() != folder.get_Server_Ptr()) {
    string folderOpenStatus;
     
  
    if (folder.get_Sequence_Stop()+1 <=highNumMessages) {

      errnum = SelectFolder(the_connection,folder.get_Full_Folder_Name(),numMessages,folderOpenStatus);


      int nextuid;
      if (folder.get_Sequence_Stop()!=0)
	nextuid=folder.get_Message(folder.get_Sequence_Stop())->get_UID()+1;
      else
	nextuid=1;

       
      command = "aHEADER uid FETCH " + itoa(nextuid) + ":4294967296 BODY.PEEK[header]\r\n";

      /********************************************
       * get all of our header information from   *
       * the Fetch BODY[header] command           *
       * ******************************************/
       
      // send it out and
      // find the size of our header
      if (gAlthea.get_Verbose()==2)
	cout << "C: " << command << endl;
      WriteToSocket(the_connection,command.c_str(),strlen(command.c_str()));

      int oldstop=folder.get_Sequence_Stop();

      for (msgCounter=folder.get_Sequence_Stop()+1; msgCounter<=highNumMessages; 
	   msgCounter++)  {
	// get the headers

	errnum = GetMessageHeader(the_connection,msgCounter,to,cc,from,subject,uid,date);
	if (errnum>BEG_FAIL)
	  return(errnum);
	 
	// insert the stuff into out message
	message.set_From_Address(from);
	// do we care about this one?
	message.set_Subject(subject);
	message.set_To_Address(to);
	message.set_CC_Address(cc);
	message.parse_Date( date );
	message.set_Flags( flags );
	message.set_Have_Body( 0 );

	 
	// this is not the uid here.
	// it is the relative msg number/sequence id
	message.set_Message_ID(msgCounter);
	message.set_UID(uid);
	message.set_Sequence_Number(msgCounter);
	message.set_Server_Ptr( folder.get_Server_Ptr() );
	 
	 
	// add the message to our folder
	folder.add_Message(message);
      }
     
          
      // compose our command                     
      command = "aFL uid FETCH " + itoa(nextuid) + ":" + itoa(folder.get_Message(folder.get_Sequence_Stop())->get_UID()) + " (FLAGS BODYSTRUCTURE)\r\n";
      if (gAlthea.get_Verbose()==2)
	cout << "C: " << command << endl;
       
       
      WriteToSocket(the_connection,command.c_str(),strlen(command.c_str()));
       
      list<string> msgparts;

       
      for (int x=oldstop+1; x<=highNumMessages; x++) {       
	folder.get_Message(x)->set_Flags(GetFlags(the_connection,x,errnum,msgparts));

	 
	folder.get_Message(x)->set_Message_Parts(msgparts);	 
      }        
    } // if (folder.get_Sequence_Stop()+1 <=highNumMessages) 
   
  } // if (gAlthea.get_Current_Folder()==&folder || gAlthea.get_Current_Server() != folder.get_Server_Ptr()) {
   
  return(errnum);
}
