//
//  callbacks.h  --  gtk functions to make callbacks
//  -- created  5/23/00 updated 5/23/00
//////////////////////////////////////////////

#ifndef CALLBACKS_H
#define CALLBACKS_H
namespace std {};
using namespace std;

#include <fstream.h>
#include "Folder.h"
#include "Server.h"
#include <gtk/gtk.h>
#include <assert.h>
#include <string.h>

#include "main_window.h"
#include "new_message_window.h"
#include "about_window.h"
#include "configwindow.h"
#include "print_dialog.h"
#include "support.h"
#include "Althea.h"
#include "errors.h"
#include "helpDialog.h"
#include "imap.h"
#include "save_config.h"
#include "register.h"
#include "promptwindow.h"
#include "load_config.h"
#include "tolower.h"
#include "MIME.h"
#include "SelectFolder.h"

#define DELETED_COLORS 255, 0, 0
#define ANSWERED_COLORS 0, 255, 0
#define UNSEEN_COLORS 55, 55, 255
#define SEEN_COLORS 0, 0, 0

struct save_file_info {
  string data;
  bool isbase64;
  GtkWidget *filesel;
};




void
on_password_window_okay                 (GtkObject       *object, 
                                        gpointer        user_data);


void
on_printButton_clicked                 (GtkButton       *button,
                                        gpointer         user_data);

void 
get_mail                               ( void );

void 
get_mail                               ( Server *the_server );

void
update_message_list( Folder *the_folder );

void
select_server                          (GtkObject       *object, 
                                        gpointer        user_data);

void
select_folder                          (GtkObject       *object,
                                        gpointer        user_data);

void
on_print_message_activate              (GtkObject       *object,
                                        gpointer        user_data);

void
on_expunge_menu_activate               (GtkObject       *object,
                                        gpointer        user_data);

void
on_full_header_menu_activate               (GtkObject       *object,
					    gpointer        user_data);

void attach_file( GtkObject *object, gpointer user_data );

void create_message( GtkObject *object, gpointer user_data );

gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_main_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data);

void
on_althea_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_new_message_menu_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_save_message_menu_activate          (GtkObject     *object,
                                        gpointer      user_data);

void
on_check_mail_menu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_print_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_options_menu_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_exit_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_edit_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_copy_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_cut_menu_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_paste_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_clear_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_select_all_menu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_search_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_search_in_message_menu_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_search_in_folders_menu_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_search_again_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_advanced_search_menu_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_message_menu_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_reply_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
void
on_reply_all_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_forward_menu_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_delete_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_undelete_menu_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_move_to_folder_menu_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_address_book_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_view_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_add_an_address_menu_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_import_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_export_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_help_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_index_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_contents_menu_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_about_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_select_message                      (GtkWidget *widget,
                                        gint row,
                                        gint column,
                                        GdkEventButton *event,
                                        gpointer data);


void
on_add_server_clicked                   (GtkButton       *button,
                                        gpointer         user_data);

void
on_edit_server_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_delete_server_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void
on_add_filter_clicked                   (GtkButton       *button,
                                        gpointer         user_data);

void
on_edit_filter_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_delete_filter_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void
on_serverok_clicked                    (GtkButton       *button,
                                        gpointer         user_data);

void
on_servercancel_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void
on_filterok_clicked                    (GtkButton       *button,
                                        gpointer         user_data);

void
on_filtercancel_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void
on_okconfig_clicked						(GtkButton		*button,
								 gpointer		user_data);
void
on_registerbutton_clicked                     (GtkButton       *button,
                                        gpointer         user_data);

void
on_noregisterbutton_clicked                     (GtkButton       *button,
                                        gpointer         user_data);
void
on_passwordokbutton_clicked            (GtkButton       *button,
                                        gpointer         user_data);
void
on_entry1_key_press_event              (GtkWidget *widget,
					GdkEventKey *event,
					gpointer     data);

int 
poll_mail                              (gpointer data);





void 
on_althea_index_drag (GtkWidget* widget, GdkDragContext* drag_context, 
		      GtkSelectionData* data, guint info, guint time, 
		      gpointer user_data);


void
on_folder_list_drag (GtkWidget* widget, GdkDragContext* context, 
		     gint x, gint y, GtkSelectionData* selection_data, 
		     guint info, guint32 time, gpointer data);

gboolean
on_folder_list_drag_motion (GtkWidget* folder_list, GdkDragContext* context, 
			       gint x, gint y, guint time, gpointer user_data);

void on_folder_list_select_row (GtkCTree *ctree, GtkCTreeNode *node, gint column,
				gpointer user_data);
void 
on_attach_list_select_child            (GtkList *list,
 					GtkWidget *widget,
 					gpointer user_data);

void save_attach(GtkFileSelection *selector, gpointer user_data);



#endif
