#ifndef	cmlm_h
#define	cmlm_h
/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

static const char cmlm_h_rcsid[]="$Id: cmlm.h,v 1.9 2001/08/05 20:00:33 mrsam Exp $";

#include	"config.h"
#include	"afx/afx.h"
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	<iostream>

using namespace std;

#define	TMP	"tmp"
#define	TMPLOCK	"tmp.lock"

#define	OPTIONS	"options"
#define	DOMAINS	"sublist"
#define	ARCHIVE	"archive"
#define	UNSUBLIST "unsublist"
#define	COMMANDS "commands"
#define	COMMANDSDAT "commands.dat"

#define	BOUNCES	"bounces"
#define	BOUNCESDAT	"bounces.dat"
#define	BOUNCESLOCK	"bounces.lock"


#define	HOURLYLOCKFILE	"hourly.lock"
#define	DAILYLOCKFILE	"daily.lock"

#define	DIGESTLOCKFILE	"digest.lock"

#define	MODQUEUE "modqueue"
#define	MODQUEUELOCKFILE "modqueue.lock"

#define	HEADERADD	"headeradd"
#define	HEADERDEL	"headerdel"

#include	"datadir.h"

#define	TEMPLATEDIR	DATADIR "/couriermlm"

#define	MSGSEPARATOR	"===="

#include	"bindir.h"

#define	SENDMAIL	BINDIR "/sendmail"
#define	REFORMIME	BINDIR "/reformime"
#define	MAXRCPTS	20

#define	MSGLOCKFILE	ARCHIVE "/.lock"
#define	SEQNO	ARCHIVE "/.seqno"
#define	NEXTSEQNO	ARCHIVE "/.nextseqno"

//
//	Large domains have their own db file listing the subscribers.
//	Small domains are all lumped into one file, keyed by domain name,
//	data is address\0subinfo\0address\0subinfo...
//

#define	MISC	DOMAINS "/misc"
#define	MISCSIZE	2

#define	ALIASES	DOMAINS "/aliases"

#define	SUBLOCKFILE "sublist.lock"
#define	CMDLOCKFILE "commands.lock"

#define SUBLOGFILE "sublist.log"

class ExclusiveLock {
	int fd;
public:
	ExclusiveLock(const char *);
	~ExclusiveLock();
} ;

class SharedLock {
	int fd;
public:
	SharedLock(const char *);
	~SharedLock();
} ;

class SubSharedLock : public SharedLock {
public:
	SubSharedLock();
	~SubSharedLock();
} ;

class SubExclusiveLock : public ExclusiveLock {
public:
	SubExclusiveLock();
	~SubExclusiveLock();
} ;

class CommandLock : public ExclusiveLock {
public:
	CommandLock();
	~CommandLock();
} ;

void trapsigs(const char *);
void clearsigs(int);

CString cmdget(const char *);
CString get_verp_return(const char *, const char *);
CString toverp(CString);
CString fromverp(CString addr);

CString readmsg();
CString header(const char *, const char *);
CString returnaddr(CString, const char *);
CString mkboundary_msg(afxipipestream &);

CString mkfilename();
CString mktmpfilename();
void post(istream &, const char *);

CString header(const char *, const char *);

int is_subscriber(const char *);
int getinfo(const char *, int (*)(const char *, size_t));
int getinfodir(const char *, const char *, int (*)(const char *, size_t));
const char *myname();

int isfound(const char *, size_t);
int sendmail(const char **, pid_t &);
int wait4sendmail(pid_t);
int sendmail_bcc(pid_t &, const char *);

int goodconfirm(CString);

void ack_template(ostream &, const char *, CString);
void copy_report(const char *, afxopipestream &);
int copyio(afxipipestream &, afxopipestream &);
int copyio_noseek(afxipipestream &, afxopipestream &);
int copyio_noseek_cnt(afxipipestream &, afxopipestream &, unsigned long *);
int cmddigest(int argc, char **argv);


#endif
