#include <string>
#include <iostream>

class DBBalancer;

class DBBalancerDaemon {

public:

  DBBalancerDaemon(DBBalancer* db, unsigned int mode, bool debug);
  ~DBBalancerDaemon();
  void hello();
  void init();
  void run ();

private:
  
  int createServerSocket(string host, int port);
  int createInetServerSocket(string host, int port);
  int createUnixServerSocket(int port);
  bool testUnixSocketPath(char *path);
  void shutdown(int returnCode);
  void savePid(int port);

  DBBalancer* _db;

  string _host;
  int _port;
  long _it;
  bool _debug;

  sockaddr_in _s_in;
  sockaddr_un _s_un;

};

