#!/usr/bin/tclsh

load /usr/local/pgsql/lib/libpgtcl.so

set user 	web
set password	web
set dbname	dbbalancerd
set host	localhost
set port	5432



if {[llength $argv]<2} {

	puts "Usage: client.tcl requests_number port \[sql_sentence\]"
	exit

}

set port [lindex $argv 1]
set times [lindex $argv 0]
if {[llength $argv]==3} {
	set sql [lindex $argv 2]
} else {
	set sql "SELECT TB_ONE.FIELD1, TB_ONE.FIELD2, TB_TWO.FIELD1 FROM TB_ONE,TB_TWO WHERE TB_ONE.FIELD2=TB_TWO.FIELD2"
}
 
set hora_inicio [clock seconds]

set cont $times
while {$cont>0} {

# 	"password" authentication.
#    set conn [pg_connect -conninfo "user=$user password=$password dbname=$dbname host=$host port=$port"]
#	"trust" authentication 
#    set conn [pg_connect -conninfo "dbname=$dbname host=$host port=$port"]
#	UNIX socket
    set conn [pg_connect -conninfo "dbname=$dbname port=$port"]
    
    puts -nonewline "$port --> $cont \r"
    pg_select $conn $sql data {

	#puts -nonewline "$data(campo1) \n"
	
    }                        

    flush stdout

    pg_disconnect $conn
    incr cont -1

}

set hora_fin [clock seconds]
set dif [expr $hora_fin - $hora_inicio]

puts "\nResults:"
puts "$times iterations"
puts "$dif seconds"
puts "[expr $times.0 / $dif] requests/second."
puts "END!"
