/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DbPsql.h
 *
 * $Id: DbPsql.h,v 1.13 2002/01/02 23:54:22 benoit Exp $
 *
 * Copyright (c) 2000, 2001 Remi Lefebvre <remi@debian.org>
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DBPSQL_H
#define DBPSQL_H

#include <libpq++.h>

#include "Db.h"
#include "Dns.h"
#include "Logger.h"


/**
 * Class derived from Db implementing support for the Postgresql Database
 */
class DbPsql : public Db
{
  public:

    /// Destructor
    ~DbPsql();

    /// Constructor
    DbPsql(Logger *log, const char *dbname, const char *dbuser,
           const char *dbpass);


    //////////////////////////
    // operations on user accounts
    //////////////////////////

    /// Add a user account.
    int addUserAccount(UserAccount *account);

    /// Remove a user account.
    void delUserAccount(int id);

    /// verify if account exists
    bool accountIdExists(int id);

    /// Modify a field in a user accounts table.
    void modUserAccount(int id, char *field, char *value);
    /// modify an int field
    void modUserAccount(int id, char *field, int value);

    
    /// Fetch an account from the database by id number.
    bool fetchAccountInfo(int id, UserAccount *account);

    /// Get the account id number from an fqdn.
    int findUserAccountIdFromFqdn(const char *fqdn);

    /// Retrive the IP address of an account.
    unsigned long fetchAcctAddr(int id);

    /// update the timestamp
//    void updateLastAccess(int id);

    ///    TODO
    void getActiveAccounts();
    


    ////////////////////////
    // dns db opperations //
    ////////////////////////
    
    /// Add a DNS record.
    void addDnsRecord(int id, const char *dname, DnsRecordType type,
                      const char *data);

    /// Remove all DNS records.
    void delDnsRecords(int id);

    /// Remove a DNS record.
    void delDnsRecord(int id, const char *dname, DnsRecordType type,
                      const char *data);

    /// List all DNS records to stdout
    void listDnsRecords(int id, vector<DnsRecord> &dnsRecordList);

    /// Return the number of DNS records for an account.
    int getNbOfDnsRecords(int accountId, DnsRecordType type);


    /**
     * Run a function on all active hosts.
     */
    int pruneActiveAccount(void (*func)(int, unsigned long, time_t));

  protected:
    /// Get an account ID for a new account.
    int allocateUserAccountId();

    /// PSQL database object (libpq++)
    PgDatabase *pg;

  private:
    /// Hidden default constructor
    DbPsql();
};

#endif // DBPSQL_H
