#ifndef __htmlstreamh__
#define __htmlstreamh__

#ifndef __varsh__
  #include "vars.h"
#endif
#include <list>
#include <string>
#include <iostream>

class ParamMap;
class HTML;
class HTMLStream;
class HitopCommands;
//class Vars;
//class String;

typedef list<HTML> HTMLList;

typedef HTMLList::iterator (*ProcFunc)(HTMLStream&,HTMLList::iterator,
  const ParamMap&,const string& tag);

class HTMLStream{
public:
  static void Slice(ostream& Out, string& what);
  typedef HTMLList::iterator iterator;
  typedef HTMLList::const_iterator const_iterator;
  friend ostream& operator<<(ostream& Out,const HTMLStream& What);
  friend istream& operator>>(istream& In,HTMLStream& What);
  friend class DEFStore;
  friend class HitopCommands;
  HTMLStream();
  HTMLStream(HTMLStream* parent);
  HTMLStream& operator=(const HTMLStream& Original);
  void Process();
  void CheckHTML()const;
  void SetVar(const string& name,const string& value,Vars::Scope scope); // TODO: remove me and my references.
  static void RegisterCommand(const string& name, ProcFunc func);
  static void UnregisterCommand(const string& name, ProcFunc func);
private:
  void Mark();
  void SetContent(iterator first,iterator last);
  void SomeVars(const HTML& cur,const ParamMap& paramMap);
public:
  Vars m_curVars;
  string m_ThisPath,m_FName;
private:
  int Recurse;
  int m_debugLevel;
public:
  HTMLList m_stream;
private:
  static map<int,ProcFunc> m_funcMap;
  static bool m_funcMapInitialized;
};

#endif
