dnl MY_LIB_PATH(LIBRARY, PATH [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(MY_LIB_PATH,
[
  my_LDFLAGS="$LDFLAGS"
  my_library_name=[$1]
  my_search_path=[$2]
  my_result_path=""
  AC_MSG_CHECKING([for $my_library_name library in $my_search_path])
  for my_dir in $my_search_path; do
    test -z "$my_dir" && ac_dir=.
    if test -f $my_dir/lib$my_library_name.a; then
      my_result_path=$my_dir
      break
    fi
  done
  if ! test -z "$my_result_path"; then
    AC_MSG_RESULT([yes])
    LDFLAGS="-L$my_result_path $my_LDFLAGS"
    ifelse([$3], , , [$3])
  else
    AC_MSG_RESULT([no])
    ifelse([$4], , , [$4])
  fi
])

dnl MY_HEADER_PATH(HEADER, PATH [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(MY_HEADER_PATH,
[
  my_CPPFLAGS="$CPPFLAGS"
  my_header=[$1]
  my_search_path=[$2]
  my_result_path=""
  AC_MSG_CHECKING([for $my_header header in $my_search_path])
  for my_dir in $my_search_path; do
    test -z "$my_dir" && ac_dir=.
    if test -f $my_dir/$my_header; then
      my_result_path=$my_dir
      break
    fi
  done
  if ! test -z "$my_result_path"; then
    AC_MSG_RESULT([yes])
    CPPFLAGS="-I$my_result_path $my_CPPFLAGS"
    ifelse([$3], , , [$3])
  else
    AC_MSG_RESULT([no])
    ifelse([$4], , , [$4])
  fi
])
