#!/usr/local/bin/ruby

require 'ssl'

x509 = SSL::X509.new(ARGV[0] || 'sample.crt')
puts "Version:             " + x509.version.to_s
puts "Serial number:       " + x509.serialNumber.to_s
puts "Signature Algorithm: " + x509.sigAlgor
puts "Issuer:              " + x509.issuer
puts "Valid not before:    " + x509.notBefore
puts "Valid not after:     " + x509.notAfter
puts "Subject:             " + x509.subject
puts "Public key type:     " + x509.key_type
x509.extension.each_with_index{ |ext, i|
  puts "Extetsion[#{i}]:"
  puts "  object: " + ext[0]
  puts "  value:  " + ext[1]
}
puts x509.inspect
print x509

if ARGV[1]
  # verify with CA cert
  cacert = SSL::X509.new(ARGV[1])
  p cacert
  p x509.verify(cacert)

  # CA cert path
  p x509.verify(ARGV[1])
end
