// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef   ORGANIZER_H
#define   ORGANIZER_H

#include <qmainwindow.h>

class Collection;
class CollectionView;
class Group;
class MediaSearch;
class MediaView;
class Song;

class QAction;
class QSettings;


class Organizer : public QMainWindow
{
    Q_OBJECT

public:
    enum PlayMode { Normal, Random, OneSong, RepeatAll, RepeatOne };

    Organizer(QWidget *parent = 0);
    ~Organizer();

    inline PlayMode playMode() const { return (PlayMode) playmode; }

    void load();
    void configChanged(QSettings &);
    void deinit();

    bool isDestructing() { return destructing; }

    static Organizer *instance();


signals:
    void songSelected();
    void Play();
    void Previous();
    void Next();
    void Stop();
    void Pause();


private slots:
    void about();
    void aboutQt();


private:
    void setupActions();
    void setupMenus();
    void setupToolbars();

    MediaView *mediaview;
    CollectionView *collview;
    // QueueView *queueview;
    MediaSearch *mediasearch;

    QAction *actionSaveMedia, *actionSaveColl, *actionClose,
	*actionAbout, *actionAboutQt, *actionWhatsThis;
    QAction *actionPrevious, *actionPlay, *actionPause, *actionStop, *actionNext;
    bool destructing, autosave;
    int playmode;
};



#endif // ORGANIZER_H
