/*
** Copyright (C) 2000 Thierry MICHEL <thierry@nekhem.com>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
** As a special exception to the GNU General Public License,
** permission is granted for additional uses of the text contained in
** its release of PoPy.
**  
** The exception is that, if you link the PoPy library with other
** files to produce an executable, this does not by itself cause the
** resulting executable to be covered by the GNU General Public License
**  
** This exception applies only to the code released under the name
** PoPy. If you copy code from other releases into a copy of
** PoPy, as the General Public License permits, the exception does
** not apply to the code that you add in this way. To avoid
** misleading anyone as to the status of such modified files, you
** must delete this exception notice from them.
**  
** If you write modifications of your own for PoPy, it is your
** choice whether to permit this exception to apply to your
** modifications. If you do not wish that, delete this exception notice.
**  
*/

#include <Python.h>
#include <structmember.h>
#include <postgres.h>
#include <catalog/pg_type.h>
#include <libpq-fe.h>
#include <libpq/libpq-fs.h>
#include <regex.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

/* Handling Date and Time Objects */
#include <time.h>
#include <mxDateTime.h>

static PyObject *PoPy_connect(PyObject *self,PyObject *args);
#ifdef BLOB
static PyObject *PoPy_binary_object_create (Oid oid,PGconn *conx);
#endif

#define POPY_LO_NOTDEFINED -1000
#define MAX_BUFFER 1024
#define POPY_LOCREAT 1
#define POPY_LOUPDATE 2

/* Column status */
/* String types */
#define POPY_NULL REGPROCOID
#define POPY_CHAR CHAROID
#define POPY_VARCHAR VARCHAROID
#define POPY_TEXT TEXTOID
#define POPY_BYTE BYTEAOID
#define POPY_NAME NAMEOID
#define POPY_UNKNOWN UNKNOWNOID
#define POPY_INET INETOID
#define POPY_CIDR CIDROID
#define POPY_BPCHAR BPCHAROID
#define POPY_CASH CASHOID

/* Number types */
#define POPY_SHORT2 INT2OID
#define POPY_INTEGER INT4OID
#define POPY_SHORT4 INT8OID
#define POPY_XID XIDOID
#define POPY_CID CIDOID
#define POPY_NUMERIC NUMERICOID
#define POPY_BOOLEAN BOOLOID
#define POPY_FLOAT FLOAT4OID
#define POPY_DOUBLE FLOAT8OID


/* Array types */
#define POPY_INT2VECTOR INT2VECTOROID
#define POPY_TID TIDOID
#define POPY_OIDVECTOR OIDVECTOROID
#define POPY_POINTID POINTOID
#define POPY_LSEG LSEGOID
#define POPY_PATH PATHOID
#define POPY_BOX BOXOID
#define POPY_POLYGON POLYGONOID
#define POPY_LINE LINEOID
#define POPY_CIRCLE CIRCLEOID
 
/* PostgreSQL types definition */

/* Date Time types*/
#define POPY_DATE DATEOID
#define POPY_TIME TIMEOID
#define POPY_TIMESTAMP TIMESTAMPOID
#define POPY_ABSTIME ABSTIMEOID
#define POPY_RELTIME RELTIMEOID
#define POPY_TINTERVAL TINTERVALOID
#define POPY_INTERVAL INTERVALOID
#define POPY_TIMETZ TIMETZOID


#ifdef BLOB
#define POPY_BINARY OIDOID
#define POPY_ZPBIT ZPBITOID
#define POPY_VARBIT VARBITOID
#endif

#define POPY_ROWID 10000 /* Must be set bad value ! */



#define is_conx_object(ob) ((ob)->ob_type == &PoPy_ConnectionObject_Type)

#ifdef BLOB
#define Binary_Check(op) ((op)->ob_type == &PoPy_BinaryObject_Type)
#endif

#define SET_POPY_EXCEPTION(conn, res, type) do {  if(res == NULL){ \
                PyErr_SetString(PoPy_OperationalError,PQerrorMessage(conn));} \
                else {PyErr_SetString(type,PQresultErrorMessage(res));}\
                } while(0)

#ifdef __DEBUG__

#define DBG(s, a...) do { printf(s, ## a); printf("\n"); } while (0)

#define REF_CHECK(v) do { if ((v)->ob_refcnt != 1) { \
		printf("PoPy: refcnt bug on line %d, var %s, refs %d\n", \
			__LINE__, #v, (v)->ob_refcnt); \
		} } while (0)

#else

#define DBG(s, a...)
#define REF_CHECK(v)

#endif

static PyObject * PoPy_Error;

typedef enum {
	POPY_TRUE,
	POPY_FALSE
} POPY_BOOL;

/********************************/
/* PG DB-API Objects definition */
/********************************/

#ifdef BLOB
/* Binary object */
typedef struct {
	PyObject_HEAD
	void *buffer;
	Oid oid;
	size_t size;
} PoPy_BinaryObject;
#endif

/* Connection Object */
typedef struct {
	PyObject_HEAD
	PGconn *conn;
	POPY_BOOL opened;
        POPY_BOOL committed;
} PoPy_ConnectionObject;

/* Cursor Object */
typedef struct {
	PyObject_HEAD
	int rowcount;
	int current; 
	int nfields;
	int arraysize;
	POPY_BOOL opened;
	POPY_BOOL executed;
	PyObject *datestyle;
	PyObject *description;
	PGresult *result;
	PGconn **conn;
} PoPy_CursorObject;


/* Exceptions definition */
static PyObject * PoPy_Warning;
static PyObject * PoPy_Error;
static PyObject * PoPy_InterfaceError;
static PyObject * PoPy_DatabaseError;
static PyObject * PoPy_DataError;
static PyObject * PoPy_OperationalError;
static PyObject * PoPy_IntegrityError;
static PyObject * PoPy_InternalError;
static PyObject * PoPy_ProgrammingError;
static PyObject * PoPy_NotSupportedError;


/* Types definition */
extern PyTypeObject PoPy_ConnectionObject_Type;
extern PyTypeObject PoPy_CursorObject_Type;

#ifdef BLOB
extern PyTypeObject PoPy_BinaryObject_Type;
#endif
