/***************************************************************************
                          qdbdialog.h  -  description
                             -------------------                                         
    begin                : 29.02.2000
    version              : $Id: qdbdialog.h,v 1.9 2001/03/11 08:13:58 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef QDBDIALOG_H
#define QDBDIALOG_H

/**Grafical database dialog
(Dialogs, Tables, etc.)
  *@author Jrg Bemm
  */

#include <qtabwidget.h>
#include <qmenubar.h>

#include "sqlquerier.h"
#include "dbobj.h"
#include "qdbeingabemaske.h"

// Connect to Database, defined in sqlquerier.cpp
extern SQLQuerier sql;

// Global Database-Dialog
class QDBDialog: public QTabWidget {
  Q_OBJECT
public:
  QDBDialog(QWidget *parent = 0, const char *name = 0,
  					SQLQuerier *sql_ptr = 0, bool MakeFields = true,
  					const char *SelectPtr = 0, const char *PrimaryKeyPtr = 0,
						const char *tableName = 0, const char *filename = 0);
	virtual bool close( bool forceKill = false );
	bool killMe;

  QDBTableView *TableP2;
  QDBEingabemaske *Page1;

  SQLTable* table; // Datenbase-Query (select, usw.)

private:
	SQLQuerier *sql; // Interface to the database

  QWidget *Page2;
  QWidget *Page3;
	QFrame *frSortP3;						// Rahmen fr Sortierung auf Seite 3
  QVBoxLayout *topLayoutP2;
  QVBoxLayout *topLayoutP3;
  QDBSortFilter *SortP3;
	bool insMode;

public slots:
	void	updateView();

private slots:
	void	apply();
	void	DataRebuild();
	void	deactivatePages();
	void	activatePages();
	void	setFocus( QWidget *page );
};

#endif
