/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.InternalWindowBorder;
import netscape.application.MenuView;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.View;
import netscape.application.Window;
import netscape.application.WindowContentView;
import netscape.application.WindowOwner;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class InternalWindow
extends View
implements Window {
    RootView rootView = this.application().mainRootView();
    WindowOwner _owner;
    WindowContentView _contentView;
    View _focusedView;
    View _defaultSelectedView;
    Button _closeButton;
    MenuView menuView;
    Font _titleFont = Font.fontNamed("Helvetica", 1, 12);
    String _title = "";
    Border _border;
    int _layer;
    int _type = 1;
    int _lastX;
    int _lastY;
    int _resizePart = 0;
    boolean _closeable;
    boolean _resizable;
    boolean _canBecomeMain = true;
    boolean _containsDocument = false;
    boolean _drewOnLastDrag;
    boolean _drawToBackingStore;
    boolean _onscreen = true;
    boolean _createdDrawingBuffer;
    boolean transparent = false;
    boolean scrollToVisible;
    static Vector _resizeWindowVector = new Vector();
    static final int ABOVE = 0;
    static final int BEHIND = 1;
    static final int NO_PART = 0;
    static final int LEFT_PART = 1;
    static final int MIDDLE_PART = 2;
    static final int RIGHT_PART = 3;
    static final String ownerKey = "owner";
    static final String contentViewKey = "contentView";
    static final String focusedViewKey = "focusedView";
    static final String closeButtonKey = "closeButton";
    static final String titleFontKey = "titleFont";
    static final String titleKey = "title";
    static final String borderKey = "border";
    static final String layerKey = "layer";
    static final String typeKey = "type";
    static final String closeableKey = "closeable";
    static final String resizableKey = "resizeable";
    static final String canBecomeMainKey = "canBecomeMain";
    static final String containsDocumentKey = "canBecomeDocument";
    static final String onscreenKey = "onscreen";
    static final String transparentKey = "transparent";
    static final String scrollToVisibleKey = "scrollToVisible";
    static final String defaultSelectedViewKey = "defaultSelectedView";
    static final String menuViewKey = "menuView";
    public static final int DEFAULT_LAYER = 0;
    public static final int PALETTE_LAYER = 100;
    public static final int MODAL_LAYER = 200;
    public static final int POPUP_LAYER = 300;
    public static final int DRAG_LAYER = 400;
    public static final int IGNORE_WINDOW_CLIPVIEW_LAYER = 500;

    public InternalWindow() {
        this(0, 0, 0, 0);
    }

    public InternalWindow(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public InternalWindow(int n, int n2, int n3, int n4) {
        this(1, n, n2, n3, n4);
    }

    public InternalWindow(int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this._contentView = new WindowContentView(0, 0, 1, 1);
        this._contentView.setHorizResizeInstruction(2);
        this._contentView.setVertResizeInstruction(16);
        this.addSubviewToWindow(this._contentView);
        this._layer = 0;
        this._border = new InternalWindowBorder(this);
        this.layoutParts();
        this.setType(n);
        this._defaultSelectedView = this;
    }

    int menuViewHeight() {
        if (this.menuView == null) {
            return 0;
        }
        return this.menuView.height();
    }

    int titleBarMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.topMargin();
    }

    int leftBorderMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.leftMargin();
    }

    int rightBorderMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.rightMargin();
    }

    int bottomBorderMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.bottomMargin();
    }

    public WindowContentView contentView() {
        return this._contentView;
    }

    public Size contentSize() {
        if (this._contentView == null) {
            return null;
        }
        return new Size(this._contentView.bounds.width, this._contentView.bounds.height);
    }

    public void layoutParts() {
        if (this._contentView != null) {
            this._contentView.setAutoResizeSubviews(false);
            this._contentView.setBounds(this.leftBorderMargin(), this.titleBarMargin() + this.menuViewHeight(), this.bounds.width - (this.leftBorderMargin() + this.rightBorderMargin()), this.bounds.height - (this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin()));
            this._contentView.setAutoResizeSubviews(true);
        }
        if (this._closeButton != null) {
            this._closeButton.removeFromSuperview();
            this._closeButton.moveTo(0, 2 + (this.titleBarMargin() - 4 - this._closeButton.bounds.height) / 2);
            if (this._closeable) {
                this.addSubview(this._closeButton);
            }
        }
    }

    public void addSubview(View view) {
        if (view == this._contentView || view == this._closeButton) {
            this.addSubviewToWindow(view);
            return;
        }
        if (this._contentView != null) {
            this._contentView.addSubview(view);
        }
    }

    public void addSubviewToWindow(View view) {
        super.addSubview(view);
    }

    public void setRootView(RootView rootView) {
        if (this.rootView != rootView && this.rootView != null && this._superview != null) {
            this.rootView.removeWindow(this);
        }
        this.rootView = rootView;
    }

    public void show() {
        if (this.rootView == null) {
            throw new InconsistencyException("Can't show Window.  No RootView");
        }
        if (this._owner == null || this._owner.windowWillShow(this)) {
            if (this._superview == null) {
                this.rootView.addWindowRelativeTo(this, 0, null);
            } else {
                this.rootView.makeWindowVisible(this, 0, null);
            }
            if (this._owner != null) {
                this._owner.windowDidShow(this);
            }
        }
    }

    public void showModally() {
        Application application = Application.application();
        EventLoop eventLoop = application.eventLoop();
        int n = this.layer();
        if (n < 200) {
            this.setLayer(200);
        }
        this.show();
        this.rootView()._setMainWindow(this);
        application.beginModalSessionForView((View)this);
        application.drawAllDirtyViews();
        while (this.isVisible()) {
            Event event = eventLoop.getNextEvent();
            try {
                eventLoop.processEvent(event);
            }
            catch (Exception exception) {
                System.err.println("Uncaught Exception.");
                exception.printStackTrace(System.err);
                System.err.println("Restarting modal EventLoop.");
            }
        }
        application.endModalSessionForView((View)this);
        if (n != this.layer()) {
            this.setLayer(n);
        }
    }

    public void showInFrontOf(InternalWindow internalWindow) {
        if (internalWindow.rootView != this.rootView) {
            this.setRootView(internalWindow.rootView);
            this.rootView.addWindowRelativeTo(this, 0, internalWindow);
            return;
        }
        if (this._superview == null) {
            this.rootView.addWindowRelativeTo(this, 0, internalWindow);
            return;
        }
        this.rootView.makeWindowVisible(this, 0, internalWindow);
    }

    public void showBehind(InternalWindow internalWindow) {
        if (internalWindow.rootView != this.rootView) {
            this.setRootView(internalWindow.rootView);
            this.rootView.addWindowRelativeTo(this, 1, internalWindow);
            return;
        }
        if (this._superview == null) {
            this.rootView.addWindowRelativeTo(this, 1, internalWindow);
        }
    }

    public void moveToFront() {
        if (!this.isVisible()) {
            return;
        }
        InternalWindow internalWindow = this.rootView.frontWindowWithLayer(this.layer());
        if (internalWindow != null && internalWindow != this) {
            this.rootView.makeWindowVisible(this, 0, internalWindow);
        }
    }

    public void moveToBack() {
        if (!this.isVisible()) {
            return;
        }
        InternalWindow internalWindow = this.rootView.backWindowWithLayer(this.layer());
        if (internalWindow != null && internalWindow != this) {
            this.rootView.makeWindowVisible(this, 1, internalWindow);
        }
    }

    public void hide() {
        if (this.isVisible() && (this._owner == null || this._owner.windowWillHide(this))) {
            RootView rootView;
            if (this.containsDocument() && this.isCurrentDocument()) {
                Application.application().chooseNextCurrentDocumentWindow((Window)this);
            }
            if ((rootView = this.rootView()) != null) {
                rootView.removeWindow(this);
            }
            if (this._owner != null) {
                this._owner.windowDidHide(this);
            }
        }
    }

    public void setCanBecomeMain(boolean bl) {
        this._canBecomeMain = bl;
        if (this.isMain() && !this._canBecomeMain && this.rootView != null) {
            this.rootView._setMainWindow(null);
        }
    }

    public boolean canBecomeMain() {
        return this._canBecomeMain;
    }

    public boolean isVisible() {
        return this._superview != null;
    }

    public void setOnscreenAtStartup(boolean bl) {
        this._onscreen = bl;
    }

    public boolean onscreenAtStartup() {
        return this._onscreen;
    }

    public boolean isMain() {
        return this.rootView != null && this.rootView.mainWindow() == this;
    }

    protected Button createCloseButton() {
        Button button = new Button(0, 0, 1, 1);
        button.setImage(Bitmap.bitmapNamed("netscape/application/CloseButton.gif"));
        button.setAltImage(Bitmap.bitmapNamed("netscape/application/CloseButtonActive.gif"));
        button.setTransparent(true);
        button.sizeToMinSize();
        button.setHorizResizeInstruction(0);
        button.setVertResizeInstruction(4);
        button.moveTo(0, 2 + (this.titleBarMargin() - 4 - button.bounds.height) / 2);
        button.setTarget(this);
        button.setCommand("hide");
        button.removeAllCommandsForKeys();
        return button;
    }

    public void setCloseable(boolean bl) {
        this._closeable = bl;
        if (this._type == 0) {
            this._closeable = false;
        }
        if (this._closeable && this._closeButton == null) {
            this._closeButton = this.createCloseButton();
        }
        if (this._closeable) {
            this.addSubviewToWindow(this._closeButton);
            return;
        }
        if (this._closeButton != null) {
            this._closeButton.removeFromSuperview();
        }
    }

    public boolean isCloseable() {
        return this._closeable;
    }

    public void setResizable(boolean bl) {
        if (bl != this._resizable) {
            this._resizable = bl;
            if (this._resizable) {
                this._contentView.setHorizResizeInstruction(2);
                this._contentView.setVertResizeInstruction(16);
            }
            if (this._type == 1) {
                this.drawBottomBorder();
                this.layoutParts();
            }
        }
    }

    public boolean isResizable() {
        return this._resizable;
    }

    int resizePartWidth() {
        if (this._border instanceof InternalWindowBorder) {
            return ((InternalWindowBorder)this._border).resizePartWidth();
        }
        return 0;
    }

    public Size windowSizeForContentSize(int n, int n2) {
        return new Size(n + this.leftBorderMargin() + this.rightBorderMargin(), n2 + this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin());
    }

    public void setTitle(String string) {
        if (this._title != null && string != null && this._title.equals(string)) {
            return;
        }
        this._title = string;
        this.drawTitleBar();
    }

    public String title() {
        return this._title;
    }

    public void setBorder(Border border) {
        this._border = border;
    }

    public Border border() {
        return this._border;
    }

    public void setLayer(int n) {
        this._layer = n;
    }

    public int layer() {
        return this._layer;
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        this.setMinSize(this.resizePartWidth() * 2 + 1, this.titleBarMargin() + this.menuViewHeight() + 2);
        if (this._type == 0) {
            this._minSize.width = 0;
            this._minSize.height = 0;
            return this._minSize;
        }
        if (this._minSize.width < this.leftBorderMargin() + this.rightBorderMargin()) {
            this._minSize.width = this.leftBorderMargin() + this.rightBorderMargin();
        }
        if (this._minSize.height < this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin()) {
            this._minSize.height = this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin();
        }
        return new Size(this._minSize);
    }

    public void setOwner(WindowOwner windowOwner) {
        this._owner = windowOwner;
    }

    public WindowOwner owner() {
        return this._owner;
    }

    public void setMenuView(MenuView menuView) {
        if (menuView != null && menuView == this.menuView) {
            return;
        }
        if (this.menuView != null) {
            this.menuView.removeFromSuperview();
        }
        this.menuView = menuView;
        int n = this.leftBorderMargin();
        int n2 = this.titleBarMargin();
        int n3 = this.bounds.width - (this.leftBorderMargin() + this.rightBorderMargin());
        int n4 = this.menuView.height();
        if (n4 == 0) {
            n4 = this.menuView.minSize().height;
        }
        this.menuView.setBounds(n, n2, n3, n4);
        this.addSubviewToWindow(this.menuView);
        this.layoutParts();
    }

    public MenuView menuView() {
        return this.menuView;
    }

    public boolean isPointInBorder(int n, int n2) {
        if (this._type == 0) {
            return Rect.contains(0, 0, this.bounds.width, this.bounds.height, n, n2);
        }
        if (this._resizable && n2 > this.bounds.height - this.bottomBorderMargin()) {
            this._resizePart = n < this.resizePartWidth() ? 1 : (n > this.bounds.width - this.resizePartWidth() ? 3 : 2);
            return true;
        }
        return n2 <= this.titleBarMargin();
    }

    public View viewForMouse(int n, int n2) {
        View view = super.viewForMouse(n, n2);
        if (this._type == 0 && view == this._contentView) {
            view = this;
        }
        return view;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        if (this.transparent) {
            this._contentView.setTransparent(true);
            this.setBuffered(true);
            return;
        }
        this.setBuffered(false);
        this._contentView.setTransparent(false);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setType(int n) {
        this._type = n;
        if (this._type == 0) {
            this.setCanBecomeMain(false);
            this.setCloseable(false);
        }
        this.layoutParts();
    }

    public int type() {
        return this._type;
    }

    void updateDrawingBuffer() {
        View view;
        InternalWindow internalWindow;
        if (this.drawingBuffer == null) {
            return;
        }
        if (this.rootView == null) {
            throw new InconsistencyException("Can't draw window - no RootView");
        }
        Rect rect = Rect.newRect();
        this.rootView.disableWindowsAbove(this, true);
        this.reenableDrawing();
        Graphics graphics = this.drawingBuffer.createGraphics();
        graphics.setDebugOptions(this.shouldDebugGraphics());
        this.superview().convertRectToView(null, this.bounds, rect);
        graphics.pushState();
        graphics.translate(-rect.x, -rect.y);
        this.rootView.draw(graphics, rect);
        graphics.popState();
        int n = this.isTransparent() ? this.rootView.windows.count() : this.rootView.windows.indexOf((Object)this);
        int n2 = 0;
        int n3 = n;
        while (n3-- > 0 && n2 == 0) {
            internalWindow = (InternalWindow)this.rootView.windows.elementAt(n3);
            if (internalWindow.isTransparent() || !internalWindow.bounds.contains(this.bounds)) continue;
            n2 = n3;
        }
        if (n2 == 0 && (view = this.rootView.viewWithBuffer(this.rootView, rect)) != null) {
            Rect rect2 = Rect.newRect(0, 0, this.width(), this.height());
            this.convertRectToView(view, rect2, rect2);
            graphics.pushState();
            graphics.translate(-rect2.x, -rect2.y);
            view.draw(graphics, rect2);
            graphics.popState();
            Rect.returnRect(rect2);
        }
        n3 = n2;
        while (n3 < n) {
            internalWindow = (InternalWindow)this.rootView.windows.elementAt(n3);
            if (internalWindow.bounds.intersects(this.bounds)) {
                rect.setBounds(0, 0, this.width(), this.height());
                this.convertRectToView(internalWindow, rect, rect);
                graphics.pushState();
                graphics.translate(-rect.x, -rect.y);
                internalWindow.draw(graphics, rect);
                graphics.popState();
            }
            ++n3;
        }
        Rect.returnRect(rect);
        this.rootView.disableWindowsAbove(this, false);
        this.reenableDrawing();
        graphics.dispose();
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        this.rootView.makeWindowVisible(this, 0, null);
        if (!this.isPointInBorder(mouseEvent.x, mouseEvent.y)) {
            return false;
        }
        this._lastX = mouseEvent.x + this.bounds.x;
        this._lastY = mouseEvent.y + this.bounds.y;
        if (this._resizePart != 0) {
            InternalWindow internalWindow = new InternalWindow(this.bounds.x, this.bounds.y, 1, this.bounds.height);
            internalWindow.setType(0);
            internalWindow._contentView.setTransparent(false);
            internalWindow._contentView.setBackgroundColor(Color.darkGray);
            internalWindow.setLayer(400);
            internalWindow.setVertResizeInstruction(16);
            internalWindow.setRootView(this.rootView());
            internalWindow.show();
            _resizeWindowVector.addElement((Object)internalWindow);
            internalWindow = new InternalWindow(this.bounds.maxX() - 1, this.bounds.y, 1, this.bounds.height);
            internalWindow.setType(0);
            internalWindow._contentView.setTransparent(false);
            internalWindow._contentView.setBackgroundColor(Color.darkGray);
            internalWindow.setLayer(400);
            internalWindow.setVertResizeInstruction(16);
            internalWindow.setRootView(this.rootView());
            internalWindow.show();
            _resizeWindowVector.addElement((Object)internalWindow);
            internalWindow = new InternalWindow(this.bounds.x + 1, this.bounds.y, this.bounds.width - 2, 1);
            internalWindow.setType(0);
            internalWindow._contentView.setTransparent(false);
            internalWindow._contentView.setBackgroundColor(Color.darkGray);
            internalWindow.setLayer(400);
            internalWindow.setHorizResizeInstruction(2);
            internalWindow.setRootView(this.rootView());
            internalWindow.show();
            _resizeWindowVector.addElement((Object)internalWindow);
            internalWindow = new InternalWindow(this.bounds.x + 1, this.bounds.maxY() - 1, this.bounds.width - 2, 1);
            internalWindow.setType(0);
            internalWindow._contentView.setTransparent(false);
            internalWindow._contentView.setBackgroundColor(Color.darkGray);
            internalWindow.setLayer(400);
            internalWindow.setHorizResizeInstruction(2);
            internalWindow.setRootView(this.rootView());
            internalWindow.show();
            _resizeWindowVector.addElement((Object)internalWindow);
            return true;
        }
        return true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = n - this.bounds.x;
        int n6 = n2 - this.bounds.y;
        int n7 = n3 - this.bounds.width;
        int n8 = n4 - this.bounds.height;
        if (this.isVisible()) {
            this.moveByAndSizeBy(n5, n6, n7, n8);
            return;
        }
        this._moveBy(n5, n6);
        this._sizeBy(n7, n8);
        this._setBounds(n, n2, n3, n4);
    }

    private void _super_moveBy(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        this._setBounds(this.bounds.x + n, this.bounds.y + n2, this.bounds.width, this.bounds.height);
        if (this._superview != null) {
            this._superview.subviewDidMove(this);
        }
        this.didMoveBy(n, n2);
    }

    private void _super_sizeBy(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        this._setBounds(this.bounds.x, this.bounds.y, this.bounds.width + n, this.bounds.height + n2);
        if (this.buffered) {
            if (this.bounds.width != 0 && this.bounds.height != 0) {
                this.drawingBuffer = new Bitmap(this.bounds.width, this.bounds.height);
                this.drawingBufferValid = false;
            } else if (this.drawingBuffer != null) {
                this.drawingBuffer.flush();
                this.drawingBuffer = null;
            }
        }
        this.disableDrawing();
        if (this._superview != null) {
            this._superview.subviewDidResize(this);
        }
        super.didSizeBy(n, n2);
        this.reenableDrawing();
    }

    protected void willMoveTo(Point point) {
    }

    private void _moveBy(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        Point point = Point.newPoint(this.bounds.x + n, this.bounds.y + n2);
        this.willMoveTo(point);
        n = point.x - this.bounds.x;
        n2 = point.y - this.bounds.y;
        Point.returnPoint(point);
        if (!this.isVisible()) {
            this._super_moveBy(n, n2);
            return;
        }
        this._lastX = this.bounds.x;
        this._lastY = this.bounds.y;
        MouseEvent mouseEvent = new MouseEvent(0L, -2, this._lastX + n, this._lastY + n2, 0);
        this.mouseDragged(mouseEvent);
    }

    void _checkSize(Size size) {
        Size size2 = this.minSize();
        if (this.bounds.width + size.width < size2.width) {
            size.width = size2.width - this.bounds.width;
        }
        if (this.bounds.height + size.height < size2.height) {
            size.height = size2.height - this.bounds.height;
        }
        if (this._owner != null) {
            this._owner.windowWillSizeBy(this, size);
        }
    }

    private void _sizeBy(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        Size size = Size.newSize(n, n2);
        this._checkSize(size);
        n = size.width;
        n2 = size.height;
        Size.returnSize(size);
        if (!this.isVisible()) {
            this._super_sizeBy(n, n2);
            this.layoutParts();
            return;
        }
        Rect rect = Rect.newRect(this.bounds);
        this._super_sizeBy(n, n2);
        this.layoutParts();
        if (this.canDraw()) {
            rect.unionWith(this.bounds);
            this.superview().convertRectToView(null, rect, rect);
            this.rootView.redraw(rect);
        }
        Rect.returnRect(rect);
    }

    private void moveByAndSizeBy(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        Size size = Size.newSize(n3, n4);
        this._checkSize(size);
        n3 = size.width;
        n4 = size.height;
        Size.returnSize(size);
        Point point = Point.newPoint(this.bounds.x + n, this.bounds.y + n2);
        this.willMoveTo(point);
        n = point.x - this.bounds.x;
        n2 = point.y - this.bounds.y;
        Point.returnPoint(point);
        if (!this.isVisible()) {
            this._super_moveBy(n, n2);
            this._super_sizeBy(n3, n4);
            this.layoutParts();
            return;
        }
        Rect rect = Rect.newRect(this.bounds);
        this._super_moveBy(n, n2);
        this._super_sizeBy(n3, n4);
        if (n3 != 0 || n4 != 0) {
            this.layoutParts();
        }
        rect.unionWith(this.bounds);
        if (this.superview() != this.rootView) {
            this.superview().convertRectToView(this.rootView, rect, rect);
        }
        if (this.isTransparent()) {
            this.disableDrawing();
            this.rootView.redraw(rect);
            this.reenableDrawing();
            this.draw();
        } else {
            this.rootView.redraw(rect);
        }
        Rect.returnRect(rect);
    }

    private void moveToAndSizeTo(int n, int n2, int n3, int n4) {
        this.moveByAndSizeBy(n - this.bounds.x, n2 - this.bounds.y, n3 - this.bounds.width, n4 - this.bounds.height);
    }

    public void setScrollsToVisible(boolean bl) {
        this.scrollToVisible = bl;
    }

    public boolean scrollsToVisible() {
        return this.scrollToVisible;
    }

    public void scrollRectToVisible(Rect rect) {
        int n = 0;
        int n2 = 0;
        if (!this.scrollToVisible) {
            return;
        }
        Rect rect2 = Rect.newRect();
        this.computeVisibleRect(rect2);
        if (rect2.width == this.bounds.width && rect2.height == this.bounds.height) {
            Rect.returnRect(rect2);
            return;
        }
        if (!rect2.contains(rect)) {
            this.convertRectToView(null, rect2, rect2);
            Rect rect3 = Rect.newRect();
            this.convertRectToView(null, rect, rect3);
            Rect rect4 = Rect.newRect(0, 0, this.width(), this.height());
            this.convertRectToView(null, rect4, rect4);
            if (rect3.x < rect2.x && rect2.x > rect4.x) {
                n = rect2.x - rect3.x;
            } else if (rect3.maxX() > rect2.maxX() && rect2.maxX() < rect4.maxX()) {
                n = rect2.maxX() - rect3.maxX();
            }
            if (rect3.y < rect2.y && rect2.y > rect4.y) {
                n2 = rect2.y - rect3.y;
            } else if (rect3.maxY() > rect2.maxY() && rect2.maxY() < rect4.maxY()) {
                n2 = rect2.maxY() - rect3.maxY();
            }
            Rect rect5 = this.rootView().bounds;
            if (n > 0 && rect4.x + n > 3) {
                n = 3 - rect4.x;
            } else if (n < 0 && rect4.maxX() + n < rect5.maxX() - 3) {
                n = rect5.maxX() - 3 - rect4.maxX();
            }
            if (n2 > 0 && rect4.y + n2 > 3) {
                n2 = 3 - rect4.y;
            } else if (n2 < 0 && rect4.maxY() + n2 < rect5.maxY() - 3) {
                n2 = rect5.maxY() - 3 - rect4.maxY();
            }
            this.moveBy(n, n2);
            Rect.returnRect(rect3);
            Rect.returnRect(rect4);
        }
        Rect.returnRect(rect2);
    }

    public void subviewDidResize() {
    }

    public void center() {
        Rect rect = this.rootView.bounds;
        Rect rect2 = new Rect((rect.width - this.bounds.width) / 2, (rect.height - this.bounds.height) / 2, this.bounds.width, this.bounds.height);
        if (rect2.y < 0) {
            rect2.y = 0;
        }
        this.setBounds(rect2);
    }

    void mouseResizeDrag(MouseEvent mouseEvent) {
        int n = 0;
        mouseEvent.x += this.bounds.x;
        mouseEvent.y += this.bounds.y;
        if (this._resizePart == 2) {
            mouseEvent.x = this._lastX;
        }
        Rect rect = Rect.newRect(this.bounds);
        if (this._resizePart == 1) {
            rect.moveBy(mouseEvent.x - this._lastX, 0);
            rect.sizeBy(this._lastX - mouseEvent.x, mouseEvent.y - this._lastY);
        } else {
            rect.sizeBy(mouseEvent.x - this._lastX, mouseEvent.y - this._lastY);
        }
        if (rect.height > this.superview().height() - rect.y) {
            rect.sizeBy(0, this.superview().height() - rect.height - rect.y);
        }
        Size size = Size.newSize(rect.width - this.bounds.width, rect.height - this.bounds.height);
        this._checkSize(size);
        if (this._resizePart == 1) {
            if (rect.x > this.bounds.x + this.bounds.width) {
                rect.moveBy(this.bounds.x - rect.x - size.width, 0);
            } else {
                rect.moveBy(rect.width - this.bounds.width - size.width, 0);
            }
        }
        rect.sizeBy(size.width - (rect.width - this.bounds.width), size.height - (rect.height - this.bounds.height));
        Size.returnSize(size);
        InternalWindow internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
        n = rect.height - internalWindow.bounds.height;
        if (this._resizePart == 1) {
            if (n < 0) {
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
                internalWindow.sizeTo(1, rect.height);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(2);
                internalWindow.moveToAndSizeTo(rect.x + 1, rect.y, rect.width - 2, 1);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(3);
                internalWindow.moveToAndSizeTo(rect.x + 1, rect.maxY() - 1, rect.width - 2, 1);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
                internalWindow.moveToAndSizeTo(rect.x, rect.y, 1, rect.height);
            } else {
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
                internalWindow.moveToAndSizeTo(rect.x, rect.y, 1, rect.height);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(3);
                internalWindow.moveToAndSizeTo(rect.x + 1, rect.maxY() - 1, rect.width - 2, 1);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(2);
                internalWindow.moveToAndSizeTo(rect.x + 1, rect.y, rect.width - 2, 1);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
                internalWindow.sizeTo(1, rect.height);
            }
        } else if (this._resizePart == 2) {
            if (n < 0) {
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
                internalWindow.sizeTo(1, rect.height);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
                internalWindow.sizeTo(1, rect.height);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(3);
                internalWindow.moveToAndSizeTo(rect.x + 1, rect.maxY() - 1, internalWindow.bounds.width, internalWindow.bounds.height);
            } else {
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(3);
                internalWindow.moveToAndSizeTo(rect.x + 1, rect.maxY() - 1, internalWindow.bounds.width, internalWindow.bounds.height);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
                internalWindow.sizeTo(1, rect.height);
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
                internalWindow.sizeTo(1, rect.height);
            }
        } else if (n < 0) {
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
            internalWindow.sizeTo(1, rect.height);
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(2);
            internalWindow.sizeTo(rect.width - 2, 1);
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(3);
            internalWindow.moveToAndSizeTo(rect.x + 1, rect.maxY() - 1, rect.width - 2, 1);
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
            internalWindow.moveToAndSizeTo(rect.maxX() - 1, rect.y, 1, rect.height);
        } else {
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
            internalWindow.moveToAndSizeTo(rect.maxX() - 1, rect.y, 1, rect.height);
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(3);
            internalWindow.moveToAndSizeTo(rect.x + 1, rect.maxY() - 1, rect.width - 2, 1);
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(2);
            internalWindow.sizeTo(rect.width - 2, 1);
            internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
            internalWindow.sizeTo(1, rect.height);
        }
        Rect.returnRect(rect);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._resizePart != 0) {
            this.mouseResizeDrag(mouseEvent);
            return;
        }
        int n = mouseEvent.x + this.bounds.x;
        int n2 = mouseEvent.y + this.bounds.y;
        int n3 = this._type == 0 ? -5 : -this.titleBarMargin() + 5;
        int n4 = this.superview().height() - 5;
        int n5 = this.bounds.y + n2 - this._lastY;
        if (n5 < n3) {
            n2 = n3 + this._lastY - this.bounds.y;
        } else if (n5 > n4) {
            n2 = n4 + this._lastY - this.bounds.y;
        }
        int n6 = -this.bounds.width + 5;
        int n7 = this.superview().width() - 5;
        int n8 = this.bounds.x + n - this._lastX;
        if (n8 < n6) {
            n = n6 + this._lastX - this.bounds.x;
        } else if (n8 > n7) {
            n = n7 + this._lastX - this.bounds.x;
        }
        Point point = Point.newPoint(this.bounds.x + n - this._lastX, this.bounds.y + n2 - this._lastY);
        this.willMoveTo(point);
        n = point.x + this._lastX - this.bounds.x;
        n2 = point.y + this._lastY - this.bounds.y;
        Point.returnPoint(point);
        Rect rect = Rect.newRect();
        this.computeVisibleRect(rect);
        Rect rect2 = Rect.newRect();
        this.convertRectToView(null, rect, rect2);
        if (!this.isTransparent() && this.drawingBuffer == null) {
            this._createdDrawingBuffer = true;
            this.setBuffered(true);
            this._drawToBackingStore = true;
            Graphics graphics = this.drawingBuffer.createGraphics();
            graphics.setDebugOptions(this.shouldDebugGraphics());
            this.draw(graphics, null);
            graphics.dispose();
            graphics = null;
            this._drawToBackingStore = false;
        }
        this._super_moveBy(n - this._lastX, n2 - this._lastY);
        if (!this.isTransparent()) {
            if (this.drawingBuffer != null) {
                this.drawingBufferIsBitCache = true;
            }
            this.draw();
            if (this.drawingBuffer != null) {
                this.drawingBufferIsBitCache = false;
            }
        }
        if (this.isTransparent()) {
            this.draw();
        }
        this.rootView.disableWindowsAbove(this, true);
        this.rootView.redraw(rect2);
        this.rootView.disableWindowsAbove(this, false);
        this._lastX = n;
        this._lastY = n2;
        rect2.unionWith(this.superview().convertRectToView(null, this.bounds));
        this.rootView.redrawTransparentWindows(rect2, this);
        Rect.returnRect(rect);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this._resizePart != 0) {
            InternalWindow internalWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
            InternalWindow internalWindow2 = (InternalWindow)_resizeWindowVector.elementAt(1);
            if (this._resizePart == 1) {
                this.moveByAndSizeBy(internalWindow.bounds.x - this.bounds.x, 0, internalWindow2.bounds.x - internalWindow.bounds.x - this.bounds.width + 1, internalWindow.bounds.height - this.bounds.height);
            } else {
                this.sizeTo(internalWindow2.bounds.x - internalWindow.bounds.x + 1, internalWindow.bounds.height);
            }
            int n = _resizeWindowVector.count();
            while (n-- > 0) {
                internalWindow = (InternalWindow)_resizeWindowVector.elementAt(n);
                internalWindow.hide();
            }
            _resizeWindowVector.removeAllElements();
            this._resizePart = 0;
        }
        if (this._createdDrawingBuffer) {
            this.setBuffered(false);
            this._createdDrawingBuffer = false;
        }
    }

    void _drawLine(Graphics graphics, int n, int n2, int n3, Color color, Color color2) {
        graphics.setColor(color);
        int n4 = n;
        while (n4 <= n2) {
            graphics.drawLine(n4, n3, n4, n3);
            n4 += 2;
        }
        graphics.setColor(color2);
        n4 = n + 1;
        while (n4 <= n2) {
            graphics.drawLine(n4, n3, n4, n3);
            n4 += 2;
        }
    }

    public void drawView(Graphics graphics) {
        if (this.drawingBuffer != null && !graphics.isDrawingBuffer() || this._type == 0) {
            return;
        }
        this._border.drawInRect(graphics, 0, 0, this.bounds.width, this.bounds.height);
    }

    public void drawTitleBar() {
        if (this._type == 0) {
            return;
        }
        Rect rect = Rect.newRect(0, 0, this.bounds.width, this.titleBarMargin());
        this.draw(rect);
        Rect.returnRect(rect);
    }

    public void drawBottomBorder() {
        if (this._type == 0) {
            return;
        }
        Rect rect = Rect.newRect(0, this.bounds.height - this.bottomBorderMargin(), this.bounds.width, this.bottomBorderMargin());
        this.draw(rect);
        Rect.returnRect(rect);
    }

    public void draw(Graphics graphics, Rect rect) {
        View view;
        if (this.isTransparent() && (graphics == null || !graphics.isDrawingBuffer()) && this.rootView._redrawTransWindows && ((view = null) == null || view.isTransparent())) {
            this.updateDrawingBuffer();
        }
        super.draw(graphics, rect);
    }

    public void didBecomeMain() {
        this.drawTitleBar();
        if (this._owner != null) {
            this._owner.windowDidBecomeMain(this);
        }
        this.rootView.setFocusedView(this.focusedView(), false);
        if (this.containsDocument()) {
            Application.application().makeCurrentDocumentWindow((Window)this);
        }
    }

    public void didResignMain() {
        this.drawTitleBar();
        if (this._owner != null) {
            this._owner.windowDidResignMain(this);
        }
        if (this.rootView != null) {
            this.rootView.setFocusedView(null, false);
        }
    }

    public void setContainsDocument(boolean bl) {
        this._containsDocument = bl;
    }

    public boolean containsDocument() {
        return this._containsDocument;
    }

    public void setCanBecomeDocument(boolean bl) {
        this.setContainsDocument(bl);
    }

    public boolean canBecomeDocument() {
        return this.containsDocument();
    }

    public void didBecomeCurrentDocument() {
    }

    public void didResignCurrentDocument() {
    }

    public boolean isCurrentDocument() {
        return Application.application().currentDocumentWindow() == this;
    }

    public void setFocusedView(View view) {
        this._focusedView = view;
        if (this.rootView != null) {
            if (this.rootView.mainWindow() == this && view != null) {
                this.rootView.makeWindowVisible(this, 0, null);
            }
            this.rootView.setFocusedView(this.focusedView());
        }
    }

    public View focusedView() {
        if (this._focusedView != null && this._focusedView.descendsFrom(this)) {
            return this._focusedView;
        }
        this._focusedView = null;
        return this._focusedView;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.InternalWindow", 3);
        classInfo.addField(ownerKey, (byte)18);
        classInfo.addField(contentViewKey, (byte)18);
        classInfo.addField(focusedViewKey, (byte)18);
        classInfo.addField(closeButtonKey, (byte)18);
        classInfo.addField(titleFontKey, (byte)18);
        classInfo.addField(titleKey, (byte)16);
        classInfo.addField(borderKey, (byte)18);
        classInfo.addField(layerKey, (byte)8);
        classInfo.addField(typeKey, (byte)8);
        classInfo.addField(closeableKey, (byte)0);
        classInfo.addField(resizableKey, (byte)0);
        classInfo.addField(canBecomeMainKey, (byte)0);
        classInfo.addField(containsDocumentKey, (byte)0);
        classInfo.addField(onscreenKey, (byte)0);
        classInfo.addField(transparentKey, (byte)0);
        classInfo.addField(scrollToVisibleKey, (byte)0);
        classInfo.addField(defaultSelectedViewKey, (byte)18);
        classInfo.addField(menuViewKey, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(ownerKey, (Codable)this._owner);
        encoder.encodeObject(contentViewKey, this._contentView);
        encoder.encodeObject(focusedViewKey, this.focusedView());
        encoder.encodeObject(closeButtonKey, this._closeButton);
        encoder.encodeObject(titleFontKey, this._titleFont);
        encoder.encodeString(titleKey, this._title);
        encoder.encodeObject(borderKey, this._border);
        encoder.encodeInt(layerKey, this._layer);
        encoder.encodeInt(typeKey, this._type);
        encoder.encodeBoolean(closeableKey, this._closeable);
        encoder.encodeBoolean(resizableKey, this._resizable);
        encoder.encodeBoolean(canBecomeMainKey, this._canBecomeMain);
        encoder.encodeBoolean(containsDocumentKey, this._containsDocument);
        encoder.encodeBoolean(onscreenKey, this._onscreen);
        encoder.encodeBoolean(transparentKey, this.transparent);
        encoder.encodeBoolean(scrollToVisibleKey, this.scrollToVisible);
        encoder.encodeObject(defaultSelectedViewKey, this._defaultSelectedView);
        encoder.encodeObject(menuViewKey, this.menuView);
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.versionForClassName("netscape.application.TextField");
        super.decode(decoder);
        this._owner = (WindowOwner)decoder.decodeObject(ownerKey);
        this._contentView = (WindowContentView)decoder.decodeObject(contentViewKey);
        this._focusedView = (View)decoder.decodeObject(focusedViewKey);
        this._closeButton = (Button)decoder.decodeObject(closeButtonKey);
        this._titleFont = (Font)decoder.decodeObject(titleFontKey);
        this._title = decoder.decodeString(titleKey);
        this._border = (Border)decoder.decodeObject(borderKey);
        this._layer = decoder.decodeInt(layerKey);
        this._type = decoder.decodeInt(typeKey);
        this._closeable = decoder.decodeBoolean(closeableKey);
        this._resizable = decoder.decodeBoolean(resizableKey);
        this._canBecomeMain = decoder.decodeBoolean(canBecomeMainKey);
        this._containsDocument = decoder.decodeBoolean(containsDocumentKey);
        this._onscreen = decoder.decodeBoolean(onscreenKey);
        this.transparent = decoder.decodeBoolean(transparentKey);
        this.scrollToVisible = decoder.decodeBoolean(scrollToVisibleKey);
        if (n > 1) {
            this._defaultSelectedView = (View)decoder.decodeObject(defaultSelectedViewKey);
        }
        if (n > 2) {
            this.menuView = (MenuView)decoder.decodeObject(menuViewKey);
        }
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        if (this._closeButton != null) {
            this._closeButton.removeAllCommandsForKeys();
        }
    }

    public String toString() {
        if (this._title != null) {
            return "InternalWindow (" + this._title + ")";
        }
        return super.toString();
    }

    View ancestorWithDrawingBuffer() {
        if (this.drawingBuffer != null) {
            return this;
        }
        return null;
    }

    public InternalWindow window() {
        return this;
    }

    public Font font() {
        return this._titleFont;
    }

    public void performCommand(String string, Object object) {
        if ("show".equals(string)) {
            this.show();
            return;
        }
        if ("hide".equals(string)) {
            this.hide();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + string);
    }

    public boolean hidesSubviewsFromKeyboard() {
        return true;
    }

    public void setDefaultSelectedView(View view) {
        this._defaultSelectedView = view;
    }

    public View defaultSelectedView() {
        return this._defaultSelectedView;
    }

    public boolean canBecomeSelectedView() {
        return this.isMain();
    }

    boolean wantsKeyboardArrow() {
        return false;
    }
}

