#include "yahoolib.h"

void DBG_Print(struct yahoo_context *ctx, char *tmp, ...);
void yahoo_RusConv(const char to[4], char *t_in);

static void process_packet_status(struct yahoo_context *context,
struct yahoo_packet *pkt) {
    int i;

    if(pkt->service == YAHOO_SERVICE_LOGOFF &&
    !strcmp(pkt->active_id, context->user)) {

	if(context->yahoo_Disconnected)
	    (*context->yahoo_Disconnected)(context);

    }

    for(i = 0; i < pkt->idstatus_count; i++) {
	struct yahoo_idstatus *rec;
	char *id;

	rec = pkt->idstatus[i];
	id = rec->id;
/*
	set_in_pager(id, rec->in_pager);
	set_in_chat(id, rec->in_chat);
*/

	if(pkt->service != YAHOO_SERVICE_CHATLOGOFF &&
	pkt->service != YAHOO_SERVICE_CHATLOGON) {
	    DBG_Print(context, "status change of %s: %d", id, rec->status);

	    if(context->yahoo_UserStatus) {
		(*context->yahoo_UserStatus)(context, id, rec->status);
	    }
	}

	if(pkt->service == YAHOO_SERVICE_LOGON) {
	    DBG_Print(context, "logon of %s: %d", id, rec->status);

	    if(context->yahoo_UserLogon) {
		(*context->yahoo_UserLogon)(context, id, rec->status);
	    }

	} else if(pkt->service == YAHOO_SERVICE_LOGOFF) {
	    DBG_Print(context, "logoff of %s: %d", id, rec->status);

	    if(context->yahoo_UserLogoff) {
		(*context->yahoo_UserLogoff)(context, id);
	    }

	} else {
	    DBG_Print(context, "logon/logoff (?) of %s: %d", id, rec->status);
/*
	    if(context->yahoo_UserStatus) {
		(*context->yahoo_UserStatus)(context, id, );
	    }
*/
	}
    }
}

static void process_packet_message(struct yahoo_context *context, struct yahoo_packet *pkt) {
    char mesg[2050], pmesg[2050], *pmsg, fromid[66], *r, *p;
    int mpos, ppos, pflag, i;

    if(pkt->msgtype == YAHOO_MSGTYPE_STATUS) {
	if(context->yahoo_UserStatus) {
	    (*context->yahoo_UserStatus)(context, pkt->msg_id, pkt->msg_status);
	}
    }

    if(pkt->msg) {
	if(pkt->msgtype == YAHOO_MSGTYPE_BOUNCE) {
	    DBG_Print(context, "message bounced for %s, %s",
		pkt->msg_id, pkt->msg);

	    if(context->yahoo_RecvBounced) {
		// The message is bounced, user is not online
		(*context->yahoo_RecvBounced)(context, pkt->msg_id);
	    }
	} else {
	    pmsg = pkt->msg;
	    DBG_Print(context, "message from %s", pkt->msg_id);

	    while(strlen(pmsg)) {

		if(pmsg[0] == 1) {
		    for(i = 0; i < 5 && pmsg; i++) {
			pmsg = (char *) strchr(pmsg, ',');
			if(pmsg) {
			    pmsg++;
			    if(i == 2) {
				strncpy(fromid, pmsg, 64);
				fromid[64] = 0;
				if(p = (char *) strchr(fromid, ',')) *p = 0;
			    }
			}
		    }
		    if(!pmsg) break;
		} else {
		    strncpy(fromid, pkt->msg_id, 64);
		    fromid[64] = 0;
		}

		r = (char *) strchr(pmsg, '\001');
		if(!r) r = pmsg+strlen(pmsg);
		strncpy(mesg, pmsg, r-pmsg);
		mesg[r-pmsg] = 0;
		pmsg = r;

		// strip HTML tags and carriage returns

		ppos = 0;
		pflag = 0;

		for(mpos = 0; mpos <= strlen(mesg); mpos++) {
		    if(mesg[mpos] == '<') pflag = 1;
		    if(mesg[mpos] == '>') pflag = 0;

		    if(pflag == 0 && mesg[mpos] != '>') {
			pmesg[ppos] = mesg[mpos];

			if(pmesg[ppos])
			switch(pmesg[ppos]) {
			    case 6:
				mpos = strlen(mesg);
				ppos--;
				break;
			    case 27:
				mpos += 3;
				ppos--;
				break;
			    default:
				if(pmesg[ppos] == 13 || pmesg[ppos] == 10)
				    pmesg[ppos] = ' ';
				break;
			}

			ppos++;
		    }
		}

		pmesg[ppos] = '\0';
		yahoo_RusConv("wk", pmesg);

		if(context->yahoo_RecvMessage) {
		    // A message is received
		    (*context->yahoo_RecvMessage)(context, fromid, pmesg);
		}
	    }
	}
    }
}

static void process_packet_ping(struct yahoo_context *context, struct yahoo_packet *pkt) {
    DBG_Print(context, "ping");
/*
    sprintf(tbuffer,"\n\rPing.\n\r");
    waddstr(inputwin,tbuffer);
    wrefresh(inputwin);
*/
}

void yahoo_main(struct yahoo_context *context) {
    struct yahoo_rawpacket *rawpkt;
    struct yahoo_packet *pkt;

    if(!yahoo_getdata(context)) {
	if(context->yahoo_Disconnected)
	    (*context->yahoo_Disconnected)(context);
	return;
    }

    if(context->io_buf_curlen <= 103)
	return;

    while((rawpkt = yahoo_getpacket(context))) {
	pkt = yahoo_parsepacket(context, rawpkt);

	switch(pkt->service) {
	    case YAHOO_SERVICE_USERSTAT:
	    case YAHOO_SERVICE_CHATLOGON:
	    case YAHOO_SERVICE_CHATLOGOFF:
	    case YAHOO_SERVICE_LOGON:
	    case YAHOO_SERVICE_LOGOFF:
	    case YAHOO_SERVICE_ISAWAY:
	    case YAHOO_SERVICE_ISBACK:
		process_packet_status(context, pkt);
		break;

	    case YAHOO_SERVICE_MESSAGE:
	    case YAHOO_SERVICE_CHATMSG:
	    case YAHOO_SERVICE_SYSMESSAGE:
		process_packet_message(context, pkt);
		break;

	    case YAHOO_SERVICE_NEWCONTACT:
		if(pkt->msg) process_packet_message(context, pkt);
		else process_packet_status(context, pkt);
		yahoo_get_config(context);
		break;

	    case YAHOO_SERVICE_PING:
		process_packet_ping(context, pkt);
		break;
	}

	yahoo_free_packet(pkt);
	yahoo_free_rawpacket(rawpkt);
    }
}
