{
  'includes': [
    '../core/core_generated.gypi',
    'modules_generated.gypi',
  ],
  'variables': {
    # Experimental hooks for embedder to provide extra IDL and source files.
    #
    # Note: this is not a supported API. If you rely on this, you will be broken
    # from time to time as the code generator changes in backward incompatible
    # ways.
    'extra_blink_module_idl_files': [],
    'extra_blink_module_files': [],
    # Files for which bindings (.cpp and .h files) will be generated
    'modules_idl_files': [
      '<@(extra_blink_module_idl_files)',
      'battery/BatteryManager.idl',
      'crypto/AesKeyAlgorithm.idl',
      'crypto/Crypto.idl',
      'crypto/HmacKeyAlgorithm.idl',
      'crypto/Key.idl',
      'crypto/KeyAlgorithm.idl',
      'crypto/RsaHashedKeyAlgorithm.idl',
      'crypto/RsaKeyAlgorithm.idl',
      'crypto/SubtleCrypto.idl',
      'device_light/DeviceLightEvent.idl',
      'device_orientation/DeviceAcceleration.idl',
      'device_orientation/DeviceMotionEvent.idl',
      'device_orientation/DeviceOrientationEvent.idl',
      'device_orientation/DeviceRotationRate.idl',
      'encoding/TextDecoder.idl',
      'encoding/TextEncoder.idl',
      'encryptedmedia/MediaKeyMessageEvent.idl',
      'encryptedmedia/MediaKeyNeededEvent.idl',
      'encryptedmedia/MediaKeySession.idl',
      'encryptedmedia/MediaKeys.idl',
      'filesystem/DOMFileSystem.idl',
      'filesystem/DOMFileSystemSync.idl',
      'filesystem/DirectoryEntry.idl',
      'filesystem/DirectoryEntrySync.idl',
      'filesystem/DirectoryReader.idl',
      'filesystem/DirectoryReaderSync.idl',
      'filesystem/EntriesCallback.idl',
      'filesystem/Entry.idl',
      'filesystem/EntryCallback.idl',
      'filesystem/EntrySync.idl',
      'filesystem/ErrorCallback.idl',
      'filesystem/FileCallback.idl',
      'filesystem/FileEntry.idl',
      'filesystem/FileEntrySync.idl',
      'filesystem/FileSystemCallback.idl',
      'filesystem/FileWriter.idl',
      'filesystem/FileWriterCallback.idl',
      'filesystem/FileWriterSync.idl',
      'filesystem/Metadata.idl',
      'filesystem/MetadataCallback.idl',
      'gamepad/Gamepad.idl',
      'gamepad/GamepadButton.idl',
      'gamepad/GamepadEvent.idl',
      'gamepad/GamepadList.idl',
      'gamepad/WebKitGamepad.idl',
      'gamepad/WebKitGamepadList.idl',
      'geolocation/Coordinates.idl',
      'geolocation/Geolocation.idl',
      'geolocation/Geoposition.idl',
      'geolocation/PositionCallback.idl',
      'geolocation/PositionError.idl',
      'geolocation/PositionErrorCallback.idl',
      'indexeddb/IDBCursor.idl',
      'indexeddb/IDBCursorWithValue.idl',
      'indexeddb/IDBDatabase.idl',
      'indexeddb/IDBFactory.idl',
      'indexeddb/IDBIndex.idl',
      'indexeddb/IDBKeyRange.idl',
      'indexeddb/IDBObjectStore.idl',
      'indexeddb/IDBOpenDBRequest.idl',
      'indexeddb/IDBRequest.idl',
      'indexeddb/IDBTransaction.idl',
      'indexeddb/IDBVersionChangeEvent.idl',
      'mediasource/MediaSource.idl',
      'mediasource/SourceBuffer.idl',
      'mediasource/SourceBufferList.idl',
      'mediasource/VideoPlaybackQuality.idl',
      'mediastream/MediaDeviceInfo.idl',
      'mediastream/MediaDeviceInfoCallback.idl',
      'mediastream/MediaStream.idl',
      'mediastream/MediaStreamEvent.idl',
      'mediastream/MediaStreamTrack.idl',
      'mediastream/MediaStreamTrackEvent.idl',
      'mediastream/MediaStreamTrackSourcesCallback.idl',
      'mediastream/NavigatorUserMediaError.idl',
      'mediastream/NavigatorUserMediaErrorCallback.idl',
      'mediastream/NavigatorUserMediaSuccessCallback.idl',
      'mediastream/RTCDTMFSender.idl',
      'mediastream/RTCDTMFToneChangeEvent.idl',
      'mediastream/RTCDataChannel.idl',
      'mediastream/RTCDataChannelEvent.idl',
      'mediastream/RTCErrorCallback.idl',
      'mediastream/RTCIceCandidate.idl',
      'mediastream/RTCIceCandidateEvent.idl',
      'mediastream/RTCPeerConnection.idl',
      'mediastream/RTCSessionDescription.idl',
      'mediastream/RTCSessionDescriptionCallback.idl',
      'mediastream/RTCStatsCallback.idl',
      'mediastream/RTCStatsReport.idl',
      'mediastream/RTCStatsResponse.idl',
      'mediastream/SourceInfo.idl',
      'netinfo/NetworkInformation.idl',
      'notifications/Notification.idl',
      'notifications/NotificationPermissionCallback.idl',
      'performance/WorkerPerformance.idl',
      'push_messaging/PushEvent.idl',
      'push_messaging/PushManager.idl',
      'push_messaging/PushRegistration.idl',
      'quota/DeprecatedStorageInfo.idl',
      'quota/DeprecatedStorageQuota.idl',
      'quota/StorageErrorCallback.idl',
      'quota/StorageInfo.idl',
      'quota/StorageQuota.idl',
      'quota/StorageQuotaCallback.idl',
      'quota/StorageUsageCallback.idl',
      'serviceworkers/Client.idl',
      'serviceworkers/FetchEvent.idl',
      'serviceworkers/HeaderMap.idl',
      'serviceworkers/HeaderMapForEachCallback.idl',
      'serviceworkers/InstallEvent.idl',
      'serviceworkers/InstallPhaseEvent.idl',
      'serviceworkers/Request.idl',
      'serviceworkers/Response.idl',
      'serviceworkers/ServiceWorker.idl',
      'serviceworkers/ServiceWorkerClients.idl',
      'serviceworkers/ServiceWorkerContainer.idl',
      'serviceworkers/ServiceWorkerGlobalScope.idl',
      'speech/SpeechGrammar.idl',
      'speech/SpeechGrammarList.idl',
      'speech/SpeechRecognition.idl',
      'speech/SpeechRecognitionAlternative.idl',
      'speech/SpeechRecognitionError.idl',
      'speech/SpeechRecognitionEvent.idl',
      'speech/SpeechRecognitionResult.idl',
      'speech/SpeechRecognitionResultList.idl',
      'speech/SpeechSynthesis.idl',
      'speech/SpeechSynthesisEvent.idl',
      'speech/SpeechSynthesisUtterance.idl',
      'speech/SpeechSynthesisVoice.idl',
      'webaudio/AnalyserNode.idl',
      'webaudio/AudioBuffer.idl',
      'webaudio/AudioBufferCallback.idl',
      'webaudio/AudioBufferSourceNode.idl',
      'webaudio/AudioContext.idl',
      'webaudio/AudioDestinationNode.idl',
      'webaudio/AudioListener.idl',
      'webaudio/AudioNode.idl',
      'webaudio/AudioParam.idl',
      'webaudio/AudioProcessingEvent.idl',
      'webaudio/AudioSourceNode.idl',
      'webaudio/BiquadFilterNode.idl',
      'webaudio/ChannelMergerNode.idl',
      'webaudio/ChannelSplitterNode.idl',
      'webaudio/ConvolverNode.idl',
      'webaudio/DelayNode.idl',
      'webaudio/DynamicsCompressorNode.idl',
      'webaudio/GainNode.idl',
      'webaudio/MediaElementAudioSourceNode.idl',
      'webaudio/MediaStreamAudioDestinationNode.idl',
      'webaudio/MediaStreamAudioSourceNode.idl',
      'webaudio/OfflineAudioCompletionEvent.idl',
      'webaudio/OfflineAudioContext.idl',
      'webaudio/OscillatorNode.idl',
      'webaudio/PannerNode.idl',
      'webaudio/PeriodicWave.idl',
      'webaudio/ScriptProcessorNode.idl',
      'webaudio/WaveShaperNode.idl',
      'webdatabase/Database.idl',
      'webdatabase/DatabaseCallback.idl',
      'webdatabase/DatabaseSync.idl',
      'webdatabase/SQLError.idl',
      'webdatabase/SQLResultSet.idl',
      'webdatabase/SQLResultSetRowList.idl',
      'webdatabase/SQLStatementCallback.idl',
      'webdatabase/SQLStatementErrorCallback.idl',
      'webdatabase/SQLTransaction.idl',
      'webdatabase/SQLTransactionCallback.idl',
      'webdatabase/SQLTransactionErrorCallback.idl',
      'webdatabase/SQLTransactionSync.idl',
      'webdatabase/SQLTransactionSyncCallback.idl',
      'webmidi/MIDIAccess.idl',
      'webmidi/MIDIConnectionEvent.idl',
      'webmidi/MIDIErrorCallback.idl',
      'webmidi/MIDIInput.idl',
      'webmidi/MIDIMessageEvent.idl',
      'webmidi/MIDIOutput.idl',
      'webmidi/MIDIPort.idl',
      'webmidi/MIDISuccessCallback.idl',
      'websockets/CloseEvent.idl',
      'websockets/WebSocket.idl',
    ],
    # 'partial interface' or target (right side of) 'implements'
    'modules_dependency_idl_files': [
      'battery/NavigatorBattery.idl',
      'beacon/NavigatorBeacon.idl',
      'crypto/WindowCrypto.idl',
      'crypto/WorkerGlobalScopeCrypto.idl',
      'device_light/WindowDeviceLight.idl',
      'device_orientation/WindowDeviceMotion.idl',
      'device_orientation/WindowDeviceOrientation.idl',
      'donottrack/NavigatorDoNotTrack.idl',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.idl',
      'filesystem/DataTransferItemFileSystem.idl',
      'filesystem/HTMLInputElementFileSystem.idl',
      'filesystem/InspectorFrontendHostFileSystem.idl',
      'filesystem/WindowFileSystem.idl',
      'filesystem/WorkerGlobalScopeFileSystem.idl',
      'gamepad/NavigatorGamepad.idl',
      'geolocation/NavigatorGeolocation.idl',
      'imagebitmap/ImageBitmapFactories.idl',
      'imagebitmap/WindowImageBitmapFactories.idl',
      'indexeddb/WindowIndexedDatabase.idl',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.idl',
      'mediasource/HTMLVideoElementMediaSource.idl',
      'mediasource/URLMediaSource.idl',
      'mediastream/NavigatorMediaStream.idl',
      'mediastream/URLMediaStream.idl',
      'mediastream/WindowMediaStream.idl',
      'navigatorcontentutils/NavigatorContentUtils.idl',
      'netinfo/NavigatorNetworkInformation.idl',
      'netinfo/WorkerNavigatorNetworkInformation.idl',
      'performance/SharedWorkerPerformance.idl',
      'performance/WorkerGlobalScopePerformance.idl',
      'push_messaging/NavigatorPushManager.idl',
      'push_messaging/ServiceWorkerGlobalScopePush.idl',
      'quota/NavigatorStorageQuota.idl',
      'quota/WindowQuota.idl',
      'quota/WorkerNavigatorStorageQuota.idl',
      'screen_orientation/ScreenOrientation.idl',
      'serviceworkers/NavigatorServiceWorker.idl',
      'speech/WindowSpeech.idl',
      'speech/WindowSpeechSynthesis.idl',
      'vibration/NavigatorVibration.idl',
      'webaudio/WindowWebAudio.idl',
      'webdatabase/WindowWebDatabase.idl',
      'webdatabase/WorkerGlobalScopeWebDatabase.idl',
      'webmidi/NavigatorWebMIDI.idl',
    ],
    # interfaces that inherit from Event
    'modules_event_idl_files': [
      'device_light/DeviceLightEvent.idl',
      'device_orientation/DeviceMotionEvent.idl',
      'device_orientation/DeviceOrientationEvent.idl',
      'encryptedmedia/MediaKeyMessageEvent.idl',
      'encryptedmedia/MediaKeyNeededEvent.idl',
      'gamepad/GamepadEvent.idl',
      'indexeddb/IDBVersionChangeEvent.idl',
      'mediastream/MediaStreamEvent.idl',
      'mediastream/MediaStreamTrackEvent.idl',
      'mediastream/RTCDTMFToneChangeEvent.idl',
      'mediastream/RTCDataChannelEvent.idl',
      'mediastream/RTCIceCandidateEvent.idl',
      'push_messaging/PushEvent.idl',
      'serviceworkers/FetchEvent.idl',
      'serviceworkers/InstallEvent.idl',
      'serviceworkers/InstallPhaseEvent.idl',
      'speech/SpeechRecognitionError.idl',
      'speech/SpeechRecognitionEvent.idl',
      'speech/SpeechSynthesisEvent.idl',
      'webaudio/AudioProcessingEvent.idl',
      'webaudio/OfflineAudioCompletionEvent.idl',
      'webmidi/MIDIConnectionEvent.idl',
      'webmidi/MIDIMessageEvent.idl',
      'websockets/CloseEvent.idl',
    ],
    'generated_modules_files': [
      # .cpp files from make_modules_generated actions.
      '<(blink_modules_output_dir)/EventModules.cpp',
      '<(blink_modules_output_dir)/EventModulesHeaders.h',
      '<(blink_modules_output_dir)/EventModulesInterfaces.h',
      '<(blink_modules_output_dir)/EventModulesNames.cpp',
      '<(blink_modules_output_dir)/EventModulesNames.h',
      '<(blink_modules_output_dir)/EventTargetModulesHeaders.h',
      '<(blink_modules_output_dir)/EventTargetModulesInterfaces.h',
      '<(blink_modules_output_dir)/EventTargetModulesNames.cpp',
      '<(blink_modules_output_dir)/EventTargetModulesNames.h',
    ],
    'modules_files': [
      '<@(extra_blink_module_files)',
      '<@(generated_modules_files)',
      'InitModules.cpp',
      'InitModules.h',
      'battery/BatteryDispatcher.cpp',
      'battery/BatteryDispatcher.h',
      'battery/BatteryManager.cpp',
      'battery/BatteryManager.h',
      'battery/BatteryStatus.cpp',
      'battery/BatteryStatus.h',
      'battery/NavigatorBattery.cpp',
      'battery/NavigatorBattery.h',
      'beacon/NavigatorBeacon.cpp',
      'beacon/NavigatorBeacon.h',
      'crypto/AesKeyAlgorithm.cpp',
      'crypto/AesKeyAlgorithm.h',
      'crypto/Crypto.cpp',
      'crypto/Crypto.h',
      'crypto/CryptoResultImpl.cpp',
      'crypto/CryptoResultImpl.h',
      'crypto/DOMWindowCrypto.cpp',
      'crypto/DOMWindowCrypto.h',
      'crypto/HmacKeyAlgorithm.cpp',
      'crypto/HmacKeyAlgorithm.h',
      'crypto/Key.cpp',
      'crypto/Key.h',
      'crypto/KeyAlgorithm.cpp',
      'crypto/KeyAlgorithm.h',
      'crypto/NormalizeAlgorithm.cpp',
      'crypto/NormalizeAlgorithm.h',
      'crypto/RsaHashedKeyAlgorithm.cpp',
      'crypto/RsaHashedKeyAlgorithm.h',
      'crypto/RsaKeyAlgorithm.cpp',
      'crypto/RsaKeyAlgorithm.h',
      'crypto/SubtleCrypto.cpp',
      'crypto/SubtleCrypto.h',
      'crypto/WorkerGlobalScopeCrypto.cpp',
      'crypto/WorkerGlobalScopeCrypto.h',
      'device_light/DeviceLightController.cpp',
      'device_light/DeviceLightController.h',
      'device_light/DeviceLightDispatcher.cpp',
      'device_light/DeviceLightDispatcher.h',
      'device_light/DeviceLightEvent.cpp',
      'device_light/DeviceLightEvent.h',
      'device_orientation/DeviceAcceleration.cpp',
      'device_orientation/DeviceAcceleration.h',
      'device_orientation/DeviceMotionController.cpp',
      'device_orientation/DeviceMotionController.h',
      'device_orientation/DeviceMotionData.cpp',
      'device_orientation/DeviceMotionData.h',
      'device_orientation/DeviceMotionDispatcher.cpp',
      'device_orientation/DeviceMotionDispatcher.h',
      'device_orientation/DeviceMotionEvent.cpp',
      'device_orientation/DeviceMotionEvent.h',
      'device_orientation/DeviceOrientationController.cpp',
      'device_orientation/DeviceOrientationController.h',
      'device_orientation/DeviceOrientationData.cpp',
      'device_orientation/DeviceOrientationData.h',
      'device_orientation/DeviceOrientationDispatcher.cpp',
      'device_orientation/DeviceOrientationDispatcher.h',
      'device_orientation/DeviceOrientationEvent.cpp',
      'device_orientation/DeviceOrientationEvent.h',
      'device_orientation/DeviceOrientationInspectorAgent.cpp',
      'device_orientation/DeviceOrientationInspectorAgent.h',
      'device_orientation/DeviceRotationRate.cpp',
      'device_orientation/DeviceRotationRate.h',
      'donottrack/NavigatorDoNotTrack.cpp',
      'donottrack/NavigatorDoNotTrack.h',
      'encoding/TextDecoder.cpp',
      'encoding/TextDecoder.h',
      'encoding/TextEncoder.cpp',
      'encoding/TextEncoder.h',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.cpp',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.h',
      'encryptedmedia/MediaKeyMessageEvent.cpp',
      'encryptedmedia/MediaKeyMessageEvent.h',
      'encryptedmedia/MediaKeyNeededEvent.cpp',
      'encryptedmedia/MediaKeyNeededEvent.h',
      'encryptedmedia/MediaKeySession.cpp',
      'encryptedmedia/MediaKeySession.h',
      'encryptedmedia/MediaKeys.cpp',
      'encryptedmedia/MediaKeys.h',
      'encryptedmedia/MediaKeysClient.h',
      'encryptedmedia/MediaKeysController.cpp',
      'encryptedmedia/MediaKeysController.h',
      'filesystem/DOMFilePath.cpp',
      'filesystem/DOMFilePath.h',
      'filesystem/DOMFileSystem.cpp',
      'filesystem/DOMFileSystem.h',
      'filesystem/DOMFileSystemBase.cpp',
      'filesystem/DOMFileSystemBase.h',
      'filesystem/DOMFileSystemSync.cpp',
      'filesystem/DOMFileSystemSync.h',
      'filesystem/DOMWindowFileSystem.cpp',
      'filesystem/DOMWindowFileSystem.h',
      'filesystem/DataTransferItemFileSystem.cpp',
      'filesystem/DataTransferItemFileSystem.h',
      'filesystem/DirectoryEntry.cpp',
      'filesystem/DirectoryEntry.h',
      'filesystem/DirectoryEntrySync.cpp',
      'filesystem/DirectoryEntrySync.h',
      'filesystem/DirectoryReader.cpp',
      'filesystem/DirectoryReader.h',
      'filesystem/DirectoryReaderBase.h',
      'filesystem/DirectoryReaderSync.cpp',
      'filesystem/DirectoryReaderSync.h',
      'filesystem/DraggedIsolatedFileSystem.cpp',
      'filesystem/DraggedIsolatedFileSystem.h',
      'filesystem/EntriesCallback.h',
      'filesystem/Entry.cpp',
      'filesystem/Entry.h',
      'filesystem/EntryBase.cpp',
      'filesystem/EntryBase.h',
      'filesystem/EntryCallback.h',
      'filesystem/EntrySync.cpp',
      'filesystem/EntrySync.h',
      'filesystem/ErrorCallback.h',
      'filesystem/FileCallback.h',
      'filesystem/FileEntry.cpp',
      'filesystem/FileEntry.h',
      'filesystem/FileEntrySync.cpp',
      'filesystem/FileEntrySync.h',
      'filesystem/FileSystemCallback.h',
      'filesystem/FileSystemCallbacks.cpp',
      'filesystem/FileSystemCallbacks.h',
      'filesystem/FileSystemClient.h',
      'filesystem/FileSystemFlags.h',
      'filesystem/FileWriter.cpp',
      'filesystem/FileWriter.h',
      'filesystem/FileWriterBase.cpp',
      'filesystem/FileWriterBase.h',
      'filesystem/FileWriterBaseCallback.h',
      'filesystem/FileWriterCallback.h',
      'filesystem/FileWriterSync.cpp',
      'filesystem/FileWriterSync.h',
      'filesystem/HTMLInputElementFileSystem.cpp',
      'filesystem/HTMLInputElementFileSystem.h',
      'filesystem/InspectorFileSystemAgent.cpp',
      'filesystem/InspectorFileSystemAgent.h',
      'filesystem/InspectorFrontendHostFileSystem.cpp',
      'filesystem/InspectorFrontendHostFileSystem.h',
      'filesystem/LocalFileSystem.cpp',
      'filesystem/LocalFileSystem.h',
      'filesystem/Metadata.h',
      'filesystem/MetadataCallback.h',
      'filesystem/SyncCallbackHelper.h',
      'filesystem/WorkerGlobalScopeFileSystem.cpp',
      'filesystem/WorkerGlobalScopeFileSystem.h',
      'gamepad/Gamepad.cpp',
      'gamepad/Gamepad.h',
      'gamepad/GamepadButton.cpp',
      'gamepad/GamepadButton.h',
      'gamepad/GamepadCommon.cpp',
      'gamepad/GamepadCommon.h',
      'gamepad/GamepadDispatcher.cpp',
      'gamepad/GamepadDispatcher.h',
      'gamepad/GamepadEvent.cpp',
      'gamepad/GamepadEvent.h',
      'gamepad/GamepadList.cpp',
      'gamepad/GamepadList.h',
      'gamepad/NavigatorGamepad.cpp',
      'gamepad/NavigatorGamepad.h',
      'gamepad/WebKitGamepad.cpp',
      'gamepad/WebKitGamepad.h',
      'gamepad/WebKitGamepadList.cpp',
      'gamepad/WebKitGamepadList.h',
      'geolocation/Coordinates.cpp',
      'geolocation/Geolocation.cpp',
      'geolocation/GeolocationController.cpp',
      'geolocation/GeolocationInspectorAgent.cpp',
      'geolocation/NavigatorGeolocation.cpp',
      'geolocation/NavigatorGeolocation.h',
      'imagebitmap/ImageBitmapFactories.cpp',
      'imagebitmap/ImageBitmapFactories.h',
      'indexeddb/DOMWindowIndexedDatabase.cpp',
      'indexeddb/DOMWindowIndexedDatabase.h',
      'indexeddb/IDBAny.cpp',
      'indexeddb/IDBAny.h',
      'indexeddb/IDBCursor.cpp',
      'indexeddb/IDBCursor.h',
      'indexeddb/IDBCursorWithValue.cpp',
      'indexeddb/IDBCursorWithValue.h',
      'indexeddb/IDBDatabase.cpp',
      'indexeddb/IDBDatabase.h',
      'indexeddb/IDBDatabaseCallbacks.cpp',
      'indexeddb/IDBDatabaseCallbacks.h',
      'indexeddb/IDBEventDispatcher.cpp',
      'indexeddb/IDBEventDispatcher.h',
      'indexeddb/IDBFactory.cpp',
      'indexeddb/IDBFactory.h',
      'indexeddb/IDBHistograms.h',
      'indexeddb/IDBIndex.cpp',
      'indexeddb/IDBIndex.h',
      'indexeddb/IDBKey.cpp',
      'indexeddb/IDBKey.h',
      'indexeddb/IDBKeyPath.cpp',
      'indexeddb/IDBKeyPath.h',
      'indexeddb/IDBKeyRange.cpp',
      'indexeddb/IDBKeyRange.h',
      'indexeddb/IDBMetadata.h',
      'indexeddb/IDBObjectStore.cpp',
      'indexeddb/IDBObjectStore.h',
      'indexeddb/IDBOpenDBRequest.cpp',
      'indexeddb/IDBOpenDBRequest.h',
      'indexeddb/IDBPendingTransactionMonitor.cpp',
      'indexeddb/IDBPendingTransactionMonitor.h',
      'indexeddb/IDBRequest.cpp',
      'indexeddb/IDBRequest.h',
      'indexeddb/IDBTracing.h',
      'indexeddb/IDBTransaction.cpp',
      'indexeddb/IDBTransaction.h',
      'indexeddb/IDBVersionChangeEvent.cpp',
      'indexeddb/IDBVersionChangeEvent.h',
      'indexeddb/IndexedDB.h',
      'indexeddb/IndexedDBClient.cpp',
      'indexeddb/IndexedDBClient.h',
      'indexeddb/InspectorIndexedDBAgent.cpp',
      'indexeddb/InspectorIndexedDBAgent.h',
      'indexeddb/WebIDBCallbacksImpl.cpp',
      'indexeddb/WebIDBCallbacksImpl.h',
      'indexeddb/WebIDBDatabaseCallbacksImpl.cpp',
      'indexeddb/WebIDBDatabaseCallbacksImpl.h',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.cpp',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.h',
      'mediasource/HTMLVideoElementMediaSource.cpp',
      'mediasource/HTMLVideoElementMediaSource.h',
      'mediasource/MediaSource.cpp',
      'mediasource/MediaSource.h',
      'mediasource/MediaSourceRegistry.cpp',
      'mediasource/MediaSourceRegistry.h',
      'mediasource/SourceBuffer.cpp',
      'mediasource/SourceBuffer.h',
      'mediasource/SourceBufferList.cpp',
      'mediasource/SourceBufferList.h',
      'mediasource/URLMediaSource.cpp',
      'mediasource/URLMediaSource.h',
      'mediasource/VideoPlaybackQuality.cpp',
      'mediasource/VideoPlaybackQuality.h',
      'mediastream/MediaConstraintsImpl.cpp',
      'mediastream/MediaConstraintsImpl.h',
      'mediastream/MediaDeviceInfo.cpp',
      'mediastream/MediaDeviceInfo.h',
      'mediastream/MediaDeviceInfoCallback.h',
      'mediastream/MediaDevicesRequest.cpp',
      'mediastream/MediaDevicesRequest.h',
      'mediastream/MediaStream.cpp',
      'mediastream/MediaStream.h',
      'mediastream/MediaStreamEvent.cpp',
      'mediastream/MediaStreamEvent.h',
      'mediastream/MediaStreamRegistry.cpp',
      'mediastream/MediaStreamRegistry.h',
      'mediastream/MediaStreamTrack.cpp',
      'mediastream/MediaStreamTrack.h',
      'mediastream/MediaStreamTrackEvent.cpp',
      'mediastream/MediaStreamTrackEvent.h',
      'mediastream/MediaStreamTrackSourcesCallback.h',
      'mediastream/MediaStreamTrackSourcesRequestImpl.cpp',
      'mediastream/MediaStreamTrackSourcesRequestImpl.h',
      'mediastream/NavigatorMediaStream.cpp',
      'mediastream/NavigatorMediaStream.h',
      'mediastream/NavigatorUserMediaError.cpp',
      'mediastream/NavigatorUserMediaError.h',
      'mediastream/NavigatorUserMediaErrorCallback.h',
      'mediastream/NavigatorUserMediaSuccessCallback.h',
      'mediastream/RTCDTMFSender.cpp',
      'mediastream/RTCDTMFSender.h',
      'mediastream/RTCDTMFToneChangeEvent.cpp',
      'mediastream/RTCDTMFToneChangeEvent.h',
      'mediastream/RTCDataChannel.cpp',
      'mediastream/RTCDataChannel.h',
      'mediastream/RTCDataChannelEvent.cpp',
      'mediastream/RTCDataChannelEvent.h',
      'mediastream/RTCErrorCallback.h',
      'mediastream/RTCIceCandidate.cpp',
      'mediastream/RTCIceCandidate.h',
      'mediastream/RTCIceCandidateEvent.cpp',
      'mediastream/RTCIceCandidateEvent.h',
      'mediastream/RTCPeerConnection.cpp',
      'mediastream/RTCPeerConnection.h',
      'mediastream/RTCSessionDescription.cpp',
      'mediastream/RTCSessionDescription.h',
      'mediastream/RTCSessionDescriptionCallback.h',
      'mediastream/RTCSessionDescriptionRequestImpl.cpp',
      'mediastream/RTCSessionDescriptionRequestImpl.h',
      'mediastream/RTCStatsReport.cpp',
      'mediastream/RTCStatsReport.h',
      'mediastream/RTCStatsRequestImpl.cpp',
      'mediastream/RTCStatsRequestImpl.h',
      'mediastream/RTCStatsResponse.cpp',
      'mediastream/RTCStatsResponse.h',
      'mediastream/RTCVoidRequestImpl.cpp',
      'mediastream/RTCVoidRequestImpl.h',
      'mediastream/SourceInfo.cpp',
      'mediastream/SourceInfo.h',
      'mediastream/URLMediaStream.cpp',
      'mediastream/URLMediaStream.h',
      'mediastream/UserMediaClient.h',
      'mediastream/UserMediaController.cpp',
      'mediastream/UserMediaController.h',
      'mediastream/UserMediaRequest.cpp',
      'mediastream/UserMediaRequest.h',
      'navigatorcontentutils/NavigatorContentUtils.cpp',
      'navigatorcontentutils/NavigatorContentUtils.h',
      'navigatorcontentutils/NavigatorContentUtilsClient.h',
      'netinfo/NavigatorNetworkInformation.cpp',
      'netinfo/NavigatorNetworkInformation.h',
      'netinfo/NetworkInformation.cpp',
      'netinfo/NetworkInformation.h',
      'netinfo/WorkerNavigatorNetworkInformation.cpp',
      'netinfo/WorkerNavigatorNetworkInformation.h',
      'notifications/Notification.cpp',
      'notifications/Notification.h',
      'notifications/NotificationClient.h',
      'notifications/NotificationController.cpp',
      'notifications/NotificationController.h',
      'notifications/NotificationPermissionCallback.h',
      'performance/SharedWorkerPerformance.cpp',
      'performance/WorkerGlobalScopePerformance.cpp',
      'performance/WorkerGlobalScopePerformance.h',
      'performance/WorkerPerformance.cpp',
      'performance/WorkerPerformance.h',
      'push_messaging/NavigatorPushManager.cpp',
      'push_messaging/NavigatorPushManager.h',
      'push_messaging/PushController.cpp',
      'push_messaging/PushController.h',
      'push_messaging/PushError.cpp',
      'push_messaging/PushError.h',
      'push_messaging/PushEvent.cpp',
      'push_messaging/PushEvent.h',
      'push_messaging/PushManager.cpp',
      'push_messaging/PushManager.h',
      'push_messaging/PushRegistration.cpp',
      'push_messaging/PushRegistration.h',
      'push_messaging/ServiceWorkerGlobalScopePush.h',
      'quota/DOMWindowQuota.cpp',
      'quota/DOMWindowQuota.h',
      'quota/DeprecatedStorageInfo.cpp',
      'quota/DeprecatedStorageInfo.h',
      'quota/DeprecatedStorageQuota.cpp',
      'quota/DeprecatedStorageQuota.h',
      'quota/DeprecatedStorageQuotaCallbacksImpl.cpp',
      'quota/DeprecatedStorageQuotaCallbacksImpl.h',
      'quota/NavigatorStorageQuota.cpp',
      'quota/NavigatorStorageQuota.h',
      'quota/StorageErrorCallback.cpp',
      'quota/StorageErrorCallback.h',
      'quota/StorageInfo.cpp',
      'quota/StorageInfo.h',
      'quota/StorageQuota.cpp',
      'quota/StorageQuota.h',
      'quota/StorageQuotaCallback.h',
      'quota/StorageQuotaCallbacksImpl.cpp',
      'quota/StorageQuotaCallbacksImpl.h',
      'quota/StorageQuotaClient.cpp',
      'quota/StorageQuotaClient.h',
      'quota/StorageUsageCallback.h',
      'quota/WorkerNavigatorStorageQuota.cpp',
      'quota/WorkerNavigatorStorageQuota.h',
      'screen_orientation/LockOrientationCallback.cpp',
      'screen_orientation/LockOrientationCallback.h',
      'screen_orientation/ScreenOrientation.cpp',
      'screen_orientation/ScreenOrientation.h',
      'screen_orientation/ScreenOrientationController.cpp',
      'screen_orientation/ScreenOrientationController.h',
      'serviceworkers/Client.cpp',
      'serviceworkers/Client.h',
      'serviceworkers/FetchEvent.cpp',
      'serviceworkers/FetchEvent.h',
      'serviceworkers/FetchManager.cpp',
      'serviceworkers/FetchManager.h',
      'serviceworkers/HeaderMap.cpp',
      'serviceworkers/HeaderMap.h',
      'serviceworkers/HeaderMapForEachCallback.h',
      'serviceworkers/InstallEvent.cpp',
      'serviceworkers/InstallEvent.h',
      'serviceworkers/InstallPhaseEvent.cpp',
      'serviceworkers/InstallPhaseEvent.h',
      'serviceworkers/NavigatorServiceWorker.cpp',
      'serviceworkers/NavigatorServiceWorker.h',
      'serviceworkers/RegistrationOptionList.h',
      'serviceworkers/Request.cpp',
      'serviceworkers/Request.h',
      'serviceworkers/RequestInit.h',
      'serviceworkers/RespondWithObserver.cpp',
      'serviceworkers/RespondWithObserver.h',
      'serviceworkers/Response.cpp',
      'serviceworkers/Response.h',
      'serviceworkers/ResponseInit.h',
      'serviceworkers/ServiceWorker.cpp',
      'serviceworkers/ServiceWorker.h',
      'serviceworkers/ServiceWorkerClients.cpp',
      'serviceworkers/ServiceWorkerClients.h',
      'serviceworkers/ServiceWorkerContainer.cpp',
      'serviceworkers/ServiceWorkerContainer.h',
      'serviceworkers/ServiceWorkerContainerClient.cpp',
      'serviceworkers/ServiceWorkerContainerClient.h',
      'serviceworkers/ServiceWorkerError.cpp',
      'serviceworkers/ServiceWorkerError.h',
      'serviceworkers/ServiceWorkerGlobalScope.cpp',
      'serviceworkers/ServiceWorkerGlobalScope.h',
      'serviceworkers/ServiceWorkerGlobalScopeClient.cpp',
      'serviceworkers/ServiceWorkerGlobalScopeClient.h',
      'serviceworkers/ServiceWorkerThread.cpp',
      'serviceworkers/ServiceWorkerThread.h',
      'serviceworkers/WaitUntilObserver.cpp',
      'speech/DOMWindowSpeechSynthesis.cpp',
      'speech/DOMWindowSpeechSynthesis.h',
      'speech/SpeechGrammar.cpp',
      'speech/SpeechGrammar.h',
      'speech/SpeechGrammarList.cpp',
      'speech/SpeechGrammarList.h',
      'speech/SpeechRecognition.cpp',
      'speech/SpeechRecognition.h',
      'speech/SpeechRecognitionAlternative.cpp',
      'speech/SpeechRecognitionAlternative.h',
      'speech/SpeechRecognitionClient.h',
      'speech/SpeechRecognitionController.cpp',
      'speech/SpeechRecognitionController.h',
      'speech/SpeechRecognitionError.cpp',
      'speech/SpeechRecognitionError.h',
      'speech/SpeechRecognitionEvent.cpp',
      'speech/SpeechRecognitionEvent.h',
      'speech/SpeechRecognitionResult.cpp',
      'speech/SpeechRecognitionResult.h',
      'speech/SpeechRecognitionResultList.cpp',
      'speech/SpeechRecognitionResultList.h',
      'speech/SpeechSynthesis.cpp',
      'speech/SpeechSynthesis.h',
      'speech/SpeechSynthesisEvent.cpp',
      'speech/SpeechSynthesisEvent.h',
      'speech/SpeechSynthesisUtterance.cpp',
      'speech/SpeechSynthesisUtterance.h',
      'speech/SpeechSynthesisVoice.cpp',
      'speech/SpeechSynthesisVoice.h',
      'vibration/NavigatorVibration.cpp',
      'vibration/NavigatorVibration.h',
      'webaudio/AnalyserNode.cpp',
      'webaudio/AnalyserNode.h',
      'webaudio/AsyncAudioDecoder.cpp',
      'webaudio/AsyncAudioDecoder.h',
      'webaudio/AudioBasicInspectorNode.cpp',
      'webaudio/AudioBasicInspectorNode.h',
      'webaudio/AudioBasicProcessorNode.cpp',
      'webaudio/AudioBasicProcessorNode.h',
      'webaudio/AudioBuffer.cpp',
      'webaudio/AudioBuffer.h',
      'webaudio/AudioBufferCallback.h',
      'webaudio/AudioBufferSourceNode.cpp',
      'webaudio/AudioBufferSourceNode.h',
      'webaudio/AudioContext.cpp',
      'webaudio/AudioContext.h',
      'webaudio/AudioDestinationNode.cpp',
      'webaudio/AudioDestinationNode.h',
      'webaudio/AudioListener.cpp',
      'webaudio/AudioListener.h',
      'webaudio/AudioNode.cpp',
      'webaudio/AudioNode.h',
      'webaudio/AudioNodeInput.cpp',
      'webaudio/AudioNodeInput.h',
      'webaudio/AudioNodeOutput.cpp',
      'webaudio/AudioNodeOutput.h',
      'webaudio/AudioParam.cpp',
      'webaudio/AudioParam.h',
      'webaudio/AudioParamTimeline.cpp',
      'webaudio/AudioParamTimeline.h',
      'webaudio/AudioProcessingEvent.cpp',
      'webaudio/AudioProcessingEvent.h',
      'webaudio/AudioScheduledSourceNode.cpp',
      'webaudio/AudioScheduledSourceNode.h',
      'webaudio/AudioSourceNode.h',
      'webaudio/AudioSummingJunction.cpp',
      'webaudio/AudioSummingJunction.h',
      'webaudio/BiquadDSPKernel.cpp',
      'webaudio/BiquadDSPKernel.h',
      'webaudio/BiquadFilterNode.cpp',
      'webaudio/BiquadFilterNode.h',
      'webaudio/BiquadProcessor.cpp',
      'webaudio/BiquadProcessor.h',
      'webaudio/ChannelMergerNode.cpp',
      'webaudio/ChannelMergerNode.h',
      'webaudio/ChannelSplitterNode.cpp',
      'webaudio/ChannelSplitterNode.h',
      'webaudio/ConvolverNode.cpp',
      'webaudio/ConvolverNode.h',
      'webaudio/DefaultAudioDestinationNode.cpp',
      'webaudio/DefaultAudioDestinationNode.h',
      'webaudio/DelayDSPKernel.cpp',
      'webaudio/DelayDSPKernel.h',
      'webaudio/DelayNode.cpp',
      'webaudio/DelayNode.h',
      'webaudio/DelayProcessor.cpp',
      'webaudio/DelayProcessor.h',
      'webaudio/DynamicsCompressorNode.cpp',
      'webaudio/DynamicsCompressorNode.h',
      'webaudio/GainNode.cpp',
      'webaudio/GainNode.h',
      'webaudio/MediaElementAudioSourceNode.cpp',
      'webaudio/MediaElementAudioSourceNode.h',
      'webaudio/MediaStreamAudioDestinationNode.cpp',
      'webaudio/MediaStreamAudioDestinationNode.h',
      'webaudio/MediaStreamAudioSourceNode.cpp',
      'webaudio/MediaStreamAudioSourceNode.h',
      'webaudio/OfflineAudioCompletionEvent.cpp',
      'webaudio/OfflineAudioCompletionEvent.h',
      'webaudio/OfflineAudioContext.cpp',
      'webaudio/OfflineAudioContext.h',
      'webaudio/OfflineAudioDestinationNode.cpp',
      'webaudio/OfflineAudioDestinationNode.h',
      'webaudio/OscillatorNode.cpp',
      'webaudio/OscillatorNode.h',
      'webaudio/PannerNode.cpp',
      'webaudio/PannerNode.h',
      'webaudio/PeriodicWave.cpp',
      'webaudio/PeriodicWave.h',
      'webaudio/RealtimeAnalyser.cpp',
      'webaudio/RealtimeAnalyser.h',
      'webaudio/ScriptProcessorNode.cpp',
      'webaudio/ScriptProcessorNode.h',
      'webaudio/WaveShaperDSPKernel.cpp',
      'webaudio/WaveShaperDSPKernel.h',
      'webaudio/WaveShaperNode.cpp',
      'webaudio/WaveShaperNode.h',
      'webaudio/WaveShaperProcessor.cpp',
      'webaudio/WaveShaperProcessor.h',
      'webdatabase/AbstractDatabaseServer.h',
      'webdatabase/AbstractSQLStatement.h',
      'webdatabase/AbstractSQLStatementBackend.h',
      'webdatabase/ChangeVersionData.h',
      'webdatabase/ChangeVersionWrapper.cpp',
      'webdatabase/ChangeVersionWrapper.h',
      'webdatabase/DOMWindowWebDatabase.cpp',
      'webdatabase/DOMWindowWebDatabase.h',
      'webdatabase/Database.cpp',
      'webdatabase/DatabaseAuthorizer.cpp',
      'webdatabase/DatabaseAuthorizer.h',
      'webdatabase/DatabaseBackend.cpp',
      'webdatabase/DatabaseBackend.h',
      'webdatabase/DatabaseBackendBase.cpp',
      'webdatabase/DatabaseBackendBase.h',
      'webdatabase/DatabaseBackendSync.cpp',
      'webdatabase/DatabaseBackendSync.h',
      'webdatabase/DatabaseBase.cpp',
      'webdatabase/DatabaseBase.h',
      'webdatabase/DatabaseBasicTypes.h',
      'webdatabase/DatabaseCallback.h',
      'webdatabase/DatabaseClient.cpp',
      'webdatabase/DatabaseClient.h',
      'webdatabase/DatabaseContext.cpp',
      'webdatabase/DatabaseContext.h',
      'webdatabase/DatabaseError.h',
      'webdatabase/DatabaseManager.cpp',
      'webdatabase/DatabaseManager.h',
      'webdatabase/DatabaseServer.cpp',
      'webdatabase/DatabaseServer.h',
      'webdatabase/DatabaseSync.cpp',
      'webdatabase/DatabaseSync.h',
      'webdatabase/DatabaseTask.cpp',
      'webdatabase/DatabaseTask.h',
      'webdatabase/DatabaseThread.cpp',
      'webdatabase/DatabaseThread.h',
      'webdatabase/DatabaseTracker.cpp',
      'webdatabase/DatabaseTracker.h',
      'webdatabase/InspectorDatabaseAgent.cpp',
      'webdatabase/InspectorDatabaseAgent.h',
      'webdatabase/InspectorDatabaseResource.cpp',
      'webdatabase/InspectorDatabaseResource.h',
      'webdatabase/QuotaTracker.cpp',
      'webdatabase/QuotaTracker.h',
      'webdatabase/SQLCallbackWrapper.h',
      'webdatabase/SQLError.cpp',
      'webdatabase/SQLError.h',
      'webdatabase/SQLResultSet.cpp',
      'webdatabase/SQLResultSetRowList.cpp',
      'webdatabase/SQLStatement.cpp',
      'webdatabase/SQLStatement.h',
      'webdatabase/SQLStatementBackend.cpp',
      'webdatabase/SQLStatementBackend.h',
      'webdatabase/SQLStatementSync.cpp',
      'webdatabase/SQLStatementSync.h',
      'webdatabase/SQLTransaction.cpp',
      'webdatabase/SQLTransaction.h',
      'webdatabase/SQLTransactionBackend.cpp',
      'webdatabase/SQLTransactionBackend.h',
      'webdatabase/SQLTransactionBackendSync.cpp',
      'webdatabase/SQLTransactionBackendSync.h',
      'webdatabase/SQLTransactionClient.cpp',
      'webdatabase/SQLTransactionClient.h',
      'webdatabase/SQLTransactionCoordinator.cpp',
      'webdatabase/SQLTransactionCoordinator.h',
      'webdatabase/SQLTransactionState.h',
      'webdatabase/SQLTransactionStateMachine.cpp',
      'webdatabase/SQLTransactionStateMachine.h',
      'webdatabase/SQLTransactionSync.cpp',
      'webdatabase/SQLTransactionSync.h',
      'webdatabase/SQLTransactionSyncCallback.h',
      'webdatabase/WorkerGlobalScopeWebDatabase.cpp',
      'webdatabase/WorkerGlobalScopeWebDatabase.h',
      'webdatabase/sqlite/SQLValue.cpp',
      'webdatabase/sqlite/SQLiteAuthorizer.cpp',
      'webdatabase/sqlite/SQLiteDatabase.cpp',
      'webdatabase/sqlite/SQLiteDatabase.h',
      'webdatabase/sqlite/SQLiteFileSystem.cpp',
      'webdatabase/sqlite/SQLiteFileSystem.h',
      'webdatabase/sqlite/SQLiteFileSystemPosix.cpp',
      'webdatabase/sqlite/SQLiteFileSystemWin.cpp',
      'webdatabase/sqlite/SQLiteStatement.cpp',
      'webdatabase/sqlite/SQLiteStatement.h',
      'webdatabase/sqlite/SQLiteTransaction.cpp',
      'webdatabase/sqlite/SQLiteTransaction.h',
      'webmidi/MIDIAccess.cpp',
      'webmidi/MIDIAccess.h',
      'webmidi/MIDIAccessInitializer.cpp',
      'webmidi/MIDIAccessInitializer.h',
      'webmidi/MIDIAccessor.cpp',
      'webmidi/MIDIAccessor.h',
      'webmidi/MIDIAccessorClient.h',
      'webmidi/MIDIClient.h',
      'webmidi/MIDIClientMock.cpp',
      'webmidi/MIDIClientMock.h',
      'webmidi/MIDIConnectionEvent.cpp',
      'webmidi/MIDIConnectionEvent.h',
      'webmidi/MIDIController.cpp',
      'webmidi/MIDIController.h',
      'webmidi/MIDIErrorCallback.h',
      'webmidi/MIDIInput.cpp',
      'webmidi/MIDIInput.h',
      'webmidi/MIDIMessageEvent.h',
      'webmidi/MIDIOptions.h',
      'webmidi/MIDIOutput.cpp',
      'webmidi/MIDIOutput.h',
      'webmidi/MIDIPort.cpp',
      'webmidi/MIDIPort.h',
      'webmidi/MIDISuccessCallback.h',
      'webmidi/NavigatorWebMIDI.cpp',
      'webmidi/NavigatorWebMIDI.h',
      'websockets/CloseEvent.h',
      'websockets/MainThreadWebSocketChannel.cpp',
      'websockets/MainThreadWebSocketChannel.h',
      'websockets/NewWebSocketChannelImpl.cpp',
      'websockets/NewWebSocketChannelImpl.h',
      'websockets/ThreadableWebSocketChannelClientWrapper.cpp',
      'websockets/ThreadableWebSocketChannelClientWrapper.h',
      'websockets/WebSocket.cpp',
      'websockets/WebSocket.h',
      'websockets/WebSocketChannel.cpp',
      'websockets/WebSocketChannel.h',
      'websockets/WebSocketChannelClient.h',
      'websockets/WebSocketDeflateFramer.cpp',
      'websockets/WebSocketDeflateFramer.h',
      'websockets/WebSocketDeflater.cpp',
      'websockets/WebSocketDeflater.h',
      'websockets/WebSocketExtensionDispatcher.cpp',
      'websockets/WebSocketExtensionDispatcher.h',
      'websockets/WebSocketExtensionParser.cpp',
      'websockets/WebSocketExtensionParser.h',
      'websockets/WebSocketExtensionProcessor.h',
      'websockets/WebSocketFrame.cpp',
      'websockets/WebSocketFrame.h',
      'websockets/WebSocketHandshake.cpp',
      'websockets/WebSocketHandshake.h',
      'websockets/WebSocketPerMessageDeflate.cpp',
      'websockets/WebSocketPerMessageDeflate.h',
      'websockets/WorkerThreadableWebSocketChannel.cpp',
      'websockets/WorkerThreadableWebSocketChannel.h',
    ],
    # 'partial interface' or target (right side of) 'implements'
    'modules_testing_dependency_idl_files' : [
      'geolocation/testing/InternalsGeolocation.idl',
      'navigatorcontentutils/testing/InternalsNavigatorContentUtils.idl',
      'speech/testing/InternalsSpeechSynthesis.idl',
      'vibration/testing/InternalsVibration.idl',
    ],
    'modules_testing_files': [
      'geolocation/testing/GeolocationClientMock.cpp',
      'geolocation/testing/GeolocationClientMock.h',
      'geolocation/testing/InternalsGeolocation.cpp',
      'geolocation/testing/InternalsGeolocation.h',
      'navigatorcontentutils/testing/InternalsNavigatorContentUtils.cpp',
      'navigatorcontentutils/testing/InternalsNavigatorContentUtils.h',
      'navigatorcontentutils/testing/NavigatorContentUtilsClientMock.cpp',
      'navigatorcontentutils/testing/NavigatorContentUtilsClientMock.h',
      'speech/testing/InternalsSpeechSynthesis.cpp',
      'speech/testing/InternalsSpeechSynthesis.h',
      'speech/testing/PlatformSpeechSynthesizerMock.cpp',
      'speech/testing/PlatformSpeechSynthesizerMock.h',
      'vibration/testing/InternalsVibration.cpp',
      'vibration/testing/InternalsVibration.h',
    ],
    'modules_unittest_files': [
      'indexeddb/IDBKeyPathTest.cpp',
      'indexeddb/IDBRequestTest.cpp',
      'indexeddb/IDBTransactionTest.cpp',
      'websockets/WebSocketDeflaterTest.cpp',
      'websockets/WebSocketExtensionDispatcherTest.cpp',
      'websockets/WebSocketExtensionParserTest.cpp',
      'websockets/WebSocketPerMessageDeflateTest.cpp',
      'websockets/WebSocketTest.cpp',
    ],
  },
}
