// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_POLICY_BOOLEAN_DISABLING_POLICY_HANDLER_H_
#define CHROME_BROWSER_POLICY_BOOLEAN_DISABLING_POLICY_HANDLER_H_

#include "base/values.h"
#include "components/policy/core/browser/configuration_policy_handler.h"

class PrefValueMap;

namespace policy {

class PolicyMap;

// This policy handler only forces the pref to false when policy value is false.
// Otherwise this handler does not affect the value of the pref. This can be
// used in cases where the policy is something like "AllowFeatureX" and the pref
// is something like "EnableFeatureX". The admin can prevent the feature from
// from being used by setting the policy to false which forces the pref to
// false. However, if the policy is true, the pref is not forced to true and the
// user must still manually enable the feature from settings.
class BooleanDisablingPolicyHandler : public policy::TypeCheckingPolicyHandler {
 public:
  BooleanDisablingPolicyHandler(const char* policy_name, const char* pref_path);
  ~BooleanDisablingPolicyHandler() override;
  BooleanDisablingPolicyHandler(const BooleanDisablingPolicyHandler&) = delete;
  BooleanDisablingPolicyHandler& operator=(
      const BooleanDisablingPolicyHandler&) = delete;

  // ConfigurationPolicyHandler methods:
  void ApplyPolicySettings(const PolicyMap& policies,
                           PrefValueMap* prefs) override;

 private:
  const char* pref_path_;
};

}  // namespace policy

#endif  // CHROME_BROWSER_POLICY_BOOLEAN_DISABLING_POLICY_HANDLER_H_
