/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class ImageCrop
extends Applet {
    private static final int LANDSCAPE = 0;
    private static final int PORTRAIT = 1;
    Image offscreen;
    Image image;
    ImageObserver imageObserver;
    Color bgcolor = Color.white;
    boolean imageLoaded = false;
    boolean errorOccurred;
    String errorMessage = "";
    Rectangle canvasRect = new Rectangle(10, 10, 440, 375);
    Rectangle widgetRect = new Rectangle(10, 395, 440, 30);
    Rectangle imageRect = new Rectangle(this.canvasRect);
    Rectangle cropRect = new Rectangle(this.canvasRect);
    Rectangle resizeHandleRect = new Rectangle(0, 0, 10, 10);
    Dimension rawImageSize = new Dimension(4, 3);
    int cropToSize;
    int cropLayout = 0;
    boolean cropTooSmall = false;
    AspectRatio cropRatio;
    Vector aspectRatios;
    float imageScale;
    boolean mouseDown_onMoveHandle = false;
    boolean mouseDown_onResizeHandle = false;
    Point mouseDownPoint;
    Choice choice_Ratio;
    Choice choice_Layout;

    public void destroy() {
        if (this.image != null) {
            this.image.flush();
        }
        if (this.offscreen != null) {
            this.offscreen.flush();
        }
    }

    public int getIntParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void init() {
        try {
            this.rawImageSize.width = this.getIntParameter("IMAGE_W");
            this.rawImageSize.height = this.getIntParameter("IMAGE_H");
            if (this.rawImageSize.width == 0 || this.rawImageSize.height == 0) {
                throw new Exception("Invalid Image Size Parameters");
            }
            this.cropLayout = this.rawImageSize.width > this.rawImageSize.height ? 0 : 1;
            this.cropRect.x = this.getIntParameter("CROP_X");
            this.cropRect.y = this.getIntParameter("CROP_Y");
            this.cropRect.width = this.getIntParameter("CROP_W");
            this.cropRect.height = this.getIntParameter("CROP_H");
            this.cropToSize = this.getIntParameter("CROP_TO_SIZE");
            String string = this.getParameter("IMAGE");
            if (string == null) {
                throw new Exception("No Image URL parameter provided.");
            }
            System.out.println("ImageUrl [" + string + "]");
            try {
                this.image = this.getImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new Exception("Malformed Image URL [" + string + "]");
            }
            this.prepareImage(this.image, this);
            this.aspectRatios = new Vector();
            this.aspectRatios.addElement(new AspectRatio("As Image", this.rawImageSize.width, this.rawImageSize.height));
            this.aspectRatios.addElement(new AspectRatio("Letterbox", 1, 3));
            this.aspectRatios.addElement(new AspectRatio("HDTV", 9, 16));
            this.aspectRatios.addElement(new AspectRatio("Photo", 3, 5));
            this.aspectRatios.addElement(new AspectRatio("Photo", 4, 6));
            this.aspectRatios.addElement(new AspectRatio("Photo", 5, 7));
            this.aspectRatios.addElement(new AspectRatio("Screen", 3, 4));
            this.aspectRatios.addElement(new AspectRatio("Photo", 8, 10));
            this.aspectRatios.addElement(new AspectRatio("Square", 1, 1));
            this.setBackground(Color.white);
            this.setLayout(null);
            Panel panel = new Panel(new BorderLayout());
            Panel panel2 = new Panel(new FlowLayout(0, 1, 2));
            panel.setSize(this.widgetRect.width, this.widgetRect.height);
            panel.setLocation(this.widgetRect.x, this.widgetRect.y);
            panel2.setBackground(Color.white);
            this.choice_Ratio = new Choice();
            this.choice_Layout = new Choice();
            this.choice_Layout.add("Landscape");
            this.choice_Layout.add("Portrait");
            Panel panel3 = new Panel(new FlowLayout(2, 3, 2));
            Button button = new Button("Cancel");
            button.setSize(100, 25);
            Button button2 = new Button("OK");
            button2.setSize(100, 25);
            panel2.add(new Label("Aspect Ratio:"));
            panel2.add(this.choice_Ratio);
            panel2.add(this.choice_Layout);
            panel3.add(button);
            panel3.add(button2);
            panel.add((Component)panel2, "West");
            panel.add((Component)panel3, "East");
            this.add(panel);
            this.updateWidgets(true);
            WidgetItemListener widgetItemListener = new WidgetItemListener();
            this.choice_Ratio.addItemListener(widgetItemListener);
            this.choice_Layout.addItemListener(widgetItemListener);
            MyMouseListener myMouseListener = new MyMouseListener();
            this.addMouseListener(myMouseListener);
            this.addMouseMotionListener(myMouseListener);
            MyButtonListener myButtonListener = new MyButtonListener();
            button.addActionListener(myButtonListener);
            button2.addActionListener(myButtonListener);
            return;
        }
        catch (Exception exception) {
            this.errorOccurred = true;
            this.errorMessage = exception.toString();
            return;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        if (this.imageLoaded) {
            graphics2.setColor(Color.black);
            graphics2.fillRect(this.imageRect.x + 1, this.imageRect.y + 1, this.imageRect.width, this.imageRect.height);
            graphics2.drawImage(this.image, this.imageRect.x, this.imageRect.y, this.imageRect.width, this.imageRect.height, this.bgcolor, this);
            Color color = this.cropTooSmall ? Color.red : Color.cyan;
            int n = this.resizeHandleRect.x + this.imageRect.x;
            int n2 = this.resizeHandleRect.y + this.imageRect.y;
            int n3 = this.resizeHandleRect.width;
            int n4 = this.resizeHandleRect.height;
            graphics2.setColor(Color.black);
            graphics2.drawRect(n + 1, n2 + 1, n3, n4);
            graphics2.setColor(Color.white);
            graphics2.drawRect(n - 1, n2 - 1, n3, n4);
            graphics2.setColor(color);
            graphics2.fillRect(n, n2, n3, n4);
            n = this.cropRect.x + this.imageRect.x;
            n2 = this.cropRect.y + this.imageRect.y;
            n3 = this.cropRect.width;
            n4 = this.cropRect.height;
            graphics2.setColor(Color.black);
            graphics2.drawRect(n + 1, n2 + 1, n3, n4);
            graphics2.setColor(Color.white);
            graphics2.drawRect(n - 1, n2 - 1, n3, n4);
            graphics2.setColor(color);
            graphics2.drawRect(n, n2, n3, n4);
        } else if (this.errorOccurred) {
            graphics2.drawString("Error Occurred: " + this.errorMessage, 100, 100);
        } else {
            graphics2.drawString("Loading image...", 100, 100);
        }
        super.paint(graphics2);
        graphics.drawImage(this.offscreen, 0, 0, null);
        graphics2.dispose();
    }

    private void finishInitWithImage() {
        float f;
        this.imageLoaded = true;
        Dimension dimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        if (dimension.width > dimension.height) {
            this.imageRect.width = dimension.width > this.canvasRect.width ? this.canvasRect.width : dimension.width;
            f = (float)this.imageRect.width / (float)dimension.width;
            this.imageRect.height = (int)(f * (float)dimension.height);
        } else {
            this.imageRect.height = dimension.height > this.canvasRect.height ? this.canvasRect.height : dimension.height;
            f = (float)this.imageRect.height / (float)dimension.height;
            this.imageRect.width = (int)(f * (float)dimension.width);
        }
        this.imageRect.x = this.canvasRect.x + (this.canvasRect.width - this.imageRect.width) / 2;
        this.imageRect.y = this.canvasRect.y + (this.canvasRect.height - this.imageRect.height) / 2;
        this.imageScale = (float)this.rawImageSize.width / (float)this.imageRect.width;
        if (this.cropRect.width > 0 && this.cropRect.height > 0) {
            this.cropRect.x = (int)((float)this.cropRect.x / this.imageScale);
            this.cropRect.y = (int)((float)this.cropRect.y / this.imageScale);
            this.cropRect.width = (int)((float)this.cropRect.width / this.imageScale);
            this.cropRect.height = (int)((float)this.cropRect.height / this.imageScale);
        } else {
            this.cropRect.x = 0;
            this.cropRect.y = 0;
            this.cropRect.width = this.imageRect.width;
            this.cropRect.height = this.imageRect.height;
        }
        this.cropToSize = (int)((float)this.cropToSize / this.imageScale);
        this.cropLayout = this.cropRect.width < this.cropRect.height ? 1 : 0;
        boolean bl = false;
        Enumeration enumeration = this.aspectRatios.elements();
        while (enumeration.hasMoreElements() && !bl) {
            AspectRatio aspectRatio = (AspectRatio)enumeration.nextElement();
            if (!aspectRatio.isMatch(this.cropRect.width, this.cropRect.height)) continue;
            this.cropRatio = aspectRatio;
            bl = true;
        }
        if (!bl) {
            this.cropRatio = (AspectRatio)this.aspectRatios.elementAt(0);
        }
        this.constrainCrop();
        this.updateHandles();
    }

    public void updateHandles() {
        this.resizeHandleRect.x = this.cropRect.x + this.cropRect.width - this.resizeHandleRect.width;
        this.resizeHandleRect.y = this.cropRect.y + this.cropRect.height - this.resizeHandleRect.height;
    }

    public void updateWidgets(boolean bl) {
        if (!bl) {
            this.cropLayout = this.choice_Layout.getSelectedIndex();
            this.cropRatio = (AspectRatio)this.aspectRatios.elementAt(this.choice_Ratio.getSelectedIndex());
        }
        this.choice_Ratio.removeAll();
        Enumeration enumeration = this.aspectRatios.elements();
        while (enumeration.hasMoreElements()) {
            AspectRatio aspectRatio = (AspectRatio)enumeration.nextElement();
            this.choice_Ratio.add(aspectRatio.getLabel());
            if (aspectRatio != this.cropRatio) continue;
            this.choice_Ratio.select(aspectRatio.getLabel());
        }
        this.choice_Layout.select(this.cropLayout);
    }

    private void constrainCrop() {
        int n;
        float f;
        float f2;
        if (this.cropToSize > 0) {
            this.cropTooSmall = this.cropLayout == 0 && this.cropRect.width < this.cropToSize ? true : this.cropLayout == 1 && this.cropRect.height < this.cropToSize;
        }
        if ((f2 = (float)this.cropRect.height / (float)this.cropRect.width) > (f = (float)this.cropRatio.getY() / (float)this.cropRatio.getX())) {
            int n2;
            this.cropRect.height = n2 = (int)((float)this.cropRect.width * f);
            return;
        }
        this.cropRect.width = n = (int)((float)this.cropRect.height / f);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (n == 32) {
            if (!this.imageLoaded) {
                this.finishInitWithImage();
                this.updateWidgets(true);
            }
            this.repaint();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    static /* synthetic */ int access$1() {
        return 0;
    }

    class WidgetItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ImageCrop.this.updateWidgets(false);
            ImageCrop.this.constrainCrop();
            ImageCrop.this.updateHandles();
            ImageCrop.this.repaint();
        }

        WidgetItemListener() {
            ImageCrop.this = ImageCrop.this;
        }
    }

    class MyButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = String.valueOf(ImageCrop.this.getDocumentBase()) + "&";
            string = ((Button)actionEvent.getSource()).getLabel() == "OK" ? String.valueOf(string) + "action=doit" : String.valueOf(string) + "action=cancel";
            string = String.valueOf(string) + "&crop_x=" + (int)((float)ImageCrop.this.cropRect.x * ImageCrop.this.imageScale);
            string = String.valueOf(string) + "&crop_y=" + (int)((float)ImageCrop.this.cropRect.y * ImageCrop.this.imageScale);
            string = String.valueOf(string) + "&crop_w=" + (int)((float)ImageCrop.this.cropRect.width * ImageCrop.this.imageScale);
            string = String.valueOf(string) + "&crop_h=" + (int)((float)ImageCrop.this.cropRect.height * ImageCrop.this.imageScale);
            System.out.println("Submit [" + string + "]");
            try {
                ImageCrop.this.getAppletContext().showDocument(new URL(string));
                return;
            }
            catch (Exception exception) {
                System.out.println("Bad submit url [" + string + "]");
                return;
            }
        }

        MyButtonListener() {
            ImageCrop.this = ImageCrop.this;
        }
    }

    class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ImageCrop.this.cropRect.x = 0;
                ImageCrop.this.cropRect.y = 0;
                ImageCrop.this.cropRect.width = ImageCrop.this.imageRect.width;
                ImageCrop.this.cropRect.height = ImageCrop.this.imageRect.height;
                ImageCrop.this.constrainCrop();
                ImageCrop.this.updateHandles();
                ImageCrop.this.invalidate();
                ImageCrop.this.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ImageCrop.this.mouseDownPoint = mouseEvent.getPoint();
            ImageCrop.this.mouseDownPoint.x -= ImageCrop.this.imageRect.x;
            ImageCrop.this.mouseDownPoint.y -= ImageCrop.this.imageRect.y;
            if (ImageCrop.this.resizeHandleRect.contains(ImageCrop.this.mouseDownPoint)) {
                ImageCrop.this.mouseDown_onResizeHandle = true;
                return;
            }
            if (ImageCrop.this.cropRect.contains(ImageCrop.this.mouseDownPoint)) {
                ImageCrop.this.mouseDown_onMoveHandle = true;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageCrop.this.mouseDown_onMoveHandle = false;
            ImageCrop.this.mouseDown_onResizeHandle = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.x -= ImageCrop.this.imageRect.x;
            point.y -= ImageCrop.this.imageRect.y;
            int n = point.x - ImageCrop.this.mouseDownPoint.x;
            int n2 = point.y - ImageCrop.this.mouseDownPoint.y;
            boolean bl = false;
            if (ImageCrop.this.mouseDown_onMoveHandle) {
                if (ImageCrop.this.cropRect.x + ImageCrop.this.cropRect.width + n < ImageCrop.this.imageRect.width && ImageCrop.this.cropRect.x + n > 0) {
                    ImageCrop.this.cropRect.x += n;
                    bl = true;
                }
                if (ImageCrop.this.cropRect.y + ImageCrop.this.cropRect.height + n2 < ImageCrop.this.imageRect.height && ImageCrop.this.cropRect.y + n2 > 0) {
                    ImageCrop.this.cropRect.y += n2;
                    bl = true;
                }
            }
            if (ImageCrop.this.mouseDown_onResizeHandle) {
                if (ImageCrop.this.cropRect.x + ImageCrop.this.cropRect.width + n <= ImageCrop.this.imageRect.width && ImageCrop.this.cropRect.width + n >= 10) {
                    ImageCrop.this.cropRect.width += n;
                    bl = true;
                }
                if (ImageCrop.this.cropRect.y + ImageCrop.this.cropRect.height + n2 <= ImageCrop.this.imageRect.height && ImageCrop.this.cropRect.height + n2 >= 10) {
                    ImageCrop.this.cropRect.height += n2;
                    bl = true;
                }
                ImageCrop.this.constrainCrop();
            }
            ImageCrop.this.mouseDownPoint = point;
            if (bl) {
                ImageCrop.this.updateHandles();
                ImageCrop.this.invalidate();
                ImageCrop.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        MyMouseListener() {
            ImageCrop.this = ImageCrop.this;
        }
    }

    private class AspectRatio {
        public int longSide;
        public int shortSide;
        private String label;

        public AspectRatio(String string, int n, int n2) {
            this(n, n2);
            this.label = string;
        }

        public AspectRatio(int n, int n2) {
            ImageCrop.this = ImageCrop.this;
            this.longSide = n < n2 ? n2 : n;
            this.shortSide = n < n2 ? n : n2;
        }

        public String getLabel() {
            return String.valueOf(this.shortSide) + ":" + this.longSide + " (" + this.label + ")";
        }

        public int getX() {
            if (ImageCrop.this.cropLayout == ImageCrop.access$1()) {
                return this.longSide;
            }
            return this.shortSide;
        }

        public int getY() {
            if (ImageCrop.this.cropLayout == ImageCrop.access$1()) {
                return this.shortSide;
            }
            return this.longSide;
        }

        public boolean isMatch(int n, int n2) {
            float f = 0.05f;
            return Math.abs((float)n / (float)n2 - (float)this.getX() / (float)this.getY()) <= f;
        }
    }
}

