/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.model;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.ExifData;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.GalleryItem;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

public class Picture
extends GalleryItem
implements Serializable,
PreferenceNames,
Cloneable {
    public static final String MODULE = "Picture";
    File source = null;
    HashMap extraFields;
    boolean hidden;
    int angle = 0;
    boolean flipped = false;
    boolean suppressServerAutoRotate = false;
    boolean online = false;
    URL urlFull = null;
    Dimension sizeFull = null;
    URL urlResized = null;
    Dimension sizeResized = null;
    URL urlThumbnail = null;
    Dimension sizeThumbnail = null;
    Rectangle cropTo = null;
    Album albumOnServer = null;
    int indexOnServer = -1;
    transient double fileSize = 0.0;
    transient int indexCache = -1;
    transient Dimension dimension = null;
    transient ExifData exif = null;

    public Picture(Gallery gallery) {
        super(gallery);
        this.setAllowsChildren(false);
    }

    public Picture(Gallery gallery, File source) {
        this(gallery);
        this.setSource(source);
    }

    public Object clone() {
        Picture newPicture = (Picture)super.clone();
        newPicture.source = this.source;
        newPicture.extraFields = this.extraFields;
        newPicture.angle = this.angle;
        newPicture.flipped = this.flipped;
        newPicture.suppressServerAutoRotate = this.suppressServerAutoRotate;
        newPicture.online = this.online;
        newPicture.urlFull = this.urlFull;
        newPicture.sizeFull = this.sizeFull;
        newPicture.urlResized = this.urlResized;
        newPicture.sizeResized = this.sizeResized;
        newPicture.urlThumbnail = this.urlThumbnail;
        newPicture.sizeThumbnail = this.sizeThumbnail;
        newPicture.fileSize = this.fileSize;
        newPicture.escapedCaption = this.escapedCaption;
        newPicture.indexCache = this.indexCache;
        newPicture.albumOnServer = this.albumOnServer;
        newPicture.indexOnServer = this.indexOnServer;
        return newPicture;
    }

    public void setSource(File source) {
        this.source = source;
        if (GalleryRemote._().properties.getBooleanProperty("setCaptionsWithFilenames")) {
            int i;
            String filename = source.getName();
            if (GalleryRemote._().properties.getBooleanProperty("captionStripExtension") && (i = filename.lastIndexOf(".")) != -1) {
                filename = filename.substring(0, i);
            }
            this.setCaption(filename);
        } else if (GalleryRemote._().properties.getBooleanProperty("setCaptionsWithMetadataComment") && this.getExifData() != null && this.getExifData().getCaption() != null) {
            this.setCaption(this.getExifData().getCaption());
        }
        this.fileSize = 0.0;
    }

    public File getSource() {
        if (this.online) {
            throw new RuntimeException("Can't get source for an online file!");
        }
        return this.source;
    }

    public File getUploadSource() {
        boolean useLossyCrop = false;
        File picture = this.getSource();
        Album album = this.getParentAlbum();
        if (this.cropTo != null) {
            try {
                picture = ImageUtils.losslessCrop(picture.getPath(), this.cropTo);
            }
            catch (UnsupportedOperationException e) {
                Log.log(1, MODULE, "Couldn't use ImageUtils to losslessly crop the image, will try lossy");
                Log.logException(1, MODULE, e);
                useLossyCrop = true;
            }
        }
        if (album.getResize()) {
            int i = album.getResizeDimension();
            if (i <= 0) {
                int l = album.getServerAutoResize();
                i = l != 0 ? l : GalleryRemote._().properties.getIntDimensionProperty("resizeToDefault");
            }
            if (i != -1 || useLossyCrop) {
                try {
                    picture = ImageUtils.resize(picture.getPath(), new Dimension(i, i), useLossyCrop ? this.cropTo : null);
                }
                catch (UnsupportedOperationException e) {
                    Log.log(1, MODULE, "Couldn't use ImageUtils to resize the image, it will be uploaded at the original size");
                    Log.logException(1, MODULE, e);
                }
            }
        } else if (useLossyCrop) {
            picture = ImageUtils.resize(picture.getPath(), null, useLossyCrop ? this.cropTo : null);
        }
        if (this.angle != 0 || this.flipped) {
            try {
                picture = ImageUtils.rotate(picture.getPath(), this.angle, this.flipped, true);
            }
            catch (UnsupportedOperationException e) {
                Log.log(1, MODULE, "Couldn't use jpegtran to resize the image, it will be uploaded unrotated");
                Log.logException(1, MODULE, e);
            }
        }
        return picture;
    }

    public double getFileSize() {
        if (this.fileSize == 0.0 && this.source != null && this.source.exists()) {
            this.fileSize = this.source.length();
        }
        return this.fileSize;
    }

    public void setFileSize(double fileSize) {
        if (!this.online) {
            throw new RuntimeException("Can't set the size of a local image");
        }
        this.fileSize = fileSize;
    }

    public String toString() {
        if (this.online) {
            return this.getName();
        }
        return this.source.getName();
    }

    public int hashCode() {
        String path = null;
        path = this.online ? this.safeGetUrlFull().toString() : this.source.getName();
        return path.hashCode();
    }

    public int getSize() {
        return 0;
    }

    public Object getElementAt(int index) {
        return null;
    }

    public void rotateRight() {
        this.angle = (this.angle + 1) % 4;
    }

    public void rotateLeft() {
        this.angle = (this.angle + 3) % 4;
    }

    public void flip() {
        this.flipped = !this.flipped;
    }

    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    public String getExtraField(String name) {
        if (this.extraFields == null) {
            return null;
        }
        return (String)this.extraFields.get(name);
    }

    public String getExtraFieldsString() {
        if (this.extraFields == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        Iterator it = this.getParentAlbum().getExtraFields().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = (String)this.extraFields.get(name);
            if (value == null) continue;
            sb.append(name).append(": ").append(value).append(sep);
        }
        return sb.toString();
    }

    public void setExtraField(String name, String value) {
        if (this.extraFields == null) {
            this.extraFields = new HashMap();
        }
        this.extraFields.put(name, value);
    }

    public void removeExtraField(String name) {
        if (this.extraFields == null) {
            this.extraFields = new HashMap();
        }
        this.extraFields.remove(name);
    }

    public HashMap getExtraFieldsMap() {
        return this.extraFields;
    }

    public void setSuppressServerAutoRotate(boolean suppressServerAutoRotate) {
        this.suppressServerAutoRotate = suppressServerAutoRotate;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public URL getUrlFull() {
        if (!this.online) {
            throw new RuntimeException("Can't get URL for a local file!");
        }
        return this.urlFull;
    }

    public URL safeGetUrlFull() {
        if (!this.online) {
            throw new RuntimeException("Can't get URL for a local file!");
        }
        if (this.urlFull != null) {
            return this.urlFull;
        }
        if (this.urlResized != null) {
            return this.urlResized;
        }
        throw new RuntimeException("Neither full nor resized URL!");
    }

    public void setUrlFull(URL urlFull) {
        this.urlFull = urlFull;
    }

    public Dimension getSizeFull() {
        if (!this.online) {
            throw new RuntimeException("Can't get dimension for a local file!");
        }
        return this.sizeFull;
    }

    public Dimension safeGetSizeFull() {
        if (!this.online) {
            throw new RuntimeException("Can't get dimension for a local file!");
        }
        if (this.sizeFull != null) {
            return this.sizeFull;
        }
        if (this.sizeResized != null) {
            return this.sizeResized;
        }
        throw new RuntimeException("Neither full nor resized size!");
    }

    public void setSizeFull(Dimension sizeFull) {
        this.sizeFull = sizeFull;
    }

    public URL getUrlResized() {
        if (!this.online) {
            throw new RuntimeException("Can't get URL for a local file!");
        }
        return this.urlResized;
    }

    public void setUrlResized(URL urlResized) {
        this.urlResized = urlResized;
    }

    public Dimension getSizeResized() {
        if (!this.online) {
            throw new RuntimeException("Can't get dimension for a local file!");
        }
        return this.sizeResized;
    }

    public void setSizeResized(Dimension sizeResized) {
        this.sizeResized = sizeResized;
    }

    public URL getUrlThumbnail() {
        if (!this.online) {
            throw new RuntimeException("Can't get URL for a local file!");
        }
        return this.urlThumbnail;
    }

    public void setUrlThumbnail(URL urlThumbnail) {
        this.urlThumbnail = urlThumbnail;
    }

    public Dimension getSizeThumbnail() {
        if (!this.online) {
            throw new RuntimeException("Can't get dimension for a local file!");
        }
        return this.sizeThumbnail;
    }

    public void setSizeThumbnail(Dimension sizeThumbnail) {
        this.sizeThumbnail = sizeThumbnail;
    }

    public String getName() {
        String path = this.safeGetUrlFull().getPath();
        int i = path.lastIndexOf(47);
        if (i != -1) {
            path = path.substring(i + 1);
        }
        if ((i = path.lastIndexOf(46)) != -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public Album getAlbumOnServer() {
        if (!this.online) {
            throw new RuntimeException("Can't get Album on server for a local file!");
        }
        return this.albumOnServer;
    }

    public void setAlbumOnServer(Album albumOnServer) {
        this.albumOnServer = albumOnServer;
    }

    public int getIndexOnServer() {
        if (!this.online) {
            throw new RuntimeException("Can't get Index on server for a local file!");
        }
        return this.indexOnServer;
    }

    public int getIndex() {
        Album album = this.getParentAlbum();
        if (this.indexCache == -1 || this.indexCache >= album.pictures.size() || album.pictures.get(this.indexCache) != this) {
            return album.pictures.indexOf(this);
        }
        return this.indexCache;
    }

    public void setIndexOnServer(int indexOnServer) {
        this.indexOnServer = indexOnServer;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Rectangle getCropTo() {
        return this.cropTo;
    }

    public void setCropTo(Rectangle cropTo) {
        Log.log(3, MODULE, "setCropTo " + cropTo);
        if (cropTo != null) {
            Dimension d = this.getDimension();
            if (cropTo.x < 0) {
                cropTo.x = 0;
            }
            if (cropTo.y < 0) {
                cropTo.y = 0;
            }
            if (cropTo.width + cropTo.x > d.width) {
                cropTo.width = d.width - cropTo.x;
            }
            if (cropTo.height + cropTo.y > d.height) {
                cropTo.height = d.height - cropTo.y;
            }
        }
        this.cropTo = cropTo;
    }

    public Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = ImageUtils.getPictureDimension(this);
        }
        return this.dimension;
    }

    public ExifData getExifData() {
        if (this.exif == null && ImageUtils.isExifAvailable()) {
            this.exif = ImageUtils.getExifData(this.source.getPath());
        }
        return this.exif;
    }
}

