/* $Id: dot.c,v 1.8 2004/12/11 19:26:05 ellson Exp $ $Revision: 1.8 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#include <dotneato.h>

int main(int argc, char **argv)
{
    Agraph_t *g, *prev = NULL;
    GVC_t *gvc;

    gvc = gvContext();

    dotneato_initialize(gvc, argc, argv);
    while ((g = next_input_graph())) {
	if (prev) {
	    dot_cleanup(prev);
	    agclose(prev);
	}
	prev = g;

	gvBindContext(gvc, g);

	dot_layout(g);
	dotneato_write(gvc);
    }
    dotneato_terminate(gvc);
    return 0;
}
