/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlpkt.h,v 1.1.26.1 2004/07/09 01:57:03 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
 
#ifndef _SMLPKT_H_
#define _SMLPKT_H_

#include "hxwintyp.h"

const char RMA_DRIVER_VERSION[] = "1.0";

class CSmilPacket
{
public:
    typedef enum
    {
	SMILAddChannel,
	SMILAddGroup,
	SMILPlayGroup,
	SMILChannelAdded,
	SMILEndLayout,
	SMILAddSource,
	SMILSourceAdded,
	SMILMetaValues,
	SMILDocument
    } SMILPacketType;

    CSmilPacket			    (SMILPacketType pktType):
					m_type(pktType)
					{}

    virtual ~CSmilPacket	    ()
					{};

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues) 
					{};

    SMILPacketType m_type;
    CHXString m_id;
    CHXString m_version;
};

class CSmilMetaValuesPacket: public CSmilPacket
{
public:
    CSmilMetaValuesPacket	    ();
    virtual ~CSmilMetaValuesPacket  ();

    virtual void assign		    (const char* pName,
				    const char** pValues,
				    INT32 nValues);

    CHXHeader* m_pValues;
};

class CSmilDocumentPacket: public CSmilPacket
{
public:
    CSmilDocumentPacket		    ();
    virtual ~CSmilDocumentPacket    ();

    virtual void assign		    (const char* pName,
				    const char** pValues,
				    INT32 nValues);

    UINT32    m_ulPacketNumber;
    UINT32    m_ulTotalPackets;
    CHXString m_document;
};

class CSmilAddGroupPacket: public CSmilPacket
{
public:
    CSmilAddGroupPacket		    ();
    ~CSmilAddGroupPacket	    ()
				    {};

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues);

    INT32 m_nGroup;		// group to create
    INT32 m_nTotalTracks;	// total number of tracks in group
    INT32 m_nInitTracks;	// number of tracks needed to start group
    CHXString m_title;
    UINT32 m_ulDuration;
};

class CSmilPlayGroupPacket: public CSmilPacket
{
public:
    CSmilPlayGroupPacket	    ();
    ~CSmilPlayGroupPacket	    ()
				    {};

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues);

    INT32 	m_nGroup;
    UINT32	m_ulDelay;
    UINT32 	m_ulDuration;
};

class CSmilAddChannelPacket: public CSmilPacket
{
public:
    CSmilAddChannelPacket	    ();
    ~CSmilAddChannelPacket	    ()
				    {};

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues);

    UINT32	m_ulTop;
    UINT32	m_ulLeft;
    UINT32	m_ulHeight;
    UINT32	m_ulWidth;
    UINT32      m_ulZIndex;
    HXxColor	m_ulBgColor;
};

class CSmilEndLayoutPacket: public CSmilPacket
{
public:
    CSmilEndLayoutPacket	    ();
    ~CSmilEndLayoutPacket	    ();

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues);

    CHXString m_layoutName;
};

class CSmilAddSourcePacket: public CSmilPacket
{
public:
    CSmilAddSourcePacket	    ();
    ~CSmilAddSourcePacket	    ()
				    {};

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues);

    CHXString	m_src;
    CHXString	m_channel;
    CHXString	m_fill;
    UINT32	m_nGroup;
    UINT32	m_ulDelay;
    UINT32	m_ulDuration;
    UINT32	m_ulClipStart;
    UINT32	m_ulClipEnd;
};

class CSmilSourceAddedPacket: public CSmilPacket
{
public:
    CSmilSourceAddedPacket	    ();
    ~CSmilSourceAddedPacket	    ()
				    {};

    virtual void assign		    (const char* pName, 
				    const char** pValues,
				    INT32 nValues);

    UINT32 m_duration;
};

class CSmilPacketTag
{
public:
    CSmilPacketTag		    () 
				    {};
    ~CSmilPacketTag		    ()
				    {};

    CHXString   m_name;
};


class CSmilPacketParser
{
public:
    CSmilPacketParser		    ();
    ~CSmilPacketParser		    ();

    typedef enum
    {
        SMILUnknown,
        SMILNoValue,
        SMILMissingQuote,
        SMILOpenList,
        SMILCloseList,
        SMILString
    } SMILPacketParseResult;

    class Node
    {
    public:
        Node			    (): m_bIsSymbol(FALSE),
				    car(0),
				    cdr(0)
				    {}
        ~Node			    ()
				    {}
        CHXString       m_name;
	BOOL		m_bIsSymbol;
	Node*		car;
	Node*		cdr;
	void dump	();
    };

    CSmilPacket* parse(IHXBuffer* pBuffer,
	REF(CSmilPacketParser::SMILPacketParseResult) pktPrsRslt);

private:
    SMILPacketParseResult getAtom	(const char*& pBuf, 
    					UINT32 len,
        				CSmilPacketTag*& pTag);
    void 	deleteNode		(Node* pNode);
    void	eval			(Node* pNode, 
    					CSmilPacket* pPkt);
    CSmilPacket* evalNode		(Node* pNode);
    Node*	getRoot			() 
					{ return m_pRootNode->car; }
    Node*   		m_pRootNode;
};

#endif	/* _SMLPKT_H_ */
