/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: animattr.h,v 1.2.18.1 2004/07/09 01:57:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef ANIMATTR_H
#define ANIMATTR_H

enum
{
    kAttrNameUnknown,
    kAttrNameLeft,
    kAttrNameTop,
    kAttrNameRight,
    kAttrNameBottom,
    kAttrNameWidth,
    kAttrNameHeight,
    kAttrNameBackgroundColor,
    kAttrNameZIndex,
    kAttrNameSoundLevel,
    kAttrNameCoords,
    kAttrNameColor,
    kAttrNameLeftTop,
    kAttrNameMediaOpacity,
    kAttrNameBackgroundOpacity,
    kAttrNameValue,
    kNumAttrNames
};

#if defined(HELIX_FEATURE_SMIL2_ANIMATION)

class CAttr
{
public:
    CAttr(UINT32 ulAttrName = kAttrNameUnknown, const char* pszStr = NULL);
    CAttr(UINT32 ulAttrName,
          double dVal0,       CSS2Type eType0 = CSS2TypeAuto,
          double dVal1 = 0.0, CSS2Type eType1 = CSS2TypeAuto,
          double dVal2 = 0.0, CSS2Type eType2 = CSS2TypeAuto,
          double dVal3 = 0.0, CSS2Type eType3 = CSS2TypeAuto);
    CAttr(const CAttr& rAttr);
    virtual ~CAttr();

    enum
    {
        kVectorSize = 4
    };

    // Methods
    HX_RESULT     GetLastError() const { return m_lLastError; }
    UINT32        GetAttrName() const  { return m_ulAttrName; }
    static double Dist(CAttr* pAttr1, CAttr* pAttr2, CAttr* pDepend);
    static double GetAbsolute(CAttr* pAttr, UINT32 i, CAttr* pDepend);
    void          Interp(CAttr* pAttr1, double t1,
                         CAttr* pAttr2, double t2,
                         double t, CAttr* pDepend);
    void          Add(CAttr* pAttr, CAttr* pDepend);
    void          Mult(double dMult);
    void          Clamp();
    double        GetValueDouble(UINT32 i = 0) const;
    CSS2Type      GetCSS2Type(UINT32 i = 0) const;
    BOOL          IsRelative(UINT32 i = 0) const;
    const char*   GetValueString(UINT32 i = 0) const;
    // Operators
    CAttr&        operator = (const CAttr& rAttr);
protected:
    enum
    {
        kAttrTypeString,
        kAttrTypeRealScalar,
        kAttrTypeRealVector,
        kNumAttrTypes
    };

    HX_RESULT m_lLastError;
    UINT32    m_ulAttrName;
    UINT32    m_ulAttrType;
    double    m_dValue[kVectorSize];
    char*     m_pszValue;
    CSS2Type  m_eType[kVectorSize];

    static BOOL   Compatible(CAttr* pAttr1, CAttr* pAttr2);
    HX_RESULT     ParsePosLenValue(const char* pszStr,
                                   double&     rdValue,
                                   BOOL&       rbIsPercent);
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */

#endif
