/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: stage1.cpp,v 1.1.2.1 2004/07/09 02:03:06 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/***********************************************************************
 * stage1.cpp 
 *
 * A simple self-extracting installer 
 *
 ***********************************************************************
 *
 * KEEP THIS THING GENERIC AND VERY SIMPLE , putting package-specific items
 *     in the second-stage installer.  The second-stage installer
 *     is responsible for all cleanup.
 *
 ***********************************************************************/

#include "hxtypes.h"

#ifdef _WIN32
#include <windows.h>
#include <process.h>
#include <direct.h>
#ifndef mkdir
#define mkdir(n,p) mkdir(n)
#endif // mkdir
#else
#include <unistd.h>
#include <sys/ioctl.h>
#endif // _WIN32

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

//#include "package_info.h"
#include "stage1.h"
//#include "servinstlib.h"


/***********************************************************************
 * Defines
 */
#ifdef _WIN32
#define PATH_SEP "\\"
#else
#define PATH_SEP "/"
#endif

#ifndef SECOND_STAGE_PROG
#define SECOND_STAGE_PROG "Bin" PATH_SEP "setup"
#endif

#ifndef TMP_EXTRACT_PROG
#define TMP_EXTRACT_PROG "xxextract.tmp"
#endif

/***********************************************************************
 * Globals
 */
char* g_szProg=0;

Stage1* Stage1::g_pStage1 = NULL;

Stage1::Stage1() : 
    m_ulInstFlags(0),
    m_szArchiveType("bz2"),
    m_ulArchiveSize(0),    
    m_szPassword(NULL)
{
    memset(m_szUserPass, 0, MAX_PASS);

    g_pStage1 = this;
}

Stage1::~Stage1()
{
}

/************************************************************************
 * Stage1::ParseCmdLine - Parse the command-line options
 *
 * We pass our command-line options to the second-stage installer,
 * so most of them will be parsed by it.  We just grab -h and -v
 * here so we don't have to extract the archive before handling them.
 */
BOOL
Stage1::ParseCmdLine(int argc, char* argv[])
{
    int i = 0;    
    BOOL bExit = FALSE;

    // First, scan all args for -v or -h; if there we want to exit now...
    for (i = 1; i < argc && !bExit; i++)
    {
        if (strcmp(argv[i], "--version") == 0 ||
            strcmp(argv[i], "-v") == 0)
        {
            PrintVersion();
            bExit = TRUE;
        }
        if (strcmp(argv[i], "--help") == 0||
            strcmp(argv[i], "-h") == 0 ||
            strcmp(argv[i], "-?") == 0 ||
            strcmp(argv[i], "/?") == 0)
        {
            PrintUsage();
            bExit = TRUE;
        }
    }

    for(i = 1; i < argc && !bExit; i++)
    {
        if(strcmp(argv[i], "--silent") == 0 || 
            strcmp(argv[i], "-s") == 0 ||
            strcmp(argv[i], "/s") == 0)
        {
            m_ulInstFlags |= INST_SILENT | INST_NON_INTERACTIVE;
        }
        else if (strcmp(argv[i], "--progress-only") == 0 ||
                 strcmp(argv[i], "-p") == 0)
        {
            m_ulInstFlags |= INST_NON_INTERACTIVE;
        }
        else if(strcmp(argv[i], "--password") == 0)
        {
           if(++i < argc)
           {
               strncpy(m_szUserPass, argv[i], MAX_PASS-1);
           }
        }
    }

    // any other args will be parsed by the second-stage installer
    // so ignore them

    return bExit;
}

