#ifndef IMIPSCHEDULER_H
#define IMIPSCHEDULER_H
// $Id: imipscheduler.h,v 1.1 2001/04/18 23:28:58 cschumac Exp $
//
// iMIP implementation of iTIP methods
//

#include <qlist.h>

#include "scheduler.h"

namespace KCal {

/*
  This class implements the iTIP interface using the email interface specified
  as iMIP.
*/
class IMIPScheduler : public Scheduler {
  public:
    IMIPScheduler(Calendar *);
    virtual ~IMIPScheduler();
    
    bool publish (Event *incidence,const QString &recipients);
    bool performTransaction(Event *incidence,Method method);
    QList<ScheduleMessage> retrieveTransactions();
};

}

#endif  // IMIPSCHEDULER_H

