/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.
                  Let a thousand taggers bloom!

   Copyright (C) Robert Kaye 2003

   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: lookup.h,v 1.7 2003/07/31 23:20:01 dave Exp $

----------------------------------------------------------------------------*/
#ifndef __LOOKUP_H__
#define __LOOKUP_H__

#include "thread.h"
#include "semaphore.h"
#include "trm.h"
#include "track.h"

class TunePimp;
class FileCache;
class SubmitInfo;

class LookupThread : public Thread
{
    public:

                 LookupThread(TunePimp     *tunePimp,
                              FileCache    *cache,
                              SubmitInfo   *submit);
        virtual ~LookupThread(void);

        void     wake(void);
        void     threadMain(void);
        void     setAutoFileLookup(bool enable);
        bool     getAutoFileLookup(void);

    private:

        void      lookup(Track *track);

        TunePimp       *tunePimp;
        FileCache      *cache;
        bool            exitThread, autoFileLookup;
        Semaphore      *sem;
        SubmitInfo     *submitInfo;
};

#endif

