/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.request;

import itunes.FieldPair;
import java.util.ArrayList;
import org.cdavies.itunes.Itunes4Track;
import org.cdavies.itunes.Track;
import org.cdavies.itunes.request.LegacyDatabaseRequest;
import org.cdavies.itunes.request.NoServerPermissionException;
import org.cdavies.itunes.request.Request;
import org.cdavies.itunes.request.TracklistRequest;

public class LegacyTracklistRequest
extends LegacyDatabaseRequest
implements TracklistRequest {
    private Track[] _tracks;
    private int _dbId;

    public LegacyTracklistRequest(String string, int n, int n2, int n3) {
        super(string, n, n2);
        this.requestString = "databases/" + n3 + "/items?session-id=" + n2 + "&meta=dmap.itemid,dmap.itemname,daap.songalbum,daap.songartist,daap.songtracknumber,daap.songuserrating,daap.songgenre,daap.songformat,daap.songtime";
        this._dbId = n3;
    }

    public void process() throws NoServerPermissionException {
        if (this.data.length == 0) {
            return;
        }
        this.dataType = this.dataString(4);
        this.offset += 4;
        int n = this.dataInt();
        this.offset += 4;
        this.fieldPairs = this.processDataFields();
        this.parseMLCL();
        this._tracks = new Track[this.mlitDataFields.size()];
        for (int i = 0; i < this.mlitDataFields.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.mlitDataFields.get(i);
            Itunes4Track itunes4Track = new Itunes4Track();
            for (int j = 0; j < arrayList.size(); ++j) {
                FieldPair fieldPair = (FieldPair)arrayList.get(j);
                if (fieldPair.name.equals("miid")) {
                    itunes4Track.setTrackId(Request.readInt(fieldPair.value, 0, 4));
                    continue;
                }
                if (fieldPair.name.equals("minm")) {
                    itunes4Track.setTrackName(Request.readString(fieldPair.value, 0, fieldPair.value.length));
                    continue;
                }
                if (fieldPair.name.equals("asal")) {
                    itunes4Track.setAlbumName(Request.readString(fieldPair.value, 0, fieldPair.value.length));
                    continue;
                }
                if (fieldPair.name.equals("asar")) {
                    itunes4Track.setArtistName(Request.readString(fieldPair.value, 0, fieldPair.value.length));
                    continue;
                }
                if (fieldPair.name.equals("astn")) {
                    itunes4Track.setTrackNumber(Request.readInt(fieldPair.value, 0, 2));
                    continue;
                }
                if (fieldPair.name.equals("asgn")) {
                    itunes4Track.setGenre(Request.readString(fieldPair.value, 0, fieldPair.value.length));
                    continue;
                }
                if (fieldPair.name.equals("asur")) {
                    itunes4Track.setRating(Request.readInt(fieldPair.value, 0, 1));
                    continue;
                }
                if (fieldPair.name.equals("asfm")) {
                    itunes4Track.setFormat(Request.readString(fieldPair.value, 0, fieldPair.value.length));
                    continue;
                }
                if (!fieldPair.name.equals("astm")) continue;
                itunes4Track.setLength(Request.readInt(fieldPair.value, 0, 4));
            }
            itunes4Track.setDatabaseId(this._dbId);
            this._tracks[i] = itunes4Track;
        }
    }

    public Track[] getTracklist() {
        return this._tracks;
    }
}

