/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import com.sun.resolver.Catalog;
import com.sun.resolver.tools.ResolvingXMLReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidate
extends MatchingTask {
    protected File baseDir = null;
    protected ValidatorErrorHandler errorHandler = null;
    protected File catalogFile = null;
    protected boolean warnings = false;

    public void setBasedir(File file) {
        if (file.isDirectory()) {
            this.baseDir = file;
        }
    }

    public void setCatalog(File file) {
        this.catalogFile = file;
    }

    public void setWarnings(boolean bl) {
        this.warnings = bl;
    }

    public void execute() throws BuildException {
        File file = null;
        try {
            ResolvingXMLReader resolvingXMLReader = new ResolvingXMLReader();
            Catalog catalog = resolvingXMLReader.getCatalog();
            this.errorHandler = new ValidatorErrorHandler(this.warnings);
            if (this.catalogFile != null) {
                catalog.parseCatalog(this.catalogFile.getAbsolutePath());
            }
            if (this.baseDir == null) {
                this.baseDir = this.getProject().getBaseDir();
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.log(new Integer(stringArray.length).toString() + " file(s) to validate/parse");
            int n = 0;
            while (n < stringArray.length) {
                file = new File(this.baseDir, stringArray[n]);
                if (!(file.canRead() && file.exists() && file.isFile())) {
                    throw new BuildException("Couldn't read file " + file);
                }
                InputSource inputSource = new InputSource(new FileReader(file));
                this.errorHandler.init(file.getPath());
                resolvingXMLReader.setErrorHandler((ErrorHandler)this.errorHandler);
                resolvingXMLReader.parse(inputSource);
                this.log(file + " file have been successfully validated.");
                ++n;
            }
        }
        catch (SAXException sAXException) {
            if (file != null) {
                throw new BuildException(sAXException.getMessage() + ": Can't parse " + file.getPath());
            }
            throw new BuildException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected class ValidatorErrorHandler
    extends DefaultHandler {
        String fileName = null;
        private boolean warn = true;

        public ValidatorErrorHandler(boolean bl) {
            this.warn = bl;
        }

        public void init(String string) {
            this.fileName = string;
        }

        public void fatalError(SAXParseException sAXParseException) {
            XMLValidate.this.log("[FatalError] " + this.fileName + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            XMLValidate.this.log("[Error] " + this.fileName + ": " + sAXParseException.getMessage());
        }

        public void warning(SAXParseException sAXParseException) {
            if (this.warn) {
                XMLValidate.this.log("[Warning] " + this.fileName + ": " + sAXParseException.getMessage());
            }
        }
    }
}

