/*************************************************************************
 *
 *  $RCSfile: IntegerArray.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.util.Arrays;

public final class IntegerArray {
    private static final int InitialSize = 128;
    private int[] _array;
    private int _size;
    private int _free = 0;
  
    public IntegerArray() {
		this(InitialSize);
    }
  
    public IntegerArray(int size) {
		_array = new int[_size = size];
    }

    public IntegerArray(int[] array) {
		this(array.length);
		System.arraycopy(array, 0, _array, 0, _free = _size);
    }

    public void clear() {
		_free = 0;
    }

    public int[] toIntArray() {
		int[] result = new int[cardinality()];
		System.arraycopy(_array, 0, result, 0, cardinality());
		return result;
    }

    public final int at(int index) {
		return _array[index];
    }

    public final void set(int index, int value) {
		_array[index] = value;
    }

    public int indexOf(int n) {
		for (int i = 0; i < _free; i++)
			if (n == _array[i])
				return i;
		return -1;
    }

    public final void add(int value) {
		if (_free == _size)
			growArray(_size * 2);
		_array[_free++] = value;
    }
  
    /** adds new int at the end if not already present */
    public void addNew(int value) {
		for (int i = 0; i < _free; i++)
			if (_array[i] == value)	// already in array
				return;
		add(value);
    }

    private void growArray(int size) {
		int[] newArray = new int[_size = size];
		System.arraycopy(_array, 0, newArray, 0, _free);
		_array = newArray;
    }

    public int popLast() {
		return _array[--_free];
    }

    public int last() {
		return _array[_free - 1];
    }

    public void pop() {
		_free--;
    }

    public void pop(int n) {
		_free -= n;
    }
  
    public final int cardinality() {
		return _free;
    }

    public void sort() {		// ascending order
		Arrays.sort(_array, 0, _free);
    }
  
    public void toDifferences(IntegerArray result) {
		if (result._size < _size)
			result.growArray(_size);
		if ((result._free = _free) > 0) {
			result._array[0] = _array[0];
			for (int i = 1; i < _free; i++)
				result._array[i] = _array[i] - _array[i - 1];
		}
    }
  
    public int binarySearch(int value) {
		int i = 0, j = _free, k;
		while (i <= j)
			if (_array[k = (i + j)/2] < value)
				i = k + 1;
			else if (value < _array[k])
				j = k - 1;
			else
				return k;
		return -1;
    }
  
    public void print(java.io.PrintStream out) {
		if (_free > 0) {
			for (int i = 0; i < _free - 1; i++) {
				out.print(_array[i]);
				out.print(' ');
			}
			out.println(_array[_free - 1]);
		}
		else
			out.println("IntegerArray: empty");
    }
}
