/*************************************************************************
 *
 *  $RCSfile: c2uno.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dbo $ $Date: 2001/04/20 13:38:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _UNO_DATA_H_
#include <uno/data.h>
#endif
#ifndef _UNO_ANY2_H_
#include <uno/any2.h>
#endif

#include "c_bridge.hxx"


namespace c_uno
{

//==================================================================================================
static cuno_ErrorCode c2uno_call(
	cInterfaceProxy * pThis,
	const typelib_TypeDescription * pMemberTypeDescr,
	typelib_TypeDescriptionReference * pReturnTypeRef, // 0 indicates void return
	sal_Int32 nParams, typelib_MethodParameter * pParams,
	// pCallStack: this, exc, [ret *], params
	void ** pCallStack )
{
	void * pUnoRet;
	char * pStack;
	
	// return
	typelib_TypeDescription * pReturnTypeDescr = 0;
	if (pReturnTypeRef && pReturnTypeRef->eTypeClass != typelib_TypeClass_VOID)
	{
		if (pReturnTypeRef->eTypeClass <= typelib_TypeClass_ENUM &&
			pReturnTypeRef->eTypeClass != typelib_TypeClass_ANY)
		{
			pUnoRet = pCallStack[ 2 ];
		}
		else
		{
			TYPELIB_DANGER_GET( &pReturnTypeDescr, pReturnTypeRef );
			pUnoRet = alloca( pReturnTypeDescr->nSize );
		}
		pStack = (char *)&pCallStack[ 3 ];
	}
	else
	{
		pStack = (char *)&pCallStack[ 2 ];
		pUnoRet = 0;
	}
	
	OSL_ENSURE( (sizeof(void *) == 4) && (sizeof (long) == 4) &&
				(sizeof (double) == 8) && (sizeof (sal_Int64) == 8),
				"### unexpected type sizes!" );
	
	// parameters
	void ** pUnoArgs = (void **)alloca( 4 * sizeof (void *) * nParams );
	void ** pCArgs = (void **)(pUnoArgs + nParams);
	// indizes of values which have to be reconverted (interface conversion c<=>uno)
	sal_Int32 * pTempIndizes = (sal_Int32 *)(pUnoArgs + (2* nParams));
	// type descriptions for reconversions
	typelib_TypeDescription ** ppTempParamTypeDescr = (typelib_TypeDescription **)(pUnoArgs + (3 * nParams));
	sal_Int32 nTempIndizes = 0;
	
	for ( sal_Int32 nPos = 0; nPos < nParams; ++nPos )
	{
		typelib_MethodParameter const & rParam = pParams[ nPos ];
		typelib_TypeClass tc = rParam.pTypeRef->eTypeClass;
		
		if (rParam.bOut) // inout/out, only pointers
		{
			if (tc != typelib_TypeClass_ANY && tc <= typelib_TypeClass_ENUM)
			{
				pUnoArgs[ nPos ] = *(void **)pStack;
			}
			else
			{
				// convert to uno
				typelib_TypeDescription * pParamTypeDescr = 0;
				TYPELIB_DANGER_GET( &pParamTypeDescr, rParam.pTypeRef );
				OSL_ASSERT( pParamTypeDescr && pParamTypeDescr->eTypeClass == tc );
				pUnoArgs[ nPos ] = alloca( pParamTypeDescr->nSize );
				pCArgs[ nPos ] = *(void **)pStack;
				
				if (rParam.bIn)
				{
					::uno_copyAndConvertData(
						pUnoArgs[ nPos ], pCArgs[ nPos ],
						pParamTypeDescr, &pThis->pBridge->aC2Uno );
				}
				
				ppTempParamTypeDescr[ nTempIndizes ] = pParamTypeDescr;
				pTempIndizes[ nTempIndizes ] = nPos;
				++nTempIndizes;
			}
		}
		else // pure in
		{
			if (tc > typelib_TypeClass_ENUM || tc == typelib_TypeClass_ANY)
			{
				// convert to uno
				typelib_TypeDescription * pParamTypeDescr = 0;
				TYPELIB_DANGER_GET( &pParamTypeDescr, rParam.pTypeRef );
				OSL_ASSERT( pParamTypeDescr && pParamTypeDescr->eTypeClass == tc );
				pUnoArgs[ nPos ] = alloca( pParamTypeDescr->nSize );
				
				if (tc == typelib_TypeClass_INTERFACE || tc == typelib_TypeClass_SEQUENCE)
				{
					pCArgs[ nPos ] = pStack;
				}
				else
				{
					pCArgs[ nPos ] = *(void **)pStack;
				}
				
				::uno_copyAndConvertData(
					pUnoArgs[ nPos ], pCArgs[ nPos ],
					pParamTypeDescr, &pThis->pBridge->aC2Uno );
				
				ppTempParamTypeDescr[ nTempIndizes ] = pParamTypeDescr;
				pTempIndizes[ nTempIndizes ] = nPos;
				++nTempIndizes;
			}
			else
			{
				switch (tc)
				{
// xxx todo: for big endian machines
//  				case typelib_TypeClass_BOOLEAN:
//  				case typelib_TypeClass_BYTE:
//  					pUnoArgs[ nPos ] += pStack +3;
//  					break;
//  				case typelib_TypeClass_CHAR:
//  				case typelib_TypeClass_SHORT:
//  				case typelib_TypeClass_UNSIGNED_SHORT:
//  					pUnoArgs[ nPos ] = pStack +2;
//  					break;
				case typelib_TypeClass_HYPER:
				case typelib_TypeClass_UNSIGNED_HYPER:
				case typelib_TypeClass_DOUBLE:
					pUnoArgs[ nPos ] = pStack;
					pStack += 4; // extra long
					break;
				default:
					pUnoArgs[ nPos ] = pStack;
				}
			}
		}
		
		pStack += 4;
	}
	
	uno_Any aUnoExc; // any will be constructed by callee
	uno_Any * pUnoExc = &aUnoExc;
	
	// invoke uno dispatch call
	(*pThis->pUnoI->pDispatcher)( pThis->pUnoI, pMemberTypeDescr, pUnoRet, pUnoArgs, &pUnoExc );
	
	if (pUnoExc) // exception occured
	{
		// destruct temporary in/inout params
		while (nTempIndizes--)
		{
			sal_Int32 nIndex = pTempIndizes[ nTempIndizes ];
			typelib_TypeDescription * pParamTypeDescr = ppTempParamTypeDescr[ nTempIndizes ];
			
			if (pParams[ nIndex ].bIn) // is in/inout => was converted
			{
				::uno_destructData( pUnoArgs[ nIndex ], pParamTypeDescr, 0 );
			}
			
			TYPELIB_DANGER_RELEASE( pParamTypeDescr );
		}
		
		if (pReturnTypeDescr)
		{
			TYPELIB_DANGER_RELEASE( pReturnTypeDescr );
		}
		
		// signal exception
		::uno_type_any_constructAndConvert(
			(uno_Any *)pCallStack[ 1 ], pUnoExc->pData,
			pUnoExc->pType, &pThis->pBridge->aUno2C );
		::uno_any_destruct( pUnoExc, 0 );
		
		return CUNO_ERROR_EXCEPTION;
	}
	else // no exception
	{
		// temporary in/inout params
		while (nTempIndizes--)
		{
			sal_Int32 nIndex = pTempIndizes[ nTempIndizes ];
			typelib_TypeDescription * pParamTypeDescr = ppTempParamTypeDescr[ nTempIndizes ];

			if (pParams[ nIndex ].bIn) // in in/inout
			{
				if (pParams[ nIndex ].bOut) // inout
				{
					::uno_destructData( pCArgs[ nIndex ], pParamTypeDescr, c_release );
					// write back
					::uno_copyAndConvertData(
						pCArgs[ nIndex ], pUnoArgs[ nIndex ], pParamTypeDescr,
						&pThis->pBridge->aUno2C );
				}
			}
			else // pure out
			{
				// write back
				::uno_copyAndConvertData(
					pCArgs[ nIndex ], pUnoArgs[ nIndex ], pParamTypeDescr,
					&pThis->pBridge->aUno2C );
			}
			// destroy temp uno param
			::uno_destructData( pUnoArgs[ nIndex ], pParamTypeDescr, 0 );
			
			TYPELIB_DANGER_RELEASE( pParamTypeDescr );
		}
		
		// return
		if (pReturnTypeDescr)
		{
			::uno_copyAndConvertData( pCallStack[ 2 ], pUnoRet, pReturnTypeDescr, &pThis->pBridge->aUno2C );
			// destroy temp uno return
			::uno_destructData( pUnoRet, pReturnTypeDescr, 0 );
			TYPELIB_DANGER_RELEASE( pReturnTypeDescr );
		}
		
		return CUNO_ERROR_NONE;
	}
}

//==================================================================================================
extern "C" cuno_ErrorCode SAL_CALL proxy_ftable_call(
	sal_Int32 nFtableCall, void ** pCallStack ) SAL_THROW_EXTERN_C()
{
	++pCallStack; // skip ret adr
	OSL_ENSURE( sizeof (sal_Int32) == sizeof (void *), "### unexpected type size!" );
	
	// pCallStack: ret, this, exc, [ret *], params
	cInterfaceProxy * pThis = reinterpret_cast< cInterfaceProxy * >( *pCallStack );
	
	typelib_InterfaceTypeDescription * pTypeDescr = pThis->pTypeDescr;
	OSL_ENSURE( nFtableCall < pTypeDescr->nMapFunctionIndexToMemberIndex, "### illegal ftable index!" );
	// xxx todo: throw RuntimeException
//  	if (nFtableCall >= pTypeDescr->nMapFunctionIndexToMemberIndex)
//  	{
//  		::com::sun::star::uno::RuntimeException aExc(
//  			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("illegal method index!") ),
//  			::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >() );
		
//  		Type const & rExcType = ::getCppuType( &aExc );
//  		// null reference binary identical
//  		::uno_type_any_construct( (uno_Any *)pCallStack[ 1 ], &aExc, rExcType.getTypeLibType(), 0 );
//  		return CUNO_EXCEPTION;
//  	}
	
	// determine called method
	sal_Int32 nMemberPos = pTypeDescr->pMapFunctionIndexToMemberIndex[ nFtableCall ];
	OSL_ENSURE( nMemberPos < pTypeDescr->nAllMembers, "### illegal member index!" );
	
	typelib_TypeDescription * pMemberTypeDescr = 0;
	TYPELIB_DANGER_GET( &pMemberTypeDescr, pTypeDescr->ppAllMembers[ nMemberPos ] );
	
	cuno_ErrorCode ret;
	
	switch (pMemberTypeDescr->eTypeClass)
	{
	case typelib_TypeClass_INTERFACE_ATTRIBUTE:
	{
		if (pTypeDescr->pMapMemberIndexToFunctionIndex[nMemberPos] == nFtableCall)
		{
			// is GET method
			ret = c2uno_call(
				pThis, pMemberTypeDescr,
				((typelib_InterfaceAttributeTypeDescription *)pMemberTypeDescr)->pAttributeTypeRef,
				0, 0, // no params
				pCallStack );
		}
		else
		{
			// is SET method
			typelib_MethodParameter aParam;
			aParam.pTypeRef = ((typelib_InterfaceAttributeTypeDescription *)pMemberTypeDescr)->pAttributeTypeRef;
			aParam.bIn = sal_True;
			aParam.bOut = sal_False;
			
			ret = c2uno_call(
				pThis, pMemberTypeDescr,
				0, // indicates void return
				1, &aParam,
				pCallStack );
		}
		break;
	}
	case typelib_TypeClass_INTERFACE_METHOD:
	{
		// is METHOD
		switch (nFtableCall) // standard XInterface ftable calls
		{
		case 0: // queryInterface() opt
		{
			typelib_TypeDescription * pTD = 0;
			TYPELIB_DANGER_GET( &pTD, reinterpret_cast< typelib_TypeDescriptionReference * >( pCallStack[ 3 ] ) );
			OSL_ASSERT( pTD );
			
			*(void **)pCallStack[ 2 ] = 0;
			(*pThis->pBridge->pCEnv->getRegisteredInterface)(
				pThis->pBridge->pCEnv, (void **)pCallStack[ 2 ],
				pThis->oid.pData, (typelib_InterfaceTypeDescription *)pTD );
			
			TYPELIB_DANGER_RELEASE( pTD );
			
			if (*(void **)pCallStack[ 2 ])
			{
				ret = CUNO_ERROR_NONE;
			}
			else // perform queryInterface() call
			{
				uno_Any aUnoExc;
				uno_Any * pUnoExc = &aUnoExc;
				uno_Any aUnoRet;
				void * pUnoArgs[ 1 ];
				pUnoArgs[ 0 ] = &pCallStack[ 3 ];
				
				(*pThis->pUnoI->pDispatcher)(
					pThis->pUnoI, pMemberTypeDescr, &aUnoRet, pUnoArgs, &pUnoExc );
				
				if (pUnoExc)
				{
					// signal exception
					::uno_type_any_constructAndConvert(
						(uno_Any *)pCallStack[ 1 ], pUnoExc->pData,
						pUnoExc->pType, &pThis->pBridge->aUno2C );
					::uno_any_destruct( pUnoExc, 0 );
					
					ret = CUNO_ERROR_EXCEPTION;
				}
				else
				{
					if (typelib_TypeClass_INTERFACE == aUnoRet.pType->eTypeClass)
					{
						::uno_type_copyAndConvertData(
							pCallStack[ 2 ], aUnoRet.pData, aUnoRet.pType, &pThis->pBridge->aUno2C );
					}
					else
					{
						*(void **)pCallStack[ 2 ] = 0;
					}
					::uno_any_destruct( &aUnoRet, 0 );
					ret = CUNO_ERROR_NONE;
				}
			}
			break;
		}
		case 1: // acquire()
			pThis->acquireProxy();
			ret = CUNO_ERROR_NONE;
			break;
		case 2: // release()
			pThis->releaseProxy();
			ret = CUNO_ERROR_NONE;
			break;
		default:
			ret = c2uno_call(
				pThis, pMemberTypeDescr,
				((typelib_InterfaceMethodTypeDescription *)pMemberTypeDescr)->pReturnTypeRef,
				((typelib_InterfaceMethodTypeDescription *)pMemberTypeDescr)->nParams,
				((typelib_InterfaceMethodTypeDescription *)pMemberTypeDescr)->pParams,
				pCallStack );
			break;
		}
	}
	// xxx todo: throw RuntimeException
//  	default:
//  	{
//  		::com::sun::star::uno::RuntimeException aExc(
//  			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("illegal member type description!") ),
//  			::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >() );
		
//  		Type const & rExcType = ::getCppuType( &aExc );
//  		// null reference binary identical
//  		::uno_type_any_construct( (uno_Any *)pCallStack[ 1 ], &aExc, rExcType.getTypeLibType(), 0 );
//  		ret = CUNO_EXCEPTION;
//  	}
	}
	
	TYPELIB_DANGER_RELEASE( pMemberTypeDescr );
	return ret;
}

}
