/*************************************************************************
 *
 *  $RCSfile: sdaemon.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "system.h"

#ifndef _OSL_THREAD_H_
#   include <osl/thread.h>
#endif
#ifndef _OSL_DAEMON_H_
#   include <osl/daemon.h>
#endif

#include "../all/daemprot.h"
#include "../all/daemman.h"
#include "../all/daemreg.h"

int PASCAL WinMain(HINSTANCE hinstCurrent, HINSTANCE hinstPrevious,
    LPSTR lpszCmdLine, int nCmdShow)
{
#ifdef test

	if ((argc == 2) && (strcmp(argv[1], "-shutdown") == 0))
	{
		if (osl_shutdownDaemonManager())
			fprintf(stderr, "shutdown request send to daemon manager\n");
		else
			fprintf(stderr, "daemon manager is not running\n");
	}
	else
	{
		oslDaemonConnection rootConn = NULL;
		oslDaemonConnection childConn = NULL;

		DaemonRegistryApi* pRegApi = osl_openDefaultRegistry();

		oslDaemonManagerStartupError startupError = osl_initDaemonManager(pRegApi);

		switch (startupError)
		{
			case osl_oslDaemonManagerStartupError_NoError:
				break;
			case osl_oslDaemonManagerStartupError_AllreadyStarted:
				fprintf(stderr, "daemon manager allready running\n");
				break;
			case osl_oslDaemonManagerStartupError_CouldNotReadProfile:
				fprintf(stderr, "could not read profile\n");
				break;
			default:
				fprintf(stderr, "unknown error occured\n");
				break;
		}

		if (startupError != osl_oslDaemonManagerStartupError_NoError)
		{
			return(-1);
		}
			
		rootConn = osl_openDaemonMgrConn(OSL_DAEMON_MANAGER_PIPE, osl_DaemonConnection_CREATE);

		if (rootConn == NULL)
		{
			osl_deinitDaemonManager();
			fprintf(stderr, "unknown error occured\n");
			return(-1);
		}
		else
		{
			osl_startupAutomaticDaemons();

			/* wait for connections */
			do
			{
				childConn = osl_acceptOnDaemonMgrConn(rootConn);

				if (childConn != NULL)
					osl_handleConnection(childConn);
			} 
			while (childConn != NULL);
		}

		osl_deinitDaemonManager();
		osl_closeDefaultRegistry();
	}

#endif

	return(-1);
}

