/*************************************************************************
 *
 *  $RCSfile: w16int64.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __W16INT64_HXX__
#include <sal/w16int64.hxx>
#endif

static void hex8(const unsigned __int8 x, char *c) /*fold02*/
{
    char *hexTab = "0123456789ABCDEF";
    c[0] = hexTab[x >> 4];
    c[1] = hexTab[x & 0x0F];
}

static void hex16(const __int16 x, char *c) /*fold02*/
{
    hex8(x >> 8, c);
    hex8(x & 0x00FF, c+2);
}

static void hex32(const unsigned long x, char *c) /*fold02*/
{
    hex16(x >> 16, c);
    hex16(x & 0x0000FFFFUL, c+4);
}

extern "C" /*FOLD00*/
{
void int64_shl64(__int64 &x, int y) /*fold02*/
{
    for (int i = y; i > 0; i--)
    {
        x.hi <<= 1;
        if (x.lo > 0x7FFFFFFFUL) x.hi++;
        x.lo <<= 1;
    }
}

void int64_shr64(__int64 &x, int y) /*fold02*/
{
    for (int i = y; i > 0; i--)
    {
        x.lo >>= 1;
        if (x.hi & 0x00000001UL) x.lo |= 0x80000000UL;
        x.hi >>= 1;
    }
}

bool int64_geq64(const __int64 &x, const __int64 &y) /*fold02*/
{
    bool bYisNeg = y.isNeg64();
    if (x.isNeg64()) { if (!bYisNeg) return false; }
    else if (bYisNeg) return true;
    if (x.hi > y.hi) return true;
    if (x.hi < y.hi) return false;
    return (x.lo >= y.lo);
}

bool int64_leq64(const __int64 &x, const __int64 &y) /*fold02*/
{
    bool bYisNeg = y.isNeg64();
    if (x.isNeg64()) { if (!bYisNeg) return true; }
    else if (bYisNeg) return false;
    if (x.hi > y.hi) return false;
    if (x.hi < y.hi) return true;
    return (x.lo <= y.lo);
}

bool int64_geq32(const __int64 &x, signed long y) /*fold02*/
{
    bool bYisNeg = (y < 0);
    if (x.isNeg64())
    {
        if ((!bYisNeg) || (x.hi != 0xFFFFFFFFUL)) return false;
    }
    else if ((bYisNeg) || (x.hi != 0)) return true;
    return (x.lo >= ((unsigned long) y));
}

bool int64_leq32(const __int64 &x, signed long y) /*fold02*/
{
    bool bYisNeg = (y < 0);
    if (x.isNeg64())
    {
        if ((!bYisNeg) || (x.hi != 0xFFFFFFFFUL)) return true;
    }
    else if ((bYisNeg) || (x.hi != 0)) return false;
    return (x.lo <= ((unsigned long) y));
}

typedef struct
{
    unsigned __int16 lo;
    unsigned __int16 hi;
} __int32_;


typedef struct
{
    unsigned int pad0;
    unsigned long mid;
    unsigned int pad1;
} __int64_;


void int64_mul32(__int64 &x, unsigned long a, unsigned long b) /*fold02*/
{
    __int64 y;
    x.clr64();
    y.clr64();
    ((__int64_ *) &x)->mid = ((unsigned long) ((__int32_ *) &a)->hi) * ((__int32_ *) &b)->lo;
    ((__int64_ *) &y)->mid = ((unsigned long) ((__int32_ *) &a)->lo) * ((__int32_ *) &b)->hi;
    x.add64(y);
    y.clr64();
    y.hi = ((unsigned long) ((__int32_ *) &a)->hi) * ((__int32_ *) &b)->hi;
    y.lo = ((unsigned long) ((__int32_ *) &a)->lo) * ((__int32_ *) &b)->lo;
    x.add64(y);
}

void int64_mul64(__int64 &x, const __int64 &y) /*fold02*/
{
    bool bNegResult = false;
    __int64 _x, _y;
    _x = x;
    _y = y;
    if (_x.isNeg64())
    {
        bNegResult = true;
        _x.neg64();
    }
    if (_y.isNeg64())
    {
        bNegResult = ~bNegResult;
        _y.neg64();
    }

    __int64 z[3];
    int64_mul32(z[0], _x.hi, _y.hi);
    int64_mul32(z[1], _x.hi, _y.lo);
    int64_mul32(z[2], _x.lo, _y.hi);
    int64_mul32(x,    _x.lo, _y.lo);
    // overflow if (z[0] != 0) || (z[1].hi != 0) || (z[2].hi != 0)
    x.hi += z[1].lo; // no overflow-check
    x.hi += z[2].lo; // no overflow-check

    if (bNegResult) x.neg64();
}

void int64_mod64(const __int64 &p, const __int64 &q, __int64 &Quotient, __int64 &Remainder) /*fold02*/
{
    unsigned long nMask;
    __int64 tempDividend = p;
    __int64 tempDivisor = q;

    bool bNegativResult = false;

    if (tempDividend.isNeg64())
    {
        bNegativResult = true;
        tempDividend.neg64();
    }
    if (tempDivisor.isNeg64())
    {
        bNegativResult = ~bNegativResult;
        tempDivisor.neg64();
    }

    //Handle the special case's
    if (tempDivisor.isZero64())
    {
        //force a Divide by Zero exception
        tempDivisor.lo /= tempDivisor.hi;
    }
    else
    {
        Quotient.clr64();
        Remainder.clr64();
        if (!tempDividend.isZero64())
        {
            int i;
            nMask = 0x80000000UL;
            for (i = 0; (i < 32); i++)
            {
                if (tempDividend.hi & nMask) Remainder++;
                if (Remainder >= tempDivisor)
                {
                    Quotient.hi |= nMask;
                    Remainder -= tempDivisor;
                }
                else Quotient.hi &= ~nMask;
                if (!Remainder.isZero64()) Remainder <<= 1;
                nMask >>= 1;
            }

            nMask = 0x80000000UL;
            for (; (i < 64); i++)
            {
                if (tempDividend.lo & nMask) Remainder++;
                if (Remainder >= tempDivisor)
                {
                    Quotient.lo |= nMask;
                    Remainder -= tempDivisor;
                }
                else Quotient.lo &= ~nMask;
                if ((i != 63) && !Remainder.isZero64()) Remainder <<= 1;
                nMask >>= 1;
            }

            if (bNegativResult) Quotient.neg64();
        }
    }
}

void int64_val64(__int64 &x, const char *y) /*fold02*/
{
    bool bNeg;
    int i = 0;
    x.clr64();

    if (y[i] == '-')
    {
        i++;
        bNeg = true;
    }
    else bNeg = false;

    if ((y[i] == '0') && (y[i+1] == 'x'))
    { // base16
        i += 2;
        __int64 _x = 16, _y;
        char d = y[i];
        while (((d >= '0') && (d <= '9')) ||
               ((d >= 'A') && (d <= 'F')) ||
               ((d >= 'a') && (d <= 'f')))
        {
            if      ((d >= '0') && (d <= '9'))  _y = d - '0';
            else if ((d >= 'A') && (d <= 'F'))  _y = d - 'A' + 10;
            else                                _y = d - 'a' + 10;
            int64_mul64(x, _x);
            x.add64(_y);
            i++;
            d = y[i];
        }
    }
    else
    { // base10
        __int64 _x = 10, _y;
        while ((y[i] >= '0') && (y[i] <= '9'))
        {
            int64_mul64(x, _x);
            _y = y[i];
            x.add64(_y);
            i++;
        }
    }
    if (bNeg) x.neg64();
}

void int64_hex64(__int64 x, char *c) /*fold02*/
{
    hex32(x.hi, c);
    hex32(x.lo, c+8);
}

} /*FOLD00*/

