/*************************************************************************
 *
 *  $RCSfile: action.hxx,v $
 *
 *  $Revision: 1.28.34.1 $
 *
 *  last change: $Author: vg $ $Date: 2003/11/07 10:15:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SETUP_ACTION_HXX
#define SETUP_ACTION_HXX

#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif

#ifndef _VOS_MODULE_HXX_
#include <vos/module.hxx>
#endif

#include <tools/solar.h>

#include "simode.hxx"
#include "actntype.hxx"
#include "decltor.hxx"
#include "sicustom.hxx"

// forward declarations --------------------------------------------------

class SiEnvironment;
class SiAgenda;
class SiLogStream;

using namespace ::vos;

#define LOCAL_FONT_PATH         "\\share\\fonts\\truetype"

// Action ----------------------------------------------------------------
//

class SiAction
{
	SiAgenda   *m_pAgenda;
	SiAction   *m_pDependsOn;  // Abhaengigkeit von einem Target
	BOOL		m_bSucceeded;  // erfolgreich ausgefuehrt
	BOOL        m_bMayExecute; // fuer Recover
	SiActionType m_eType;

	BOOL Succeeded() const;    // z.Zt. nicht in Gebrauch

protected:
	void			WriteLog(ByteString const&);
	SiLogStream&	GetLogfile();
	SiInstallMode	GetInstallMode() const;
	BOOL			DoRecoverOnly() const;
	BOOL			SetSuccess(BOOL b);

	virtual BOOL	CheckTarget(SiEnvironment const&) const;
    sal_Int16       ReplaceMeta( ByteString& rValue, BOOL bDecode );

public:
	SiAction(SiAgenda* pAgenda, SiActionType = AT_UNKNOWN);
	virtual ~SiAction();

	SiAgenda*		GetAgenda()		const { return m_pAgenda; }
	void 			SetDependence(SiAction*);
	BOOL			DoesTargetExist(SiEnvironment const&) const;
	BOOL			MayExecute() const	{ return m_bMayExecute;  }
	void			DoNotExecute()		{ m_bMayExecute = FALSE; }

	SiActionType	GetType()   const { return m_eType; }

	virtual BOOL 	Execute(SiEnvironment&) = 0;
};

class SiUnregisterAction : public SiAction
{
public:
	SiUnregisterAction(SiAgenda* pAgenda)
	: SiAction(pAgenda, AT_UNREGISTER)
	{}
};

// MakeDirAction ---------------------------------------------------------
//

class SiMakeDirAction : public SiAction
{
	ByteString	m_aDirName;
	int		m_nUnixRights;
public:
	SiMakeDirAction(SiAgenda* pAgenda, ByteString const& aDirName, int nRights = 0);

	virtual BOOL CheckTarget(SiEnvironment const& Env) const;
	virtual BOOL Execute(SiEnvironment&);

	ByteString const& GetName() const { return m_aDirName; } // fuer Fehlerausgabe

};

// DeleteDirAction ------------------------------------------------------
//

class SiDeleteDirAction : public SiAction
{
	ByteString	m_aPath;
	BOOL	m_bDeleteAll;
public:
	SiDeleteDirAction(SiAgenda*, ByteString const& aRelPath, BOOL bDeleteAll = FALSE );

	ByteString const& GetName() const { return m_aPath; }
	virtual BOOL Execute(SiEnvironment&);

	// fuer das sortierte PTRARR
	BOOL operator < (const SiDeleteDirAction&);
	BOOL operator == (const SiDeleteDirAction&);
};

// FileTransferAction ----------------------------------------------------
//

class SiTransferAction : public SiAction
{
protected:
	SiDataCarrier const *m_pDataCarrier;
	ByteString			m_aSourcePath;
	ByteString			m_aSourceFile;
	ByteString			m_aDestPath;
	ByteString			m_aDestFile;
	SiFileFlags         m_Flags;

private:
	Date                m_aDate;
	Time                m_aTime;
	int                 m_nUnixRights;
    BOOL                m_bMoveAfterReboot;
    ByteString          m_aMoveDestination;
    ByteString          m_aMoveSource;
	SiOs2Creator const *m_pOs2Creator;

protected:
	void RenameFile		(ByteString const& aFrom, ByteString const& aTo);
	void SetDateTime	(ByteString const& aFile, BOOL bLog = TRUE);
	void SetUnixRights	(ByteString const& aFile, BOOL bLog = TRUE);
	void SetOs2Creator	(ByteString const& aFile, SiEnvironment const& rEnv,
						 BOOL bLog = TRUE);
	void DoMigration	(const ByteString& rFilename, const SiEnvironment& rEnv);
	void Substitute		(const ByteString& rFilename, const SiEnvironment& rEnv);
	void MoveSystemFileAfterReboot( const ByteString& rSource, const ByteString& rDest );
	void TouchVirtual( ByteString& rName );
    BOOL DeregisterFont ( const ByteString& rFilename, const SiDirEntry& rFile );
    BOOL SpecialFontHandling( SiEnvironment& Env, SiFile *pFile );
public:
	SiTransferAction
	(
		SiAgenda* pAgenda,
		SiActionType,
		SiDataCarrier const*,
		ByteString const& aSourcePath,
		ByteString const& aSourceFile,
		ByteString const& aDestPath,
		ByteString const& aDestFile,
		Date   const& aDate,
		Time   const& aTime,
		SiFileFlags,
		int			  nUnixRights,
		SiOs2Creator const* pOs2Creator
	);

	virtual BOOL   CheckTarget(SiEnvironment const&) const;

	int  GetDiskNo() const; // zum Sortieren
	BOOL FromDataCarrier() const { return m_pDataCarrier != NULL; }

	// fuer Fortschrittsanzeige
	ByteString const& GetSourceFile() const { return m_aSourceFile; }
	ByteString const& GetDestFile()   const { return m_aDestFile;	}
	ByteString const& GetDestPath()   const { return m_aDestPath;	}

    // For special font file handling
    BOOL        MoveFileAfterReboot() const { return m_bMoveAfterReboot; }
    ByteString  GetMoveDestination()  const { return m_aMoveDestination; }
    ByteString  GetMoveSource()       const { return m_aMoveSource; }
};

// CopyAction ------------------------------------------------------------
//

class SiCopyAction : public SiTransferAction
{
	SiFile *m_pFile;
public:
	SiCopyAction
	(
		SiAgenda* pAgenda,
		SiDataCarrier const*,
		ByteString const& aSourcePath,
		ByteString const& aSourceFile,
		ByteString const& aDestPath,
		ByteString const& aDestFile,
		Date   const& aDate,
		Time   const& aTime,
		SiFileFlags,
		int			  nUnixRights,
		SiFile*,
		SiOs2Creator const* pOs2Creator
	);

	virtual BOOL Execute(SiEnvironment&);
	SiFile* 	 GetSiFile() const { return m_pFile; }
};

// UnzipAction -----------------------------------------------------------
//

class SiUnzipAction : public SiTransferAction
{
	ByteString  m_aArchiveFile;	// Quelle ist ein Archiv
	SiFile *m_pFile;		// zum Ablegen der Dateiliste

public:
	SiUnzipAction
	(
		SiAgenda*,
		SiDataCarrier const*,
		ByteString const& aArchiveFile,
		ByteString const& aSourcePath,
		ByteString const& aSourceFile,
		ByteString const& aDestPath,
		ByteString const& aDestFile,
		Date   const& aDate,
		Time   const& aTime,
		SiFileFlags,
		int			  nUnixRights,
		SiFile*,						// fuer Archive
		SiOs2Creator const* pOs2Creator
	);

	virtual BOOL CheckTarget(SiEnvironment const&) const;
	virtual BOOL Execute(SiEnvironment&);

	SiFile* 	 GetSiFile() const { return m_pFile; }
};

// DeleteFileAction -------------------------------------------------
//

class SiDeleteFileAction : public SiAction
{
	ByteString	m_aRelPath;
	ByteString	m_aFile;
	SiFile*     m_pFile;

	BOOL	m_bTimeCheck;
	Date	m_aFileDate;
	Time	m_aFileTime;

	BOOL	CheckTimestamp( const SiDirEntry& rFile );
    BOOL    DeleteDirectory( const SiDirEntry& rDir, BOOL bCheckTimestamp );

public:
	SiDeleteFileAction
	(
		SiAgenda* pAgenda,
		SiFile* pFile,
		ByteString const& aRelPath,
		ByteString const& aFile,
		const Date& aFileDate,
		const Time&	aFileTime,
		BOOL bCheckTime = FALSE
	);

	virtual BOOL Execute(SiEnvironment&);
	SiFile* 	 GetSiFile() const { return m_pFile; }
	ByteString	 GetFilename() const { return m_aFile; }
};

// AppendAction -----------------------------------------------------------
//

class SiAppendAction : public SiAction
{
	ByteString    m_aSourcePath; // relativer Pfad
	ByteString    m_aSourceFile; // Name der anzuhaengenden Datei
	ByteString    m_aDestPath;	 // relativer Pfad
	ByteString    m_aDestFile;	 // Name der Zieldatei

	SiFile const* m_pBaseFile; // zum Sortieren, damit die Teile in der
	int       m_nPart;     // richtigen Reihenfolge zusammengesetzt werden
	long	  m_lSize;

public:
	SiAppendAction
	(
		SiAgenda*,
		ByteString const& aSourcePath,
		ByteString const& aSourceFile, // wird angehaengt ...
		ByteString const& aDestPath,
		ByteString const& aDestFile, // wird angehaengt ...
		SiFile const* pBaseFile,
		int           nPart
	);

	virtual BOOL Execute(SiEnvironment&);

	SiFile const* GetBaseFile() const { return m_pBaseFile; }
	int           GetPart()     const { return m_nPart;     }
};

// SiActiveXAction --------------------------------------------------
class SiActiveXAction : public SiAction
{
	SiFile *m_pFile;
	BOOL	m_bRegister;
public:
		SiActiveXAction( SiAgenda* pAgenda, SiFile* pFile, BOOL bRegister);

	virtual BOOL		Execute(SiEnvironment&);
	BOOL 				IsRegister() const { return m_bRegister; }
};

// MakeFolderAction -------------------------------------------------
class SiMakeFolderAction : public SiAction
{
	ByteString   m_aName;       // Titel im Folder

	// OS-2 Felder
	#ifdef OS2
	ByteString   m_anOs2ID;     // <OFFICE_FOLDER>
	BOOL	 m_bOs2NetIcon1;
	ByteString   m_anOs2IconPath1;
	ByteString   m_anOs2Icon1;
	BOOL	 m_bOs2NetIcon2;
	ByteString   m_anOs2IconPath2;
	ByteString   m_anOs2Icon2;
	#endif

public:

	#ifndef OS2

	SiMakeFolderAction
	(
		SiAgenda    * pAgenda,
		ByteString const& aName       // Titel im Folder
	);

	#else

	SiMakeFolderAction
	(
		SiAgenda    * pAgenda,
		ByteString const& aName,      // Titel im Folder
		ByteString const& anOs2ID,    // <OFFICE_FOLDER>
		BOOL		  bOs2NetIcon1,
		ByteString const& anOs2IconPath1,
		ByteString const& anOs2Icon1,
		BOOL		  bOs2NetIcon2,
		ByteString const& anOs2IconPath2,
		ByteString const& anOs2Icon2
	);

	#endif

	virtual BOOL Execute(SiEnvironment&);
};

// DeleteFolderItemAction ------------------------------------------------
//

class SiDeleteFolderAction : public SiUnregisterAction
{
	ByteString   m_aName;       // Titel im Folder
	ByteString   m_anOs2ID;

	SiFolder*	 m_pItem;

public:

	SiDeleteFolderAction
	(
		SiAgenda    * pAgenda,
		ByteString const& aName,       // Titel im Folder
		ByteString const& anOs2ID,
		SiFolder* pItem
	);

	virtual BOOL Execute(SiEnvironment&);
};

// MakeFolderItemAction --------------------------------------------------
//

class SiFolderItem;

class SiMakeFolderItemAction : public SiAction
{
	UniString   m_suFolderName;     // Os2-FolderId: "<STB_FOLDER>"
	ByteString  m_anItemName;       // Titel im Folder
	ByteString  m_aPath;
	ByteString  m_aFileName;
	ByteString  m_aParameter;
    UniString   m_aIconFile;
    sal_Int32   m_nIconIndex;
    BOOL		m_bNetwork;

	SiFolderItem* 	m_pItem;

	// nur fuer OS/2
	#ifdef OS2
	ByteString  m_anOs2ID;      // "<STB_ITEM>",
	ByteString  m_anOs2Class;           // "WPProgram",
	ByteString  m_anOs2Creater;     // "Setup Toolbox",
	ByteString  m_anOs2Filters;
	ByteString  m_anOs2Reference;
	#endif

public:

	SiMakeFolderItemAction
	(
		SiAgenda*     pAgenda,
		UniString const& aFolderName,
		ByteString const& anItemName,
		BOOL		  bNetwork,
		ByteString const& aPath,
		ByteString const& aFileName,
		ByteString const& aParameter,
        const UniString&  rIconFile,
        sal_Int32         nIconIndex,
		SiFolderItem* 	pItem
	);

	virtual BOOL Execute(SiEnvironment&);
};

// DeleteFolderItemAction -------------------------------------------
//
class SiDeleteFolderItemAction : public SiUnregisterAction
{
	UniString	m_suFolderName;
	ByteString	m_anItemName;
	ByteString  m_anOs2ID;
	SiFolderItem* 	m_pItem;

public:
	SiDeleteFolderItemAction
	(
		SiAgenda*,
		UniString const& aFolderName,
		ByteString const& anItemName,
		ByteString const& anOs2ID,
		SiFolderItem* 	pItem
	);

	virtual BOOL Execute(SiEnvironment&);
};

// InstallFontAction ------------------------------------------------
//
class SiInstallFontAction : public SiAction
{
	ByteString   m_aFontName;
	ByteString   m_aFontFile; // nur Dateiname

public:
	SiInstallFontAction
	(
		SiAgenda     * pAgenda,
		ByteString  const& aFontName,
		ByteString  const& aFontFile  // nur Dateiname
	);

	virtual BOOL CheckTarget(SiEnvironment const&) const;
	virtual BOOL Execute(SiEnvironment&);
};

// UninstallFontAction ----------------------------------------------
//
class SiUninstallFontAction : public SiUnregisterAction
{
	ByteString   m_aFontName;
	ByteString   m_aFontFile; // nur Dateiname

public:
	SiUninstallFontAction
	(
		SiAgenda     * pAgenda,
		ByteString  const& aFontName,
		ByteString  const& aFontFile  // nur Dateiname
	);

	virtual BOOL Execute(SiEnvironment&);
};

// ProfileItemAction ------------------------------------------------
//

enum PIA
{
	PIA_CREATE,
	PIA_REMOVE
};

class SiProfile;
class SiProfileItem;

class SiProfileItemAction : public SiAction
{
	SiProfile*			m_pProfile;
	SiProfileItem*		m_pProfileItem;
	ByteString          m_aSection;
	ByteString          m_aKey;
	ByteString          m_aValue;
	ByteString    		m_aWorkstationValue;
	ByteString    		m_aStandaloneValue;
	PIA              	m_ePIA;
	int				 	m_nOrder;
    BOOL                m_bInstallInfo : 1;
    BOOL                m_bDontOverwrite : 1;

public:
	SiProfileItemAction
	(
		SiAgenda*,
		PIA,
		SiProfile const*,
		ByteString	  const& aSection,
		ByteString	  const& aKey,
		ByteString	  const& aValue = "", 				/* "" == PIA_REMOVE */
		ByteString    const& aWorkstationValue = "", 	/* "" == PIA_REMOVE */
		ByteString      const& aStandaloneValue = "", 	/* "" == PIA_REMOVE */
		int				 nOrder = 0,
		BOOL			 bInstInf = FALSE,
        BOOL             bDontOverwrite = FALSE,
		SiProfileItem*	 pItem = NULL
	);

	virtual BOOL Execute(SiEnvironment&);

	int GetOrder() const { return m_nOrder; }
};

// SiStarRegistryAction ---------------------------------------------
//

class SiStarRegistryItem;

class SiStarRegistryAction : public SiAction
{
	const SiStarRegistryItem*	m_pItem;
	PIA							m_ePIA;

public:
	SiStarRegistryAction( SiAgenda*, PIA, const SiStarRegistryItem* );

	virtual BOOL	Execute(SiEnvironment&);
};

// SiConfigurationAction --------------------------------------------
//

class SiConfigurationItem;

class SiConfigurationAction : public SiAction
{
	const SiConfigurationItem*			m_pItem;
	PIA									m_ePIA;
    USHORT                              m_nLanguage;

	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > xORB;
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > xCfgProvider;

public:
		SiConfigurationAction( SiAgenda*, PIA, const SiConfigurationItem* );
		SiConfigurationAction( SiAgenda*, PIA, const SiConfigurationItem*, USHORT );

	void 			setUNO( com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > xo,
							com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > xp )
					{ xORB = xo; xCfgProvider = xp; }

    const SiConfigurationItem*  GetItem() const { return m_pItem; }
	virtual BOOL	Execute(SiEnvironment&);
};

// SiCustomAction ---------------------------------------------------------
//
class SiCustomModuleList;
class SiCustom;
class SiCompiledScript;

class SiCustomAction : public SiAction
{
	SiModule*				pRootModule;
	SiCustom*				m_pCustom;
	OModule*				m_pCustomDll;
	SiCustomFnc				m_aCustomFnc;
	SiSetupFnc				m_aSetupFnc;
	SiCustomEnvironment		m_aCustEnv;

	ByteString				m_aTempFile;
	ByteString				m_aDllName;
	ByteString				m_aExePath;

    BOOL					m_bKeepAlive    : 1;
    BOOL 					m_bInstallation : 1;
    BOOL 					m_bModify       : 1;
    BOOL 					m_bRepair       : 1;
    BOOL 					m_bPre          : 1;
    BOOL 					bInternalError  : 1;

    SiCustomModuleList*		pModuleInfoList;
    SiCompiledScript*       m_pCScript;

	void					AddModuleInfo(SiModule* pModule);
public:
		SiCustomAction( SiAgenda*, SiModule* pRoot, const ByteString& aDllName, const ByteString& aExePath,
						BOOL bInst, BOOL bPre, SiCustom* pCustom, SiCompiledScript* pCScript );
		~SiCustomAction();

	void 					SetKeepAlive(BOOL b=TRUE) 		{ m_bKeepAlive = b; }
    void                    SetModify()                     { m_bModify = TRUE; }
    void                    SetRepair()                     { m_bRepair = TRUE; }
	virtual BOOL			Execute( SiEnvironment& rEnv );

	SiCustomFnc&			GetCustomFnc() 					{ return m_aCustomFnc; }
	BOOL 					InternalError() const			{ return bInternalError; }
	SiCustomModuleList*		GetCustomModuleList() const		{ return pModuleInfoList; }
	ByteString 				WriteCodeFile();

	const ByteString& 		GetModuleName() const 			{ return m_aDllName; }
};

// SimpleProcedureAction --------------------------------------------------
class SiCompiledScript;

class SimpleProcedureAction
{
	ByteString		m_aProcName;
	ByteString		m_aCode;
public:
			SimpleProcedureAction( const ByteString& aProcName, const ByteString& aCode );
			~SimpleProcedureAction() {};

	const ByteString&		GetProcname() const { return m_aProcName; }
	BOOL 				Execute(SiCompiledScript* pCS, SiEnvironment& rEnv);
};

// RunProcedureAction -----------------------------------------------------
class SiRunProcedureAction : public SiAction
{
	ByteString m_aProcName;
	ByteString m_aCode;
	SiCompiledScript *m_pCS;

public:
	SiRunProcedureAction(SiAgenda*,
		ByteString const& aProcName, ByteString const& aCode, SiCompiledScript *);

	const ByteString&		GetProcname() const { return m_aProcName; }
	virtual BOOL Execute(SiEnvironment&);
};

// RegistryItemAction -----------------------------------------------------
//

enum RIA // RegistryItemAction
{
	RIA_CREATE,
	RIA_REMOVE
};

class SiRegistryItemAction : public SiAction
{
	ByteString     m_aKey;
	ByteString     m_aSubkey;
	ByteString     m_aName;
	ByteString     m_aValue;
    USHORT         m_nLanguage;
	BOOL		   m_bHexValue;
	BOOL		   m_bDeleteAll;
	RIA            m_eRIA;

public:
	SiRegistryItemAction
	(
		SiAgenda*,
		RIA,
        USHORT nLanguage,
		ByteString const& aKey,
		ByteString const& aSubkey,
		ByteString const& aName,
		ByteString const& aValue = ByteString(), // fuer RIA_REMOVE
		BOOL		  bHexValue = FALSE,
		BOOL		  bDeleteAll = FALSE
	);

	virtual BOOL Execute(SiEnvironment&);
};

// DeregistryAreaAction -----------------------------------------------------
//

class SiUnregisterAreaAction : public SiUnregisterAction
{
	ByteString  m_aSubKey;
	ByteString	m_aFromKey;
	ByteString	m_aToKey;

public:
	SiUnregisterAreaAction
	(
		SiAgenda*,
		ByteString const& aSubKey,
		ByteString const& aFromKey,
		ByteString const& aToKey
	);

	virtual BOOL Execute(SiEnvironment&);
};

// ------------------------------------------------------------------
// OS/2 Aktionen
// ------------------------------------------------------------------

// Os2RegisterClassAction -------------------------------------------
//

class SiOs2RegisterClassAction : public SiAction
{
	ByteString		m_aName;
	BOOL		m_bNetwork;
	ByteString		m_aDLLPath;
	ByteString		m_aDLLName;

public:
	SiOs2RegisterClassAction
	(
		SiAgenda*,
		ByteString const& aName,
		BOOL		  bNetwork,
		ByteString const& aDLLPath,
		ByteString const& aDLLName
	);

	virtual BOOL Execute(SiEnvironment&);
};

// Os2UnregisterClassAction -----------------------------------------
//

class SiOs2UnregisterClassAction : public SiUnregisterAction
{
	ByteString  m_aName;

public:
	SiOs2UnregisterClassAction
	(
		SiAgenda*,
		ByteString const& aName
	);

	virtual BOOL Execute(SiEnvironment&);
};

// Os2CreateTemplateAction ------------------------------------------
//
class SiOs2Class;

class SiOs2CreateTemplateAction : public SiAction
{
	ByteString			m_anID;
	BOOL			m_bNetwork;
	ByteString			m_anIconPath;
	ByteString			m_anIconName;
	SiOs2Class*		m_pOs2Class;

public:
	SiOs2CreateTemplateAction
	(
		SiAgenda*	  pAgenda,
		ByteString const& anID,
		BOOL		  bNetwork,
		ByteString const& anIconPath,
		ByteString const& anIconName,
		SiOs2Class*   pOs2Class
	);

	virtual BOOL Execute(SiEnvironment&);
};

// Os2DeleteTemplateAction ------------------------------------------
//

class SiOs2DeleteTemplateAction : public SiUnregisterAction
{
	ByteString	m_anID;

public:
	SiOs2DeleteTemplateAction
	(
		SiAgenda*,
		ByteString const& m_anID
	);

	virtual BOOL Execute(SiEnvironment&);
};

// Os2JoinEAsAction -------------------------------------------------
//

class SiOs2JoinEAsAction : public SiAction
{
	ByteString	m_aFileDir;
	ByteString	m_aFileName;
	ByteString	m_anEAFileDir;
	ByteString	m_anEAFileName;

public:
	SiOs2JoinEAsAction
	(
		SiAgenda*,
		ByteString const& aFileDir,
		ByteString const& aFileName,
		ByteString const& anEAFileDir,
		ByteString const& anEAFileName
	);

	virtual BOOL Execute(SiEnvironment&);
};

// ------------------------------------------------------------------
// Unix Aktionen
// ------------------------------------------------------------------

// UnixSoftLink ------------------------------------------------------
//

class SiUnixCreateSoftLinkAction : public SiAction
{
	ByteString  m_aSourcePath;
	ByteString	m_aName; 	// Name fuer Link und Datei ist gleich
	ByteString 	m_aDestPath;

public:

	SiUnixCreateSoftLinkAction
	(
		SiAgenda* pAgenda,
		ByteString const& aSourcePath,
		ByteString const& aName,
		ByteString const& aDestPath
	);

	virtual BOOL Execute(SiEnvironment&);
};

// UnixHardLink ------------------------------------------------------
//

class SiShortcutAction : public SiAction
{
	ByteString	m_aAbsFilename;
	ByteString	m_aAbsShortcutName;
    UniString   m_aParameter;
    UniString   m_aDescription;
    UniString   m_aWorkDir;
    UniString   m_aIconFile;
    sal_Int32   m_nIconIndex;

public:

	SiShortcutAction(
		SiAgenda* pAgenda,
		ByteString const& aAbsFilename,
		ByteString const& aAbsShortcutName
	);

	SiShortcutAction(
		SiAgenda* pAgenda,
		const ByteString&   rAbsFilename,
		const ByteString&   rAbsShortcutName,
        const UniString&    rParameter,
        const UniString&    rDescription,
        const UniString&    rWorkDir,
        const UniString&    rIconFile,
        sal_Int32           nIconIndex
	);

	virtual BOOL Execute(SiEnvironment&);
};

// ------------------------------------------------------------------
// Mac Aktionen
// ------------------------------------------------------------------

class SiMacAddApplicationAction : public SiAction
{
	ByteString 	m_aRelDir;
	ByteString 	m_aFileName;
	ByteString  m_aCreator;

public:

	SiMacAddApplicationAction
	(
		SiAgenda* pAgenda,
		ByteString const& aRelPath,
		ByteString const& aFileName,
		ByteString const& aCreator
	);

	virtual BOOL Execute(SiEnvironment&);
};

class SiMacDeleteApplicationAction : public SiUnregisterAction
{
	ByteString 	m_aRelDir;
	ByteString 	m_aFileName;
	ByteString  m_aCreator;

public:

	SiMacDeleteApplicationAction
	(
		SiAgenda* pAgenda,
		ByteString const& aRelPath,
		ByteString const& aFileName,
		ByteString const& aCreator
	);

	virtual BOOL Execute(SiEnvironment&);
};


#endif // __ACTION_HXX

