/*************************************************************************
 *
 *  $RCSfile: options.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/05 13:09:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SETUP_OPTIONS_HXX
#define _SETUP_OPTIONS_HXX

// include ---------------------------------------------------------------

#include <svdlg.hxx>
#include <svctrl.hxx>
#include <svtool.hxx>
#include <svtfixed.hxx>

#include "modview.hxx"
#include "simode.hxx"

class SiModule;
class SiEnvironment;

// class SetupOptionsDialog ----------------------------------------------

class SetupOptionsDialog : public ModelessDialog
{
private:
	FixedText       m_aInfo1Text;
	FixedText       m_aInfo2Text;
	FixedText       m_aInfo3Text;

	FixedText       m_aOptionText;
	SiModuleView    m_aModuleView;

	FixedText       m_aDescText;
	GroupBox        m_aDescBox;
	FixedInfo       m_aDescInfoText;

	FixedText       m_aPathText;
	PushButton      m_aPathBtn;
	FixedInfo       m_aWorkPathText;
	FixedInfo       m_aSysPathText;
	FixedInfo       m_aRequire1Text;
	FixedInfo       m_aRequire2Text;
	FixedInfo       m_aRequire3Text;
	FixedInfo       m_aTemp1Text;
	FixedInfo       m_aTemp2Text;
	FixedInfo       m_aTemp3Text;
	FixedInfo       m_aExist1Text;
	FixedInfo       m_aExist2Text;
	FixedInfo       m_aExist3Text;
	GroupBox        m_aMemBox;

	PushButton      m_aInstallBtn;
	CancelButton    m_aCancelBtn;

	BOOL            m_bMinimal;
	SiInstallMode   m_eInstallMode;

	ByteString			m_aProgramName;
	SiModule	   *m_pModule;
	SiEnvironment  *m_pEnv;
	BOOL			m_bScanRemoveableDisks;

	ULONG			m_lSysClusterSize;
	ULONG			m_lClusterSize;
	ByteString          m_aWorkPathStr;
	ByteString          m_aSysPathStr;

	USHORT			m_nOkEvent;
	USHORT			m_nCancelEvent;

	virtual BOOL    Close();
	virtual void    Activate();

	DECL_LINK(InstallHdl, Button*);
	DECL_LINK(CancelHdl,  Button*);
	DECL_LINK(PathHdl,	  Button*);
	DECL_LINK(SelectHdl, SiModuleView*);
	DECL_LINK(CheckHdl,	 SiModuleView*);

	void FillOptionBox();

	void UpdateUsedSize();
	void UpdatePath();
	void UpdateFreeSize();

	static int	  GetMinModuleCount(SiModule const*);
	static ByteString GetMinModuleNames(SiModule const*);
	static BOOL	  CheckMinInstall(SiModule const*);

protected:
	virtual void KeyInput(const KeyEvent&);

public:

	SetupOptionsDialog
	(
		Window		* pParent,
		ByteString const& aProgramName,
		SiEnvironment *,
		SiModule	  *,
		SiInstallMode eInstallMode,
		BOOL		  bMin,
		BOOL		  bScanRemoveableDisks,
		BOOL		  bDisablePath,
		USHORT		  nOkEvent,
		USHORT		  nCancelEvent
	);

	~SetupOptionsDialog();
};


#endif
