 /*************************************************************************
 *
 *  $RCSfile: rapofflinefilestream.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINEFILESTREAM_HXX
#define INCLUDED_UCB_RAPOFFLINEFILESTREAM_HXX

#ifndef _COM_SUN_STAR_IO_IOEXCEPTION_HPP_
#include "com/sun/star/io/IOException.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include "com/sun/star/io/XInputStream.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XMARKABLESTREAM_HPP_
#include "com/sun/star/io/XMarkableStream.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include "com/sun/star/io/XOutputStream.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XSEEKABLE_HPP_
#include "com/sun/star/io/XSeekable.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include "com/sun/star/lang/IllegalArgumentException.hpp"
#endif
#ifndef _CPPUHELPER_IMPLBASE4_HXX_
#include "cppuhelper/implbase4.hxx"
#endif
#ifndef _OSL_FILE_HXX_
#include "osl/file.hxx"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif

#include <hash_map>
#include <map>
#include <memory>

namespace ucprmt { namespace offline {

class FileStream: public cppu::WeakImplHelper4<
                             com::sun::star::io::XInputStream,
                             com::sun::star::io::XOutputStream,
                             com::sun::star::io::XSeekable,
                             com::sun::star::io::XMarkableStream >
                      //TODO! Implement XConnectable, also?
{
public:
    FileStream(rtl::OUString const & rSystemPath,
               sal_uInt32 nMode,
               bool bVolatile = false);

    virtual ~FileStream();

    virtual com::sun::star::uno::Any SAL_CALL
    queryInterface(com::sun::star::uno::Type const & rType)
        throw (com::sun::star::uno::RuntimeException);

    inline osl::FileBase::RC getOpenError() const { return m_eOpenError; }

    virtual sal_Int32 SAL_CALL
    readBytes(com::sun::star::uno::Sequence< sal_Int8 > & rData,
              sal_Int32 nBytesToRead)
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::BufferSizeExceededException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL
    readSomeBytes(com::sun::star::uno::Sequence< sal_Int8 > & rData,
                  sal_Int32 nMaxBytesToRead)
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::BufferSizeExceededException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL skipBytes(sal_Int32 nBytesToSkip)
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::BufferSizeExceededException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL available()
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL closeInput()
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    writeBytes(com::sun::star::uno::Sequence< sal_Int8 > const & rData)
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::BufferSizeExceededException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL flush()
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::BufferSizeExceededException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL closeOutput()
        throw (com::sun::star::io::NotConnectedException,
               com::sun::star::io::BufferSizeExceededException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL seek(sal_Int64 nLocation)
        throw (com::sun::star::lang::IllegalArgumentException,
               com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int64 SAL_CALL getPosition()
        throw (com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int64 SAL_CALL getLength()
        throw (com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL createMark()
        throw (com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL deleteMark(sal_Int32 nMark)
        throw (com::sun::star::io::IOException,
               com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL jumpToMark(sal_Int32 nMark)
        throw (com::sun::star::io::IOException,
               com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL jumpToFurthest()
        throw (com::sun::star::io::IOException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL offsetToMark(sal_Int32 nMark)
        throw (com::sun::star::io::IOException,
               com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

private:
    typedef std::multimap< sal_uInt64, sal_Int32 > MarkPositions;
    typedef std::hash_map< sal_Int32, MarkPositions::iterator >
        MarkIdentifiers;

    osl::File m_aFile;
    osl::Mutex m_aMutex;
    std::auto_ptr< MarkPositions > m_xMarkPositions;
    std::auto_ptr< MarkIdentifiers > m_xMarkIdentifiers;
    sal_Int32 m_nNextMarkIdentifier;
    osl::FileBase::RC m_eOpenError;
    bool m_bInputStream;
    bool m_bOutputStream;
    bool m_bMarkableStream;
    bool m_bInputOpen;
    bool m_bOutputOpen;

    FileStream(FileStream &); // not implemented
    void operator =(FileStream); // not implemented

    sal_uInt64 getPos() SAL_THROW((com::sun::star::io::IOException));

    void setPos(sal_uInt64 nPos) SAL_THROW((com::sun::star::io::IOException));

    sal_uInt64 getSize(sal_uInt64 * pPos)
        SAL_THROW((com::sun::star::io::IOException));

    MarkIdentifiers::iterator findMark(sal_Int32 nMark)
        SAL_THROW((com::sun::star::lang::IllegalArgumentException));

    void close(bool bInput, bool bOutput, bool bCheckErrors)
        SAL_THROW((com::sun::star::io::IOException));
};

} }

#endif // INCLUDED_UCB_RAPOFFLINEFILESTREAM_HXX
