/*************************************************************************
 *
 *  $RCSfile: rapofflinestoragenode.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#include "rapofflinestoragenode.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEDATASTREAM_HXX
#include "rapofflinestoragedatastream.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEIMPL_HXX
#include "rapofflinestorageimpl.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGESTREAM_HXX
#include "rapofflinestoragestream.hxx"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _OSL_INTERLOCK_H_
#include "osl/interlck.h"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _STORE_STORE_HXX_
#include "store/store.hxx"
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

using namespace com::sun;
using ucprmt::offline::StorageDataStream;
using ucprmt::offline::StorageError;
using ucprmt::offline::StorageImpl;
using ucprmt::offline::StorageNode;
using ucprmt::offline::StorageNodeContainer;
using ucprmt::offline::StorageNodeContainerIterator;
using ucprmt::offline::StorageStream;
using ucprmt::offline::StorageStreamModificationListener;

class StorageNode::StreamModificationListener:
    public StorageStreamModificationListener
{
public:
    inline
    StreamModificationListener(rtl::Reference< StorageNode > const & rNode):
        m_xNode(rNode) { OSL_ASSERT(rNode.is()); }

    virtual void notifyStorageStreamModification();

private:
    rtl::Reference< StorageNode > m_xNode;
};

void
StorageNode::StreamModificationListener::notifyStorageStreamModification()
{
    try
    {
        m_xNode->setStreamModified();
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
}

inline
StorageNode::StorageNode(rtl::Reference< StorageNodeContainer > const &
                             rContainer,
                         bool bUninserted):
	m_xContainer(rContainer),
	m_nRefCount(0),
    m_eMode(bUninserted ? MODE_UNINSERTED : MODE_INITIAL)
{
	OSL_ASSERT(rContainer.is());
}

inline StorageNode::~StorageNode() SAL_THROW(())
{}

void StorageNode::read() SAL_THROW((StorageError))
{
    if (m_eMode == MODE_INITIAL)
    {
        storeError eError
            = m_aStream.
                  create(m_xContainer->m_xImpl->getFile(),
                         rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/")),
                         m_aContainerIt->first,
                         store_AccessReadWrite);
        if (eError != store_E_None)
            throw StorageError(eError);
        StorageDataStream aDataStream(m_aStream);
        m_aCurrentChildren = aDataStream.readStrings();
        m_aOriginalChildren = aDataStream.readStrings();
        m_aOriginalUrl = aDataStream.readString();
        m_aCurrentParent = aDataStream.readString();
        m_aOriginalParent = aDataStream.readString();
        m_aContentType = aDataStream.readString();
        m_aCurrentTitle = aDataStream.readString();
        m_aOriginalTitle = aDataStream.readString();
        m_aDateCreated = aDataStream.readDateTime();
        m_aDateModified = aDataStream.readDateTime();
        sal_uInt32 nState = aDataStream.readInteger();
        if (nState > STATE_DELETED)
            throw StorageError(store_E_Unknown);
        m_eState = static_cast< State >(nState);
        m_bFolder = aDataStream.readBoolean();
        m_bDocument = aDataStream.readBoolean();
        m_bReadOnly = aDataStream.readBoolean();
        m_eMode = MODE_READ;
    }
}

void StorageNode::write() SAL_THROW((StorageError))
{
    if (m_eMode == MODE_UNINSERTED)
    {
        rtl::OUString aPath(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/")));
        for (bool bFirst = true;; bFirst = false)
        {
            storeError eError
                = m_aStream.create(m_xContainer->m_xImpl->getFile(),
                                   aPath,
                                   m_aContainerIt->first,
                                   store_AccessReadWrite);
            if (eError == store_E_None)
                break;
            if (eError == store_E_NotExists && bFirst)
                eError = m_aStream.create(m_xContainer->m_xImpl->getFile(),
                                          aPath,
                                          m_aContainerIt->first,
                                          store_AccessCreate);
            if (eError != store_E_None)
                throw StorageError(eError);
        }
        m_eMode = MODE_READ;
    }

    if (m_eMode != MODE_REMOVED)
    {
        OSL_ASSERT(m_eMode == MODE_READ);

        //TODO! commit-or-roll-back-semantics missing
        StorageDataStream aDataStream(m_aStream);
        aDataStream.writeStrings(m_aCurrentChildren);
        aDataStream.writeStrings(m_aOriginalChildren);
        aDataStream.writeString(m_aOriginalUrl);
        aDataStream.writeString(m_aCurrentParent);
        aDataStream.writeString(m_aOriginalParent);
        aDataStream.writeString(m_aContentType);
        aDataStream.writeString(m_aCurrentTitle);
        aDataStream.writeString(m_aOriginalTitle);
        aDataStream.writeDateTime(m_aDateCreated);
        aDataStream.writeDateTime(m_aDateModified);
        aDataStream.writeInteger(m_eState);
        aDataStream.writeBoolean(m_bFolder);
        aDataStream.writeBoolean(m_bDocument);
        aDataStream.writeBoolean(m_bReadOnly);
    }
}

void StorageNode::fill(star::uno::Sequence< rtl::OUString > const & rChildren,
                       rtl::OUString const & rParent,
                       rtl::OUString const & rContentType,
                       rtl::OUString const & rTitle,
                       com::sun::star::util::DateTime const & rDateCreated,
                       bool bFolder,
                       bool bDocument,
                       bool bReadOnly)
    SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode == MODE_UNINSERTED);
    m_aCurrentChildren = rChildren;
    m_aCurrentParent = rParent;
    m_aContentType = rContentType;
    m_aCurrentTitle = rTitle;
    m_aDateCreated = rDateCreated;
    m_aDateModified = rDateCreated;
    m_bFolder = bFolder;
    m_bDocument = bDocument;
    m_bReadOnly = bReadOnly;
    m_eState = STATE_UNCHANGED;
}

void StorageNode::setInserted(bool bLog) SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode == MODE_UNINSERTED);
    OSL_ASSERT(m_eState == STATE_UNCHANGED);
    m_aOriginalUrl = m_aContainerIt->first;
    if (bLog)
        m_eState = STATE_INSERTED;
    write();
}

void StorageNode::setDeleted(bool bLog) SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);
    if (m_eMode != MODE_REMOVED)
        if (bLog)
        {
            read();
            if (m_eState != STATE_DELETED)
            {
                if ((m_eState & STATE_CHILDREN_MODIFIED) != 0)
                {
                    m_aCurrentChildren = m_aOriginalChildren;
                    m_aOriginalChildren.realloc(0);
                }
                if ((m_eState & STATE_PARENT_MODIFIED) != 0)
                {
                    m_aCurrentParent = m_aOriginalParent;
                    m_aOriginalParent = rtl::OUString();
                }
                if ((m_eState & STATE_TITLE_MODIFIED) != 0)
                {
                    m_aCurrentTitle = m_aOriginalTitle;
                    m_aOriginalTitle = rtl::OUString();
                }
                m_eState = STATE_DELETED;
                write();
            }
        }
        else
        {
            m_aStream.close();
            storeError eError
                = m_xContainer->
                      m_xImpl->
                          getFile().
                              remove(rtl::OUString(
                                         RTL_CONSTASCII_USTRINGPARAM("/")),
                                     m_aContainerIt->first);
            if (eError != store_E_None)
                throw StorageError(eError);
            m_eMode = MODE_REMOVED;
            eError
                = m_xContainer->
                      m_xImpl->
                          getFile().
                              remove(rtl::OUString(
                                         RTL_CONSTASCII_USTRINGPARAM("/")),
                                     rtl::OUString(
                                             RTL_CONSTASCII_USTRINGPARAM(
                                                 "@S:"))
                                         + m_aContainerIt->first);
            OSL_ASSERT(eError == store_E_None || eError == store_E_NotExists);
        }
}

void StorageNode::setStreamModified() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);
    if (m_eMode != MODE_REMOVED
        && m_eState != STATE_DELETED
        && (m_eState & STATE_STREAM_MODIFIED) == 0)
    {
        m_eState = static_cast< State >(m_eState | STATE_STREAM_MODIFIED);
        write();
    }
}

void StorageNode::release() SAL_THROW(())
{
    if (osl_decrementInterlockedCount(&m_nRefCount) == 0)
    {
        m_xContainer->releaseElement(this);
        delete this;
    }
}

star::uno::Sequence< rtl::OUString > StorageNode::getCurrentChildren()
    SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aCurrentChildren;
}

star::uno::Sequence< rtl::OUString > StorageNode::getOriginalChildren()
    SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_eState == STATE_DELETED
           || (m_eState & STATE_CHILDREN_MODIFIED) == 0 ?
               m_aCurrentChildren : m_aOriginalChildren;
}

rtl::OUString StorageNode::getOriginalUrl() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aOriginalUrl;
}

rtl::OUString StorageNode::getCurrentParent() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aCurrentParent;
}

rtl::OUString StorageNode::getOriginalParent() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return
        m_eState == STATE_DELETED || (m_eState & STATE_PARENT_MODIFIED) == 0 ?
            m_aCurrentParent : m_aOriginalParent;
}

rtl::OUString StorageNode::getContentType() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aContentType;
}

rtl::OUString StorageNode::getCurrentTitle() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aCurrentTitle;
}

star::util::DateTime StorageNode::getDateCreated() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aDateCreated;
}

star::util::DateTime StorageNode::getDateModified() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_aDateModified;
}

bool StorageNode::getFolder() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_bFolder;
}

bool StorageNode::getDocument() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_bDocument;
}

bool StorageNode::getReadOnly() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    read();
    return m_bReadOnly;
}

star::uno::Reference< star::io::XStream > StorageNode::getStream()
    SAL_THROW((StorageError))
{
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);

    store::OStoreStream aStream;
    rtl::OUString aPath(RTL_CONSTASCII_USTRINGPARAM("/"));
    rtl::OUString aName(RTL_CONSTASCII_USTRINGPARAM("@S:"));
    aName += m_aContainerIt->first;
    storeAccessMode eMode = store_AccessReadWrite;
    for (bool bFirst = true;; bFirst = false)
    {
        storeError eError = aStream.create(m_xContainer->m_xImpl->getFile(),
                                           aPath,
                                           aName,
                                           eMode);
        if (eError == store_E_None)
            break;
        if (bFirst)
            switch (eError)
            {
            case store_E_AccessViolation:
                eMode = store_AccessReadOnly;
                eError = store_E_None;
                break;

            case store_E_NotExists:
                eError = aStream.create(m_xContainer->m_xImpl->getFile(),
                                        aPath,
                                        aName,
                                        store_AccessCreate);
                break;
            }
        if (eError != store_E_None)
            throw StorageError(eError);
    }

    return new StorageStream(aStream, new StreamModificationListener(this));
}

bool StorageNode::isInserted() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);
    read();
    return m_eMode != MODE_REMOVED
           && m_eState != STATE_DELETED
           && (m_eState & STATE_INSERTED) != 0;
}

bool StorageNode::isModified() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);
    read();
    return m_eMode != MODE_REMOVED
           && m_eState != STATE_DELETED
           && (m_eState & STATE_INSERTED) == 0
           && (m_eState & (STATE_CHILDREN_MODIFIED
                               | STATE_PARENT_MODIFIED
                               | STATE_TITLE_MODIFIED
                               | STATE_STREAM_MODIFIED))
                  != 0;
}

bool StorageNode::isStreamModified() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);
    read();
    return m_eMode != MODE_REMOVED
           && m_eState != STATE_DELETED
           && (m_eState & STATE_INSERTED) == 0
           && (m_eState & STATE_STREAM_MODIFIED) != 0;
}

bool StorageNode::isDeleted() SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode != MODE_UNINSERTED);
    read();
    return m_eMode == MODE_REMOVED || m_eState == STATE_DELETED;
}

void StorageNode::addChild(rtl::OUString const & rChild)
    SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode == MODE_READ);
    for (sal_Int32 i = 0; i < m_aCurrentChildren.getLength(); ++i)
        if (m_aCurrentChildren[i] == rChild)
            return;
    if ((m_eState & STATE_CHILDREN_MODIFIED) == 0)
    {
        m_aOriginalChildren = m_aCurrentChildren;
        m_eState = static_cast< State >(m_eState | STATE_CHILDREN_MODIFIED);
    }
    m_aCurrentChildren.realloc(m_aCurrentChildren.getLength() + 1);
    m_aCurrentChildren[m_aCurrentChildren.getLength() - 1] = rChild;
    write();
}

void StorageNode::removeChild(rtl::OUString const & rChild)
    SAL_THROW((StorageError))
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode == MODE_READ);
    for (sal_Int32 i = 0; i < m_aCurrentChildren.getLength(); ++i)
        if (m_aCurrentChildren[i] == rChild)
        {
            if ((m_eState & STATE_CHILDREN_MODIFIED) == 0)
            {
                m_aOriginalChildren = m_aCurrentChildren;
                m_eState
                    = static_cast< State >(m_eState
                                               | STATE_CHILDREN_MODIFIED);
            }
            star::uno::Sequence< rtl::OUString >
                aChildren(m_aCurrentChildren.getLength() - 1);
            sal_Int32 j = 0;
            for (sal_Int32 k = 0; k < m_aCurrentChildren.getLength(); ++k)
                if (k != i)
                    aChildren[j++] = m_aCurrentChildren[k];
            m_aCurrentChildren = aChildren;
            write();
            break;
        }
}

void StorageNode::setTitle(rtl::OUString const & rTitle)
{
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(m_eMode == MODE_UNINSERTED);
    m_aCurrentTitle = rTitle;
}

StorageNodeContainer::~StorageNodeContainer() SAL_THROW(())
{}

void StorageNodeContainer::releaseElement(StorageNode * pElement)
    SAL_THROW(())
{
    OSL_ASSERT(pElement);
    osl::MutexGuard aGuard(m_aMutex);
    if (pElement->m_aContainerIt != m_aMap.end())
        m_aMap.erase(pElement->m_aContainerIt);
}

StorageNodeContainer::StorageNodeContainer(
    rtl::Reference< StorageImpl > const & rImpl):
    m_xImpl(rImpl)
{
    OSL_ASSERT(m_xImpl.is());
}

rtl::Reference< StorageNode >
StorageNodeContainer::find(rtl::OUString const & rId)
{
    osl::MutexGuard aGuard(m_aMutex);
	Map::iterator aIt(m_aMap.find(rId));
	if (aIt != m_aMap.end())
    {
        if (osl_incrementInterlockedCount(&aIt->second->m_nRefCount) > 1)
        {
            rtl::Reference< StorageNode > xElement(aIt->second);
            osl_decrementInterlockedCount(&aIt->second->m_nRefCount);
            return xElement;
        }
        osl_decrementInterlockedCount(&aIt->second->m_nRefCount);
        aIt->second->m_aContainerIt = m_aMap.end();
    }
    storeError eError
        = m_xImpl->
              getFile().
                  attrib(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/")),
                         rId,
                         0,
                         0);
    if (eError == store_E_NotExists)
        return 0;
    if (eError != store_E_None)
        throw StorageError(eError);
    std::auto_ptr< StorageNode > xElement(new StorageNode(this, false));
    aIt = m_aMap.insert(Map::value_type(rId, xElement.get())).first;
    aIt->second->m_aContainerIt = aIt;
    xElement.release();
    return aIt->second;
}

rtl::Reference< StorageNode>
StorageNodeContainer::create(
    star::uno::Sequence< rtl::OUString > const & rChildren,
    rtl::OUString const & rParent,
    rtl::OUString const & rContentType,
    rtl::OUString const & rTitle,
    star::util::DateTime const & rDateCreated,
    bool bFolder,
    bool bDocument,
    bool bReadOnly)
{
    std::auto_ptr< StorageNode > xElement(new StorageNode(this, true));
    xElement->m_aContainerIt = m_aMap.end();
    xElement->fill(rChildren,
                   rParent,
                   rContentType,
                   rTitle,
                   rDateCreated,
                   bFolder,
                   bDocument,
                   bReadOnly);
    return xElement.release();
}

bool
StorageNodeContainer::insert(rtl::Reference< StorageNode > const & rElement,
                             rtl::OUString const & rId,
                             bool bLog)
{
    OSL_ASSERT(rElement.is());
    OSL_ASSERT(rId.getLength() > 0);
    osl::MutexGuard aGuard(m_aMutex);
    OSL_ASSERT(rElement->m_aContainerIt == m_aMap.end());
    rElement->m_aContainerIt
        = m_aMap.insert(Map::value_type(rId, rElement.get())).first;
    rElement->setInserted(bLog);
    return true;
}

bool StorageNodeContainer::remove(rtl::OUString const & rId, bool bLog)
{
    rtl::Reference< StorageNode > xElement(find(rId));
    if (!xElement.is())
        return false;
    xElement->setDeleted(bLog);
    return true;
}

StorageNodeContainerIterator::StorageNodeContainerIterator(
    rtl::Reference< StorageNodeContainer > const & rContainer):
    m_xContainer(rContainer),
    m_aGuard(rContainer->m_aMutex),
    m_aIt(rContainer->m_aMap.begin())
{
    OSL_ASSERT(m_xContainer.is());
}

StorageNodeContainerIterator::~StorageNodeContainerIterator() SAL_THROW(())
{}

bool StorageNodeContainerIterator::empty() const
{
    return m_aIt == m_xContainer->m_aMap.end();
}

StorageNodeContainerIterator::value_type *
StorageNodeContainerIterator::operator ->()
{
    return m_aIt.operator ->();
}

StorageNodeContainerIterator & StorageNodeContainerIterator::operator ++()
{
    ++m_aIt;
    return *this;
}
