 /*************************************************************************
 *
 *  $RCSfile: TextDocument.java,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/11 15:02:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 */

package com.sun.star.wizards.common;

import java.util.*;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XElementAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XIndexContainer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.beans.XMultiPropertySet;

import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbc.*;
import com.sun.star.sdb.XColumn;
import com.sun.star.sdb.*;
import com.sun.star.sdbc.XColumnLocate;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Any;
import com.sun.star.uno.*;
import com.sun.star.sheet.*;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XEventsSupplier;
import com.sun.star.document.*;
import com.sun.star.table.*;
import com.sun.star.sdb.*;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XText;
import com.sun.star.table.XCellRange;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.util.XLinkUpdate;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.NumberFormat;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.Date;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.Rectangle;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.lang.*;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.Locale;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.TableColumnSeparator;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.script.XInvocation;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.style.XStyleLoader;
import com.sun.star.style.TabStop;
import com.sun.star.style.BreakType;
import com.sun.star.frame.XFrame;
import com.sun.star.awt.Size;
import com.sun.star.awt.XTextComponent;
import com.sun.star.view.XSelectionSupplier;


public class TextDocument {
    public XComponent xComponent;
    public XTextDocument xTextDocument;
    public XNumberFormats NumberFormats;
    public XDocumentInfo xDocInfo;
    public XStatusIndicator xProgressBar;
    public XFrame xFrame;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XTextSectionsSupplier xTextSectionsSupplier;
    public XTextTablesSupplier xTextTablesSupplier;
    public XStyleFamiliesSupplier xStyleFamiliesSupplier;
    public XFormsSupplier xFormsSupplier;
    public XTextViewCursorSupplier xViewCursorSupplier;
    public XTextFieldsSupplier xTextFieldsSupplier;
    public XNumberFormatsSupplier xNumberFormatsSupplier;
    public XWindowPeer xWindowPeer;
    public int PageWidth;
    public int ScaleWidth;
    public Rectangle PosSize;
    public Locale CharLocale;
    
    
    /** Creates a new instance of TextDocument */	   
    public TextDocument(XMultiServiceFactory xMSF, boolean bshowStatusIndicator, boolean bgetCurrentFrame) {
	this.xMSF = xMSF;
	XDesktop xDesktop = Tools.getDesktop(xMSF);
	if (bgetCurrentFrame){
	    XFramesSupplier xFrameSupplier = (XFramesSupplier) UnoRuntime.queryInterface(XFramesSupplier.class, xDesktop);
	    xFrame = xFrameSupplier.getActiveFrame();
	    xComponent = (XComponent) UnoRuntime.queryInterface(XComponent.class, xFrame.getController().getModel());
	    xTextDocument = (XTextDocument) UnoRuntime.queryInterface(XTextDocument.class, xComponent);
	}
	else{
	    xTextDocument =  (XTextDocument) Tools.createNewDocument(xDesktop, "swriter");
	    xFrame = xTextDocument.getCurrentController().getFrame();
	    xComponent = (XComponent) UnoRuntime.queryInterface(XComponent.class, xTextDocument);
	}
	PosSize = xFrame.getComponentWindow().getPosSize();
	if (bshowStatusIndicator){
	    XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory) UnoRuntime.queryInterface(XStatusIndicatorFactory.class, xFrame);
	    xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
	    xProgressBar.start("",100);
	    xProgressBar.setValue(5);
	}
	xWindowPeer = (XWindowPeer) UnoRuntime.queryInterface(XWindowPeer.class, xFrame.getComponentWindow());
	xMSFDoc = (XMultiServiceFactory) UnoRuntime.queryInterface(XMultiServiceFactory.class, xTextDocument);
	xNumberFormatsSupplier = (XNumberFormatsSupplier) UnoRuntime.queryInterface(XNumberFormatsSupplier.class, xTextDocument);
	xTextSectionsSupplier = (XTextSectionsSupplier) UnoRuntime.queryInterface(XTextSectionsSupplier.class, xTextDocument);
	xTextTablesSupplier = (XTextTablesSupplier) UnoRuntime.queryInterface(XTextTablesSupplier.class, xTextDocument);
	xTextFieldsSupplier = (XTextFieldsSupplier) UnoRuntime.queryInterface(XTextFieldsSupplier.class, xTextDocument);
	xStyleFamiliesSupplier  = (XStyleFamiliesSupplier) UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, xTextDocument);
	xFormsSupplier  = (XFormsSupplier) UnoRuntime.queryInterface(XFormsSupplier.class, xTextDocument);
	xViewCursorSupplier = (XTextViewCursorSupplier) UnoRuntime.queryInterface(XTextViewCursorSupplier.class, xTextDocument.getCurrentController());
	XDocumentInfoSupplier xDocInfoSuppl = (XDocumentInfoSupplier) UnoRuntime.queryInterface(XDocumentInfoSupplier.class, xTextDocument);
	xDocInfo = xDocInfoSuppl.getDocumentInfo();
	CharLocale = (Locale) Tools.getUNOStructValue((Object) xComponent, "CharLocale");
    }

    
    public XTextCursor createTextCursor(Object oCursorContainer){
      XSimpleText xText = (XSimpleText) UnoRuntime.queryInterface(XSimpleText.class, oCursorContainer);
      XTextCursor xTextCursor = xText.createTextCursor();
      return xTextCursor;
    }

    
    public void insertTextTable(XTextCursor xTextCursor){
	try{	
	XInterface xTextTable =  (XInterface) xMSFDoc.createInstance("com.sun.star.text.TextTable");
	XTextContent xTextContentTable = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, xTextTable);
	if (xTextCursor == null){
	    xTextCursor = createTextCursor(xTextDocument.getText());
	    xTextCursor.gotoEnd(false);
	}
	xTextCursor.getText().insertTextContent(xTextCursor, xTextContentTable, false);
    }
    catch( com.sun.star.uno.Exception exception ){
	exception.printStackTrace(System.out);
    }}
    
    
    
    public void renameTextTable(XNameAccess xTextTableNames, String OldTableName, String NewTableName){
    try{
	if (xTextTableNames.hasByName(OldTableName)){
	    Object oTextTable = xTextTableNames.getByName(OldTableName);
	    XNamed xTextTableName = (XNamed) UnoRuntime.queryInterface(XNamed.class, oTextTable);
	    xTextTableName.setName(NewTableName);
	}
    }
    catch( com.sun.star.uno.Exception exception ){
	exception.printStackTrace(System.out);
    }}


    public void removeTextTablebyName(String TableName){
    try{
	XNameAccess xAllTextTables = xTextTablesSupplier.getTextTables();
	if (xAllTextTables.hasByName(TableName) == true){
	    Object oTextTable = xAllTextTables.getByName(TableName);
	    XTextContent xTextContentoTextTable = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextTable);
	    xTextDocument.getText().removeTextContent(xTextContentoTextTable);
	}
     }
     catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
      }}


    public void removeAllTextTables(){
    try{
	Object oTextTable;
	XText xText = xTextDocument.getText();
	XIndexAccess xAllTextTables = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextTablesSupplier.getTextTables());
	int TextTableCount = xAllTextTables.getCount();
	for (int i = TextTableCount-1; i >= 0 ; i--){
	    oTextTable = xAllTextTables.getByIndex(i);
	    XTextContent xTextContentTextTable = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextTable);
	    xText.removeTextContent(xTextContentTextTable);
	}
    }
    catch( com.sun.star.uno.Exception exception ){
	exception.printStackTrace(System.out);
    }}


// Todo: This method is  unsecure because the last index is not necessarily the last section
    public void removeLastTextTable(){
    try{
	XIndexAccess xAllTextTables = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextTablesSupplier.getTextTables());
	Object oTextTable = xAllTextTables.getByIndex(xAllTextTables.getCount()-1);
	XTextContent xTextContentTable = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextTable);
	xTextDocument.getText().removeTextContent(xTextContentTable);
     }
     catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
      }}

    
    // Todo: This Routine should be  modified, because I cannot rely on the last Table in the document to be the last in the TextTables sequence
    // to make it really safe you must acquire the Tablenames before the insertion and after the insertion of the new Table. By comparing the 
    // two sequences of tablenames you can find out the tablename of the last inserted Table 
    public XTextTable getlastTextTable(){
    try{
	XTextTablesSupplier xTextTablesSuppl = (XTextTablesSupplier) UnoRuntime.queryInterface(XTextTablesSupplier.class, xTextDocument);
	XIndexAccess xAllTextTables = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextTablesSuppl.getTextTables());
	int MaxIndex = xAllTextTables.getCount()-1;
	Object oTable = xAllTextTables.getByIndex(MaxIndex);
	XTextTable xTextTable = (XTextTable) UnoRuntime.queryInterface(XTextTable.class, oTable);
	return xTextTable;
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
 	return null;
    }}
    
    
// Todo: This method is  unsecure because the last index is not necessarily the last section
    public void removeLastTextSection(){
    try{
	XIndexAccess xAllTextSections = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextSectionsSupplier.getTextSections());
	Object oTextSection = xAllTextSections.getByIndex(xAllTextSections.getCount()-1);
	XTextContent xTextContentTextSection = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextSection);
	xTextDocument.getText().removeTextContent(xTextContentTextSection);
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}    

    
    public void insertTextSection(String GroupName, String TemplateName){
    try{
	XInterface xTextSection;
	if (xTextSectionsSupplier.getTextSections().hasByName(GroupName) == true){
	    xTextSection = (XInterface) xTextSectionsSupplier.getTextSections().getByName(GroupName);
	}
	else{
	    xTextSection =  (XInterface) xMSFDoc.createInstance("com.sun.star.text.TextSection");
	    XTextContent xTextContentSection = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, xTextSection);
	    XTextCursor xTextCursor = createTextCursor(xTextDocument.getText());
	    xTextCursor.gotoEnd(false);
	    xTextCursor.getText().insertTextContent(xTextCursor, xTextContentSection, false);
	}
	linkSectiontoTemplate(xTextSection, TemplateName, GroupName);
    }
    catch( com.sun.star.uno.Exception exception ){
	exception.printStackTrace(System.out);
    }}

    
    public void removeAllTextSections(){
    try{
	Object oTextSection;
	XText xText = xTextDocument.getText();
	XIndexAccess xAllTextSections = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextSectionsSupplier.getTextSections());
	int TextSectionCount = xAllTextSections.getCount();
	for (int i = TextSectionCount-1; i >= 0 ; i--){
	    oTextSection = xAllTextSections.getByIndex(i);
	    XTextContent xTextContentTextSection = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextSection);
	    xText.removeTextContent(xTextContentTextSection);
	}
    }
    catch( com.sun.star.uno.Exception exception ){
	exception.printStackTrace(System.out);
    }}

    
    public void linkSectiontoTemplate(Object oTextSection, String TemplateName, String SectionName){
	com.sun.star.text.SectionFileLink oSectionLink = new com.sun.star.text.SectionFileLink();
	oSectionLink.FileURL = TemplateName;
	Tools.setUNOPropertyValue(oTextSection, "FileLink", oSectionLink);
	Tools.setUNOPropertyValue(oTextSection, "LinkRegion", SectionName);
	XNamed xSectionName = (XNamed) UnoRuntime.queryInterface(XNamed.class, oTextSection);
	String NewSectionName = xSectionName.getName();
        if (NewSectionName.compareTo(SectionName) != 0)
	    xSectionName.setName(SectionName);
    }

    public void removeTextSectionbyName(String SectionName){
    try{
	XNameAccess xAllTextSections = xTextSectionsSupplier.getTextSections();
	if (xAllTextSections.hasByName(SectionName) == true){
	    Object oTextSection = xTextSectionsSupplier.getTextSections().getByName(SectionName);
	    XTextContent xTextContentTextSection = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextSection);
	    xTextDocument.getText().removeTextContent(xTextContentTextSection);
	}
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}


    public void breakLinkofTextSections(){
    try{
	Object oTextSection;
	XIndexAccess xAllTextSections = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextSectionsSupplier.getTextSections());
	int iSectionCount = xAllTextSections.getCount();
	com.sun.star.text.SectionFileLink oSectionLink = new com.sun.star.text.SectionFileLink();
	oSectionLink.FileURL = "";	
	for (int i =0; i < iSectionCount; i++){
	    oTextSection = xAllTextSections.getByIndex(i);
	    Tools.setUNOPropertyValues(oTextSection, new String[]{"FileLink", "LinkRegion"}, new Object[]{oSectionLink, ""});
	}
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}  

    
    public void insertUserField(XTextCursor xTextCursor, String FieldName, String FieldTitle){
    try{
	XInterface xField = (XInterface) xMSFDoc.createInstance("com.sun.star.text.TextField.User");
	XDependentTextField xDepField = (XDependentTextField) UnoRuntime.queryInterface(XDependentTextField.class, xField);
	XTextContent xFieldContent = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, xField);
	if (xTextFieldsSupplier.getTextFieldMasters().hasByName("com.sun.star.text.FieldMaster.User." + FieldName)){
	    Object oMaster = xTextFieldsSupplier.getTextFieldMasters().getByName("com.sun.star.text.FieldMaster.User." + FieldName);
	    XComponent xComponent = (XComponent) UnoRuntime.queryInterface(XComponent.class, oMaster);
	    xComponent.dispose();
	}
	Object oMaster = xMSFDoc.createInstance("com.sun.star.text.FieldMaster.User");
	XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, oMaster);
	xPSet.setPropertyValue("Name", FieldName);
	xPSet.setPropertyValue("Content", FieldTitle);
	xDepField.attachTextFieldMaster(xPSet);	
	xTextCursor.getText().insertTextContent(xTextCursor, xFieldContent, false);
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}


    public String getUserFieldContent(XTextCursor xTextCursor){
    try{
	XTextRange xTextRange = xTextCursor.getEnd();
	Object oTextField = Tools.getUNOPropertyValue(xTextRange, "TextField");
	if (com.sun.star.uno.AnyConverter.isVoid(oTextField))
	    return "";
	else{
	    XDependentTextField xDependent = (XDependentTextField) UnoRuntime.queryInterface(XDependentTextField.class, oTextField);
	    XPropertySet xMaster = xDependent.getTextFieldMaster();
	    String UserFieldContent = (String) xMaster.getPropertyValue("Content");
	    return UserFieldContent;	    
	}    
    }
    catch(com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
	return "";
    }}

    
    public void selectFirstPage(){
    try{
	XTextRange xRange;
	XTextContent xTextTable;
	BreakType BreakValue;
	xTextDocument = (XTextDocument) UnoRuntime.queryInterface(XTextDocument.class, xComponent);
	xViewCursorSupplier = (XTextViewCursorSupplier) UnoRuntime.queryInterface(XTextViewCursorSupplier.class, xTextDocument.getCurrentController());	
	XPageCursor xPageCursor = (XPageCursor) UnoRuntime.queryInterface(XPageCursor.class, xViewCursorSupplier.getViewCursor());
	XTextCursor xViewTextCursor = (XTextCursor) UnoRuntime.queryInterface(XTextCursor.class,  xPageCursor);
	xPageCursor.jumpToFirstPage();
	xPageCursor.jumpToStartOfPage();
	Tools.setUNOPropertyValue(xPageCursor, "PageDescName", "First Page");
	Object oPageStyles = xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
	XNameAccess xName = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, oPageStyles);
	Object oPageStyle = xName.getByName("First Page");
	XIndexAccess xAllTextTables = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextTablesSupplier.getTextTables());
	int TextTablesCount = xAllTextTables.getCount();
	for (int i = 0; i<TextTablesCount; i++){
	    xTextTable = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, xAllTextTables.getByIndex(i));
	    xRange = (XTextRange) UnoRuntime.queryInterface(XTextRange.class, xTextTable.getAnchor().getText());
	    xViewTextCursor.gotoRange(xRange, false);
	    if (xPageCursor.getPage() == (short)1){
		Tools.setUNOPropertyValue(xTextTable, "PageDescName", "First Page");
		resetBreakTypeofTextTable(xTextTable);
	    }
	}
	XTextRange xHeaderRange = (XTextRange) Tools.getUNOPropertyValue(oPageStyle, "HeaderText", XTextRange.class);
	if (com.sun.star.uno.AnyConverter.isVoid(xHeaderRange) == false){
	    xViewTextCursor.gotoRange(xHeaderRange, false);
	    xViewTextCursor.collapseToStart();
	}
	else
	    System.out.println("No Headertext available");

	
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}

    
    public XNameContainer getDocumentForms(){
	XDrawPageSupplier xDrawPageSuppl = (XDrawPageSupplier) UnoRuntime.queryInterface(XDrawPageSupplier.class, xTextDocument);
	XDrawPage xDrawPage = xDrawPageSuppl.getDrawPage();
	XFormsSupplier xFormsSuppl = (XFormsSupplier) UnoRuntime.queryInterface(XFormsSupplier.class, xDrawPage);
	XNameContainer xNamedForms = xFormsSuppl.getForms();
	return xNamedForms;
    }
    

    public XNameContainer insertFormbyName(String FormName){
    try{
	XInterface xDBForm;
	XNameContainer xNamedForms = getDocumentForms();
	XNameAccess xForms = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xNamedForms);
	if (xForms.hasByName(FormName) == false){
	    xDBForm = (XInterface) xMSFDoc.createInstance("com.sun.star.form.component.Form");
	    xNamedForms.insertByName(FormName, xDBForm);
	}
	else
	    xDBForm = (XInterface) AnyConverter.toObject(new Type(XInterface.class), Tools.getUNOObjectbyName(xForms, FormName));
        XNameContainer xNamedForm = (XNameContainer) UnoRuntime.queryInterface(XNameContainer.class, xDBForm);
	return xNamedForm;
    }
    catch(com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
	return null;
    }}

    
    public void insertHiddenControl(XNameAccess xNameAccess, XNameContainer xNamedForm, String ControlName, String ControlValue){
    try{
	XInterface xHiddenControl;
	if (xNameAccess.hasByName(ControlName) == true)
	    xHiddenControl = (XInterface) AnyConverter.toObject(new Type(XInterface.class), xNameAccess.getByName(ControlName));
	else{
	    xHiddenControl = (XInterface) xMSFDoc.createInstance("com.sun.star.form.component.HiddenControl");
	    xNamedForm.insertByName(ControlName, xHiddenControl);
	}
	Tools.setUNOPropertyValue(xHiddenControl, "HiddenValue", ControlValue);
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}


    public String getValueofHiddenControl(XNameAccess xNamedForm, String ControlName, String sMsg) 
					   throws com.sun.star.wizards.common.TextDocument.UnknownHiddenControlException{
    try{
	if (xNamedForm.hasByName(ControlName)){
	    String ControlValue = AnyConverter.toString(Tools.getUNOPropertyValue(xNamedForm.getByName(ControlName), "HiddenValue"));
	    return ControlValue;
	}
	else
	    throw new UnknownHiddenControlException(xNamedForm, ControlName, sMsg);
    }
    catch(com.sun.star.uno.Exception exception){
	throw new UnknownHiddenControlException(xNamedForm, ControlName, sMsg);
    }}
    
    
    public class UnknownHiddenControlException extends java.lang.Throwable {
	public UnknownHiddenControlException(XNameAccess xNamedForm, String ControlName, String sMsgHiddenControlisMissing){
	    XNamed xNamed = (XNamed) UnoRuntime.queryInterface(XNamed.class, xNamedForm);
	    String FormName = xNamed.getName();
	    sMsgHiddenControlisMissing = Tools.replaceSubString(sMsgHiddenControlisMissing, FormName, "<REPORTFORM>");
	    sMsgHiddenControlisMissing = Tools.replaceSubString(sMsgHiddenControlisMissing, ControlName, "<CONTROLNAME>");
	    UNODialogs.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMsgHiddenControlisMissing);
	}
    }
    
    
    public int getCharWidth(String ScaleString){
    int iScale = 200;
	xTextDocument.lockControllers();
	int iScaleLen = ScaleString.length();
	XTextCursor xTextCursor = createTextCursor(xTextDocument.getText());
	xTextCursor.gotoStart(false);
	Tools.setUNOPropertyValue(xTextCursor, "PageDescName", "First Page");
	xTextCursor.setString(ScaleString);
	XTextViewCursorSupplier xViewCursor = (XTextViewCursorSupplier) UnoRuntime.queryInterface(XTextViewCursorSupplier.class, xTextDocument.getCurrentController());
	XTextViewCursor xTextViewCursor = xViewCursor.getViewCursor();
	xTextViewCursor.gotoStart(false);
	int iFirstPos = xTextViewCursor.getPosition().X;
	xTextViewCursor.gotoEnd(false);
	int iLastPos = xTextViewCursor.getPosition().X;
	iScale = (iLastPos-iFirstPos)/iScaleLen;
	xTextCursor.gotoStart(false);
	xTextCursor.gotoEnd(true);
	xTextCursor.setString("");
	xTextDocument.unlockControllers();
	return iScale;
    }    
    
    public void unlockallControllers(){
	while (xTextDocument.hasControllersLocked() == true){
	    xTextDocument.unlockControllers();
	}
    }
    
    
    public static BreakType resetBreakTypeofTextTable(Object oTextTable){
	BreakType CorrBreakValue = null;
	BreakType BreakValue = (BreakType) Tools.getUNOStructValue(oTextTable, "BreakType");
	if (BreakValue.equals(BreakType.NONE) == false){
	    CorrBreakValue = BreakValue;
	    Tools.setUNOPropertyValue(oTextTable, "BreakType", BreakType.NONE);
	}
	return CorrBreakValue;
    }
    
    
/* Possible Values for "OptionString" are: "LoadCellStyles", "LoadTextStyles", "LoadFrameStyles",
					   "LoadPageStyles", "LoadNumberingStyles", "OverwriteStyles" */
    public void loadStyleTemplates(String sTemplateUrl, String OptionString){
    try{
	XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier) UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, xTextDocument);
	XStyleLoader xStyleLoader = (XStyleLoader) UnoRuntime.queryInterface(XStyleLoader.class, xStyleFamiliesSupplier.getStyleFamilies());
	com.sun.star.beans.PropertyValue[] StyleOptions = xStyleLoader.getStyleLoaderOptions();
	String CurOptionName = "";
	int PropCount = StyleOptions.length;
	for (int i = 0; i<PropCount; i++){
	   CurOptionName = StyleOptions[i].Name;
	   StyleOptions[i].Value = new Boolean((CurOptionName.compareTo(OptionString) == 0) || (CurOptionName.compareTo("OverwriteStyles") == 0));
	}
	xStyleLoader.loadStylesFromURL(sTemplateUrl, StyleOptions);
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}
}
