package com.sun.star.help;


import java.net.*;
import java.util.*;
import java.io.*;


class DefinitionsSorted
{
	SortedMap _sort = new TreeMap();
	
	public DefinitionsSorted( Definitions defs )
	{
		String styleName;
		Hashtable styles;
		Enumeration enum = defs.getTable().keys();
		
		while( enum.hasMoreElements() )
		{
			styleName = ( String ) enum.nextElement();
			styles = defs.getEffectiveStyle( styleName );
			
			Enumeration styleOptions = styles.keys();
			while( styleOptions.hasMoreElements() )
			{
				SortedMap value2taglist;
				String styleOptionsName = ( String ) styleOptions.nextElement();
				if( (value2taglist = (SortedMap)_sort.get( styleOptionsName )) == null )
					_sort.put( styleOptionsName,value2taglist = new TreeMap() );
				
				String styleOptionsValue = ( String ) styles.get( styleOptionsName );
				SortedSet setoftags;
				if( ( setoftags = ( SortedSet ) value2taglist.get( styleOptionsValue ) ) == null )
					value2taglist.put( styleOptionsValue, setoftags = new TreeSet() );
				
				setoftags.add( styleName );
			}
		}
	}
	

	public void print( Writer writer ) throws IOException
	{
		String str,stri;
		Iterator it = _sort.keySet().iterator();
		while( it.hasNext() )
		{
			str = ( String ) it.next();
			writer.write( "/****************************************************************************** \n");
			writer.write( " *                                                                              \n");
			writer.write( " *      " +  str + "\n" );
			writer.write( " *                                                                              \n");
			writer.write( " ******************************************************************************/\n");
//			System.out.println( str );
			SortedMap bla = ( SortedMap ) _sort.get( str );
			Iterator iti = bla.keySet().iterator();
			while( iti.hasNext() )
			{
				stri = ( String ) iti.next();
				writer.write( "\n /*   " +stri+"  ("+str+")   */\n" );
				SortedSet tags = ( SortedSet ) bla.get( stri );
				Iterator ito = tags.iterator();
				String val = "";
				String sem = "";
				while( ito.hasNext() )
				{
					val += ( sem + ( String ) ito.next() );
					sem = ",";
				}
				System.out.println( val+"{"+str+":"+stri+"}" );
				writer.write( "\n"+val+"{"+str+":"+stri+"}\n" );
			}
            writer.write( "\n\n\n" );
		}
	}
	
}



class Definitions
{

	private Hashtable _table = new Hashtable();


	public Hashtable getTable()
	{
		return _table;
	}


	public void addStyle( String name, Hashtable styles )
	{
		LinkedList list = ( LinkedList ) _table.get( name );
		if( list == null )
			_table.put( name,list = new LinkedList() );
		list.addFirst( styles );
	}

	public Hashtable getEffectiveStyle( String forName )
	{
		LinkedList list = ( LinkedList ) _table.get( forName );
		if( list == null )
			return new Hashtable();
		
		// Otherwise we have a well known style
		
		Hashtable result = new Hashtable();
		ListIterator it = list.listIterator( 0 );
		while( it.hasNext() )
		{
			Hashtable curr;
			Enumeration enum = (curr = ( Hashtable )it.next()).keys();
			while( enum.hasMoreElements() )
			{
				String str;
				if( result.get( str = ( String ) enum.nextElement() ) == null )
					result.put( str,curr.get( str ) );
			}
		}
		
		return result;
	}

	
	protected void showStyles()
	{
		String str;
		Hashtable a = getEffectiveStyle( "p.def1" );
		Enumeration enum = a.keys();
		
		while( enum.hasMoreElements() )
		{
			System.out.println( (str = ( String ) enum.nextElement()) + " : " + ((String)a.get(str)) );
		}
	}
	
}








public class HelpTransformer
{
	
	Definitions definitions = new Definitions();
	
	
	private static URL verurle( String fileName )
	{
		try
		{
			return new URL(
				( fileName.charAt( 0 ) == '/' ) ? 
				( "file://" + fileName ) :
				( "file:///" + fileName ) );
		}
		catch( java.net.MalformedURLException e )
		{
			System.err.println( e.getMessage() );
			return null;
		}
	}
	
	
	
	private Stack _stack = new Stack();
	
	
	public HelpTransformer( String _directory )
	{		
		File startDir = new File( _directory );
		
		if( startDir.isDirectory() )
			_stack.push( startDir );
	}
	
	
	
	void transform( String _prefix,HelpIndexer.ParseStuff _transformer, HelpPackager _packager )
	{
		boolean cont = true;
		File theFile;
		while( cont && ! _stack.empty() )
		{
			theFile = ( File ) _stack.pop();
			if( theFile.isDirectory() )
			{
				File[] entries = theFile.listFiles();
				for( int i = 0; i < entries.length; ++i )
					_stack.push( entries[i] );
			}
			else
			{
				String fileName = theFile.getAbsolutePath().replace( '\\','/' );
				String urlName  = verurle( fileName ).toExternalForm();
				String entryName = fileName.substring( 1 + _prefix.length() ).toLowerCase();
				
				_packager.addEntry( entryName,_transformer.parse( urlName ) );
				System.out.println( "added entry: " + entryName );
				// cont = false;
			}
		}
		
		_packager.close();
	}
	



	public void css( HelpIndexer.ParseStuff _parser )
	{
		String cssFileName = new String( "e:/help/export/home/abi/help/pool.css" );
		FileWriter writer = null;
		try
		{
			(new File( cssFileName )).createNewFile();
			writer = new FileWriter( cssFileName,true );
		}
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
		
		boolean cont = true;
		int count = 0;
		
		File theFile;
		while( cont && ! _stack.empty() )
		{
			theFile = ( File ) _stack.pop();
			if( theFile.isDirectory() )
			{
				File[] entries = theFile.listFiles();
				for( int i = 0; i < entries.length; ++i )
					_stack.push( entries[i] );
			}
			else
			{
				String fileName = theFile.getAbsolutePath().replace( '\\','/' );
				String urlName  = verurle( fileName ).toExternalForm();
				
				byte[] erg;
				try
				{
					erg = _parser.parse( urlName );
					String str = new String( erg,"UTF8" );
					divide( str );
				}
				catch( UnsupportedEncodingException e )
				{
					System.err.println( e.getMessage() );
				}
				catch( IOException e )
				{
					System.err.println( e.getMessage() );
				}
				
				System.out.println( "css determined: " + urlName );
			}
		}
		
		try
		{
			DefinitionsSorted defSort = new DefinitionsSorted( definitions );
			defSort.print( writer );
			writer.flush();
			writer.close();
		}
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
		
	}
	

	int _pos;
	String _expr;
	
	// Tokentypes
	static final int STRINGTOKEN = 0;
	static final int KOMMATOKEN = 1;
	static final int LBRACKETTOKEN = 2;
	static final int COLONTOKEN = 3;
	static final int SEMTOKEN = 4;
	static final int RBRACKETTOKEN = 5;
	static final int ENDTOKEN = 6;
	
	int _tokentype;
	String _token;
	
	void divide( String expr )
	{
		_pos = 0;
		_expr = expr;
		
		nextToken();
		
		while( _tokentype != ENDTOKEN )
		{
			LinkedList listOfTags = new LinkedList();
			
			addNameTag( listOfTags );
			
			if( _tokentype !=  LBRACKETTOKEN )
			{
				System.err.println( "weia" );
				System.exit( 1 );
			}
			
			Hashtable table = new Hashtable();
			nextToken();
			addValueKey( table );
			
			if( _tokentype != RBRACKETTOKEN )
			{
				System.err.println( "weia" );
				System.exit( 1 );
			}
			nextToken();
			
			String tag;
			Iterator it = listOfTags.iterator();
			while( it.hasNext() )
			{
				tag = ( String ) it.next();
				definitions.addStyle( tag,table );
				
			}
		}
	}



	void addValueKey( Hashtable table )
	{
		String parameter,value;
		while( _tokentype == STRINGTOKEN )
		{
			parameter = _token;
			nextToken();
			if( _tokentype != COLONTOKEN )
			{
				System.err.println( "no colon" );
				System.exit( 1 );
			}
			nextToken();
			if( _tokentype != STRINGTOKEN )
			{
				System.err.println( "_tokentype = " + _tokentype );
				System.err.println( "no value" );
				System.exit( 1 );
			}
			value = _token;
			
			// System.out.println( value + " " + parameter );
			table.put( parameter,value );
			nextToken();
			if( _tokentype != SEMTOKEN )
			{
				System.err.println( "_tokentype = " + _tokentype );
				System.err.println( "no value" );
				System.exit( 1 );
			}
			nextToken();
		}
	}
	
	

	void addNameTag( LinkedList listOfTags )
	{
		addName( listOfTags );
		
		while( _tokentype == KOMMATOKEN )
		{
			nextToken();
			addName( listOfTags );
		}
	}


	void addName( LinkedList listOfTags )
	{
		if( _tokentype == STRINGTOKEN )
		{
			listOfTags.addLast( _token );
			nextToken();
		}
		else
		{
			System.err.println( _tokentype );
			System.err.println( "aua weia" );
			System.exit( 1 );
		}
	}



	void nextToken()
	{
		// skip whitespace
		while( _pos < _expr.length() && Character.isWhitespace( _expr.charAt( _pos ) ) )
			++_pos;

		if( _pos == _expr.length() )
		{
			_tokentype = ENDTOKEN;
			return;
		}

		char ch = _expr.charAt( _pos++ );
		
	    if( ch == ',' )
		{
			_tokentype = KOMMATOKEN;
		}
		else if( ch == '{' )
		{
			_tokentype = LBRACKETTOKEN;
		}
		else if( ch == ':' )
		{
			_tokentype = COLONTOKEN;
		}
		else if( ch == ';' )
		{
			_tokentype = SEMTOKEN;
		}
		else if( ch == '}' )
		{
			_tokentype = RBRACKETTOKEN;
		}
		else
		{
			char[] cha = new char[1];
			cha[0] = ch;
			_token = new String( cha );
			while( _pos < _expr.length() &&
				   // ! Character.isWhitespace( ch = _expr.charAt( _pos ) ) &&
				   ( ch = _expr.charAt( _pos ) ) != ',' &&
				   ch != '{'   &&
				   ch != ':'   &&
				   ch != ';'   &&
				   ch != '}'  )
			{
				_token += ch;
				++_pos;
			}
			_tokentype = STRINGTOKEN;
		}
	}


	
	

	
	public static void main( String args[] )
	{
		if( args.length < 2 )
  		{
    		System.out.println( "HelpTransformer <XMLDir> <XSLFile> [HelpRoot]" );
      		System.exit( 1 );
    	}

		/*
		  if( args.length != 6 )
		  {
		  System.out.println( "Usage example: main -language de -module swriter -system WIN" );
		  System.exit( 1 );
		  }
		*/
		
     	String XMLDir = args[0];
		
		System.out.println( "------------------------" );
		System.out.println( "Starting Transformation:" );
		System.out.println( "------------------------" );
		System.out.println( "XMLDir=   " + args[0] );
		System.out.println( "XSLFile=  " + args[1] );
		
		try
  		{
    		String urlmode = HelpDatabases.getURLMode();
      		HelpURLStreamHandlerFactory urlHandler = new HelpURLStreamHandlerFactory( urlmode );
      		URL.setURLStreamHandlerFactory( urlHandler );

			String _prefix = ( args.length > 2 ) ? args[2] : args[0];
			
			HelpIndexer.ParseStuff _parser = 
				new HelpIndexer.ParseStuff( verurle( args[1] ) );			
			// _parser.setParameter( "deviceType","HTML4" );
			
			HelpPackager _packer = new HelpPackager( args[0] + ".jar" );
			
			HelpTransformer transformer = new HelpTransformer( args[0] );
			
			// compile the cascading style sheet
			// transformer.css( _parser );
			
			// pretransform the xml-files
			transformer.transform( _prefix,_parser,_packer );
      	}
    	catch( Exception e )
    	{
			System.err.println( e.getMessage() );
      		e.printStackTrace();
    	}		
	}
	
}
